/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.CipherStrings;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509Cert;
import org.jruby.ext.openssl.X509Store;
import org.jruby.ext.openssl.x509store.Certificate;
import org.jruby.ext.openssl.x509store.Name;
import org.jruby.ext.openssl.x509store.Store;
import org.jruby.ext.openssl.x509store.StoreContext;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509Object;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class SSLContext
extends RubyObject {
    private static final long serialVersionUID = -6203496135962974777L;
    private static final String[] ctx_attrs = new String[]{"cert", "key", "client_ca", "ca_file", "ca_path", "timeout", "verify_mode", "verify_depth", "verify_callback", "options", "cert_store", "extra_chain_cert", "client_cert_cb", "tmp_dh_callback", "session_id_context"};
    private static final Map<String, String> SSL_VERSION_OSSL2JSSE = new HashMap<String, String>();
    private static final Map<String, String[]> ENABLED_PROTOCOLS = new HashMap<String, String[]>();
    private static ObjectAllocator SSLCONTEXT_ALLOCATOR;
    private String ciphers = "AES:ALL:!aNULL:!eNULL:+RC4:@STRENGTH";
    private String protocol = "SSL";
    private boolean protocolForServer = true;
    private boolean protocolForClient = true;
    private PKey t_key = null;
    private X509Cert t_cert = null;
    private int verifyResult = 1;
    private InternalContext internalCtx = null;

    public static void createSSLContext(Ruby runtime, RubyModule mSSL) {
        RubyClass cSSLContext = mSSL.defineClassUnder("SSLContext", runtime.getObject(), SSLCONTEXT_ALLOCATOR);
        for (int i2 = 0; i2 < ctx_attrs.length; ++i2) {
            cSSLContext.addReadWriteAttribute(runtime.getCurrentContext(), ctx_attrs[i2]);
        }
        cSSLContext.defineAnnotatedMethods(SSLContext.class);
    }

    public SSLContext(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    public static RaiseException newSSLError(Ruby runtime, String message2) {
        return Utils.newError(runtime, "OpenSSL::SSL::SSLError", message2, false);
    }

    @JRubyMethod(rest=true)
    public IRubyObject initialize(IRubyObject[] args2) {
        return this;
    }

    @JRubyMethod
    public IRubyObject setup() {
        if (this.isFrozen()) {
            return this.getRuntime().getNil();
        }
        this.freeze(this.getRuntime().getCurrentContext());
        this.internalCtx = new InternalContext();
        this.internalCtx.protocol = this.protocol;
        this.internalCtx.protocolForServer = this.protocolForServer;
        this.internalCtx.protocolForClient = this.protocolForClient;
        X509Store certStore = this.getCertStore();
        this.internalCtx.store = certStore != null ? certStore.getStore() : new Store();
        IRubyObject value2 = this.getInstanceVariable("@extra_chain_cert");
        if (value2 != null && !value2.isNil()) {
            this.internalCtx.extraChainCert = new ArrayList<X509AuxCertificate>();
            for (X509Cert ele : this.convertToX509Certs(value2)) {
                this.internalCtx.extraChainCert.add(ele.getAuxCert());
            }
        }
        value2 = this.getInstanceVariable("@key");
        PKey key2 = null;
        if (value2 != null && !value2.isNil()) {
            Utils.checkKind(this.getRuntime(), value2, "OpenSSL::PKey::PKey");
            key2 = (PKey)value2;
        } else {
            key2 = this.getCallbackKey();
        }
        value2 = this.getInstanceVariable("@cert");
        X509Cert cert2 = null;
        if (value2 != null && !value2.isNil()) {
            Utils.checkKind(this.getRuntime(), value2, "OpenSSL::X509::Certificate");
            cert2 = (X509Cert)value2;
        } else {
            cert2 = this.getCallbackCert();
        }
        if (key2 != null && cert2 != null) {
            this.internalCtx.keyAlgorithm = key2.getAlgorithm();
            this.internalCtx.privateKey = key2.getPrivateKey();
            this.internalCtx.cert = cert2.getAuxCert();
        }
        if ((value2 = this.getInstanceVariable("@client_ca")) != null && !value2.isNil()) {
            if (value2.respondsTo("each")) {
                for (X509Cert ele : this.convertToX509Certs(value2)) {
                    this.internalCtx.clientCa.add(ele.getAuxCert());
                }
            } else {
                Utils.checkKind(this.getRuntime(), value2, "OpenSSL::X509::Certificate");
                this.internalCtx.clientCa.add(((X509Cert)value2).getAuxCert());
            }
        }
        String caFile = this.getCaFile();
        String caPath = this.getCaPath();
        if (caFile != null || caPath != null) {
            try {
                if (this.internalCtx.store.loadLocations(caFile, caPath) == 0) {
                    this.getRuntime().getWarnings().warn(IRubyWarnings.ID.MISCELLANEOUS, "can't set verify locations");
                }
            }
            catch (Exception e) {
                throw SSLContext.newSSLError(this.getRuntime(), e.getMessage());
            }
        }
        this.internalCtx.verifyMode = (value2 = this.getInstanceVariable("@verify_mode")) != null && !value2.isNil() ? RubyNumeric.fix2int(value2) : 0;
        value2 = this.getInstanceVariable("@verify_callback");
        if (value2 != null && !value2.isNil()) {
            this.internalCtx.store.setExtraData(1, value2);
        } else {
            this.internalCtx.store.setExtraData(1, null);
        }
        value2 = this.getInstanceVariable("@timeout");
        if (value2 != null && !value2.isNil()) {
            this.internalCtx.timeout = RubyNumeric.fix2int(value2);
        }
        if ((value2 = this.getInstanceVariable("@verify_depth")) != null && !value2.isNil()) {
            this.internalCtx.store.setDepth(RubyNumeric.fix2int(value2));
        } else {
            this.internalCtx.store.setDepth(-1);
        }
        try {
            this.internalCtx.init();
        }
        catch (GeneralSecurityException gse) {
            throw SSLContext.newSSLError(this.getRuntime(), gse.getMessage());
        }
        return this.getRuntime().getTrue();
    }

    @JRubyMethod
    public IRubyObject ciphers() {
        ArrayList<IRubyObject> list2 = new ArrayList<IRubyObject>();
        Ruby rt = this.getRuntime();
        try {
            String[] supported = this.getCipherSuites(this.createDummySSLEngine());
            List<CipherStrings.Def> ciphs = CipherStrings.getMatchingCiphers(this.ciphers, supported);
            for (CipherStrings.Def def : ciphs) {
                RubyArray ele = this.getRuntime().newArray(4);
                ele.set(0, rt.newString(def.name));
                ele.set(1, rt.newString(this.sslVersionString(def.algorithms)));
                ele.set(2, rt.newFixnum(def.strength_bits));
                ele.set(3, rt.newFixnum(def.alg_bits));
                list2.add(ele);
            }
        }
        catch (GeneralSecurityException gse) {
            throw SSLContext.newSSLError(this.getRuntime(), gse.getMessage());
        }
        return rt.newArray(list2);
    }

    @JRubyMethod(name={"ciphers="})
    public IRubyObject set_ciphers(IRubyObject val) {
        if (val.isNil()) {
            this.ciphers = "AES:ALL:!aNULL:!eNULL:+RC4:@STRENGTH";
        } else if (val instanceof RubyArray) {
            StringBuilder builder = new StringBuilder();
            String sep = "";
            for (IRubyObject obj : ((RubyArray)val).toJavaArray()) {
                builder.append(sep).append(obj.toString());
                sep = ":";
            }
            this.ciphers = builder.toString();
        } else {
            this.ciphers = val.convertToString().toString();
            if (this.ciphers.equals("DEFAULT")) {
                this.ciphers = "AES:ALL:!aNULL:!eNULL:+RC4:@STRENGTH";
            }
        }
        RubyArray ary = (RubyArray)this.ciphers();
        if (ary.size() == 0) {
            throw SSLContext.newSSLError(this.getRuntime(), "no cipher match");
        }
        return val;
    }

    @JRubyMethod(name={"ssl_version="})
    public IRubyObject set_ssl_version(IRubyObject val) {
        RubyString str = val.convertToString();
        String given = str.toString();
        String mapped = SSL_VERSION_OSSL2JSSE.get(given);
        if (mapped == null) {
            throw SSLContext.newSSLError(this.getRuntime(), String.format("unknown SSL method `%s'.", given));
        }
        this.protocol = mapped;
        this.protocolForClient = true;
        this.protocolForServer = true;
        if (given.endsWith("_client")) {
            this.protocolForServer = false;
        }
        if (given.endsWith("_server")) {
            this.protocolForClient = false;
        }
        return str;
    }

    boolean isProtocolForServer() {
        return this.protocolForServer;
    }

    boolean isProtocolForClient() {
        return this.protocolForClient;
    }

    int getLastVerifyResult() {
        return this.verifyResult;
    }

    void setLastVerifyResult(int verifyResult) {
        this.verifyResult = verifyResult;
    }

    SSLEngine createDummySSLEngine() throws GeneralSecurityException {
        javax.net.ssl.SSLContext ctx = javax.net.ssl.SSLContext.getInstance(this.protocol);
        ctx.init(null, null, null);
        return ctx.createSSLEngine();
    }

    SSLEngine createSSLEngine(Socket socket2) throws NoSuchAlgorithmException, KeyManagementException {
        SSLEngine engine;
        try {
            engine = this.internalCtx.getSSLContext().createSSLEngine();
        }
        catch (Exception e) {
            String peerHost = socket2.getInetAddress().getHostName();
            int peerPort = socket2.getPort();
            engine = this.internalCtx.getSSLContext().createSSLEngine(peerHost, peerPort);
        }
        engine.setEnabledCipherSuites(this.getCipherSuites(engine));
        engine.setEnabledProtocols(this.getEnabledProtocols(engine));
        return engine;
    }

    private String[] getCipherSuites(SSLEngine engine) {
        List<CipherStrings.Def> ciphs = CipherStrings.getMatchingCiphers(this.ciphers, engine.getSupportedCipherSuites());
        String[] result2 = new String[ciphs.size()];
        for (int i2 = 0; i2 < result2.length; ++i2) {
            result2[i2] = ciphs.get((int)i2).cipherSuite;
        }
        return result2;
    }

    private String[] getEnabledProtocols(SSLEngine engine) {
        ArrayList<String> candidates = new ArrayList<String>();
        long options2 = this.getOptions();
        if (ENABLED_PROTOCOLS.get(this.protocol) != null) {
            for (String enabled : ENABLED_PROTOCOLS.get(this.protocol)) {
                if ((options2 & 0x1000000L) != 0L && enabled.equals("SSLv2") || (options2 & 0x2000000L) != 0L && enabled.equals("SSLv3") || (options2 & 0x4000000L) != 0L && enabled.equals("TLSv1")) continue;
                for (String allowed : engine.getEnabledProtocols()) {
                    if (!allowed.equals(enabled)) continue;
                    candidates.add(allowed);
                }
            }
        }
        return candidates.toArray(new String[candidates.size()]);
    }

    private String sslVersionString(long bits) {
        StringBuilder sb = new StringBuilder();
        boolean first2 = true;
        if ((bits & 0x2000000L) != 0L) {
            if (!first2) {
                sb.append("/");
            }
            first2 = false;
            sb.append("TLSv1/SSLv3");
        }
        if ((bits & 0x1000000L) != 0L) {
            if (!first2) {
                sb.append("/");
            }
            first2 = false;
            sb.append("SSLv2");
        }
        return sb.toString();
    }

    private PKey getCallbackKey() {
        if (this.t_key != null) {
            return this.t_key;
        }
        this.initFromCallback();
        return this.t_key;
    }

    private X509Cert getCallbackCert() {
        if (this.t_cert != null) {
            return this.t_cert;
        }
        this.initFromCallback();
        return this.t_cert;
    }

    private void initFromCallback() {
        IRubyObject value2 = this.getInstanceVariable("@client_cert_cb");
        if (value2 != null && !value2.isNil()) {
            IRubyObject out = value2.callMethod(this.getRuntime().getCurrentContext(), "call", this);
            Utils.checkKind(this.getRuntime(), out, "Array");
            IRubyObject cert2 = (IRubyObject)((RubyArray)out).getList().get(0);
            IRubyObject key2 = (IRubyObject)((RubyArray)out).getList().get(1);
            Utils.checkKind(this.getRuntime(), cert2, "OpenSSL::X509::Certificate");
            Utils.checkKind(this.getRuntime(), key2, "OpenSSL::PKey::PKey");
            this.t_cert = (X509Cert)cert2;
            this.t_key = (PKey)key2;
        }
    }

    private X509Store getCertStore() {
        IRubyObject value2 = this.getInstanceVariable("@cert_store");
        if (value2 != null && !value2.isNil() && value2 instanceof X509Store) {
            Utils.checkKind(this.getRuntime(), value2, "OpenSSL::X509::Store");
            return (X509Store)value2;
        }
        return null;
    }

    private String getCaFile() {
        IRubyObject value2 = this.getInstanceVariable("@ca_file");
        if (value2 != null && !value2.isNil()) {
            return value2.convertToString().toString();
        }
        return null;
    }

    private String getCaPath() {
        IRubyObject value2 = this.getInstanceVariable("@ca_path");
        if (value2 != null && !value2.isNil()) {
            return value2.convertToString().toString();
        }
        return null;
    }

    private long getOptions() {
        IRubyObject value2 = this.getInstanceVariable("@options");
        if (value2 != null && !value2.isNil()) {
            return RubyNumeric.fix2long(value2);
        }
        return 0L;
    }

    private X509Cert[] convertToX509Certs(IRubyObject value2) {
        final ArrayList result2 = new ArrayList();
        ThreadContext ctx = this.getRuntime().getCurrentContext();
        RubyClass klass = Utils.getClassFromPath(ctx.runtime, "OpenSSL::SSL::SSLContext");
        RuntimeHelpers.invoke(ctx, value2, "each", CallBlock.newCallClosure(value2, klass, Arity.NO_ARGUMENTS, new BlockCallback(){

            public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
                Utils.checkKind(SSLContext.this.getRuntime(), args2[0], "OpenSSL::X509::Certificate");
                result2.add((X509Cert)args2[0]);
                return context.runtime.getNil();
            }
        }, ctx));
        return result2.toArray(new X509Cert[0]);
    }

    static {
        SSL_VERSION_OSSL2JSSE.put("TLSv1", "TLSv1");
        SSL_VERSION_OSSL2JSSE.put("TLSv1_server", "TLSv1");
        SSL_VERSION_OSSL2JSSE.put("TLSv1_client", "TLSv1");
        ENABLED_PROTOCOLS.put("TLSv1", new String[]{"TLSv1"});
        SSL_VERSION_OSSL2JSSE.put("SSLv2", "SSLv2");
        SSL_VERSION_OSSL2JSSE.put("SSLv2_server", "SSLv2");
        SSL_VERSION_OSSL2JSSE.put("SSLv2_client", "SSLv2");
        ENABLED_PROTOCOLS.put("SSLv2", new String[]{"SSLv2"});
        SSL_VERSION_OSSL2JSSE.put("SSLv3", "SSLv3");
        SSL_VERSION_OSSL2JSSE.put("SSLv3_server", "SSLv3");
        SSL_VERSION_OSSL2JSSE.put("SSLv3_client", "SSLv3");
        ENABLED_PROTOCOLS.put("SSLv3", new String[]{"SSLv3"});
        SSL_VERSION_OSSL2JSSE.put("SSLv23", "SSL");
        SSL_VERSION_OSSL2JSSE.put("SSLv23_server", "SSL");
        SSL_VERSION_OSSL2JSSE.put("SSLv23_client", "SSL");
        ENABLED_PROTOCOLS.put("SSL", new String[]{"SSLv2", "SSLv3", "TLSv1"});
        SSL_VERSION_OSSL2JSSE.put("TLS", "TLS");
        ENABLED_PROTOCOLS.put("TLS", new String[]{"TLSv1", "TLSv1.1"});
        SSL_VERSION_OSSL2JSSE.put("TLSv1.1", "TLSv1.1");
        ENABLED_PROTOCOLS.put("TLSv1.1", new String[]{"TLSv1.1"});
        SSLCONTEXT_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new SSLContext(runtime, klass);
            }
        };
    }

    private static class TM
    implements X509TrustManager {
        private InternalContext ctx;

        public TM(InternalContext ctx) {
            this.ctx = ctx;
        }

        public void checkClientTrusted(X509Certificate[] chain2, String authType) throws CertificateException {
            this.checkTrusted("ssl_client", chain2);
        }

        public void checkServerTrusted(X509Certificate[] chain2, String authType) throws CertificateException {
            this.checkTrusted("ssl_server", chain2);
        }

        public X509Certificate[] getAcceptedIssuers() {
            if (this.ctx == null) {
                return null;
            }
            ArrayList<X509AuxCertificate> chain2 = new ArrayList<X509AuxCertificate>();
            chain2.addAll(this.ctx.clientCa);
            return chain2.toArray(new X509Certificate[0]);
        }

        private void checkTrusted(String purpose, X509Certificate[] chain2) throws CertificateException {
            if (this.ctx == null) {
                throw new CertificateException("uninitialized trust manager");
            }
            if (chain2 != null && chain2.length > 0) {
                if ((this.ctx.verifyMode & 1) != 0) {
                    StoreContext storeCtx = this.ctx.createStoreContext(purpose);
                    if (storeCtx == null) {
                        throw new CertificateException("couldn't initialize store");
                    }
                    storeCtx.setCertificate(chain2[0]);
                    storeCtx.setChain(chain2);
                    this.verifyChain(storeCtx);
                }
            } else if ((this.ctx.verifyMode & 2) != 0) {
                throw new CertificateException("no peer certificate");
            }
        }

        private void verifyChain(StoreContext storeCtx) throws CertificateException {
            try {
                int ok = storeCtx.verifyCertificate();
                this.ctx.setLastVerifyResultInternal(storeCtx.error);
                if (ok == 0) {
                    throw new CertificateException("certificate verify failed");
                }
            }
            catch (Exception e) {
                this.ctx.setLastVerifyResultInternal(storeCtx.error);
                if (storeCtx.error == 0) {
                    this.ctx.setLastVerifyResultInternal(28);
                }
                throw new CertificateException("certificate verify failed", e);
            }
        }
    }

    private static class KM
    extends X509ExtendedKeyManager {
        private final InternalContext ctx;

        public KM(InternalContext ctx) {
            this.ctx = ctx;
        }

        public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
            if (this.ctx == null) {
                return null;
            }
            if (this.ctx.privateKey == null) {
                return null;
            }
            for (int i2 = 0; i2 < keyType.length; ++i2) {
                if (!keyType[i2].equalsIgnoreCase(this.ctx.keyAlgorithm)) continue;
                return keyType[i2];
            }
            return null;
        }

        public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
            if (this.ctx == null || this.ctx.privateKey == null) {
                return null;
            }
            if (keyType.equalsIgnoreCase(this.ctx.keyAlgorithm)) {
                return keyType;
            }
            return null;
        }

        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket2) {
            return null;
        }

        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket2) {
            return null;
        }

        public X509Certificate[] getCertificateChain(String alias2) {
            if (this.ctx == null) {
                return null;
            }
            ArrayList<X509AuxCertificate> chain2 = new ArrayList<X509AuxCertificate>();
            if (this.ctx.extraChainCert != null) {
                chain2.addAll(this.ctx.extraChainCert);
            } else if (this.ctx.cert != null) {
                StoreContext storeCtx = this.ctx.createStoreContext(null);
                X509AuxCertificate x = this.ctx.cert;
                while (true) {
                    chain2.add(x);
                    if (((Object)x.getIssuerDN()).equals(x.getSubjectDN())) break;
                    try {
                        Name xn = new Name(x.getIssuerX500Principal());
                        X509Object[] s_obj = new X509Object[1];
                        if (storeCtx.getBySubject(1, xn, s_obj) <= 0) break;
                        x = ((Certificate)s_obj[0]).x509;
                    }
                    catch (Exception e) {
                        break;
                    }
                }
            }
            return chain2.toArray(new X509Certificate[0]);
        }

        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return null;
        }

        public PrivateKey getPrivateKey(String alias2) {
            if (this.ctx == null || this.ctx.privateKey == null) {
                return null;
            }
            return this.ctx.privateKey;
        }

        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return null;
        }
    }

    private class InternalContext {
        Store store = null;
        int verifyMode = 0;
        X509AuxCertificate cert = null;
        String keyAlgorithm = null;
        PrivateKey privateKey = null;
        List<X509AuxCertificate> extraChainCert = null;
        List<X509AuxCertificate> clientCa = new ArrayList<X509AuxCertificate>();
        int timeout = 0;
        String protocol = null;
        boolean protocolForServer = true;
        boolean protocolForClient = true;
        private javax.net.ssl.SSLContext sslCtx = null;

        private InternalContext() {
        }

        void setLastVerifyResultInternal(int lastVerifyResult) {
            SSLContext.this.setLastVerifyResult(lastVerifyResult);
        }

        javax.net.ssl.SSLContext getSSLContext() {
            return this.sslCtx;
        }

        void init() throws GeneralSecurityException {
            KM km = new KM(this);
            TM tm = new TM(this);
            this.sslCtx = javax.net.ssl.SSLContext.getInstance(this.protocol);
            if (this.protocolForClient) {
                this.sslCtx.getClientSessionContext().setSessionTimeout(this.timeout);
            }
            if (this.protocolForServer) {
                this.sslCtx.getServerSessionContext().setSessionTimeout(this.timeout);
            }
            this.sslCtx.init(new KeyManager[]{km}, new TrustManager[]{tm}, null);
        }

        StoreContext createStoreContext(String purpose) {
            if (this.store == null) {
                return null;
            }
            StoreContext ctx = new StoreContext();
            if (ctx.init(this.store, null, null) == 0) {
                return null;
            }
            ctx.setExtraData(1, this.store.getExtraData(1));
            if (purpose != null) {
                ctx.setDefault(purpose);
            }
            ctx.param.inherit(this.store.param);
            return ctx;
        }
    }
}

