/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.operands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.interpreter.InterpreterContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundString
extends Operand {
    public final List<Operand> pieces;

    public CompoundString(List<Operand> pieces) {
        this.pieces = pieces;
    }

    @Override
    public boolean isConstant() {
        if (this.pieces != null) {
            for (Operand o : this.pieces) {
                if (o.isConstant()) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "COMPOUND_STRING" + (this.pieces == null ? "" : Arrays.toString(this.pieces.toArray()));
    }

    @Override
    public boolean isNonAtomicValue() {
        return true;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap) {
        int i2 = 0;
        for (Operand p2 : this.pieces) {
            this.pieces.set(i2, p2.getSimplifiedOperand(valueMap));
            ++i2;
        }
        return this;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        for (Operand o : this.pieces) {
            o.addUsedVariables(l);
        }
    }

    @Override
    public Operand cloneForInlining(InlinerInfo ii) {
        if (this.isConstant()) {
            return this;
        }
        ArrayList<Operand> newPieces = new ArrayList<Operand>();
        for (Operand p2 : this.pieces) {
            newPieces.add(p2.cloneForInlining(ii));
        }
        return new CompoundString(newPieces);
    }

    @Override
    public Object retrieve(InterpreterContext interp) {
        StringBuilder buf = new StringBuilder();
        for (Operand p2 : this.pieces) {
            buf.append(p2.retrieve(interp));
        }
        return interp.getRuntime().newString(buf.toString());
    }
}

