/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.ext.posix.util.Platform;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSEnvironment {
    public Map getEnvironmentVariableMap(Ruby runtime2) {
        Map envs = null;
        if (runtime2.getInstanceConfig().getEnvironment() != null) {
            return OSEnvironment.getAsMapOfRubyStrings(runtime2, runtime2.getInstanceConfig().getEnvironment().entrySet());
        }
        if (Ruby.isSecurityRestricted()) {
            envs = new HashMap();
        } else {
            Map<String, String> variables = System.getenv();
            envs = OSEnvironment.getAsMapOfRubyStrings(runtime2, variables.entrySet());
        }
        return envs;
    }

    public Map getSystemPropertiesMap(Ruby runtime2) {
        if (Ruby.isSecurityRestricted()) {
            return new HashMap();
        }
        return OSEnvironment.getAsMapOfRubyStrings(runtime2, System.getProperties().entrySet());
    }

    private static Map getAsMapOfRubyStrings(Ruby runtime2, Set<Map.Entry<Object, Object>> entrySet) {
        HashMap<RubyString, RubyString> envs = new HashMap<RubyString, RubyString>();
        Encoding encoding2 = runtime2.getEncodingService().getLocaleEncoding();
        if (Platform.IS_WINDOWS) {
            envs.put(runtime2.newString("HOME"), runtime2.newString(System.getProperty("user.home")));
            envs.put(runtime2.newString("USER"), runtime2.newString(System.getProperty("user.name")));
        }
        for (Map.Entry<Object, Object> entry : entrySet) {
            String value2 = (String)entry.getValue();
            String key2 = (String)entry.getKey();
            ByteList keyBytes = new ByteList(key2.getBytes(), encoding2);
            ByteList valueBytes = new ByteList(value2.getBytes(), encoding2);
            envs.put(runtime2.newString(keyBytes), runtime2.newString(valueBytes));
        }
        return envs;
    }
}

