/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import java.util.Map;
import org.jruby.RubyModule;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.IRModule;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.OneOperandInstr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefineInstanceMethodInstr
extends OneOperandInstr {
    public final IRModule module;
    public final IRMethod method;

    public DefineInstanceMethodInstr(IRModule module, IRMethod method2) {
        super(Operation.DEF_INST_METH, null, method2.getContainer());
        this.module = module;
        this.method = method2;
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.module.getName() + ", " + this.method.getName() + ")";
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return this;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap) {
        super.simplifyOperands(valueMap);
        Operand o = this.method.getContainer();
        Operand v = valueMap.get(o);
        if (v != null) {
            this.method.setContainer(v);
        }
    }

    @Override
    public Label interpret(InterpreterContext interp, IRubyObject self) {
        RubyModule clazz = self instanceof RubyModule ? (RubyModule)self : self.getMetaClass();
        this.method.setContainerModule(clazz);
        clazz.addMethod(this.method.getName(), new InterpretedIRMethod(this.method, clazz));
        return null;
    }
}

