/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.platform;

import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;

public class Platform {
    private static final Platform INSTANCE = new Platform();
    private static final String DARWIN = "darwin";
    private static final String WINDOWS = "windows";
    private static final String LINUX = "linux";
    private static final String FREEBSD = "freebsd";
    private static final String OPENBSD = "openbsd";
    private static final String SOLARIS = "solaris";
    private static final String GCJ = "GNU libgcj";
    public static final Map<String, String> OS_NAMES = new HashMap<String, String>(){
        {
            this.put("Mac OS X", Platform.DARWIN);
        }
    };
    public static final Map<String, String> ARCH_NAMES = new HashMap<String, String>(){
        {
            this.put("x86", "i386");
        }
    };
    public static final String ARCH = Platform.initArchitecture();
    public static final String OS = Platform.initOperatingSystem();
    public static final String JVM = Platform.getProperty("java.vm.name", "unknown");
    public static final boolean IS_WINDOWS = OS.equals("windows");
    public static final boolean IS_MAC = OS.equals("darwin");
    public static final boolean IS_FREEBSD = OS.equals("freebsd");
    public static final boolean IS_OPENBSD = OS.equals("openbsd");
    public static final boolean IS_LINUX = OS.equals("linux");
    public static final boolean IS_SOLARIS = OS.equals("solaris");
    public static final boolean IS_BSD = IS_MAC || IS_FREEBSD || IS_OPENBSD;
    public static final String NAME = String.format("%s-%s", ARCH, OS);
    public static final int BIG_ENDIAN = 4321;
    public static final int LITTLE_ENDIAN = 1234;
    public static final int BYTE_ORDER = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? 4321 : 1234;
    public static final boolean IS_GCJ = JVM.equals("GNU libgcj");

    public static Platform getPlatform() {
        return INSTANCE;
    }

    protected Platform() {
    }

    public static void main(String[] args2) {
        System.out.println(System.getProperties());
    }

    public String getPackageName() {
        return String.format("%s.%s.%s", Platform.class.getPackage().getName(), OS, ARCH);
    }

    public String getOSPackageName() {
        return String.format("%s.%s", Platform.class.getPackage().getName(), OS);
    }

    private static String initOperatingSystem() {
        String osname = Platform.getProperty("os.name", "unknown").toLowerCase();
        for (String s : OS_NAMES.keySet()) {
            if (!s.equalsIgnoreCase(osname)) continue;
            return OS_NAMES.get(s);
        }
        if (osname.startsWith(WINDOWS)) {
            return WINDOWS;
        }
        return osname;
    }

    private static String initArchitecture() {
        String arch = Platform.getProperty("os.arch", "unknown").toLowerCase();
        for (String s : ARCH_NAMES.keySet()) {
            if (!s.equalsIgnoreCase(arch)) continue;
            return ARCH_NAMES.get(s);
        }
        return arch;
    }

    public static String getProperty(String property, String defValue) {
        try {
            return System.getProperty(property, defValue);
        }
        catch (SecurityException se) {
            return defValue;
        }
    }
}

