/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.Argv;
import org.jruby.embed.variable.BiVariable;
import org.jruby.embed.variable.ClassVariable;
import org.jruby.embed.variable.Constant;
import org.jruby.embed.variable.GlobalVariable;
import org.jruby.embed.variable.InstanceVariable;
import org.jruby.embed.variable.LocalGlobalVariable;
import org.jruby.embed.variable.PersistentLocalVariable;
import org.jruby.embed.variable.TransientLocalVariable;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableInterceptor {
    private LocalVariableBehavior behavior;

    public VariableInterceptor(LocalVariableBehavior behavior) {
        this.behavior = behavior;
    }

    public BiVariable getVariableInstance(RubyObject receiver2, String name2, Object ... value2) {
        if (value2 == null || value2.length < 1) {
            return null;
        }
        if ("ARGV".equals(name2)) {
            return Argv.getInstance(receiver2, name2, value2);
        }
        switch (this.behavior) {
            case GLOBAL: {
                return LocalGlobalVariable.getInstance(receiver2, name2, value2);
            }
            case BSF: {
                BiVariable[] bEntries = new BiVariable[]{PersistentLocalVariable.getInstance(receiver2, name2, value2), GlobalVariable.getInstance(receiver2, name2, value2)};
                return this.resolve(bEntries);
            }
            case PERSISTENT: {
                BiVariable[] pEntries = new BiVariable[]{GlobalVariable.getInstance(receiver2, name2, value2), InstanceVariable.getInstance(receiver2, name2, value2), ClassVariable.getInstance(receiver2, name2, value2), Constant.getInstance(receiver2, name2, value2), PersistentLocalVariable.getInstance(receiver2, name2, value2)};
                return this.resolve(pEntries);
            }
        }
        BiVariable[] tEntries = new BiVariable[]{GlobalVariable.getInstance(receiver2, name2, value2), InstanceVariable.getInstance(receiver2, name2, value2), ClassVariable.getInstance(receiver2, name2, value2), Constant.getInstance(receiver2, name2, value2), TransientLocalVariable.getInstance(receiver2, name2, value2)};
        return this.resolve(tEntries);
    }

    private BiVariable resolve(BiVariable[] entries2) {
        for (BiVariable e : entries2) {
            if (e == null) continue;
            return e;
        }
        return null;
    }

    public void inject(BiVariableMap map, Ruby runtime2, ManyVarsDynamicScope scope, int depth, IRubyObject receiver2) {
        int i;
        IRubyObject[] values4Injection;
        if (scope != null && (values4Injection = map.getLocalVarValues()) != null && values4Injection.length > 0) {
            for (i = 0; i < values4Injection.length; ++i) {
                scope.setValue(i, values4Injection[i], depth);
            }
        }
        List<BiVariable> variables = map.getVariables();
        for (i = 0; i < variables.size(); ++i) {
            variables.get(i).inject();
        }
    }

    public void retrieve(BiVariableMap map, RubyObject receiver2) {
        Argv.retrieve(receiver2, map);
        switch (this.behavior) {
            case GLOBAL: {
                LocalGlobalVariable.retrieve(receiver2, map);
                break;
            }
            case BSF: {
                PersistentLocalVariable.retrieve(receiver2, map);
                break;
            }
            case PERSISTENT: {
                PersistentLocalVariable.retrieve(receiver2, map);
            }
            default: {
                InstanceVariable.retrieve(receiver2, map);
                GlobalVariable.retrieve(receiver2, map);
                ClassVariable.retrieve(receiver2, map);
                Constant.retrieve(receiver2, map);
            }
        }
    }

    public void tryLazyRetrieval(BiVariableMap map, IRubyObject receiver2, Object key2) {
        if (Argv.isValidName(key2)) {
            Argv.retrieveByKey((RubyObject)receiver2, map, (String)key2);
            return;
        }
        switch (this.behavior) {
            case GLOBAL: {
                if (!LocalGlobalVariable.isValidName(key2)) break;
                LocalGlobalVariable.retrieveByKey(receiver2.getRuntime(), map, (String)key2);
                break;
            }
            case BSF: {
                break;
            }
            default: {
                if (GlobalVariable.isValidName(key2)) {
                    GlobalVariable.retrieveByKey(receiver2.getRuntime(), map, (String)key2);
                    break;
                }
                if (InstanceVariable.isValidName(key2)) {
                    InstanceVariable.retrieveByKey((RubyObject)receiver2, map, (String)key2);
                    break;
                }
                if (ClassVariable.isValidName(key2)) {
                    ClassVariable.retrieveByKey((RubyObject)receiver2, map, (String)key2);
                    break;
                }
                if (!Constant.isValidName(key2)) break;
                Constant.retrieveByKey((RubyObject)receiver2, map, (String)key2);
            }
        }
    }

    public void terminateGlobalVariables(List<BiVariable> variables, Ruby runtime2) {
        if (LocalVariableBehavior.GLOBAL == this.behavior) {
            for (int i = 0; i < variables.size(); ++i) {
                if (BiVariable.Type.LocalGlobalVariable != variables.get(i).getType()) continue;
                IRubyObject irobj = JavaEmbedUtils.javaToRuby(runtime2, null);
                runtime2.getGlobalVariables().set("$" + variables.get(i).getName(), irobj);
            }
        }
    }

    public void terminateLocalVariables(List<String> varNames, List<BiVariable> variables) {
        if (LocalVariableBehavior.TRANSIENT == this.behavior) {
            for (int i = 0; i < variables.size(); ++i) {
                if (BiVariable.Type.LocalVariable != variables.get(i).getType()) continue;
                varNames.remove(i);
                variables.remove(i);
            }
        }
    }

    public boolean isKindOfRubyVariable(String name2) {
        if ("ARGV".equals(name2)) {
            return true;
        }
        switch (this.behavior) {
            case GLOBAL: {
                return LocalGlobalVariable.isValidName(name2);
            }
            case BSF: {
                if (PersistentLocalVariable.isValidName(name2)) {
                    return true;
                }
                return GlobalVariable.isValidName(name2);
            }
            case PERSISTENT: {
                if (GlobalVariable.isValidName(name2)) {
                    return true;
                }
                if (PersistentLocalVariable.isValidName(name2)) {
                    return true;
                }
                if (InstanceVariable.isValidName(name2)) {
                    return true;
                }
                if (Constant.isValidName(name2)) {
                    return true;
                }
                return ClassVariable.isValidName(name2);
            }
        }
        if (GlobalVariable.isValidName(name2)) {
            return true;
        }
        if (TransientLocalVariable.isValidName(name2)) {
            return true;
        }
        if (InstanceVariable.isValidName(name2)) {
            return true;
        }
        if (Constant.isValidName(name2)) {
            return true;
        }
        return ClassVariable.isValidName(name2);
    }
}

