/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.representations;

import java.util.ArrayList;
import java.util.List;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.representations.BasicBlock;
import org.jruby.compiler.ir.representations.InlinerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RescuedRegion {
    Label _elseBlockLabel;
    List<Label> _rescueBlockLabels;
    List<BasicBlock> _exclusiveBBs;
    List<RescuedRegion> _nestedRegions;
    BasicBlock _endBB;
    BasicBlock _firstRescueBB;

    public RescuedRegion(Label elseBlockLabel, List<Label> rescueBlockLabels) {
        this._elseBlockLabel = elseBlockLabel;
        this._rescueBlockLabels = rescueBlockLabels;
        this._exclusiveBBs = new ArrayList<BasicBlock>();
        this._nestedRegions = new ArrayList<RescuedRegion>();
    }

    public void setEndBB(BasicBlock bb) {
        this._endBB = bb;
    }

    public void addBB(BasicBlock bb) {
        this._exclusiveBBs.add(bb);
    }

    public void addNestedRegion(RescuedRegion r) {
        this._nestedRegions.add(r);
    }

    public void setFirstRescueBB(BasicBlock frbb) {
        this._firstRescueBB = frbb;
    }

    public Label getFirstRescueBlockLabel() {
        return this._rescueBlockLabels.get(0);
    }

    public RescuedRegion cloneForInlining(InlinerInfo ii) {
        ArrayList<Label> newLabels = new ArrayList<Label>();
        for (Label l : this._rescueBlockLabels) {
            newLabels.add(ii.getRenamedLabel(l));
        }
        RescuedRegion newR = new RescuedRegion(this._elseBlockLabel == null ? null : ii.getRenamedLabel(this._elseBlockLabel), newLabels);
        newR._endBB = ii.getRenamedBB(this._endBB);
        newR._firstRescueBB = ii.getRenamedBB(this._firstRescueBB);
        for (BasicBlock b : this._exclusiveBBs) {
            newR.addBB(ii.getRenamedBB(b));
        }
        for (RescuedRegion r : this._nestedRegions) {
            newR.addNestedRegion(r.cloneForInlining(ii));
        }
        return newR;
    }
}

