/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.representations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.compiler.ir.IRExecutionScope;
import org.jruby.compiler.ir.Tuple;
import org.jruby.compiler.ir.instructions.CallInstr;
import org.jruby.compiler.ir.instructions.YieldInstr;
import org.jruby.compiler.ir.operands.Array;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.LocalVariable;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.BasicBlock;
import org.jruby.compiler.ir.representations.CFG;

public class InlinerInfo {
    public final CFG callerCFG;
    public final CallInstr call;
    private Operand[] callArgs;
    private Map<Label, Label> lblRenameMap;
    private Map<Variable, Variable> varRenameMap;
    private Map<BasicBlock, BasicBlock> bbRenameMap;
    private List yieldSites;

    public InlinerInfo(CallInstr call2, CFG c) {
        this.call = call2;
        this.callArgs = call2.getCallArgs();
        this.callerCFG = c;
        this.varRenameMap = new HashMap<Variable, Variable>();
        this.lblRenameMap = new HashMap<Label, Label>();
        this.bbRenameMap = new HashMap<BasicBlock, BasicBlock>();
        this.yieldSites = new ArrayList();
    }

    public Label getRenamedLabel(Label l) {
        Label newLbl = this.lblRenameMap.get(l);
        if (newLbl == null) {
            newLbl = this.callerCFG.getScope().getNewLabel();
            this.lblRenameMap.put(l, newLbl);
        }
        return newLbl;
    }

    public Variable getRenamedVariable(Variable v) {
        Variable newVar = this.varRenameMap.get(v);
        if (newVar == null) {
            IRExecutionScope m = this.callerCFG.getScope();
            newVar = m.getNewInlineVariable();
            if (v instanceof LocalVariable) {
                newVar = m.getLocalVariable(newVar.getName());
            }
            this.varRenameMap.put(v, newVar);
        }
        return newVar;
    }

    public BasicBlock getRenamedBB(BasicBlock bb) {
        return this.bbRenameMap.get(bb);
    }

    public BasicBlock getOrCreateRenamedBB(BasicBlock bb) {
        BasicBlock renamedBB = this.getRenamedBB(bb);
        if (renamedBB == null) {
            renamedBB = new BasicBlock(this.callerCFG, this.getRenamedLabel(bb._label));
            this.bbRenameMap.put(bb, renamedBB);
        }
        return renamedBB;
    }

    public Operand getCallArg(int index2) {
        return index2 < this.callArgs.length ? this.callArgs[index2] : null;
    }

    public Operand getCallArg(int argIndex, boolean restOfArgArray) {
        if (!restOfArgArray) {
            return this.getCallArg(argIndex);
        }
        if (argIndex >= this.callArgs.length) {
            return new Array();
        }
        Operand[] tmp = new Operand[this.callArgs.length - argIndex];
        for (int j = argIndex; j < this.callArgs.length; ++j) {
            tmp[j - argIndex] = this.callArgs[j];
        }
        return new Array(tmp);
    }

    public Operand getCallReceiver() {
        return this.call.getReceiver();
    }

    public Operand getCallClosure() {
        return this.call.getClosureArg();
    }

    public Variable getCallResultVariable() {
        return this.call.result;
    }

    public void recordYieldSite(BasicBlock bb, YieldInstr i) {
        this.yieldSites.add(new Tuple<BasicBlock, YieldInstr>(bb, i));
    }

    public List getYieldSites() {
        return this.yieldSites;
    }
}

