/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.cext;

import org.jruby.RubyModule;
import org.jruby.cext.GIL;
import org.jruby.cext.Native;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

public class NativeMethod
extends DynamicMethod {
    protected final Arity arity;
    protected final long function;
    private final Native nativeInstance;

    public NativeMethod(RubyModule clazz, int arity2, long function) {
        super(clazz, Visibility.PUBLIC, CallConfiguration.FrameBacktraceScopeFull);
        this.arity = Arity.createArity(arity2);
        this.function = function;
        this.nativeInstance = Native.getInstance(clazz.getRuntime());
    }

    public final DynamicMethod dup() {
        return this;
    }

    public final Arity getArity() {
        return this.arity;
    }

    public final boolean isNative() {
        return true;
    }

    static void pre(ThreadContext context, IRubyObject self, RubyModule klazz, String name2) {
        context.preMethodFrameOnly(self.getType(), name2, self, Block.NULL_BLOCK);
        DynamicScope currentScope = context.getCurrentScope();
        context.pushScope(new ManyVarsDynamicScope(currentScope.getStaticScope(), currentScope));
        GIL.acquire();
    }

    static void pre(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, Block block) {
        context.preMethodFrameOnly(self.getType(), name2, self, block);
        DynamicScope currentScope = context.getCurrentScope();
        context.pushScope(new ManyVarsDynamicScope(currentScope.getStaticScope(), currentScope));
        GIL.acquire();
    }

    static void post(ThreadContext context) {
        GIL.release();
        context.postMethodFrameAndScope();
    }

    final Native getNativeInstance() {
        return this.nativeInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject recv2, RubyModule clazz, String name2, IRubyObject[] args2) {
        IRubyObject iRubyObject;
        NativeMethod.pre(context, recv2, clazz, name2);
        try {
            iRubyObject = this.getNativeInstance().callMethod(context, this.function, recv2, this.arity.getValue(), args2);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            NativeMethod.post(context);
            throw throwable;
        }
        NativeMethod.post(context);
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject recv2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        IRubyObject iRubyObject;
        NativeMethod.pre(context, recv2, clazz, name2, block);
        try {
            iRubyObject = this.getNativeInstance().callMethod(context, this.function, recv2, this.arity.getValue(), args2);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            NativeMethod.post(context);
            throw throwable;
        }
        NativeMethod.post(context);
        return iRubyObject;
    }
}

