/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.reader;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.reader.ReaderException;
import org.yaml.snakeyaml.reader.UnicodeReader;
import org.yaml.snakeyaml.scanner.Constant;

public class StreamReader {
    static final Pattern NON_PRINTABLE = Pattern.compile("[^\t\n\r -~\u0085\u00a0-\ud7ff\ue000-\ufffc]");
    private String name;
    private final Reader stream;
    private int pointer = 0;
    private boolean eof = true;
    private final StringBuilder buffer;
    private int index = 0;
    private int line = 0;
    private int column = 0;

    public StreamReader(String stream) {
        this.name = "<string>";
        this.buffer = new StringBuilder();
        this.checkPrintable(stream);
        this.buffer.append(stream);
        this.stream = null;
        this.eof = true;
    }

    public StreamReader(Reader reader) {
        this.name = "<reader>";
        this.buffer = new StringBuilder();
        this.stream = reader;
        this.eof = false;
    }

    void checkPrintable(CharSequence data) {
        Matcher em = NON_PRINTABLE.matcher(data);
        if (em.find()) {
            int position = this.index + this.buffer.length() - this.pointer + em.start();
            throw new ReaderException(this.name, position, em.group().charAt(0), "special characters are not allowed");
        }
    }

    public Mark getMark() {
        return new Mark(this.name, this.index, this.line, this.column, this.buffer.toString(), this.pointer);
    }

    public void forward() {
        this.forward(1);
    }

    public void forward(int length2) {
        if (this.pointer + length2 + 1 >= this.buffer.length()) {
            this.update(length2 + 1);
        }
        char ch = '\u0000';
        for (int i = 0; i < length2; ++i) {
            ch = this.buffer.charAt(this.pointer);
            ++this.pointer;
            ++this.index;
            if (Constant.LINEBR.has(ch) || ch == '\r' && this.buffer.charAt(this.pointer) != '\n') {
                ++this.line;
                this.column = 0;
                continue;
            }
            if (ch == '\ufeff') continue;
            ++this.column;
        }
    }

    public char peek() {
        return this.peek(0);
    }

    public char peek(int index2) {
        if (this.pointer + index2 + 1 > this.buffer.length()) {
            this.update(index2 + 1);
        }
        return this.buffer.charAt(this.pointer + index2);
    }

    public String prefix(int length2) {
        if (this.pointer + length2 >= this.buffer.length()) {
            this.update(length2);
        }
        if (this.pointer + length2 > this.buffer.length()) {
            return this.buffer.substring(this.pointer, this.buffer.length());
        }
        return this.buffer.substring(this.pointer, this.pointer + length2);
    }

    private void update(int length2) {
        this.buffer.delete(0, this.pointer);
        this.pointer = 0;
        while (this.buffer.length() < length2) {
            String rawData = null;
            if (!this.eof) {
                char[] data = new char[1024];
                int converted = -2;
                try {
                    converted = this.stream.read(data);
                }
                catch (IOException ioe) {
                    throw new YAMLException(ioe);
                }
                if (converted == -1) {
                    this.eof = true;
                } else {
                    rawData = new String(data, 0, converted);
                }
            }
            if (rawData != null) {
                this.checkPrintable(rawData);
                this.buffer.append(rawData);
            }
            if (!this.eof) continue;
            this.buffer.append('\u0000');
            break;
        }
    }

    public int getColumn() {
        return this.column;
    }

    public Charset getEncoding() {
        return Charset.forName(((UnicodeReader)this.stream).getEncoding());
    }

    public int getIndex() {
        return this.index;
    }

    public int getLine() {
        return this.line;
    }
}

