/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeOutputFormatter {
    private final String formatter;
    private final int totalPadding;
    private static final String formatPattern = "%([\\^0_-]+)?(\\d+)?.+";
    private static final Pattern regexp = Pattern.compile("%([\\^0_-]+)?(\\d+)?.+");

    public TimeOutputFormatter(String formatter, int totalPadding) {
        this.formatter = formatter;
        this.totalPadding = totalPadding;
    }

    public static TimeOutputFormatter getFormatter(String pattern) {
        Matcher matcher = regexp.matcher(pattern);
        if (matcher.matches() && (matcher.group(1) != null || matcher.group(2) != null)) {
            String formatter = matcher.group(1);
            int totalPadding = matcher.group(2) != null ? Integer.valueOf(matcher.group(2)) : 0;
            return new TimeOutputFormatter(formatter, totalPadding);
        }
        return null;
    }

    public String getFormatter() {
        return (this.formatter != null ? this.formatter : "") + (this.totalPadding > 0 ? Integer.valueOf(this.totalPadding) : "");
    }

    public String format(String sequence) {
        int paddedWith = 32;
        if (this.formatter != null) {
            block6: for (int i = 0; i < this.formatter.length(); ++i) {
                switch (this.formatter.charAt(i)) {
                    case '^': {
                        sequence = sequence.toUpperCase();
                        continue block6;
                    }
                    case '_': {
                        paddedWith = 32;
                        continue block6;
                    }
                    case '0': {
                        paddedWith = 48;
                        continue block6;
                    }
                    case '-': {
                        sequence = sequence.replaceAll("^[0]", "");
                    }
                }
            }
        }
        if (this.totalPadding > 0) {
            sequence = this.padding(sequence, (char)paddedWith);
        }
        return sequence;
    }

    private String padding(String sequence, char padder) {
        if (this.formatter != null && this.formatter.contains("-")) {
            return sequence;
        }
        if (sequence != null && sequence.length() < this.totalPadding) {
            StringBuilder seqBuf = new StringBuilder(this.totalPadding);
            for (int i = sequence.length(); i < this.totalPadding; ++i) {
                seqBuf.append(padder);
            }
            seqBuf.append(sequence);
            return seqBuf.toString();
        }
        return sequence;
    }
}

