/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.AbstractVariable;
import org.jruby.embed.variable.BiVariable;
import org.jruby.runtime.builtin.IRubyObject;

public class ClassVariable
extends AbstractVariable {
    private static String pattern = "@@([a-zA-Z]|_)([a-zA-Z]|_|\\d)*";

    public static BiVariable getInstance(RubyObject receiver2, String name2, Object ... javaObject) {
        if (name2.matches(pattern)) {
            return new ClassVariable(receiver2, name2, javaObject);
        }
        return null;
    }

    private ClassVariable(RubyObject receiver2, String name2, Object ... javaObject) {
        super(receiver2, name2, false, javaObject);
    }

    ClassVariable(IRubyObject receiver2, String name2, IRubyObject irubyObject) {
        super(receiver2, name2, true, irubyObject);
    }

    public static void retrieve(RubyObject receiver2, BiVariableMap vars) {
        if (vars.isLazy()) {
            return;
        }
        ClassVariable.updateClassVar(receiver2, vars);
        RubyObject topSelf = (RubyObject)receiver2.getRuntime().getTopSelf();
        ClassVariable.updateClassVar(topSelf, vars);
    }

    private static void updateClassVar(RubyObject receiver2, BiVariableMap vars) {
        List<String> keys2 = receiver2.getMetaClass().getClassVariableNameList();
        for (String key2 : keys2) {
            IRubyObject value2 = receiver2.getMetaClass().getClassVar(key2);
            BiVariable var = vars.getVariable(receiver2, key2);
            if (var != null) {
                var.setRubyObject(value2);
                continue;
            }
            var = new ClassVariable((IRubyObject)receiver2, key2, value2);
            vars.update(key2, var);
        }
    }

    public static void retrieveByKey(RubyObject receiver2, BiVariableMap vars, String key2) {
        if (!receiver2.getMetaClass().getClassVariableNameList().contains(key2)) {
            return;
        }
        IRubyObject value2 = receiver2.getMetaClass().getClassVar(key2);
        BiVariable var = vars.getVariable(receiver2, key2);
        if (var != null) {
            var.setRubyObject(value2);
        } else {
            var = new ClassVariable((IRubyObject)receiver2, key2, value2);
            vars.update(key2, var);
        }
    }

    public BiVariable.Type getType() {
        return BiVariable.Type.ClassVariable;
    }

    public static boolean isValidName(Object name2) {
        return ClassVariable.isValidName(pattern, name2);
    }

    public void inject() {
        RubyModule rubyClass = this.getRubyClass(this.receiver.getRuntime());
        rubyClass.setClassVar(this.name, this.irubyObject);
    }

    public void remove(Ruby runtime2) {
        RubyModule rubyClass = this.getRubyClass(runtime2);
        rubyClass.removeClassVariable(this.name);
    }
}

