/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jruby.Ruby;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.ast.DStrNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class DRegexpNode
extends ListNode
implements ILiteralNode {
    private final int options;
    private final boolean once;
    private RubyRegexp onceRegexp;

    public DRegexpNode(ISourcePosition position) {
        this(position, 0, false);
    }

    public DRegexpNode(ISourcePosition position, DStrNode node, int options2, boolean once) {
        this(position, options2, once);
        this.addAll(node);
    }

    public DRegexpNode(ISourcePosition position, int options2, boolean once) {
        super(position);
        this.options = options2;
        this.once = once;
    }

    public NodeType getNodeType() {
        return NodeType.DREGEXPNODE;
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitDRegxNode(this);
    }

    public boolean getOnce() {
        return this.once;
    }

    public int getOptions() {
        return this.options;
    }

    public RubyRegexp getOnceRegexp() {
        return this.onceRegexp;
    }

    public void setOnceRegexp(RubyRegexp regexp2) {
        if (this.once && this.onceRegexp == null) {
            this.onceRegexp = regexp2;
        }
    }

    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.once && this.onceRegexp != null) {
            return this.onceRegexp;
        }
        RubyString string2 = DStrNode.buildDynamicString(runtime2, context, self, aBlock, this);
        RubyRegexp regexp2 = RubyRegexp.newDRegexp(runtime2, string2, this.options);
        if (this.once) {
            this.setOnceRegexp(regexp2);
        }
        return regexp2;
    }
}

