/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.net.MalformedURLException;
import java.net.URL;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyClassPathVariable
extends RubyObject {
    public static void createClassPathVariable(Ruby runtime2) {
        RubyClassPathVariable self = new RubyClassPathVariable(runtime2);
        runtime2.getEnumerable().extend_object(self);
        runtime2.defineReadonlyVariable("$CLASSPATH", self);
        self.getMetaClass().defineAnnotatedMethods(RubyClassPathVariable.class);
    }

    private RubyClassPathVariable(Ruby runtime2) {
        super(runtime2, runtime2.getObject());
    }

    @JRubyMethod(name={"append", "<<"}, required=1)
    public IRubyObject append(IRubyObject obj) {
        String ss = obj.convertToString().toString();
        try {
            URL url = this.getURL(ss);
            this.getRuntime().getJRubyClassLoader().addURL(url);
        }
        catch (MalformedURLException mue) {
            throw this.getRuntime().newArgumentError(mue.getLocalizedMessage());
        }
        return this;
    }

    private URL getURL(String target) throws MalformedURLException {
        if (target.indexOf("://") == -1) {
            return new URL("file", null, target);
        }
        return new URL(target);
    }

    @JRubyMethod(name={"size", "length"})
    public IRubyObject size() {
        return this.getRuntime().newFixnum(this.getRuntime().getJRubyClassLoader().getURLs().length);
    }

    @JRubyMethod(name={"each"}, frame=true)
    public IRubyObject each(Block block) {
        URL[] urls = this.getRuntime().getJRubyClassLoader().getURLs();
        ThreadContext ctx = this.getRuntime().getCurrentContext();
        int j = urls.length;
        for (int i = 0; i < j; ++i) {
            block.yield(ctx, this.getRuntime().newString(urls[i].toString()));
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        return this.callMethod(this.getRuntime().getCurrentContext(), "to_a").callMethod(this.getRuntime().getCurrentContext(), "to_s");
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        return this.callMethod(this.getRuntime().getCurrentContext(), "to_a").callMethod(this.getRuntime().getCurrentContext(), "inspect");
    }
}

