/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.proxy;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.proxy.InternalJavaProxy;
import org.jruby.javasupport.proxy.JavaProxyClassFactory;
import org.jruby.javasupport.proxy.JavaProxyConstructor;
import org.jruby.javasupport.proxy.JavaProxyInvocationHandler;
import org.jruby.javasupport.proxy.JavaProxyMethod;
import org.jruby.javasupport.proxy.JavaProxyReflectionObject;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.JRubyClassLoader;

public class JavaProxyClass
extends JavaProxyReflectionObject {
    static ThreadLocal<Ruby> runtimeTLS = new ThreadLocal();
    private final Class proxyClass;
    private final ArrayList<JavaProxyMethod> methods = new ArrayList();
    private final HashMap<String, List<JavaProxyMethod>> methodMap = new HashMap();
    private final RubyArray constructors;
    private static final HashSet<String> EXCLUDE_MODULES = new HashSet();
    private static final HashSet<String> EXCLUDE_METHODS;

    JavaProxyClass(Class proxyClass) {
        super(JavaProxyClass.getThreadLocalRuntime(), JavaProxyClass.getThreadLocalRuntime().fastGetModule("Java").fastGetClass("JavaProxyClass"));
        this.proxyClass = proxyClass;
        this.constructors = this.buildRubyArray(this.getConstructors());
    }

    public boolean equals(Object other) {
        return other instanceof JavaProxyClass && this.proxyClass == ((JavaProxyClass)other).proxyClass;
    }

    public int hashCode() {
        return this.proxyClass.hashCode();
    }

    public Object getValue() {
        return this;
    }

    private static Ruby getThreadLocalRuntime() {
        return runtimeTLS.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaProxyClass getProxyClass(Ruby runtime2, Class superClass, Class[] interfaces2, Set names2) throws InvocationTargetException {
        Ruby save = runtimeTLS.get();
        runtimeTLS.set(runtime2);
        try {
            JRubyClassLoader loader = runtime2.getJRubyClassLoader();
            JavaProxyClass javaProxyClass = JavaProxyClassFactory.newProxyClass(runtime2, loader, null, superClass, interfaces2, names2);
            Object var8_7 = null;
            runtimeTLS.set(save);
            return javaProxyClass;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            runtimeTLS.set(save);
            throw throwable;
        }
    }

    public static JavaProxyClass getProxyClass(Ruby runtime2, Class superClass, Class[] interfaces2) throws InvocationTargetException {
        return JavaProxyClass.getProxyClass(runtime2, superClass, interfaces2, null);
    }

    public static Object newProxyInstance(Ruby runtime2, Class superClass, Class[] interfaces2, Class[] constructorParameters, Object[] constructorArgs, JavaProxyInvocationHandler handler) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        JavaProxyClass jpc = JavaProxyClass.getProxyClass(runtime2, superClass, interfaces2);
        JavaProxyConstructor cons = jpc.getConstructor(constructorParameters == null ? new Class[]{} : constructorParameters);
        return cons.newInstance(constructorArgs, handler);
    }

    public Class getSuperclass() {
        return this.proxyClass.getSuperclass();
    }

    public Class[] getInterfaces() {
        Class<?>[] ifaces = this.proxyClass.getInterfaces();
        Class[] result = new Class[ifaces.length - 1];
        int pos2 = 0;
        for (int i = 0; i < ifaces.length; ++i) {
            if (ifaces[i] == InternalJavaProxy.class) continue;
            result[pos2++] = ifaces[i];
        }
        return result;
    }

    public JavaProxyConstructor[] getConstructors() {
        Constructor<?>[] cons = this.proxyClass.getConstructors();
        JavaProxyConstructor[] result = new JavaProxyConstructor[cons.length];
        for (int i = 0; i < cons.length; ++i) {
            result[i] = new JavaProxyConstructor(this.getRuntime(), this, cons[i]);
        }
        return result;
    }

    public JavaProxyConstructor getConstructor(Class[] args2) throws SecurityException, NoSuchMethodException {
        Class[] realArgs = new Class[args2.length + 1];
        System.arraycopy(args2, 0, realArgs, 0, args2.length);
        realArgs[args2.length] = JavaProxyInvocationHandler.class;
        Constructor constructor2 = this.proxyClass.getConstructor(realArgs);
        return new JavaProxyConstructor(this.getRuntime(), this, constructor2);
    }

    public JavaProxyMethod[] getMethods() {
        return this.methods.toArray(new JavaProxyMethod[this.methods.size()]);
    }

    public JavaProxyMethod getMethod(String name2, Class[] parameterTypes) {
        List<JavaProxyMethod> methods2 = this.methodMap.get(name2);
        if (methods2 != null) {
            int i = methods2.size();
            while (--i >= 0) {
                ProxyMethodImpl jpm = (ProxyMethodImpl)methods2.get(i);
                if (!jpm.matches(name2, parameterTypes)) continue;
                return jpm;
            }
        }
        return null;
    }

    Class getProxyClass() {
        return this.proxyClass;
    }

    public Class getJavaClass() {
        return this.proxyClass;
    }

    JavaProxyMethod initMethod(String name2, String desc, boolean hasSuper) {
        Class proxy2 = this.proxyClass;
        try {
            Class[] parms = JavaProxyClass.parse(proxy2.getClassLoader(), desc);
            Method m = proxy2.getDeclaredMethod(name2, parms);
            Method sm = null;
            if (hasSuper) {
                sm = proxy2.getDeclaredMethod("__super$" + name2, parms);
            }
            ProxyMethodImpl jpm = new ProxyMethodImpl(this.getRuntime(), this, m, sm);
            this.methods.add(jpm);
            List<JavaProxyMethod> methodsWithName = this.methodMap.get(name2);
            if (methodsWithName == null) {
                methodsWithName = new ArrayList<JavaProxyMethod>(2);
                this.methodMap.put(name2, methodsWithName);
            }
            methodsWithName.add(jpm);
            return jpm;
        }
        catch (ClassNotFoundException e) {
            throw new InternalError(e.getMessage());
        }
        catch (SecurityException e) {
            throw new InternalError(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.getMessage());
        }
    }

    private static Class[] parse(final ClassLoader loader, String desc) throws ClassNotFoundException {
        ArrayList<Class<Byte>> al = new ArrayList<Class<Byte>>();
        int idx = 1;
        while (desc.charAt(idx) != ')') {
            Class type2;
            int arr = 0;
            while (desc.charAt(idx) == '[') {
                ++idx;
                ++arr;
            }
            switch (desc.charAt(idx)) {
                case 'L': {
                    int semi = desc.indexOf(59, idx);
                    final String name2 = desc.substring(idx + 1, semi);
                    idx = semi;
                    try {
                        type2 = AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){

                            @Override
                            public Class run() throws ClassNotFoundException {
                                return Class.forName(name2.replace('/', '.'), false, loader);
                            }
                        });
                        break;
                    }
                    catch (PrivilegedActionException e) {
                        throw (ClassNotFoundException)e.getException();
                    }
                }
                case 'B': {
                    type2 = Byte.TYPE;
                    break;
                }
                case 'C': {
                    type2 = Character.TYPE;
                    break;
                }
                case 'Z': {
                    type2 = Boolean.TYPE;
                    break;
                }
                case 'S': {
                    type2 = Short.TYPE;
                    break;
                }
                case 'I': {
                    type2 = Integer.TYPE;
                    break;
                }
                case 'J': {
                    type2 = Long.TYPE;
                    break;
                }
                case 'F': {
                    type2 = Float.TYPE;
                    break;
                }
                case 'D': {
                    type2 = Double.TYPE;
                    break;
                }
                default: {
                    throw new InternalError("cannot parse " + desc + "[" + idx + "]");
                }
            }
            ++idx;
            if (arr != 0) {
                type2 = Array.newInstance(type2, new int[arr]).getClass();
            }
            al.add(type2);
        }
        return al.toArray(new Class[al.size()]);
    }

    public static RubyClass createJavaProxyClassClass(Ruby runtime2, RubyModule javaModule) {
        RubyClass result = javaModule.defineClassUnder("JavaProxyClass", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        JavaProxyReflectionObject.registerRubyMethods(runtime2, result);
        result.defineAnnotatedMethods(JavaProxyClass.class);
        return result;
    }

    @JRubyMethod(meta=true)
    public static RubyObject get(IRubyObject recv2, IRubyObject obj) {
        if (!(obj instanceof JavaClass)) {
            throw recv2.getRuntime().newTypeError(obj, recv2.getRuntime().getJavaSupport().getJavaClassClass());
        }
        JavaClass type2 = (JavaClass)obj;
        try {
            return JavaProxyClass.getProxyClass(recv2.getRuntime(), (Class)type2.getValue(), new Class[0]);
        }
        catch (Error e) {
            RaiseException ex = recv2.getRuntime().newArgumentError("unable to create proxy class for " + type2.getValue());
            ex.initCause(e);
            throw ex;
        }
        catch (InvocationTargetException e) {
            RaiseException ex = recv2.getRuntime().newArgumentError("unable to create proxy class for " + type2.getValue());
            ex.initCause(e);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @JRubyMethod(meta=true)
    public static RubyObject get_with_class(IRubyObject recv, IRubyObject obj) {
        runtime = recv.getRuntime();
        if (!(obj instanceof RubyClass)) {
            throw runtime.newTypeError(obj, runtime.getClassClass());
        }
        clazz = (RubyClass)obj;
        javaClass = null;
        names = new HashSet<String>();
        interfaceList = new ArrayList<Class>();
        ancestors = clazz.getAncestorList();
        skipRemainingClasses = false;
        i$ = ancestors.iterator();
        block7: while (true) {
            block29: {
                block30: {
                    block27: {
                        block28: {
                            if (!i$.hasNext()) break block27;
                            ancestorObject = i$.next();
                            ancestor = (RubyModule)ancestorObject;
                            if (!(ancestor instanceof RubyClass)) break block28;
                            if (skipRemainingClasses) continue;
                            if (!ancestor.getInstanceVariables().fastHasInstanceVariable("@java_proxy_class")) {
                                skipRemainingClasses = true;
                                continue;
                            }
                            var = ancestor.getInstanceVariables().fastGetInstanceVariable("@java_class");
                            if (var == null) {
                                throw runtime.newTypeError("no java_class defined for proxy (or ancestor): " + ancestor);
                            }
                            if (!(var instanceof JavaClass)) {
                                throw runtime.newTypeError("invalid java_class defined for proxy (or ancestor): " + ancestor + ": " + var);
                            }
                            if (javaClass == null) {
                                javaClass = (JavaClass)var;
                            } else if (javaClass != var) {
                                throw runtime.newTypeError("java_class defined for " + clazz + " (" + javaClass + ") does not match java_class for ancestor " + ancestor + " (" + var + ")");
                            }
                            var = ancestor.getInstanceVariables().fastGetInstanceVariable("@java_interfaces");
                            if (var == null || var instanceof RubyNil) break block29;
                            if (!(var instanceof RubyArray)) {
                                throw runtime.newTypeError("invalid java_interfaces defined for proxy (or ancestor): " + ancestor + ": " + var);
                            }
                            ifcArray = (RubyArray)var;
                            i = size = ifcArray.size();
                            break block30;
                        }
                        if (JavaProxyClass.EXCLUDE_MODULES.contains(ancestor.getName())) continue;
                        var13_17 = methods = ancestor.getMethods();
                        // MONITORENTER : methods
                        for (String methodName : methods.keySet()) {
                            if (JavaProxyClass.EXCLUDE_METHODS.contains(methodName)) continue;
                            names.add(methodName);
                        }
                        // MONITOREXIT : var13_17
                        continue;
                    }
                    if (javaClass == null) {
                        throw runtime.newArgumentError("unable to create proxy class: no java_class defined for " + clazz);
                    }
                    interfaceCount = interfaceList.size();
                    interfaces = new Class[interfaceCount];
                    i = interfaceCount;
                    while (--i >= 0) {
                        interfaces[i] = (Class)interfaceList.get(i);
                    }
                    try {
                        return JavaProxyClass.getProxyClass(recv.getRuntime(), javaClass.javaClass(), interfaces, names);
                    }
                    catch (Error e) {
                        ex = recv.getRuntime().newArgumentError("unable to create proxy class for " + javaClass.getValue() + " : " + e.getMessage());
                        ex.initCause(e);
                        throw ex;
                    }
                    catch (InvocationTargetException e) {
                        ex = recv.getRuntime().newArgumentError("unable to create proxy class for " + javaClass.getValue() + " : " + e.getMessage());
                        ex.initCause(e);
                        throw ex;
                    }
                }
                while (--i >= 0) {
                    ifc = ifcArray.eltInternal(i);
                    if (!(ifc instanceof JavaClass)) {
                        throw runtime.newTypeError("invalid java interface defined for proxy (or ancestor): " + ancestor + ": " + ifc);
                    }
                    interfaceClass = ((JavaClass)ifc).javaClass();
                    if (!interfaceClass.isInterface()) {
                        throw runtime.newTypeError("invalid java interface defined for proxy (or ancestor): " + ancestor + ": " + ifc + " (not an interface)");
                    }
                    if (interfaceList.contains(interfaceClass)) continue;
                    interfaceList.add(interfaceClass);
                }
            }
            if ((var = ancestor.getInstanceVariables().fastGetInstanceVariable("@__java_ovrd_methods")) == null) {
                i = methods = ancestor.getMethods();
                // MONITORENTER : methods
                methodNames = RubyArray.newArrayLight(runtime, methods.size());
                for (String methodName : methods.keySet()) {
                    if (JavaProxyClass.EXCLUDE_METHODS.contains(methodName)) continue;
                    names.add(methodName);
                    methodNames.append(runtime.newString(methodName));
                }
                // MONITOREXIT : i
                ancestor.fastSetInstanceVariable("@__java_ovrd_methods", methodNames);
                continue;
            }
            if (!(var instanceof RubyArray)) {
                throw runtime.newTypeError("invalid @__java_ovrd_methods defined for proxy: " + ancestor + ": " + var);
            }
            methodNames = (RubyArray)var;
            i = size = methodNames.size();
            while (true) {
                if (--i >= 0) ** break;
                continue block7;
                methodName = methodNames.eltInternal(i);
                if (!(methodName instanceof RubyString)) {
                    throw runtime.newTypeError("invalid method name defined for proxy (or ancestor): " + ancestor + ": " + methodName);
                }
                names.add(methodName.asJavaString());
            }
            break;
        }
    }

    @JRubyMethod
    public RubyObject superclass() {
        return JavaClass.get(this.getRuntime(), this.getSuperclass());
    }

    @JRubyMethod
    public RubyArray methods() {
        return this.buildRubyArray(this.getMethods());
    }

    @JRubyMethod
    public RubyArray interfaces() {
        return this.buildRubyArray(this.getInterfaces());
    }

    @JRubyMethod
    public RubyArray constructors() {
        return this.constructors;
    }

    public static void createJavaProxyModule(Ruby runtime2) {
        RubyModule javaProxyModule = runtime2.getJavaSupport().getJavaModule();
        JavaProxyClass.createJavaProxyClassClass(runtime2, javaProxyModule);
        ProxyMethodImpl.createJavaProxyMethodClass(runtime2, javaProxyModule);
        JavaProxyConstructor.createJavaProxyConstructorClass(runtime2, javaProxyModule);
    }

    public String nameOnInspection() {
        return "[Proxy:" + this.getSuperclass().getName() + "]";
    }

    static {
        EXCLUDE_MODULES.add("Kernel");
        EXCLUDE_MODULES.add("Java");
        EXCLUDE_MODULES.add("JavaProxyMethods");
        EXCLUDE_MODULES.add("Enumerable");
        EXCLUDE_METHODS = new HashSet();
        EXCLUDE_METHODS.add("class");
        EXCLUDE_METHODS.add("finalize");
        EXCLUDE_METHODS.add("initialize");
        EXCLUDE_METHODS.add("java_class");
        EXCLUDE_METHODS.add("java_object");
        EXCLUDE_METHODS.add("__jcreate!");
        EXCLUDE_METHODS.add("__jsend!");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JRubyClass(name={"JavaProxy::JavaProxyMethod"})
    public static class ProxyMethodImpl
    extends JavaProxyReflectionObject
    implements JavaProxyMethod {
        private final Method m;
        private Object state;
        private final Method sm;
        private final Class[] parameterTypes;
        private final JavaProxyClass clazz;

        public ProxyMethodImpl(Ruby runtime2, JavaProxyClass clazz, Method m, Method sm) {
            super(runtime2, runtime2.getJavaSupport().getJavaModule().fastGetClass("JavaProxyMethod"));
            this.m = m;
            this.parameterTypes = m.getParameterTypes();
            this.sm = sm;
            this.clazz = clazz;
        }

        @Override
        public boolean equals(Object other) {
            return other instanceof ProxyMethodImpl && this.m == ((ProxyMethodImpl)other).m;
        }

        @Override
        public int hashCode() {
            return this.m.hashCode();
        }

        public Method getMethod() {
            return this.m;
        }

        @Override
        public Method getSuperMethod() {
            return this.sm;
        }

        @Override
        public int getModifiers() {
            return this.m.getModifiers();
        }

        @Override
        public String getName() {
            return this.m.getName();
        }

        @Override
        public Class<?>[] getExceptionTypes() {
            return this.m.getExceptionTypes();
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        @Override
        public boolean isVarArgs() {
            return this.m.isVarArgs();
        }

        @Override
        public Object getState() {
            return this.state;
        }

        @Override
        public boolean hasSuperImplementation() {
            return this.sm != null;
        }

        @Override
        public Object invoke(Object proxy2, Object[] args2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            if (!this.hasSuperImplementation()) {
                throw new NoSuchMethodException();
            }
            return this.sm.invoke(proxy2, args2);
        }

        @Override
        public void setState(Object state) {
            this.state = state;
        }

        @Override
        public String toString() {
            return this.m.toString();
        }

        @Override
        public Object defaultResult() {
            Class<?> rt = this.m.getReturnType();
            if (rt == Void.TYPE) {
                return null;
            }
            if (rt == Boolean.TYPE) {
                return Boolean.FALSE;
            }
            if (rt == Byte.TYPE) {
                return (byte)0;
            }
            if (rt == Short.TYPE) {
                return (short)0;
            }
            if (rt == Integer.TYPE) {
                return 0;
            }
            if (rt == Long.TYPE) {
                return 0L;
            }
            if (rt == Float.TYPE) {
                return new Float(0.0f);
            }
            if (rt == Double.TYPE) {
                return new Double(0.0);
            }
            return null;
        }

        public boolean matches(String name2, Class[] parameterTypes) {
            return this.m.getName().equals(name2) && Arrays.equals(this.parameterTypes, parameterTypes);
        }

        public Class getReturnType() {
            return this.m.getReturnType();
        }

        public static RubyClass createJavaProxyMethodClass(Ruby runtime2, RubyModule javaProxyModule) {
            RubyClass result = javaProxyModule.defineClassUnder("JavaProxyMethod", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
            JavaProxyReflectionObject.registerRubyMethods(runtime2, result);
            result.defineAnnotatedMethods(ProxyMethodImpl.class);
            return result;
        }

        public RubyObject name() {
            return this.getRuntime().newString(this.getName());
        }

        @Override
        @JRubyMethod(name={"declaring_class"})
        public JavaProxyClass getDeclaringClass() {
            return this.clazz;
        }

        @JRubyMethod
        public RubyArray argument_types() {
            return this.buildRubyArray(this.getParameterTypes());
        }

        @JRubyMethod(name={"super?"})
        public IRubyObject super_p() {
            return this.hasSuperImplementation() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        @JRubyMethod
        public RubyFixnum arity() {
            return this.getRuntime().newFixnum(this.getArity());
        }

        protected String nameOnInspection() {
            return this.getDeclaringClass().nameOnInspection() + "/" + this.getName();
        }

        @Override
        @JRubyMethod
        public IRubyObject inspect() {
            StringBuilder result = new StringBuilder();
            result.append(this.nameOnInspection());
            result.append("(");
            Class<?>[] parameterTypes = this.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                result.append(parameterTypes[i].getName());
                if (i >= parameterTypes.length - 1) continue;
                result.append(',');
            }
            result.append(")>");
            return this.getRuntime().newString(result.toString());
        }

        @JRubyMethod(name={"invoke"}, rest=true)
        public IRubyObject do_invoke(IRubyObject[] nargs) {
            if (nargs.length != 1 + this.getArity()) {
                throw this.getRuntime().newArgumentError(nargs.length, 1 + this.getArity());
            }
            IRubyObject invokee = nargs[0];
            if (!(invokee instanceof JavaObject)) {
                throw this.getRuntime().newTypeError("invokee not a java object");
            }
            Object receiver_value = ((JavaObject)invokee).getValue();
            Object[] arguments = new Object[nargs.length - 1];
            System.arraycopy(nargs, 1, arguments, 0, arguments.length);
            Class<?>[] parameterTypes = this.getParameterTypes();
            for (int i = 0; i < arguments.length; ++i) {
                arguments[i] = ((IRubyObject)arguments[i]).toJava(parameterTypes[i]);
            }
            try {
                Object javaResult = this.sm.invoke(receiver_value, arguments);
                return JavaUtil.convertJavaToRuby(this.getRuntime(), javaResult, this.getReturnType());
            }
            catch (IllegalArgumentException e) {
                throw this.getRuntime().newTypeError("expected " + this.argument_types().inspect());
            }
            catch (IllegalAccessException iae) {
                throw this.getRuntime().newTypeError("illegal access on '" + this.sm.getName() + "': " + iae.getMessage());
            }
            catch (InvocationTargetException ite) {
                if (this.getRuntime().getDebug().isTrue()) {
                    ite.getTargetException().printStackTrace();
                }
                this.getRuntime().getJavaSupport().handleNativeException(ite.getTargetException(), this.sm);
                return this.getRuntime().getNil();
            }
        }

        private int getArity() {
            return this.getParameterTypes().length;
        }
    }
}

