/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.SignalFacade;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class SunSignalFacade
implements SignalFacade {
    public IRubyObject trap(IRubyObject recv2, IRubyObject blk, IRubyObject sig) {
        return this.trap(recv2.getRuntime(), new JRubySignalHandler(recv2.getRuntime(), blk, sig.toString()));
    }

    public IRubyObject trap(Ruby runtime2, BlockCallback blk, String sig) {
        return this.trap(runtime2, new JRubySignalHandler(runtime2, blk, sig));
    }

    private IRubyObject trap(final Ruby runtime2, final JRubySignalHandler handler) {
        SignalHandler oldHandler;
        Signal signal2;
        try {
            signal2 = new Signal(handler.signal);
        }
        catch (Throwable e) {
            return runtime2.getNil();
        }
        try {
            oldHandler = Signal.handle(signal2, handler);
        }
        catch (Exception e) {
            throw runtime2.newArgumentError(e.getMessage());
        }
        BlockCallback callback = null;
        if (oldHandler instanceof JRubySignalHandler) {
            JRubySignalHandler jsHandler = (JRubySignalHandler)oldHandler;
            if (jsHandler.blockCallback != null) {
                callback = jsHandler.blockCallback;
            } else {
                return jsHandler.block;
            }
        }
        if (callback == null) {
            callback = new BlockCallback(){

                public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
                    oldHandler.handle(new Signal(handler.signal));
                    return runtime2.getNil();
                }
            };
        }
        RubyModule signalModule = runtime2.getModule("Signal");
        Block block = CallBlock.newCallClosure(signalModule, signalModule, Arity.noArguments(), callback, runtime2.getCurrentContext());
        return RubyProc.newProc(runtime2, block, Block.Type.NORMAL);
    }

    private static final class JRubySignalHandler
    implements SignalHandler {
        private final Ruby runtime;
        private final IRubyObject block;
        private final String signal;
        private final BlockCallback blockCallback;

        public JRubySignalHandler(Ruby runtime2, IRubyObject block, String signal2) {
            this(runtime2, block, null, signal2);
        }

        public JRubySignalHandler(Ruby runtime2, BlockCallback callback, String signal2) {
            this(runtime2, null, callback, signal2);
        }

        private JRubySignalHandler(Ruby runtime2, IRubyObject block, BlockCallback callback, String signal2) {
            this.runtime = runtime2;
            this.block = block;
            this.blockCallback = callback;
            this.signal = signal2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(Signal signal2) {
            ThreadContext context = this.runtime.getCurrentContext();
            try {
                if (this.block != null) {
                    this.block.callMethod(context, "call");
                } else {
                    this.blockCallback.call(context, new IRubyObject[0], Block.NULL_BLOCK);
                }
            }
            catch (RaiseException e) {
                try {
                    this.runtime.getThread().callMethod(context, "main").callMethod(context, "raise", e.getException());
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            catch (MainExitException mee) {
                this.runtime.getThreadService().getMainThread().kill();
            }
            finally {
                Signal.handle(new Signal(this.signal), this);
            }
        }
    }
}

