/*
 * Decompiled with CFR 0.152.
 */
package org.joni.ast;

import org.jcodings.CodeRange;
import org.jcodings.Encoding;
import org.jcodings.IntHolder;
import org.jcodings.exception.EncodingException;
import org.joni.BitSet;
import org.joni.CodeRangeBuffer;
import org.joni.ScanEnvironment;
import org.joni.ast.Node;
import org.joni.constants.CCSTATE;
import org.joni.constants.CCVALTYPE;
import org.joni.exception.InternalException;
import org.joni.exception.SyntaxException;
import org.joni.exception.ValueException;

public final class CClassNode
extends Node {
    private static final int FLAG_NCCLASS_NOT = 1;
    private static final int FLAG_NCCLASS_SHARE = 2;
    int flags;
    public final BitSet bs = new BitSet();
    public CodeRangeBuffer mbuf;
    private int ctype;
    private Encoding enc;

    public CClassNode() {
    }

    public CClassNode(int n, Encoding encoding2, boolean bl, int n2, int[] nArray) {
        this(bl, n2, nArray);
        this.ctype = n;
        this.enc = encoding2;
    }

    public CClassNode(boolean bl, int n, int[] nArray) {
        if (bl) {
            this.setNot();
        }
        if (n > 0 && nArray != null) {
            int n2 = nArray[0];
            for (int i = 0; i < n2; ++i) {
                int n3 = nArray[i * 2 + 1];
                int n4 = nArray[i * 2 + 2];
                for (int j = n3; j <= n4; ++j) {
                    if (j >= n) {
                        this.setupBuffer(nArray);
                        return;
                    }
                    this.bs.set(j);
                }
            }
        }
        this.setupBuffer(nArray);
    }

    public int getType() {
        return 1;
    }

    public String getName() {
        return "Character Class";
    }

    public boolean equals(Object object) {
        if (!(object instanceof CClassNode)) {
            return false;
        }
        CClassNode cClassNode = (CClassNode)object;
        return this.ctype == cClassNode.ctype && this.isNot() == cClassNode.isNot() && this.enc == cClassNode.enc;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n  flags: " + this.flagsToString());
        stringBuilder.append("\n  bs: " + CClassNode.pad(this.bs, n + 1));
        stringBuilder.append("\n  mbuf: " + CClassNode.pad(this.mbuf, n + 1));
        return stringBuilder.toString();
    }

    public String flagsToString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isNot()) {
            stringBuilder.append("NOT ");
        }
        if (this.isShare()) {
            stringBuilder.append("SHARE ");
        }
        return stringBuilder.toString();
    }

    private void setupBuffer(int[] nArray) {
        if (nArray != null) {
            if (nArray[0] == 0) {
                return;
            }
            this.mbuf = new CodeRangeBuffer(nArray);
        }
    }

    public boolean isEmpty() {
        return this.mbuf == null && this.bs.isEmpty();
    }

    public void addCodeRangeToBuf(int n, int n2) {
        this.mbuf = CodeRangeBuffer.addCodeRangeToBuff(this.mbuf, n, n2);
    }

    public void addCodeRange(ScanEnvironment scanEnvironment, int n, int n2) {
        this.mbuf = CodeRangeBuffer.addCodeRange(this.mbuf, scanEnvironment, n, n2);
    }

    public void addAllMultiByteRange(Encoding encoding2) {
        this.mbuf = CodeRangeBuffer.addAllMultiByteRange(encoding2, this.mbuf);
    }

    public void clearNotFlag(Encoding encoding2) {
        if (this.isNot()) {
            this.bs.invert();
            if (!encoding2.isSingleByte()) {
                this.mbuf = CodeRangeBuffer.notCodeRangeBuff(encoding2, this.mbuf);
            }
            this.clearNot();
        }
    }

    public void and(CClassNode cClassNode, Encoding encoding2) {
        Object object;
        boolean bl = this.isNot();
        BitSet bitSet = this.bs;
        CodeRangeBuffer codeRangeBuffer = this.mbuf;
        boolean bl2 = cClassNode.isNot();
        BitSet bitSet2 = cClassNode.bs;
        CodeRangeBuffer codeRangeBuffer2 = cClassNode.mbuf;
        if (bl) {
            object = new BitSet();
            bitSet.invertTo((BitSet)object);
            bitSet = object;
        }
        if (bl2) {
            object = new BitSet();
            bitSet2.invertTo((BitSet)object);
            bitSet2 = object;
        }
        bitSet.and(bitSet2);
        if (bitSet != this.bs) {
            this.bs.copy(bitSet);
            bitSet = this.bs;
        }
        if (bl) {
            this.bs.invert();
        }
        object = null;
        if (!encoding2.isSingleByte()) {
            if (bl && bl2) {
                object = CodeRangeBuffer.orCodeRangeBuff(encoding2, codeRangeBuffer, false, codeRangeBuffer2, false);
            } else {
                object = CodeRangeBuffer.andCodeRangeBuff(codeRangeBuffer, bl, codeRangeBuffer2, bl2);
                if (bl) {
                    object = CodeRangeBuffer.notCodeRangeBuff(encoding2, (CodeRangeBuffer)object);
                }
            }
            this.mbuf = object;
        }
    }

    public void or(CClassNode cClassNode, Encoding encoding2) {
        Object object;
        boolean bl = this.isNot();
        BitSet bitSet = this.bs;
        CodeRangeBuffer codeRangeBuffer = this.mbuf;
        boolean bl2 = cClassNode.isNot();
        BitSet bitSet2 = cClassNode.bs;
        CodeRangeBuffer codeRangeBuffer2 = cClassNode.mbuf;
        if (bl) {
            object = new BitSet();
            bitSet.invertTo((BitSet)object);
            bitSet = object;
        }
        if (bl2) {
            object = new BitSet();
            bitSet2.invertTo((BitSet)object);
            bitSet2 = object;
        }
        bitSet.or(bitSet2);
        if (bitSet != this.bs) {
            this.bs.copy(bitSet);
            bitSet = this.bs;
        }
        if (bl) {
            this.bs.invert();
        }
        if (!encoding2.isSingleByte()) {
            object = null;
            if (bl && bl2) {
                object = CodeRangeBuffer.andCodeRangeBuff(codeRangeBuffer, false, codeRangeBuffer2, false);
            } else {
                object = CodeRangeBuffer.orCodeRangeBuff(encoding2, codeRangeBuffer, bl, codeRangeBuffer2, bl2);
                if (bl) {
                    object = CodeRangeBuffer.notCodeRangeBuff(encoding2, (CodeRangeBuffer)object);
                }
            }
            this.mbuf = object;
        }
    }

    public void addCTypeByRange(int n, boolean bl, Encoding encoding2, int n2, int[] nArray) {
        int n3 = nArray[0];
        if (!bl) {
            int n4;
            for (n4 = 0; n4 < n3; ++n4) {
                for (int i = nArray[n4 * 2 + 1]; i <= nArray[n4 * 2 + 2]; ++i) {
                    if (i >= n2) {
                        if (i == nArray[n4 * 2 + 2]) {
                            ++n4;
                        } else if (i > nArray[n4 * 2 + 1]) {
                            this.addCodeRangeToBuf(i, nArray[n4 * 2 + 2]);
                            ++n4;
                        }
                        while (n4 < n3) {
                            this.addCodeRangeToBuf(nArray[2 * n4 + 1], nArray[2 * n4 + 2]);
                            ++n4;
                        }
                        return;
                    }
                    this.bs.set(i);
                }
            }
            for (n4 = 0; n4 < n3; ++n4) {
                this.addCodeRangeToBuf(nArray[2 * n4 + 1], nArray[2 * n4 + 2]);
            }
        } else {
            int n5;
            int n6 = 0;
            for (n5 = 0; n5 < n3; ++n5) {
                for (int i = n6; i < nArray[2 * n5 + 1]; ++i) {
                    if (i >= n2) {
                        n6 = n2;
                        for (n5 = 0; n5 < n3; ++n5) {
                            if (n6 < nArray[2 * n5 + 1]) {
                                this.addCodeRangeToBuf(n6, nArray[n5 * 2 + 1] - 1);
                            }
                            n6 = nArray[n5 * 2 + 2] + 1;
                        }
                        if (n6 < Integer.MAX_VALUE) {
                            this.addCodeRangeToBuf(n6, Integer.MAX_VALUE);
                        }
                        return;
                    }
                    this.bs.set(i);
                }
                n6 = nArray[2 * n5 + 2] + 1;
            }
            for (n5 = n6; n5 < n2; ++n5) {
                this.bs.set(n5);
            }
            n6 = n2;
            for (n5 = 0; n5 < n3; ++n5) {
                if (n6 < nArray[2 * n5 + 1]) {
                    this.addCodeRangeToBuf(n6, nArray[n5 * 2 + 1] - 1);
                }
                n6 = nArray[n5 * 2 + 2] + 1;
            }
            if (n6 < Integer.MAX_VALUE) {
                this.addCodeRangeToBuf(n6, Integer.MAX_VALUE);
            }
        }
    }

    public void addCType(int n, boolean bl, ScanEnvironment scanEnvironment, IntHolder intHolder) {
        Encoding encoding2 = scanEnvironment.enc;
        int[] nArray = encoding2.ctypeCodeRange(n, intHolder);
        if (nArray != null) {
            this.addCTypeByRange(n, bl, encoding2, intHolder.value, nArray);
            return;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                if (bl) {
                    for (int i = 0; i < 256; ++i) {
                        if (encoding2.isCodeCType(i, n)) continue;
                        this.bs.set(i);
                    }
                    this.addAllMultiByteRange(encoding2);
                    break;
                }
                for (int i = 0; i < 256; ++i) {
                    if (!encoding2.isCodeCType(i, n)) continue;
                    this.bs.set(i);
                }
                break;
            }
            case 5: 
            case 7: {
                if (bl) {
                    for (int i = 0; i < 256; ++i) {
                        if (encoding2.isCodeCType(i, n)) continue;
                        this.bs.set(i);
                    }
                    break;
                }
                for (int i = 0; i < 256; ++i) {
                    if (!encoding2.isCodeCType(i, n)) continue;
                    this.bs.set(i);
                }
                this.addAllMultiByteRange(encoding2);
                break;
            }
            case 12: {
                if (!bl) {
                    for (int i = 0; i < 256; ++i) {
                        if (!encoding2.isSbWord(i)) continue;
                        this.bs.set(i);
                    }
                    this.addAllMultiByteRange(encoding2);
                    break;
                }
                for (int i = 0; i < 256; ++i) {
                    try {
                        if (encoding2.codeToMbcLength(i) <= 0 || encoding2.isWord(i)) continue;
                        this.bs.set(i);
                        continue;
                    }
                    catch (EncodingException encodingException) {
                        // empty catch block
                    }
                }
                break;
            }
            default: {
                throw new InternalException("internal parser error (bug)");
            }
        }
    }

    public void nextStateClass(CCStateArg cCStateArg, ScanEnvironment scanEnvironment) {
        if (cCStateArg.state == CCSTATE.RANGE) {
            throw new SyntaxException("char-class value at end of range");
        }
        if (cCStateArg.state == CCSTATE.VALUE && cCStateArg.type != CCVALTYPE.CLASS) {
            if (cCStateArg.type == CCVALTYPE.SB) {
                this.bs.set(cCStateArg.vs);
            } else if (cCStateArg.type == CCVALTYPE.CODE_POINT) {
                this.addCodeRange(scanEnvironment, cCStateArg.vs, cCStateArg.vs);
            }
        }
        cCStateArg.state = CCSTATE.VALUE;
        cCStateArg.type = CCVALTYPE.CLASS;
    }

    public void nextStateValue(CCStateArg cCStateArg, ScanEnvironment scanEnvironment) {
        switch (cCStateArg.state) {
            case VALUE: {
                if (cCStateArg.type == CCVALTYPE.SB) {
                    if (cCStateArg.vs > 255) {
                        throw new ValueException("invalid code point value");
                    }
                    this.bs.set(cCStateArg.vs);
                    break;
                }
                if (cCStateArg.type != CCVALTYPE.CODE_POINT) break;
                this.addCodeRange(scanEnvironment, cCStateArg.vs, cCStateArg.vs);
                break;
            }
            case RANGE: {
                if (cCStateArg.inType == cCStateArg.type) {
                    if (cCStateArg.inType == CCVALTYPE.SB) {
                        if (cCStateArg.vs > 255 || cCStateArg.v > 255) {
                            throw new ValueException("invalid code point value");
                        }
                        if (cCStateArg.vs > cCStateArg.v) {
                            if (scanEnvironment.syntax.allowEmptyRangeInCC()) {
                                cCStateArg.state = CCSTATE.COMPLETE;
                                break;
                            }
                            throw new ValueException("empty range in char class");
                        }
                        this.bs.setRange(cCStateArg.vs, cCStateArg.v);
                    } else {
                        this.addCodeRange(scanEnvironment, cCStateArg.vs, cCStateArg.v);
                    }
                } else {
                    if (cCStateArg.vs > cCStateArg.v) {
                        if (scanEnvironment.syntax.allowEmptyRangeInCC()) {
                            cCStateArg.state = CCSTATE.COMPLETE;
                            break;
                        }
                        throw new ValueException("empty range in char class");
                    }
                    this.bs.setRange(cCStateArg.vs, cCStateArg.v < 255 ? cCStateArg.v : 255);
                    this.addCodeRange(scanEnvironment, cCStateArg.vs, cCStateArg.v);
                }
                cCStateArg.state = CCSTATE.COMPLETE;
                break;
            }
            case COMPLETE: 
            case START: {
                cCStateArg.state = CCSTATE.VALUE;
                break;
            }
        }
        cCStateArg.vsIsRaw = cCStateArg.vIsRaw;
        cCStateArg.vs = cCStateArg.v;
        cCStateArg.type = cCStateArg.inType;
    }

    public boolean isCodeInCCLength(int n, int n2) {
        boolean bl = n > 1 || n2 >= 256 ? (this.mbuf == null ? false : CodeRange.isInCodeRange(this.mbuf.getCodeRange(), n2)) : this.bs.at(n2);
        if (this.isNot()) {
            return !bl;
        }
        return bl;
    }

    public boolean isCodeInCC(Encoding encoding2, int n) {
        int n2 = encoding2.minLength() > 1 ? 2 : encoding2.codeToMbcLength(n);
        return this.isCodeInCCLength(n2, n);
    }

    public void setNot() {
        this.flags |= 1;
    }

    public void clearNot() {
        this.flags &= 0xFFFFFFFE;
    }

    public boolean isNot() {
        return (this.flags & 1) != 0;
    }

    public void setShare() {
        this.flags |= 2;
    }

    public void clearShare() {
        this.flags &= 0xFFFFFFFD;
    }

    public boolean isShare() {
        return (this.flags & 2) != 0;
    }

    public static final class CCStateArg {
        public int v;
        public int vs;
        public boolean vsIsRaw;
        public boolean vIsRaw;
        public CCVALTYPE inType;
        public CCVALTYPE type;
        public CCSTATE state;
    }
}

