/*
 * Decompiled with CFR 0.152.
 */
package org.joni.ast;

import org.joni.ScanEnvironment;
import org.joni.ast.StateNode;
import org.joni.exception.ValueException;

public final class BackRefNode
extends StateNode {
    public int backNum;
    public int[] back;
    public int nestLevel;

    public BackRefNode(int n, int[] nArray, boolean bl, ScanEnvironment scanEnvironment) {
        this.backNum = n;
        if (bl) {
            this.setNameRef();
        }
        for (int i = 0; i < n; ++i) {
            if (nArray[i] > scanEnvironment.numMem || scanEnvironment.memNodes[nArray[i]] != null) continue;
            this.setRecursion();
            break;
        }
        this.back = new int[n];
        System.arraycopy(nArray, 0, this.back, 0, n);
    }

    public BackRefNode(int n, int[] nArray, boolean bl, boolean bl2, int n2, ScanEnvironment scanEnvironment) {
        this(n, nArray, bl, scanEnvironment);
        if (bl2) {
            this.setNestLevel();
            this.nestLevel = n2;
        }
    }

    public int getType() {
        return 4;
    }

    public String getName() {
        return "Back Ref";
    }

    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder(super.toString(n));
        stringBuilder.append("\n  backNum: " + this.backNum);
        String string2 = "";
        for (int i = 0; i < this.back.length; ++i) {
            string2 = string2 + this.back[i] + ", ";
        }
        stringBuilder.append("\n  back: " + string2);
        stringBuilder.append("\n  nextLevel: " + this.nestLevel);
        return stringBuilder.toString();
    }

    public void renumber(int[] nArray) {
        if (!this.isNameRef()) {
            throw new ValueException("numbered backref/call is not allowed. (use name)");
        }
        int n = this.backNum;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[this.back[i]];
            if (n3 <= 0) continue;
            this.back[n2] = n3;
            ++n2;
        }
        this.backNum = n2;
    }
}

