/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.Encoding;
import org.jcodings.IntHolder;
import org.joni.Regex;

public abstract class SearchAlgorithm {
    public static final SearchAlgorithm NONE = new SearchAlgorithm(){

        public final String getName() {
            return "NONE";
        }

        public final int search(Regex regex, byte[] byArray, int n, int n2, int n3) {
            return n;
        }

        public final int searchBackward(Regex regex, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
            return n;
        }
    };
    public static final SearchAlgorithm SLOW = new SearchAlgorithm(){

        public final String getName() {
            return "EXACT";
        }

        public final int search(Regex regex, byte[] byArray, int n, int n2, int n3) {
            Encoding encoding2 = regex.enc;
            byte[] byArray2 = regex.exact;
            int n4 = regex.exactP;
            int n5 = regex.exactEnd;
            int n6 = n2;
            if ((n6 -= n5 - n4 - 1) > n3) {
                n6 = n3;
            }
            for (int i = n; i < n6; i += encoding2.length(byArray, i, n2)) {
                int n7;
                if (byArray[i] != byArray2[n4]) continue;
                int n8 = i + 1;
                for (n7 = n4 + 1; n7 < n5 && byArray2[n7] == byArray[n8++]; ++n7) {
                }
                if (n7 != n5) continue;
                return i;
            }
            return -1;
        }

        public final int searchBackward(Regex regex, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
            Encoding encoding2 = regex.enc;
            byte[] byArray2 = regex.exact;
            int n7 = regex.exactP;
            int n8 = regex.exactEnd;
            int n9 = n3;
            n9 = (n9 -= n8 - n7) > n4 ? n4 : encoding2.leftAdjustCharHead(byArray, n2, n9, n3);
            while (n9 >= n) {
                if (byArray[n9] == byArray2[n7]) {
                    int n10;
                    int n11 = n9 + 1;
                    for (n10 = n7 + 1; n10 < n8 && byArray2[n10] == byArray[n11++]; ++n10) {
                    }
                    if (n10 == n8) {
                        return n9;
                    }
                }
                n9 = encoding2.prevCharHead(byArray, n2, n9, n3);
            }
            return -1;
        }
    };
    public static final SearchAlgorithm SLOW_SB = new SearchAlgorithm(){

        public final String getName() {
            return "EXACT_SB";
        }

        public final int search(Regex regex, byte[] byArray, int n, int n2, int n3) {
            byte[] byArray2 = regex.exact;
            int n4 = regex.exactP;
            int n5 = regex.exactEnd;
            int n6 = n2;
            if ((n6 -= n5 - n4 - 1) > n3) {
                n6 = n3;
            }
            for (int i = n; i < n6; ++i) {
                int n7;
                if (byArray[i] != byArray2[n4]) continue;
                int n8 = i + 1;
                for (n7 = n4 + 1; n7 < n5 && byArray2[n7] == byArray[n8++]; ++n7) {
                }
                if (n7 != n5) continue;
                return i;
            }
            return -1;
        }

        public final int searchBackward(Regex regex, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
            byte[] byArray2 = regex.exact;
            int n7 = regex.exactP;
            int n8 = regex.exactEnd;
            int n9 = n3;
            if ((n9 -= n8 - n7) > n4) {
                n9 = n4;
            }
            while (n9 >= n) {
                if (byArray[n9] == byArray2[n7]) {
                    int n10;
                    int n11 = n9 + 1;
                    for (n10 = n7 + 1; n10 < n8 && byArray2[n10] == byArray[n11++]; ++n10) {
                    }
                    if (n10 == n8) {
                        return n9;
                    }
                }
                --n9;
            }
            return -1;
        }
    };
    public static final SearchAlgorithm SLOW_IC_SB = new SearchAlgorithm(){

        public final String getName() {
            return "EXACT_IC_SB";
        }

        public final int search(Regex regex, byte[] byArray, int n, int n2, int n3) {
            byte[] byArray2 = regex.enc.toLowerCaseTable();
            byte[] byArray3 = regex.exact;
            int n4 = regex.exactP;
            int n5 = regex.exactEnd;
            int n6 = n2;
            if ((n6 -= n5 - n4 - 1) > n3) {
                n6 = n3;
            }
            for (int i = n; i < n6; ++i) {
                int n7;
                if (byArray3[n4] != byArray2[byArray[i] & 0xFF]) continue;
                int n8 = i + 1;
                for (n7 = n4 + 1; n7 < n5 && byArray3[n7] == byArray2[byArray[n8++] & 0xFF]; ++n7) {
                }
                if (n7 != n5) continue;
                return i;
            }
            return -1;
        }

        public final int searchBackward(Regex regex, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
            byte[] byArray2 = regex.enc.toLowerCaseTable();
            byte[] byArray3 = regex.exact;
            int n7 = regex.exactP;
            int n8 = regex.exactEnd;
            int n9 = n3;
            if ((n9 -= n8 - n7) > n4) {
                n9 = n4;
            }
            while (n9 >= n) {
                if (byArray3[n7] == byArray2[byArray[n9] & 0xFF]) {
                    int n10;
                    int n11 = n9 + 1;
                    for (n10 = n7 + 1; n10 < n8 && byArray3[n10] == byArray2[byArray[n11++] & 0xFF]; ++n10) {
                    }
                    if (n10 == n8) {
                        return n9;
                    }
                }
                --n9;
            }
            return -1;
        }
    };
    public static final SearchAlgorithm BM = new SearchAlgorithm(){
        private static final int BM_BACKWARD_SEARCH_LENGTH_THRESHOLD = 100;

        public final String getName() {
            return "EXACT_BM";
        }

        public final int search(Regex regex, byte[] byArray, int n, int n2, int n3) {
            int n4;
            byte[] byArray2 = regex.exact;
            int n5 = regex.exactEnd;
            int n6 = regex.exactP;
            int n7 = n3 + (n5 - n6) - 1;
            if (n7 > n2) {
                n7 = n2;
            }
            int n8 = n5 - 1;
            if (regex.intMap == null) {
                for (n4 = n + (n5 - n6) - 1; n4 < n7; n4 += regex.map[byArray[n4] & 0xFF]) {
                    int n9;
                    int n10 = n4;
                    for (n9 = n8; n9 >= n6 && byArray[n10] == byArray2[n9]; --n9) {
                        --n10;
                    }
                    if (n9 >= n6) continue;
                    return n10 + 1;
                }
            } else {
                while (n4 < n7) {
                    int n11;
                    int n12 = n4;
                    for (n11 = n8; n11 >= n6 && byArray[n12] == byArray2[n11]; --n11) {
                        --n12;
                    }
                    if (n11 < n6) {
                        return n12 + 1;
                    }
                    n4 += regex.intMap[byArray[n4] & 0xFF];
                }
            }
            return -1;
        }

        public final int searchBackward(Regex regex, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
            int n7;
            Encoding encoding2 = regex.enc;
            byte[] byArray2 = regex.exact;
            int n8 = regex.exactP;
            int n9 = regex.exactEnd;
            if (regex.intMapBackward == null) {
                if (n5 - n6 < 100) {
                    return SLOW.searchBackward(regex, byArray, n, n2, n3, n4, n5, n6);
                }
                this.setBmBackwardSkip(regex, byArray2, n8, n9);
            }
            n7 = n4 < (n7 = n3 - (n9 - n8)) ? n4 : encoding2.leftAdjustCharHead(byArray, n2, n7, n3);
            while (n7 >= n) {
                int n10;
                int n11 = n7;
                for (n10 = n8; n10 < n9 && byArray[n11] == byArray2[n10]; ++n10) {
                    ++n11;
                }
                if (n10 == n9) {
                    return n7;
                }
                n7 -= regex.intMapBackward[byArray[n7] & 0xFF];
                n7 = encoding2.leftAdjustCharHead(byArray, n2, n7, n3);
            }
            return -1;
        }

        private void setBmBackwardSkip(Regex regex, byte[] byArray, int n, int n2) {
            int n3;
            int[] nArray;
            if (regex.intMapBackward == null) {
                nArray = new int[256];
                regex.intMapBackward = nArray;
            } else {
                nArray = regex.intMapBackward;
            }
            int n4 = n2 - n;
            for (n3 = 0; n3 < 256; ++n3) {
                nArray[n3] = n4;
            }
            for (n3 = n4 - 1; n3 > 0; --n3) {
                nArray[byArray[n3] & 0xFF] = n3;
            }
        }
    };
    public static final SearchAlgorithm BM_NOT_REV = new SearchAlgorithm(){

        public final String getName() {
            return "EXACT_BM_NOT_REV";
        }

        public final int search(Regex regex, byte[] byArray, int n, int n2, int n3) {
            Encoding encoding2 = regex.enc;
            byte[] byArray2 = regex.exact;
            int n4 = n3;
            int n5 = regex.exactEnd;
            int n6 = n5 - 1;
            int n7 = regex.exactP;
            int n8 = n6 - n7;
            if (n4 + n8 > n2) {
                n4 = n2 - n8;
            }
            int n9 = n;
            if (regex.intMap == null) {
                while (n9 < n4) {
                    int n10;
                    int n11;
                    int n12 = n11 = n9 + n8;
                    for (n10 = n6; n10 >= n7 && byArray[n12] == byArray2[n10]; --n10) {
                        --n12;
                    }
                    if (n10 < n7) {
                        return n9;
                    }
                    byte by = regex.map[byArray[n11] & 0xFF];
                    n10 = n9;
                    while ((n9 += encoding2.length(byArray, n9, n2)) - n10 < by && n9 < n4) {
                    }
                }
            } else {
                while (n9 < n4) {
                    int n13;
                    int n14;
                    int n15 = n14 = n9 + n8;
                    for (n13 = n6; n13 >= n7 && byArray[n15] == byArray2[n13]; --n13) {
                        --n15;
                    }
                    if (n13 < n7) {
                        return n9;
                    }
                    int n16 = regex.intMap[byArray[n14] & 0xFF];
                    n13 = n9;
                    while ((n9 += encoding2.length(byArray, n9, n2)) - n13 < n16 && n9 < n4) {
                    }
                }
            }
            return -1;
        }

        public final int searchBackward(Regex regex, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
            return BM.searchBackward(regex, byArray, n, n2, n3, n4, n5, n6);
        }
    };
    public static final SearchAlgorithm MAP = new SearchAlgorithm(){

        public final String getName() {
            return "MAP";
        }

        public final int search(Regex regex, byte[] byArray, int n, int n2, int n3) {
            Encoding encoding2 = regex.enc;
            byte[] byArray2 = regex.map;
            for (int i = n; i < n3; i += encoding2.length(byArray, i, n2)) {
                if (byArray2[byArray[i] & 0xFF] == 0) continue;
                return i;
            }
            return -1;
        }

        public final int searchBackward(Regex regex, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
            Encoding encoding2 = regex.enc;
            byte[] byArray2 = regex.map;
            int n7 = n4;
            if (n7 >= n3) {
                n7 = n3 - 1;
            }
            while (n7 >= n) {
                if (byArray2[byArray[n7] & 0xFF] != 0) {
                    return n7;
                }
                n7 = encoding2.prevCharHead(byArray, n2, n7, n3);
            }
            return -1;
        }
    };
    public static final SearchAlgorithm MAP_SB = new SearchAlgorithm(){

        public final String getName() {
            return "MAP_SB";
        }

        public final int search(Regex regex, byte[] byArray, int n, int n2, int n3) {
            byte[] byArray2 = regex.map;
            for (int i = n; i < n3; ++i) {
                if (byArray2[byArray[i] & 0xFF] == 0) continue;
                return i;
            }
            return -1;
        }

        public final int searchBackward(Regex regex, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
            byte[] byArray2 = regex.map;
            int n7 = n4;
            if (n7 >= n3) {
                n7 = n3 - 1;
            }
            while (n7 >= n) {
                if (byArray2[byArray[n7] & 0xFF] != 0) {
                    return n7;
                }
                --n7;
            }
            return -1;
        }
    };

    public abstract String getName();

    public abstract int search(Regex var1, byte[] var2, int var3, int var4, int var5);

    public abstract int searchBackward(Regex var1, byte[] var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public static final class SLOW_IC
    extends SearchAlgorithm {
        private final byte[] buf = new byte[18];
        private final IntHolder holder = new IntHolder();
        private final int caseFoldFlag;
        private final Encoding enc;

        public SLOW_IC(Regex regex) {
            this.caseFoldFlag = regex.caseFoldFlag;
            this.enc = regex.enc;
        }

        public final String getName() {
            return "EXACT_IC";
        }

        public final int search(Regex regex, byte[] byArray, int n, int n2, int n3) {
            byte[] byArray2 = regex.exact;
            int n4 = regex.exactP;
            int n5 = regex.exactEnd;
            int n6 = n2;
            if ((n6 -= n5 - n4 - 1) > n3) {
                n6 = n3;
            }
            for (int i = n; i < n6; i += this.enc.length(byArray, i, n2)) {
                if (!this.lowerCaseMatch(byArray2, n4, n5, byArray, i, n2)) continue;
                return i;
            }
            return -1;
        }

        public final int searchBackward(Regex regex, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
            byte[] byArray2 = regex.exact;
            int n7 = regex.exactP;
            int n8 = regex.exactEnd;
            int n9 = n3;
            n9 = (n9 -= n8 - n7) > n4 ? n4 : this.enc.leftAdjustCharHead(byArray, n2, n9, n3);
            while (n9 >= n) {
                if (this.lowerCaseMatch(byArray2, n7, n8, byArray, n9, n3)) {
                    return n9;
                }
                n9 = this.enc.prevCharHead(byArray, n2, n9, n3);
            }
            return -1;
        }

        private boolean lowerCaseMatch(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
            this.holder.value = n3;
            while (n < n2) {
                int n5 = this.enc.mbcCaseFold(this.caseFoldFlag, byArray2, this.holder, n4, this.buf);
                if (n5 == 1) {
                    if (byArray[n++] == this.buf[0]) continue;
                    return false;
                }
                int n6 = 0;
                while (n5 > 0) {
                    if (byArray[n++] != this.buf[n6++]) {
                        return false;
                    }
                    --n5;
                }
            }
            return true;
        }
    }
}

