/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.joni.CaptureTreeNode;

public final class Region {
    static final int REGION_NOTPOS = -1;
    public final int numRegs;
    public final int[] beg;
    public final int[] end;
    public CaptureTreeNode historyRoot;

    public Region(int n) {
        this.numRegs = n;
        this.beg = new int[n];
        this.end = new int[n];
    }

    public Region(int n, int n2) {
        this.numRegs = 1;
        this.beg = new int[]{n};
        this.end = new int[]{n2};
    }

    public Region clone() {
        Region region = new Region(this.numRegs);
        System.arraycopy(this.beg, 0, region.beg, 0, this.beg.length);
        System.arraycopy(this.end, 0, region.end, 0, this.end.length);
        if (this.historyRoot != null) {
            region.historyRoot = this.historyRoot.cloneTree();
        }
        return region;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Region: \n");
        for (int i = 0; i < this.beg.length; ++i) {
            stringBuilder.append(" " + i + ": (" + this.beg[i] + "-" + this.end[i] + ")");
        }
        return stringBuilder.toString();
    }

    CaptureTreeNode getCaptureTree() {
        return this.historyRoot;
    }

    void clear() {
        for (int i = 0; i < this.beg.length; ++i) {
            this.end[i] = -1;
            this.beg[i] = -1;
        }
    }
}

