/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.CaseFoldCodeItem;
import org.joni.ArrayCompiler;
import org.joni.BitStatus;
import org.joni.MinMaxLen;
import org.joni.NameEntry;
import org.joni.NodeOptInfo;
import org.joni.OptEnvironment;
import org.joni.Option;
import org.joni.Parser;
import org.joni.ScanEnvironment;
import org.joni.UnsetAddrList;
import org.joni.ast.AnchorNode;
import org.joni.ast.BackRefNode;
import org.joni.ast.CClassNode;
import org.joni.ast.CTypeNode;
import org.joni.ast.CallNode;
import org.joni.ast.ConsAltNode;
import org.joni.ast.EncloseNode;
import org.joni.ast.Node;
import org.joni.ast.QuantifierNode;
import org.joni.ast.StateNode;
import org.joni.ast.StringNode;

final class Analyser
extends Parser {
    private static final int GET_CHAR_LEN_VARLEN = -1;
    private static final int GET_CHAR_LEN_TOP_ALT_VARLEN = -2;
    private static final int RECURSION_EXIST = 1;
    private static final int RECURSION_INFINITE = 2;
    private static final int FOUND_CALLED_NODE = 1;
    private static final int THRESHOLD_CASE_FOLD_ALT_FOR_EXPANSION = 8;
    private static final int CEC_THRES_NUM_BIG_REPEAT = 512;
    private static final int CEC_INFINITE_NUM = Integer.MAX_VALUE;
    private static final int CEC_IN_INFINITE_REPEAT = 1;
    private static final int CEC_IN_FINITE_REPEAT = 2;
    private static final int CEC_CONT_BIG_REPEAT = 4;
    private static final int IN_ALT = 1;
    private static final int IN_NOT = 2;
    private static final int IN_REPEAT = 4;
    private static final int IN_VAR_REPEAT = 8;
    private static final int EXPAND_STRING_MAX_LENGTH = 100;
    private static final int MAX_NODE_OPT_INFO_REF_COUNT = 5;

    protected Analyser(ScanEnvironment scanEnvironment, byte[] byArray, int n, int n2) {
        super(scanEnvironment, byArray, n, n2);
    }

    protected final void compile() {
        this.regex.state = -1;
        this.reset();
        this.regex.numMem = 0;
        this.regex.numRepeat = 0;
        this.regex.numNullCheck = 0;
        this.regex.repeatRangeLo = null;
        this.regex.repeatRangeHi = null;
        this.regex.numCombExpCheck = 0;
        this.parse();
        if (this.env.numNamed > 0 && this.syntax.captureOnlyNamedGroup() && !Option.isCaptureGroup(this.regex.options)) {
            if (this.env.numNamed != this.env.numMem) {
                this.root = this.disableNoNameGroupCapture(this.root);
            } else {
                this.numberedRefCheck(this.root);
            }
        }
        if (this.env.numCall > 0) {
            this.env.unsetAddrList = new UnsetAddrList(this.env.numCall);
            this.setupSubExpCall(this.root);
            this.subexpRecursiveCheckTrav(this.root);
            this.subexpInfRecursiveCheckTrav(this.root);
            this.regex.numCall = this.env.numCall;
        } else {
            this.regex.numCall = 0;
        }
        this.setupTree(this.root, 0);
        this.regex.captureHistory = this.env.captureHistory;
        this.regex.btMemStart = this.env.btMemStart;
        this.regex.btMemEnd = this.env.btMemEnd;
        if (Option.isFindCondition(this.regex.options)) {
            this.regex.btMemEnd = BitStatus.bsAll();
        } else {
            this.regex.btMemEnd = this.env.btMemEnd;
            this.regex.btMemEnd |= this.regex.captureHistory;
        }
        this.regex.clearOptimizeInfo();
        this.setOptimizedInfoFromTree(this.root);
        this.env.memNodes = null;
        this.regex.stackPopLevel = this.regex.numRepeat != 0 || this.regex.btMemEnd != 0 ? 2 : (this.regex.btMemStart != 0 ? 1 : 0);
        new ArrayCompiler(this).compile();
        this.regex.state = 0;
    }

    private Node noNameDisableMap(Node node, int[] nArray, int[] nArray2) {
        switch (node.getType()) {
            case 8: 
            case 9: {
                ConsAltNode consAltNode = (ConsAltNode)node;
                do {
                    consAltNode.setCar(this.noNameDisableMap(consAltNode.car, nArray, nArray2));
                } while ((consAltNode = consAltNode.cdr) != null);
                break;
            }
            case 5: {
                Node node2;
                QuantifierNode quantifierNode = (QuantifierNode)node;
                Node node3 = node2 = quantifierNode.target;
                node2 = this.noNameDisableMap(node2, nArray, nArray2);
                if (node2 == node3) break;
                quantifierNode.setTarget(node2);
                if (node2.getType() != 5) break;
                quantifierNode.reduceNestedQuantifier((QuantifierNode)node2);
                break;
            }
            case 6: {
                EncloseNode encloseNode = (EncloseNode)node;
                if (encloseNode.type == 1) {
                    if (encloseNode.isNamedGroup()) {
                        nArray2[0] = nArray2[0] + 1;
                        nArray[encloseNode.regNum] = nArray2[0];
                        encloseNode.regNum = nArray2[0];
                        encloseNode.setTarget(this.noNameDisableMap(encloseNode.target, nArray, nArray2));
                        break;
                    }
                    node = encloseNode.target;
                    encloseNode.target = null;
                    node = this.noNameDisableMap(node, nArray, nArray2);
                    break;
                }
                encloseNode.setTarget(this.noNameDisableMap(encloseNode.target, nArray, nArray2));
                break;
            }
        }
        return node;
    }

    private void renumberByMap(Node node, int[] nArray) {
        switch (node.getType()) {
            case 8: 
            case 9: {
                ConsAltNode consAltNode = (ConsAltNode)node;
                do {
                    this.renumberByMap(consAltNode.car, nArray);
                } while ((consAltNode = consAltNode.cdr) != null);
                break;
            }
            case 5: {
                this.renumberByMap(((QuantifierNode)node).target, nArray);
                break;
            }
            case 6: {
                this.renumberByMap(((EncloseNode)node).target, nArray);
                break;
            }
            case 4: {
                ((BackRefNode)node).renumber(nArray);
                break;
            }
        }
    }

    protected final void numberedRefCheck(Node node) {
        switch (node.getType()) {
            case 8: 
            case 9: {
                ConsAltNode consAltNode = (ConsAltNode)node;
                do {
                    this.numberedRefCheck(consAltNode.car);
                } while ((consAltNode = consAltNode.cdr) != null);
                break;
            }
            case 5: {
                this.numberedRefCheck(((QuantifierNode)node).target);
                break;
            }
            case 6: {
                this.numberedRefCheck(((EncloseNode)node).target);
                break;
            }
            case 4: {
                BackRefNode backRefNode = (BackRefNode)node;
                if (backRefNode.isNameRef()) break;
                this.newValueException("numbered backref/call is not allowed. (use name)");
                break;
            }
        }
    }

    protected final Node disableNoNameGroupCapture(Node node) {
        int n;
        int[] nArray = new int[this.env.numMem + 1];
        for (int i = 1; i <= this.env.numMem; ++i) {
            nArray[i] = 0;
        }
        int[] nArray2 = new int[]{0};
        node = this.noNameDisableMap(node, nArray, nArray2);
        this.renumberByMap(node, nArray);
        int n2 = 1;
        for (n = 1; n <= this.env.numMem; ++n) {
            if (nArray[n] <= 0) continue;
            this.env.memNodes[n2] = this.env.memNodes[n];
            ++n2;
        }
        n = this.env.captureHistory;
        this.env.captureHistory = BitStatus.bsClear();
        for (n2 = 1; n2 <= 31; ++n2) {
            if (!BitStatus.bsAt(n, n2)) continue;
            this.env.captureHistory = BitStatus.bsOnAtSimple(this.env.captureHistory, nArray[n2]);
        }
        this.env.numMem = this.env.numNamed;
        this.regex.numMem = this.env.numNamed;
        this.regex.renumberNameTable(nArray);
        return node;
    }

    private void swap(Node node, Node node2) {
        node.swap(node2);
        if (this.root == node2) {
            this.root = node;
        } else if (this.root == node) {
            this.root = node2;
        }
    }

    private int quantifiersMemoryInfo(Node node) {
        int n = 0;
        block0 : switch (node.getType()) {
            case 8: 
            case 9: {
                ConsAltNode consAltNode = (ConsAltNode)node;
                do {
                    int n2;
                    if ((n2 = this.quantifiersMemoryInfo(consAltNode.car)) <= n) continue;
                    n = n2;
                } while ((consAltNode = consAltNode.cdr) != null);
                break;
            }
            case 10: {
                CallNode callNode = (CallNode)node;
                if (callNode.isRecursion()) {
                    return 3;
                }
                n = this.quantifiersMemoryInfo(callNode.target);
                break;
            }
            case 5: {
                QuantifierNode quantifierNode = (QuantifierNode)node;
                if (quantifierNode.upper == 0) break;
                n = this.quantifiersMemoryInfo(quantifierNode.target);
                break;
            }
            case 6: {
                EncloseNode encloseNode = (EncloseNode)node;
                switch (encloseNode.type) {
                    case 1: {
                        return 2;
                    }
                    case 2: 
                    case 4: {
                        n = this.quantifiersMemoryInfo(encloseNode.target);
                        break block0;
                    }
                }
                break;
            }
        }
        return n;
    }

    private int getMinMatchLength(Node node) {
        int n = 0;
        switch (node.getType()) {
            case 4: {
                BackRefNode backRefNode = (BackRefNode)node;
                if (backRefNode.isRecursion()) break;
                if (backRefNode.back[0] > this.env.numMem) {
                    this.newValueException("invalid backref number/name");
                }
                n = this.getMinMatchLength(this.env.memNodes[backRefNode.back[0]]);
                for (int i = 1; i < backRefNode.backNum; ++i) {
                    int n2;
                    if (backRefNode.back[i] > this.env.numMem) {
                        this.newValueException("invalid backref number/name");
                    }
                    if (n <= (n2 = this.getMinMatchLength(this.env.memNodes[backRefNode.back[i]]))) continue;
                    n = n2;
                }
                break;
            }
            case 10: {
                CallNode callNode = (CallNode)node;
                if (callNode.isRecursion()) {
                    EncloseNode encloseNode = (EncloseNode)callNode.target;
                    if (!encloseNode.isMinFixed()) break;
                    n = encloseNode.minLength;
                    break;
                }
                n = this.getMinMatchLength(callNode.target);
                break;
            }
            case 8: {
                ConsAltNode consAltNode = (ConsAltNode)node;
                do {
                    n += this.getMinMatchLength(consAltNode.car);
                } while ((consAltNode = consAltNode.cdr) != null);
                break;
            }
            case 9: {
                ConsAltNode consAltNode = (ConsAltNode)node;
                do {
                    Node node2 = consAltNode.car;
                    int n3 = this.getMinMatchLength(node2);
                    if (consAltNode == node) {
                        n = n3;
                        continue;
                    }
                    if (n <= n3) continue;
                    n = n3;
                } while ((consAltNode = consAltNode.cdr) != null);
                break;
            }
            case 0: {
                n = ((StringNode)node).length();
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 1: 
            case 3: {
                n = 1;
                break;
            }
            case 5: {
                QuantifierNode quantifierNode = (QuantifierNode)node;
                if (quantifierNode.lower <= 0) break;
                n = this.getMinMatchLength(quantifierNode.target);
                n = MinMaxLen.distanceMultiply(n, quantifierNode.lower);
                break;
            }
            case 6: {
                EncloseNode encloseNode = (EncloseNode)node;
                switch (encloseNode.type) {
                    case 1: {
                        if (encloseNode.isMinFixed()) {
                            n = encloseNode.minLength;
                            break;
                        }
                        encloseNode.minLength = n = this.getMinMatchLength(encloseNode.target);
                        encloseNode.setMinFixed();
                        break;
                    }
                    case 2: 
                    case 4: {
                        n = this.getMinMatchLength(encloseNode.target);
                    }
                }
                break;
            }
        }
        return n;
    }

    private int getMaxMatchLength(Node node) {
        int n = 0;
        switch (node.getType()) {
            case 8: {
                ConsAltNode consAltNode = (ConsAltNode)node;
                do {
                    int n2 = this.getMaxMatchLength(consAltNode.car);
                    n = MinMaxLen.distanceAdd(n, n2);
                } while ((consAltNode = consAltNode.cdr) != null);
                break;
            }
            case 9: {
                ConsAltNode consAltNode = (ConsAltNode)node;
                do {
                    int n3;
                    if (n >= (n3 = this.getMaxMatchLength(consAltNode.car))) continue;
                    n = n3;
                } while ((consAltNode = consAltNode.cdr) != null);
                break;
            }
            case 0: {
                n = ((StringNode)node).length();
                break;
            }
            case 2: {
                n = this.enc.maxLengthDistance();
                break;
            }
            case 1: 
            case 3: {
                n = this.enc.maxLengthDistance();
                break;
            }
            case 4: {
                BackRefNode backRefNode = (BackRefNode)node;
                if (backRefNode.isRecursion()) {
                    n = Integer.MAX_VALUE;
                    break;
                }
                for (int i = 0; i < backRefNode.backNum; ++i) {
                    int n4;
                    if (backRefNode.back[i] > this.env.numMem) {
                        this.newValueException("invalid backref number/name");
                    }
                    if (n >= (n4 = this.getMaxMatchLength(this.env.memNodes[backRefNode.back[i]]))) continue;
                    n = n4;
                }
                break;
            }
            case 10: {
                CallNode callNode = (CallNode)node;
                if (!callNode.isRecursion()) {
                    n = this.getMaxMatchLength(callNode.target);
                    break;
                }
                n = Integer.MAX_VALUE;
                break;
            }
            case 5: {
                QuantifierNode quantifierNode = (QuantifierNode)node;
                if (quantifierNode.upper == 0 || (n = this.getMaxMatchLength(quantifierNode.target)) == 0) break;
                if (!QuantifierNode.isRepeatInfinite(quantifierNode.upper)) {
                    n = MinMaxLen.distanceMultiply(n, quantifierNode.upper);
                    break;
                }
                n = Integer.MAX_VALUE;
                break;
            }
            case 6: {
                EncloseNode encloseNode = (EncloseNode)node;
                switch (encloseNode.type) {
                    case 1: {
                        if (encloseNode.isMaxFixed()) {
                            n = encloseNode.maxLength;
                            break;
                        }
                        encloseNode.maxLength = n = this.getMaxMatchLength(encloseNode.target);
                        encloseNode.setMaxFixed();
                        break;
                    }
                    case 2: 
                    case 4: {
                        n = this.getMaxMatchLength(encloseNode.target);
                    }
                }
                break;
            }
        }
        return n;
    }

    protected final int getCharLengthTree(Node node) {
        return this.getCharLengthTree(node, 0);
    }

    private int getCharLengthTree(Node node, int n) {
        ++n;
        int n2 = 0;
        this.returnCode = 0;
        switch (node.getType()) {
            case 8: {
                ConsAltNode consAltNode = (ConsAltNode)node;
                do {
                    int n3 = this.getCharLengthTree(consAltNode.car, n);
                    if (this.returnCode != 0) continue;
                    n2 = MinMaxLen.distanceAdd(n2, n3);
                } while (this.returnCode == 0 && (consAltNode = consAltNode.cdr) != null);
                break;
            }
            case 9: {
                ConsAltNode consAltNode = (ConsAltNode)node;
                boolean bl = false;
                int n4 = this.getCharLengthTree(consAltNode.car, n);
                while (this.returnCode == 0 && (consAltNode = consAltNode.cdr) != null) {
                    int n5 = this.getCharLengthTree(consAltNode.car, n);
                    if (this.returnCode != 0 || n4 == n5) continue;
                    bl = true;
                }
                if (this.returnCode != 0) break;
                if (bl) {
                    if (n == 1) {
                        this.returnCode = -2;
                        break;
                    }
                    this.returnCode = -1;
                    break;
                }
                n2 = n4;
                break;
            }
            case 0: {
                StringNode stringNode = (StringNode)node;
                n2 = stringNode.length(this.enc);
                break;
            }
            case 5: {
                QuantifierNode quantifierNode = (QuantifierNode)node;
                if (quantifierNode.lower == quantifierNode.upper) {
                    int n6 = this.getCharLengthTree(quantifierNode.target, n);
                    if (this.returnCode != 0) break;
                    n2 = MinMaxLen.distanceMultiply(n6, quantifierNode.lower);
                    break;
                }
                this.returnCode = -1;
                break;
            }
            case 10: {
                CallNode callNode = (CallNode)node;
                if (!callNode.isRecursion()) {
                    n2 = this.getCharLengthTree(callNode.target, n);
                    break;
                }
                this.returnCode = -1;
                break;
            }
            case 2: {
                n2 = 1;
            }
            case 1: 
            case 3: {
                n2 = 1;
                break;
            }
            case 6: {
                EncloseNode encloseNode = (EncloseNode)node;
                switch (encloseNode.type) {
                    case 1: {
                        if (encloseNode.isCLenFixed()) {
                            n2 = encloseNode.charLength;
                            break;
                        }
                        n2 = this.getCharLengthTree(encloseNode.target, n);
                        if (this.returnCode != 0) break;
                        encloseNode.charLength = n2;
                        encloseNode.setCLenFixed();
                        break;
                    }
                    case 2: 
                    case 4: {
                        n2 = this.getCharLengthTree(encloseNode.target, n);
                    }
                }
                break;
            }
            case 7: {
                break;
            }
            default: {
                this.returnCode = -1;
            }
        }
        return n2;
    }

    private boolean isNotIncluded(Node node, Node node2) {
        block26: while (true) {
            int n = node2.getType();
            switch (node.getType()) {
                case 2: {
                    Node node3;
                    Node node4;
                    switch (n) {
                        case 2: {
                            node4 = (CTypeNode)node2;
                            CTypeNode cTypeNode = (CTypeNode)node;
                            return ((CTypeNode)node4).ctype == cTypeNode.ctype && ((CTypeNode)node4).not != cTypeNode.not;
                        }
                        case 1: {
                            node3 = node;
                            node = node2;
                            node2 = node3;
                            continue block26;
                        }
                        case 0: {
                            node3 = node;
                            node = node2;
                            node2 = node3;
                            continue block26;
                        }
                    }
                    break block26;
                }
                case 1: {
                    Node node3;
                    Node node4 = (CClassNode)node;
                    switch (n) {
                        case 2: {
                            switch (((CTypeNode)node2).ctype) {
                                case 12: {
                                    if (!((CTypeNode)node2).not) {
                                        if (((CClassNode)node4).mbuf == null && !((CClassNode)node4).isNot()) {
                                            for (int i = 0; i < 256; ++i) {
                                                if (!((CClassNode)node4).bs.at(i) || !this.enc.isSbWord(i)) continue;
                                                return false;
                                            }
                                            return true;
                                        }
                                        return false;
                                    }
                                    for (int i = 0; i < 256; ++i) {
                                        if (this.enc.isSbWord(i) || !(!((CClassNode)node4).isNot() ? ((CClassNode)node4).bs.at(i) : !((CClassNode)node4).bs.at(i))) continue;
                                        return false;
                                    }
                                    return true;
                                }
                            }
                            break block26;
                        }
                        case 1: {
                            CClassNode cClassNode = (CClassNode)node2;
                            for (int i = 0; i < 256; ++i) {
                                boolean bl = ((CClassNode)node4).bs.at(i);
                                if ((!bl || ((CClassNode)node4).isNot()) && (bl || !((CClassNode)node4).isNot()) || (!(bl = cClassNode.bs.at(i)) || cClassNode.isNot()) && (bl || !cClassNode.isNot())) continue;
                                return false;
                            }
                            return ((CClassNode)node4).mbuf == null && !((CClassNode)node4).isNot() || cClassNode.mbuf == null && !cClassNode.isNot();
                        }
                        case 0: {
                            node3 = node;
                            node = node2;
                            node2 = node3;
                            continue block26;
                        }
                    }
                    break block26;
                }
                case 0: {
                    StringNode stringNode = (StringNode)node;
                    if (stringNode.length() == 0) break block26;
                    switch (n) {
                        case 2: {
                            CTypeNode cTypeNode = (CTypeNode)node2;
                            switch (cTypeNode.ctype) {
                                case 12: {
                                    if (this.enc.isMbcWord(stringNode.bytes, stringNode.p, stringNode.end)) {
                                        return cTypeNode.not;
                                    }
                                    return !cTypeNode.not;
                                }
                            }
                            break block26;
                        }
                        case 1: {
                            CClassNode cClassNode = (CClassNode)node2;
                            int n2 = this.enc.mbcToCode(stringNode.bytes, stringNode.p, stringNode.p + this.enc.maxLength());
                            return !cClassNode.isCodeInCC(this.enc, n2);
                        }
                        case 0: {
                            StringNode stringNode2 = (StringNode)node2;
                            int n3 = stringNode.length();
                            if (n3 > stringNode2.length()) {
                                n3 = stringNode2.length();
                            }
                            if (stringNode.isAmbig() || stringNode2.isAmbig()) {
                                return false;
                            }
                            int n4 = 0;
                            int n5 = stringNode2.p;
                            int n6 = stringNode.p;
                            while (n4 < n3) {
                                if (stringNode2.bytes[n5] != stringNode.bytes[n6]) {
                                    return true;
                                }
                                ++n4;
                                ++n5;
                                ++n6;
                            }
                            break block26;
                        }
                    }
                }
            }
            break;
        }
        return false;
    }

    private Node getHeadValueNode(Node node, boolean bl) {
        Node node2 = null;
        switch (node.getType()) {
            case 3: 
            case 4: 
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 1: 
            case 2: {
                if (bl) break;
                node2 = node;
                break;
            }
            case 8: {
                node2 = this.getHeadValueNode(((ConsAltNode)node).car, bl);
                break;
            }
            case 0: {
                StringNode stringNode = (StringNode)node;
                if (stringNode.end <= stringNode.p || bl && !stringNode.isRaw() && Option.isIgnoreCase(this.regex.options)) break;
                node2 = node;
                break;
            }
            case 5: {
                QuantifierNode quantifierNode = (QuantifierNode)node;
                if (quantifierNode.lower <= 0) break;
                if (quantifierNode.headExact != null) {
                    node2 = quantifierNode.headExact;
                    break;
                }
                node2 = this.getHeadValueNode(quantifierNode.target, bl);
                break;
            }
            case 6: {
                EncloseNode encloseNode = (EncloseNode)node;
                switch (encloseNode.type) {
                    case 2: {
                        int n = this.regex.options;
                        this.regex.options = encloseNode.option;
                        node2 = this.getHeadValueNode(encloseNode.target, bl);
                        this.regex.options = n;
                        break;
                    }
                    case 1: 
                    case 4: {
                        node2 = this.getHeadValueNode(encloseNode.target, bl);
                    }
                }
                break;
            }
            case 7: {
                AnchorNode anchorNode = (AnchorNode)node;
                if (anchorNode.type != 1024) break;
                node2 = this.getHeadValueNode(anchorNode.target, bl);
                break;
            }
        }
        return node2;
    }

    private boolean checkTypeTree(Node node, int n, int n2, int n3) {
        if ((node.getType2Bit() & n) == 0) {
            return true;
        }
        boolean bl = false;
        switch (node.getType()) {
            case 8: 
            case 9: {
                ConsAltNode consAltNode = (ConsAltNode)node;
                while (!(bl = this.checkTypeTree(consAltNode.car, n, n2, n3)) && (consAltNode = consAltNode.cdr) != null) {
                }
                break;
            }
            case 5: {
                bl = this.checkTypeTree(((QuantifierNode)node).target, n, n2, n3);
                break;
            }
            case 6: {
                EncloseNode encloseNode = (EncloseNode)node;
                if ((encloseNode.type & n2) == 0) {
                    return true;
                }
                bl = this.checkTypeTree(encloseNode.target, n, n2, n3);
                break;
            }
            case 7: {
                AnchorNode anchorNode = (AnchorNode)node;
                if ((anchorNode.type & n3) == 0) {
                    return true;
                }
                if (anchorNode.target == null) break;
                bl = this.checkTypeTree(anchorNode.target, n, n2, n3);
                break;
            }
        }
        return bl;
    }

    private int subexpInfRecursiveCheck(Node node, boolean bl) {
        int n = 0;
        switch (node.getType()) {
            case 8: {
                ConsAltNode consAltNode = (ConsAltNode)node;
                do {
                    int n2;
                    int n3;
                    if ((n3 = this.subexpInfRecursiveCheck(consAltNode.car, bl)) == 2) {
                        return n3;
                    }
                    n |= n3;
                    if (!bl || (n2 = this.getMinMatchLength(consAltNode.car)) == 0) continue;
                    bl = false;
                } while ((consAltNode = consAltNode.cdr) != null);
                break;
            }
            case 9: {
                ConsAltNode consAltNode = (ConsAltNode)node;
                n = 1;
                do {
                    int n4;
                    if ((n4 = this.subexpInfRecursiveCheck(consAltNode.car, bl)) == 2) {
                        return n4;
                    }
                    n &= n4;
                } while ((consAltNode = consAltNode.cdr) != null);
                break;
            }
            case 5: {
                QuantifierNode quantifierNode = (QuantifierNode)node;
                n = this.subexpInfRecursiveCheck(quantifierNode.target, bl);
                if (n != 1 || quantifierNode.lower != 0) break;
                n = 0;
                break;
            }
            case 7: {
                AnchorNode anchorNode = (AnchorNode)node;
                switch (anchorNode.type) {
                    case 1024: 
                    case 2048: 
                    case 4096: 
                    case 8192: {
                        n = this.subexpInfRecursiveCheck(anchorNode.target, bl);
                    }
                }
                break;
            }
            case 10: {
                n = this.subexpInfRecursiveCheck(((CallNode)node).target, bl);
                break;
            }
            case 6: {
                EncloseNode encloseNode = (EncloseNode)node;
                if (encloseNode.isMark2()) {
                    return 0;
                }
                if (encloseNode.isMark1()) {
                    return !bl ? 1 : 2;
                }
                encloseNode.setMark2();
                n = this.subexpInfRecursiveCheck(encloseNode.target, bl);
                encloseNode.clearMark2();
                break;
            }
        }
        return n;
    }

    protected final int subexpInfRecursiveCheckTrav(Node node) {
        int n = 0;
        switch (node.getType()) {
            case 8: 
            case 9: {
                ConsAltNode consAltNode = (ConsAltNode)node;
                while ((n = this.subexpInfRecursiveCheckTrav(consAltNode.car)) == 0 && (consAltNode = consAltNode.cdr) != null) {
                }
                break;
            }
            case 5: {
                n = this.subexpInfRecursiveCheckTrav(((QuantifierNode)node).target);
                break;
            }
            case 7: {
                AnchorNode anchorNode = (AnchorNode)node;
                switch (anchorNode.type) {
                    case 1024: 
                    case 2048: 
                    case 4096: 
                    case 8192: {
                        n = this.subexpInfRecursiveCheckTrav(anchorNode.target);
                    }
                }
                break;
            }
            case 6: {
                EncloseNode encloseNode = (EncloseNode)node;
                if (encloseNode.isRecursion()) {
                    encloseNode.setMark1();
                    n = this.subexpInfRecursiveCheck(encloseNode.target, true);
                    if (n > 0) {
                        this.newValueException("never ending recursion");
                    }
                    encloseNode.clearMark1();
                }
                n = this.subexpInfRecursiveCheckTrav(encloseNode.target);
                break;
            }
        }
        return n;
    }

    private int subexpRecursiveCheck(Node node) {
        int n = 0;
        switch (node.getType()) {
            case 8: 
            case 9: {
                ConsAltNode consAltNode = (ConsAltNode)node;
                do {
                    n |= this.subexpRecursiveCheck(consAltNode.car);
                } while ((consAltNode = consAltNode.cdr) != null);
                break;
            }
            case 5: {
                n = this.subexpRecursiveCheck(((QuantifierNode)node).target);
                break;
            }
            case 7: {
                AnchorNode anchorNode = (AnchorNode)node;
                switch (anchorNode.type) {
                    case 1024: 
                    case 2048: 
                    case 4096: 
                    case 8192: {
                        n = this.subexpRecursiveCheck(anchorNode.target);
                    }
                }
                break;
            }
            case 10: {
                CallNode callNode = (CallNode)node;
                n = this.subexpRecursiveCheck(callNode.target);
                if (n == 0) break;
                callNode.setRecursion();
                break;
            }
            case 6: {
                EncloseNode encloseNode = (EncloseNode)node;
                if (encloseNode.isMark2()) {
                    return 0;
                }
                if (encloseNode.isMark1()) {
                    return 1;
                }
                encloseNode.setMark2();
                n = this.subexpRecursiveCheck(encloseNode.target);
                encloseNode.clearMark2();
                break;
            }
        }
        return n;
    }

    protected final int subexpRecursiveCheckTrav(Node node) {
        int n = 0;
        switch (node.getType()) {
            case 8: 
            case 9: {
                ConsAltNode consAltNode = (ConsAltNode)node;
                do {
                    int n2;
                    if ((n2 = this.subexpRecursiveCheckTrav(consAltNode.car)) != 1) continue;
                    n = 1;
                } while ((consAltNode = consAltNode.cdr) != null);
                break;
            }
            case 5: {
                QuantifierNode quantifierNode = (QuantifierNode)node;
                n = this.subexpRecursiveCheckTrav(quantifierNode.target);
                if (quantifierNode.upper != 0 || n != 1) break;
                quantifierNode.isRefered = true;
                break;
            }
            case 7: {
                AnchorNode anchorNode = (AnchorNode)node;
                switch (anchorNode.type) {
                    case 1024: 
                    case 2048: 
                    case 4096: 
                    case 8192: {
                        n = this.subexpRecursiveCheckTrav(anchorNode.target);
                    }
                }
                break;
            }
            case 6: {
                EncloseNode encloseNode = (EncloseNode)node;
                if (!encloseNode.isRecursion() && encloseNode.isCalled()) {
                    encloseNode.setMark1();
                    n = this.subexpRecursiveCheck(encloseNode.target);
                    if (n != 0) {
                        encloseNode.setRecursion();
                    }
                    encloseNode.clearMark1();
                }
                n = this.subexpRecursiveCheckTrav(encloseNode.target);
                if (!encloseNode.isCalled()) break;
                n |= 1;
                break;
            }
        }
        return n;
    }

    protected final void setupSubExpCall(Node node) {
        switch (node.getType()) {
            case 8: {
                ConsAltNode consAltNode = (ConsAltNode)node;
                do {
                    this.setupSubExpCall(consAltNode.car);
                } while ((consAltNode = consAltNode.cdr) != null);
                break;
            }
            case 9: {
                ConsAltNode consAltNode = (ConsAltNode)node;
                do {
                    this.setupSubExpCall(consAltNode.car);
                } while ((consAltNode = consAltNode.cdr) != null);
                break;
            }
            case 5: {
                this.setupSubExpCall(((QuantifierNode)node).target);
                break;
            }
            case 6: {
                this.setupSubExpCall(((EncloseNode)node).target);
                break;
            }
            case 10: {
                CallNode callNode = (CallNode)node;
                if (callNode.groupNum != 0) {
                    int n = callNode.groupNum;
                    if (this.env.numNamed > 0 && this.syntax.captureOnlyNamedGroup() && !Option.isCaptureGroup(this.env.option)) {
                        this.newValueException("numbered backref/call is not allowed. (use name)");
                    }
                    if (n > this.env.numMem) {
                        this.newValueException("undefined group <%n> reference", callNode.nameP, callNode.nameEnd);
                    }
                    callNode.target = this.env.memNodes[callNode.groupNum];
                    if (callNode.target == null) {
                        this.newValueException("undefined name <%n> reference", callNode.nameP, callNode.nameEnd);
                    }
                    ((EncloseNode)callNode.target).setCalled();
                    this.env.btMemStart = BitStatus.bsOnAt(this.env.btMemStart, callNode.groupNum);
                    callNode.unsetAddrList = this.env.unsetAddrList;
                    break;
                }
                NameEntry nameEntry = this.regex.nameToGroupNumbers(callNode.name, callNode.nameP, callNode.nameEnd);
                if (nameEntry == null) {
                    this.newValueException("undefined name <%n> reference", callNode.nameP, callNode.nameEnd);
                    break;
                }
                if (nameEntry.backNum > 1) {
                    this.newValueException("multiplex definition name <%n> call", callNode.nameP, callNode.nameEnd);
                    break;
                }
                callNode.groupNum = nameEntry.backRef1;
                callNode.target = this.env.memNodes[callNode.groupNum];
                if (callNode.target == null) {
                    this.newValueException("undefined name <%n> reference", callNode.nameP, callNode.nameEnd);
                }
                ((EncloseNode)callNode.target).setCalled();
                this.env.btMemStart = BitStatus.bsOnAt(this.env.btMemStart, callNode.groupNum);
                callNode.unsetAddrList = this.env.unsetAddrList;
                break;
            }
            case 7: {
                AnchorNode anchorNode = (AnchorNode)node;
                switch (anchorNode.type) {
                    case 1024: 
                    case 2048: 
                    case 4096: 
                    case 8192: {
                        this.setupSubExpCall(anchorNode.target);
                    }
                }
            }
        }
    }

    private void divideLookBehindAlternatives(Node node) {
        AnchorNode anchorNode = (AnchorNode)node;
        int n = anchorNode.type;
        Node node2 = anchorNode.target;
        Node node3 = ((ConsAltNode)node2).car;
        this.swap(node, node2);
        Node node4 = node;
        node = node2;
        node2 = node4;
        ((ConsAltNode)node).setCar(node2);
        ((AnchorNode)node2).setTarget(node3);
        node3 = node;
        while ((node3 = ((ConsAltNode)node3).cdr) != null) {
            AnchorNode anchorNode2 = new AnchorNode(n);
            anchorNode2.setTarget(((ConsAltNode)node3).car);
            ((ConsAltNode)node3).setCar(anchorNode2);
        }
        if (n == 8192) {
            node3 = node;
            do {
                ((ConsAltNode)node3).toListNode();
            } while ((node3 = ((ConsAltNode)node3).cdr) != null);
        }
    }

    private void setupLookBehind(Node node) {
        AnchorNode anchorNode = (AnchorNode)node;
        int n = this.getCharLengthTree(anchorNode.target);
        switch (this.returnCode) {
            case 0: {
                anchorNode.charLength = n;
                break;
            }
            case -1: {
                this.newSyntaxException("invalid pattern in look-behind");
                break;
            }
            case -2: {
                if (this.syntax.differentLengthAltLookBehind()) {
                    this.divideLookBehindAlternatives(node);
                    break;
                }
                this.newSyntaxException("invalid pattern in look-behind");
            }
        }
    }

    private void nextSetup(Node node, Node node2) {
        while (true) {
            StateNode stateNode;
            int n;
            if ((n = node.getType()) == 5) {
                Node node3;
                stateNode = (QuantifierNode)node;
                if (!((QuantifierNode)stateNode).greedy || !QuantifierNode.isRepeatInfinite(((QuantifierNode)stateNode).upper)) break;
                Node node4 = (StringNode)this.getHeadValueNode(node2, true);
                if (node4 != null && node4.bytes[node4.p] != 0) {
                    ((QuantifierNode)stateNode).nextHeadExact = node4;
                }
                if (((QuantifierNode)stateNode).lower > 1 || !((QuantifierNode)stateNode).target.isSimple() || (node4 = this.getHeadValueNode(((QuantifierNode)stateNode).target, false)) == null || (node3 = this.getHeadValueNode(node2, false)) == null || !this.isNotIncluded(node4, node3)) break;
                EncloseNode encloseNode = new EncloseNode(4);
                encloseNode.setStopBtSimpleRepeat();
                this.swap(node, encloseNode);
                encloseNode.setTarget(node);
                break;
            }
            if (n != 6 || !((EncloseNode)(stateNode = (EncloseNode)node)).isMemory()) break;
            node = ((EncloseNode)stateNode).target;
        }
    }

    private void updateStringNodeCaseFold(Node node) {
        StringNode stringNode = (StringNode)node;
        byte[] byArray = new byte[stringNode.length() << 1];
        int n = 0;
        this.value = stringNode.p;
        int n2 = stringNode.end;
        byte[] byArray2 = new byte[18];
        while (this.value < n2) {
            int n3 = this.enc.mbcCaseFold(this.regex.caseFoldFlag, stringNode.bytes, this, n2, byArray2);
            for (int i = 0; i < n3; ++i) {
                if (n >= byArray.length) {
                    byte[] byArray3 = new byte[byArray.length << 1];
                    System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                    byArray = byArray3;
                }
                byArray[n++] = byArray2[i];
            }
        }
        stringNode.set(byArray, 0, n);
    }

    private Node expandCaseFoldMakeRemString(byte[] byArray, int n, int n2) {
        StringNode stringNode = new StringNode(byArray, n, n2);
        this.updateStringNodeCaseFold(stringNode);
        stringNode.setAmbig();
        stringNode.setDontGetOptInfo();
        return stringNode;
    }

    private boolean expandCaseFoldStringAlt(int n, CaseFoldCodeItem[] caseFoldCodeItemArray, byte[] byArray, int n2, int n3, int n4, Node[] nodeArray) {
        ConsAltNode consAltNode;
        ConsAltNode consAltNode2;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (caseFoldCodeItemArray[i].byteLen == n3) continue;
            bl = true;
            break;
        }
        ConsAltNode consAltNode3 = null;
        if (bl) {
            consAltNode3 = ConsAltNode.newAltNode(null, null);
            nodeArray[0] = consAltNode3;
            consAltNode2 = ConsAltNode.newListNode(null, null);
            consAltNode3.setCar(consAltNode2);
            consAltNode = ConsAltNode.newAltNode(null, null);
            consAltNode2.setCar(consAltNode);
        } else {
            consAltNode = ConsAltNode.newAltNode(null, null);
            nodeArray[0] = consAltNode;
        }
        StringNode stringNode = new StringNode(byArray, n2, n2 + n3);
        consAltNode.setCar(stringNode);
        for (int i = 0; i < n; ++i) {
            stringNode = new StringNode();
            for (int j = 0; j < caseFoldCodeItemArray[i].codeLen; ++j) {
                stringNode.ensure(7);
                stringNode.end += this.enc.codeToMbc(caseFoldCodeItemArray[i].code[j], stringNode.bytes, stringNode.end);
            }
            ConsAltNode consAltNode4 = ConsAltNode.newAltNode(null, null);
            if (caseFoldCodeItemArray[i].byteLen != n3) {
                int n5 = n2 + caseFoldCodeItemArray[i].byteLen;
                if (n5 < n4) {
                    Node node = this.expandCaseFoldMakeRemString(byArray, n5, n4);
                    consAltNode2 = ConsAltNode.listAdd(null, stringNode);
                    ConsAltNode.listAdd(consAltNode2, node);
                    consAltNode4.setCar(consAltNode2);
                } else {
                    consAltNode4.setCar(stringNode);
                }
                consAltNode3.setCdr(consAltNode4);
                consAltNode3 = consAltNode4;
                continue;
            }
            consAltNode4.setCar(stringNode);
            consAltNode.setCdr(consAltNode4);
            consAltNode = consAltNode4;
        }
        return bl;
    }

    private void expandCaseFoldString(Node node) {
        CaseFoldCodeItem[] caseFoldCodeItemArray;
        int n;
        int n2;
        StringNode stringNode = (StringNode)node;
        if (stringNode.isAmbig() || stringNode.length() <= 0) {
            return;
        }
        byte[] byArray = stringNode.bytes;
        int n3 = stringNode.end;
        int n4 = 1;
        Object object = null;
        ConsAltNode consAltNode = null;
        Node[] nodeArray = new Node[]{null};
        StringNode stringNode2 = null;
        for (n = stringNode.p; n < n3; n += n2) {
            boolean bl;
            caseFoldCodeItemArray = this.enc.caseFoldCodesByString(this.regex.caseFoldFlag, byArray, n, n3);
            n2 = this.enc.length(byArray, n, n3);
            if (caseFoldCodeItemArray.length == 0) {
                if (stringNode2 == null) {
                    if (consAltNode == null && nodeArray[0] != null) {
                        consAltNode = ConsAltNode.listAdd(null, nodeArray[0]);
                        object = consAltNode;
                    }
                    stringNode2 = new StringNode();
                    nodeArray[0] = stringNode2;
                    if (consAltNode != null) {
                        ConsAltNode.listAdd(consAltNode, stringNode2);
                    }
                }
                stringNode2.cat(byArray, n, n + n2);
                continue;
            }
            if ((n4 *= caseFoldCodeItemArray.length + 1) > 8) break;
            if (consAltNode == null && nodeArray[0] != null) {
                consAltNode = ConsAltNode.listAdd(null, nodeArray[0]);
                object = consAltNode;
            }
            if (bl = this.expandCaseFoldStringAlt(caseFoldCodeItemArray.length, caseFoldCodeItemArray, byArray, n, n2, n3, nodeArray)) {
                if (consAltNode == null) {
                    object = (ConsAltNode)nodeArray[0];
                } else {
                    ConsAltNode.listAdd(consAltNode, nodeArray[0]);
                }
                consAltNode = (ConsAltNode)((ConsAltNode)nodeArray[0]).car;
            } else if (consAltNode != null) {
                ConsAltNode.listAdd(consAltNode, nodeArray[0]);
            }
            stringNode2 = null;
        }
        if (n < n3) {
            caseFoldCodeItemArray = this.expandCaseFoldMakeRemString(byArray, n, n3);
            if (nodeArray[0] != null && consAltNode == null) {
                consAltNode = ConsAltNode.listAdd(null, nodeArray[0]);
                object = consAltNode;
            }
            if (consAltNode == null) {
                nodeArray[0] = caseFoldCodeItemArray;
            } else {
                ConsAltNode.listAdd(consAltNode, (Node)caseFoldCodeItemArray);
            }
        }
        caseFoldCodeItemArray = object != null ? object : nodeArray[0];
        this.swap(node, (Node)caseFoldCodeItemArray);
    }

    protected final int setupCombExpCheck(Node node, int n) {
        int n2 = n;
        block0 : switch (node.getType()) {
            case 8: {
                ConsAltNode consAltNode = (ConsAltNode)node;
                while ((n2 = this.setupCombExpCheck(consAltNode.car, n2)) >= 0 && (consAltNode = consAltNode.cdr) != null) {
                }
                break;
            }
            case 9: {
                int n3;
                ConsAltNode consAltNode = (ConsAltNode)node;
                do {
                    n3 = this.setupCombExpCheck(consAltNode.car, n);
                    n2 |= n3;
                } while (n3 >= 0 && (consAltNode = consAltNode.cdr) != null);
                break;
            }
            case 5: {
                QuantifierNode quantifierNode = (QuantifierNode)node;
                int n4 = n;
                int n5 = 0;
                if (!QuantifierNode.isRepeatInfinite(quantifierNode.upper) && quantifierNode.upper > 1) {
                    n4 |= 2;
                    if (this.env.backrefedMem == 0 && quantifierNode.target.getType() == 6) {
                        EncloseNode encloseNode = (EncloseNode)quantifierNode.target;
                        if (encloseNode.type == 1 && encloseNode.target.getType() == 5) {
                            QuantifierNode quantifierNode2 = (QuantifierNode)encloseNode.target;
                            if (QuantifierNode.isRepeatInfinite(quantifierNode2.upper) && quantifierNode2.greedy == quantifierNode.greedy) {
                                int n6 = quantifierNode.upper = quantifierNode.lower == 0 ? 1 : quantifierNode.lower;
                                if (quantifierNode.upper == 1) {
                                    n4 = n;
                                }
                            }
                        }
                    }
                }
                if ((n & 2) != 0) {
                    quantifierNode.combExpCheckNum = -1;
                } else {
                    int n7;
                    if (QuantifierNode.isRepeatInfinite(quantifierNode.upper)) {
                        n7 = Integer.MAX_VALUE;
                        n4 |= 1;
                    } else {
                        n7 = quantifierNode.upper - quantifierNode.lower;
                    }
                    if (n7 >= 512) {
                        n5 |= 4;
                    }
                    if (((n & 1) != 0 && n7 != 0 || (n & 4) != 0 && n7 >= 512) && quantifierNode.combExpCheckNum == 0) {
                        ++this.env.numCombExpCheck;
                        quantifierNode.combExpCheckNum = this.env.numCombExpCheck;
                        if (this.env.currMaxRegNum > this.env.combExpMaxRegNum) {
                            this.env.combExpMaxRegNum = this.env.currMaxRegNum;
                        }
                    }
                }
                n2 = this.setupCombExpCheck(quantifierNode.target, n4);
                n2 |= n5;
                break;
            }
            case 6: {
                EncloseNode encloseNode = (EncloseNode)node;
                switch (encloseNode.type) {
                    case 1: {
                        if (this.env.currMaxRegNum < encloseNode.regNum) {
                            this.env.currMaxRegNum = encloseNode.regNum;
                        }
                        n2 = this.setupCombExpCheck(encloseNode.target, n);
                        break block0;
                    }
                }
                n2 = this.setupCombExpCheck(encloseNode.target, n);
                break;
            }
            case 10: {
                CallNode callNode = (CallNode)node;
                if (callNode.isRecursion()) {
                    this.env.hasRecursion = true;
                    break;
                }
                n2 = this.setupCombExpCheck(callNode.target, n);
                break;
            }
        }
        return n2;
    }

    protected final void setupTree(Node node, int n) {
        switch (node.getType()) {
            case 8: {
                ConsAltNode consAltNode = (ConsAltNode)node;
                Node node2 = null;
                do {
                    this.setupTree(consAltNode.car, n);
                    if (node2 != null) {
                        this.nextSetup(node2, consAltNode.car);
                    }
                    node2 = consAltNode.car;
                } while ((consAltNode = consAltNode.cdr) != null);
                break;
            }
            case 9: {
                ConsAltNode consAltNode = (ConsAltNode)node;
                do {
                    this.setupTree(consAltNode.car, n | 1);
                } while ((consAltNode = consAltNode.cdr) != null);
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                if (!Option.isIgnoreCase(this.regex.options) || ((StringNode)node).isRaw()) break;
                this.expandCaseFoldString(node);
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 10: {
                break;
            }
            case 4: {
                BackRefNode backRefNode = (BackRefNode)node;
                for (int i = 0; i < backRefNode.backNum; ++i) {
                    if (backRefNode.back[i] > this.env.numMem) {
                        this.newValueException("invalid backref number/name");
                    }
                    this.env.backrefedMem = BitStatus.bsOnAt(this.env.backrefedMem, backRefNode.back[i]);
                    this.env.btMemStart = BitStatus.bsOnAt(this.env.btMemStart, backRefNode.back[i]);
                    if (backRefNode.isNestLevel()) {
                        this.env.btMemEnd = BitStatus.bsOnAt(this.env.btMemEnd, backRefNode.back[i]);
                    }
                    ((EncloseNode)this.env.memNodes[backRefNode.back[i]]).setMemBackrefed();
                }
                break;
            }
            case 5: {
                int n2;
                int n3;
                QuantifierNode quantifierNode = (QuantifierNode)node;
                Node node3 = quantifierNode.target;
                if ((n & 4) != 0) {
                    quantifierNode.setInRepeat();
                }
                if ((QuantifierNode.isRepeatInfinite(quantifierNode.upper) || quantifierNode.lower >= 1) && (n3 = this.getMinMatchLength(node3)) == 0) {
                    quantifierNode.targetEmptyInfo = 1;
                    n2 = this.quantifiersMemoryInfo(node3);
                    if (n2 > 0) {
                        quantifierNode.targetEmptyInfo = n2;
                    }
                }
                n |= 4;
                if (quantifierNode.lower != quantifierNode.upper) {
                    n |= 8;
                }
                this.setupTree(node3, n);
                if (node3.getType() == 0 && !QuantifierNode.isRepeatInfinite(quantifierNode.lower) && quantifierNode.lower == quantifierNode.upper && quantifierNode.lower > 1 && quantifierNode.lower <= 100) {
                    StringNode stringNode = (StringNode)node3;
                    n2 = stringNode.length();
                    if (n2 * quantifierNode.lower > 100) break;
                    StringNode stringNode2 = quantifierNode.convertToString();
                    int n4 = quantifierNode.lower;
                    for (int i = 0; i < n4; ++i) {
                        stringNode2.cat(stringNode.bytes, stringNode.p, stringNode.end);
                    }
                    break;
                }
                if (!quantifierNode.greedy || quantifierNode.targetEmptyInfo == 0) break;
                if (node3.getType() == 5) {
                    QuantifierNode quantifierNode2 = (QuantifierNode)node3;
                    if (quantifierNode2.headExact == null) break;
                    quantifierNode.headExact = quantifierNode2.headExact;
                    quantifierNode2.headExact = null;
                    break;
                }
                quantifierNode.headExact = this.getHeadValueNode(quantifierNode.target, true);
                break;
            }
            case 6: {
                EncloseNode encloseNode = (EncloseNode)node;
                switch (encloseNode.type) {
                    case 2: {
                        int n5 = this.regex.options;
                        this.regex.options = encloseNode.option;
                        this.setupTree(encloseNode.target, n);
                        this.regex.options = n5;
                        break;
                    }
                    case 1: {
                        if ((n & 0xB) != 0) {
                            this.env.btMemStart = BitStatus.bsOnAt(this.env.btMemStart, encloseNode.regNum);
                        }
                        this.setupTree(encloseNode.target, n);
                        break;
                    }
                    case 4: {
                        this.setupTree(encloseNode.target, n);
                        if (encloseNode.target.getType() != 5) break;
                        QuantifierNode quantifierNode = (QuantifierNode)encloseNode.target;
                        if (!QuantifierNode.isRepeatInfinite(quantifierNode.upper) || quantifierNode.lower > 1 || !quantifierNode.greedy || !quantifierNode.target.isSimple()) break;
                        encloseNode.setStopBtSimpleRepeat();
                    }
                }
                break;
            }
            case 7: {
                AnchorNode anchorNode = (AnchorNode)node;
                switch (anchorNode.type) {
                    case 1024: {
                        this.setupTree(anchorNode.target, n);
                        break;
                    }
                    case 2048: {
                        this.setupTree(anchorNode.target, n | 2);
                        break;
                    }
                    case 4096: {
                        boolean bl = this.checkTypeTree(anchorNode.target, 2031, 1, 4135);
                        if (bl) {
                            this.newSyntaxException("invalid pattern in look-behind");
                        }
                        this.setupLookBehind(node);
                        this.setupTree(anchorNode.target, n);
                        break;
                    }
                    case 8192: {
                        boolean bl = this.checkTypeTree(anchorNode.target, 2031, 1, 4135);
                        if (bl) {
                            this.newSyntaxException("invalid pattern in look-behind");
                        }
                        this.setupLookBehind(node);
                        this.setupTree(anchorNode.target, n | 2);
                    }
                }
                break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void optimizeNodeLeft(Node var1_1, NodeOptInfo var2_2, OptEnvironment var3_3) {
        var2_2.clear();
        var2_2.setBoundNode(var3_3.mmd);
        switch (var1_1.getType()) {
            case 8: {
                var4_4 = new OptEnvironment();
                var5_14 = new NodeOptInfo();
                var4_4.copy(var3_3);
                var6_25 = (ConsAltNode)var1_1;
                do {
                    this.optimizeNodeLeft(var6_25.car, var5_14, var4_4);
                    var4_4.mmd.add(var5_14.length);
                    var2_2.concatLeftNode(var5_14, this.enc);
                } while ((var6_25 = var6_25.cdr) != null);
                break;
            }
            case 9: {
                var4_5 = new NodeOptInfo();
                var5_15 = (ConsAltNode)var1_1;
                do {
                    this.optimizeNodeLeft(var5_15.car, var4_5, var3_3);
                    if (var5_15 == var1_1) {
                        var2_2.copy(var4_5);
                        continue;
                    }
                    var2_2.altMerge(var4_5, var3_3);
                } while ((var5_15 = var5_15.cdr) != null);
                break;
            }
            case 0: {
                var4_6 = (StringNode)var1_1;
                var5_16 = var4_6.length();
                if (!var4_6.isAmbig()) {
                    var2_2.exb.concatStr(var4_6.bytes, var4_6.p, var4_6.end, var4_6.isRaw(), this.enc);
                    if (var5_16 > 0) {
                        var2_2.map.addChar(var4_6.bytes[var4_6.p], this.enc);
                    }
                    var2_2.length.set(var5_16, var5_16);
                } else {
                    if (var4_6.isDontGetOptInfo()) {
                        var7_33 = var4_6.length(this.enc);
                        var6_26 = this.enc.maxLengthDistance() * var7_33;
                    } else {
                        var2_2.exb.concatStr(var4_6.bytes, var4_6.p, var4_6.end, var4_6.isRaw(), this.enc);
                        var2_2.exb.ignoreCase = true;
                        if (var5_16 > 0) {
                            var2_2.map.addCharAmb(var4_6.bytes, var4_6.p, var4_6.end, this.enc, var3_3.caseFoldFlag);
                        }
                        var6_26 = var5_16;
                    }
                    var2_2.length.set(var5_16, var6_26);
                }
                if (var2_2.exb.length != var5_16) break;
                var2_2.exb.reachEnd = true;
                break;
            }
            case 1: {
                var4_7 = (CClassNode)var1_1;
                if (var4_7.mbuf != null || var4_7.isNot()) {
                    var5_17 = this.enc.minLength();
                    var6_27 = this.enc.maxLengthDistance();
                    var2_2.length.set(var5_17, var6_27);
                    break;
                }
                for (var5_18 = 0; var5_18 < 256; ++var5_18) {
                    var6_28 = var4_7.bs.at(var5_18);
                    if ((!var6_28 || var4_7.isNot()) && (var6_28 || !var4_7.isNot())) continue;
                    var2_2.map.addChar((byte)var5_18, this.enc);
                }
                var2_2.length.set(1, 1);
                break;
            }
            case 2: {
                var5_19 = this.enc.maxLengthDistance();
                if (var5_19 != 1) ** GOTO lbl81
                var4_8 = 1;
                var6_29 = (CTypeNode)var1_1;
                switch (var6_29.ctype) {
                    case 12: {
                        if (var6_29.not) {
                            for (var7_34 = 0; var7_34 < 256; ++var7_34) {
                                if (this.enc.isWord(var7_34)) continue;
                                var2_2.map.addChar((byte)var7_34, this.enc);
                            }
                        } else {
                            for (var7_35 = 0; var7_35 < 256; ++var7_35) {
                                if (!this.enc.isWord(var7_35)) continue;
                                var2_2.map.addChar((byte)var7_35, this.enc);
                            }
                        }
                    }
                }
                ** GOTO lbl82
lbl81:
                // 1 sources

                var4_8 = this.enc.minLength();
lbl82:
                // 3 sources

                var2_2.length.set(var4_8, var5_19);
                break;
            }
            case 3: {
                var2_2.length.set(this.enc.minLength(), this.enc.maxLengthDistance());
                break;
            }
            case 7: {
                var4_9 = (AnchorNode)var1_1;
                switch (var4_9.type) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: 
                    case 32: {
                        var2_2.anchor.add(var4_9.type);
                        break;
                    }
                    case 1024: {
                        var5_20 = new NodeOptInfo();
                        this.optimizeNodeLeft(var4_9.target, var5_20, var3_3);
                        if (var5_20.exb.length > 0) {
                            var2_2.expr.copy(var5_20.exb);
                        } else if (var5_20.exm.length > 0) {
                            var2_2.expr.copy(var5_20.exm);
                        }
                        var2_2.expr.reachEnd = false;
                        if (var5_20.map.value <= 0) break;
                        var2_2.map.copy(var5_20.map);
                        break;
                    }
                }
                break;
            }
            case 4: {
                var4_10 = (BackRefNode)var1_1;
                if (var4_10.isRecursion()) {
                    var2_2.length.set(0, 0x7FFFFFFF);
                    break;
                }
                var5_21 = var3_3.scanEnv.memNodes;
                var6_30 = this.getMinMatchLength(var5_21[var4_10.back[0]]);
                var7_36 = this.getMaxMatchLength(var5_21[var4_10.back[0]]);
                for (var8_39 = 1; var8_39 < var4_10.backNum; ++var8_39) {
                    var9_40 = this.getMinMatchLength(var5_21[var4_10.back[var8_39]]);
                    var10_41 = this.getMaxMatchLength(var5_21[var4_10.back[var8_39]]);
                    if (var6_30 > var9_40) {
                        var6_30 = var9_40;
                    }
                    if (var7_36 >= var10_41) continue;
                    var7_36 = var10_41;
                }
                var2_2.length.set(var6_30, var7_36);
                break;
            }
            case 10: {
                var4_11 = (CallNode)var1_1;
                if (var4_11.isRecursion()) {
                    var2_2.length.set(0, 0x7FFFFFFF);
                    break;
                }
                var5_22 = var3_3.options;
                var3_3.options = ((EncloseNode)var4_11.target).option;
                this.optimizeNodeLeft(var4_11.target, var2_2, var3_3);
                var3_3.options = var5_22;
                break;
            }
            case 5: {
                var4_12 = new NodeOptInfo();
                var5_23 = (QuantifierNode)var1_1;
                this.optimizeNodeLeft(var5_23.target, var4_12, var3_3);
                if (var5_23.lower == 0 && QuantifierNode.isRepeatInfinite(var5_23.upper)) {
                    if (var3_3.mmd.max == 0 && var5_23.target.getType() == 3 && var5_23.greedy) {
                        if (Option.isMultiline(var3_3.options)) {
                            var2_2.anchor.add(32768);
                        } else {
                            var2_2.anchor.add(16384);
                        }
                    }
                } else if (var5_23.lower > 0) {
                    var2_2.copy(var4_12);
                    if (var4_12.exb.length > 0 && var4_12.exb.reachEnd) {
                        for (var6_31 = 1; var6_31 < var5_23.lower && !var2_2.exb.isFull(); ++var6_31) {
                            var2_2.exb.concat(var4_12.exb, this.enc);
                        }
                        if (var6_31 < var5_23.lower) {
                            var2_2.exb.reachEnd = false;
                        }
                    }
                    if (var5_23.lower != var5_23.upper) {
                        var2_2.exb.reachEnd = false;
                        var2_2.exm.reachEnd = false;
                    }
                    if (var5_23.lower > 1) {
                        var2_2.exm.reachEnd = false;
                    }
                }
                var6_31 = MinMaxLen.distanceMultiply(var4_12.length.min, var5_23.lower);
                var7_37 = QuantifierNode.isRepeatInfinite(var5_23.upper) != false ? (var4_12.length.max > 0 ? 0x7FFFFFFF : 0) : MinMaxLen.distanceMultiply(var4_12.length.max, var5_23.upper);
                var2_2.length.set(var6_31, var7_37);
                break;
            }
            case 6: {
                var4_13 = (EncloseNode)var1_1;
                switch (var4_13.type) {
                    case 2: {
                        var5_24 = var3_3.options;
                        var3_3.options = var4_13.option;
                        this.optimizeNodeLeft(var4_13.target, var2_2, var3_3);
                        var3_3.options = var5_24;
                        break;
                    }
                    case 1: {
                        if (++var4_13.optCount > 5) {
                            var6_32 = 0;
                            var7_38 = 0x7FFFFFFF;
                            if (var4_13.isMinFixed()) {
                                var6_32 = var4_13.minLength;
                            }
                            if (var4_13.isMaxFixed()) {
                                var7_38 = var4_13.maxLength;
                            }
                            var2_2.length.set(var6_32, var7_38);
                            break;
                        }
                        this.optimizeNodeLeft(var4_13.target, var2_2, var3_3);
                        if (!var2_2.anchor.isSet(49152) || !BitStatus.bsAt(var3_3.scanEnv.backrefedMem, var4_13.regNum)) break;
                        var2_2.anchor.remove(49152);
                        break;
                    }
                    case 4: {
                        this.optimizeNodeLeft(var4_13.target, var2_2, var3_3);
                    }
                }
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
            }
        }
    }

    protected final void setOptimizedInfoFromTree(Node node) {
        NodeOptInfo nodeOptInfo = new NodeOptInfo();
        OptEnvironment optEnvironment = new OptEnvironment();
        optEnvironment.enc = this.regex.enc;
        optEnvironment.options = this.regex.options;
        optEnvironment.caseFoldFlag = this.regex.caseFoldFlag;
        optEnvironment.scanEnv = this.env;
        optEnvironment.mmd.clear();
        this.optimizeNodeLeft(node, nodeOptInfo, optEnvironment);
        this.regex.anchor = nodeOptInfo.anchor.leftAnchor & 0xC005;
        this.regex.anchor |= nodeOptInfo.anchor.rightAnchor & 0x18;
        if ((this.regex.anchor & 0x18) != 0) {
            this.regex.anchorDmin = nodeOptInfo.length.min;
            this.regex.anchorDmax = nodeOptInfo.length.max;
        }
        if (nodeOptInfo.exb.length > 0 || nodeOptInfo.exm.length > 0) {
            nodeOptInfo.exb.select(nodeOptInfo.exm, this.enc);
            if (nodeOptInfo.map.value > 0 && nodeOptInfo.exb.compare(nodeOptInfo.map) > 0) {
                this.regex.setOptimizeMapInfo(nodeOptInfo.map);
                this.regex.setSubAnchor(nodeOptInfo.map.anchor);
            } else {
                this.regex.setExactInfo(nodeOptInfo.exb);
                this.regex.setSubAnchor(nodeOptInfo.exb.anchor);
            }
        } else if (nodeOptInfo.map.value > 0) {
            this.regex.setOptimizeMapInfo(nodeOptInfo.map);
            this.regex.setSubAnchor(nodeOptInfo.map.anchor);
        } else {
            this.regex.subAnchor |= nodeOptInfo.anchor.leftAnchor & 2;
            if (nodeOptInfo.length.max == 0) {
                this.regex.subAnchor |= nodeOptInfo.anchor.rightAnchor & 0x20;
            }
        }
    }
}

