/*
 * Decompiled with CFR 0.152.
 */
package jruby.joda.time.chrono;

import jruby.joda.time.Chronology;
import jruby.joda.time.DateTimeField;
import jruby.joda.time.DateTimeZone;
import jruby.joda.time.chrono.AssembledChronology;
import jruby.joda.time.field.LenientDateTimeField;

public final class LenientChronology
extends AssembledChronology {
    private static final long serialVersionUID = -3148237568046877177L;
    private transient Chronology iWithUTC;

    public static LenientChronology getInstance(Chronology chronology) {
        if (chronology == null) {
            throw new IllegalArgumentException("Must supply a chronology");
        }
        return new LenientChronology(chronology);
    }

    private LenientChronology(Chronology chronology) {
        super(chronology, null);
    }

    public Chronology withUTC() {
        if (this.iWithUTC == null) {
            this.iWithUTC = this.getZone() == DateTimeZone.UTC ? this : LenientChronology.getInstance(this.getBase().withUTC());
        }
        return this.iWithUTC;
    }

    public Chronology withZone(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if (dateTimeZone == DateTimeZone.UTC) {
            return this.withUTC();
        }
        if (dateTimeZone == this.getZone()) {
            return this;
        }
        return LenientChronology.getInstance(this.getBase().withZone(dateTimeZone));
    }

    protected void assemble(AssembledChronology.Fields fields2) {
        fields2.year = this.convertField(fields2.year);
        fields2.yearOfEra = this.convertField(fields2.yearOfEra);
        fields2.yearOfCentury = this.convertField(fields2.yearOfCentury);
        fields2.centuryOfEra = this.convertField(fields2.centuryOfEra);
        fields2.era = this.convertField(fields2.era);
        fields2.dayOfWeek = this.convertField(fields2.dayOfWeek);
        fields2.dayOfMonth = this.convertField(fields2.dayOfMonth);
        fields2.dayOfYear = this.convertField(fields2.dayOfYear);
        fields2.monthOfYear = this.convertField(fields2.monthOfYear);
        fields2.weekOfWeekyear = this.convertField(fields2.weekOfWeekyear);
        fields2.weekyear = this.convertField(fields2.weekyear);
        fields2.weekyearOfCentury = this.convertField(fields2.weekyearOfCentury);
        fields2.millisOfSecond = this.convertField(fields2.millisOfSecond);
        fields2.millisOfDay = this.convertField(fields2.millisOfDay);
        fields2.secondOfMinute = this.convertField(fields2.secondOfMinute);
        fields2.secondOfDay = this.convertField(fields2.secondOfDay);
        fields2.minuteOfHour = this.convertField(fields2.minuteOfHour);
        fields2.minuteOfDay = this.convertField(fields2.minuteOfDay);
        fields2.hourOfDay = this.convertField(fields2.hourOfDay);
        fields2.hourOfHalfday = this.convertField(fields2.hourOfHalfday);
        fields2.clockhourOfDay = this.convertField(fields2.clockhourOfDay);
        fields2.clockhourOfHalfday = this.convertField(fields2.clockhourOfHalfday);
        fields2.halfdayOfDay = this.convertField(fields2.halfdayOfDay);
    }

    private final DateTimeField convertField(DateTimeField dateTimeField) {
        return LenientDateTimeField.getInstance(dateTimeField, this.getBase());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LenientChronology)) {
            return false;
        }
        LenientChronology lenientChronology = (LenientChronology)object;
        return this.getBase().equals(lenientChronology.getBase());
    }

    public int hashCode() {
        return 236548278 + this.getBase().hashCode() * 7;
    }

    public String toString() {
        return "LenientChronology[" + this.getBase().toString() + ']';
    }
}

