/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callsite;

import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;

public class SuperCallSite
extends CallSite {
    protected volatile CacheEntry cache = CacheEntry.NULL_CACHE;
    protected volatile String lastName;

    public SuperCallSite() {
        super("super", CallType.SUPER);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self, long fixnum) {
        return this.call(context, caller2, self, (IRubyObject)RubyFixnum.newFixnum(context.getRuntime(), fixnum));
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject ... args2) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self, klazz, name2);
        CacheEntry myCache = this.cache;
        if (name2 == this.lastName && selfType != null && myCache.typeOk(selfType)) {
            return myCache.method.call(context, self, (RubyModule)selfType, name2, args2);
        }
        return this.cacheAndCall(caller2, selfType, args2, context, self, name2);
    }

    private IRubyObject callBlock(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject[] args2, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self, klazz, name2);
        CacheEntry myCache = this.cache;
        if (name2 == this.lastName && selfType != null && myCache.typeOk(selfType)) {
            return myCache.method.call(context, self, (RubyModule)selfType, name2, args2, block);
        }
        return this.cacheAndCall(caller2, selfType, block, args2, context, self, name2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject[] args2, Block block) {
        try {
            return this.callBlock(context, caller2, self, args2, block);
        }
        catch (JumpException.BreakJump bj) {
            return SuperCallSite.handleBreakJump(context, bj);
        }
        catch (JumpException.RetryJump rj) {
            throw SuperCallSite.retryJumpError(context);
        }
    }

    public IRubyObject callIter(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject[] args2, Block block) {
        try {
            IRubyObject iRubyObject = this.callBlock(context, caller2, self, args2, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = SuperCallSite.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            throw SuperCallSite.retryJumpError(context);
        }
        finally {
            block.escape();
        }
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self, klazz, name2);
        CacheEntry myCache = this.cache;
        if (name2 == this.lastName && selfType != null && myCache.typeOk(selfType)) {
            return myCache.method.call(context, self, selfType, name2);
        }
        return this.cacheAndCall(caller2, selfType, context, self, name2);
    }

    private IRubyObject callBlock(ThreadContext context, IRubyObject caller2, IRubyObject self, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self, klazz, name2);
        CacheEntry myCache = this.cache;
        if (name2 == this.lastName && selfType != null && myCache.typeOk(selfType)) {
            return myCache.method.call(context, self, (RubyModule)selfType, name2, block);
        }
        return this.cacheAndCall(caller2, selfType, block, context, self, name2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self, Block block) {
        try {
            return this.callBlock(context, caller2, self, block);
        }
        catch (JumpException.BreakJump bj) {
            return SuperCallSite.handleBreakJump(context, bj);
        }
        catch (JumpException.RetryJump rj) {
            throw SuperCallSite.retryJumpError(context);
        }
    }

    public IRubyObject callIter(ThreadContext context, IRubyObject caller2, IRubyObject self, Block block) {
        try {
            IRubyObject iRubyObject = this.callBlock(context, caller2, self, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = SuperCallSite.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            throw SuperCallSite.retryJumpError(context);
        }
        finally {
            block.escape();
        }
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg1) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self, klazz, name2);
        CacheEntry myCache = this.cache;
        if (name2 == this.lastName && selfType != null && myCache.typeOk(selfType)) {
            return myCache.method.call(context, self, (RubyModule)selfType, name2, arg1);
        }
        return this.cacheAndCall(caller2, selfType, context, self, name2, arg1);
    }

    private IRubyObject callBlock(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg1, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self, klazz, name2);
        CacheEntry myCache = this.cache;
        if (name2 == this.lastName && selfType != null && myCache.typeOk(selfType)) {
            return myCache.method.call(context, self, (RubyModule)selfType, name2, arg1, block);
        }
        return this.cacheAndCall(caller2, selfType, block, context, self, name2, arg1);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg1, Block block) {
        try {
            return this.callBlock(context, caller2, self, arg1, block);
        }
        catch (JumpException.BreakJump bj) {
            return SuperCallSite.handleBreakJump(context, bj);
        }
        catch (JumpException.RetryJump rj) {
            throw SuperCallSite.retryJumpError(context);
        }
    }

    public IRubyObject callIter(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg1, Block block) {
        try {
            IRubyObject iRubyObject = this.callBlock(context, caller2, self, arg1, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = SuperCallSite.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            throw SuperCallSite.retryJumpError(context);
        }
        finally {
            block.escape();
        }
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg1, IRubyObject arg2) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self, klazz, name2);
        CacheEntry myCache = this.cache;
        if (name2 == this.lastName && selfType != null && myCache.typeOk(selfType)) {
            return myCache.method.call(context, self, (RubyModule)selfType, name2, arg1, arg2);
        }
        return this.cacheAndCall(caller2, selfType, context, self, name2, arg1, arg2);
    }

    private IRubyObject callBlock(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg1, IRubyObject arg2, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self, klazz, name2);
        CacheEntry myCache = this.cache;
        if (name2 == this.lastName && selfType != null && myCache.typeOk(selfType)) {
            return myCache.method.call(context, self, (RubyModule)selfType, name2, arg1, arg2, block);
        }
        return this.cacheAndCall(caller2, selfType, block, context, self, name2, arg1, arg2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg1, IRubyObject arg2, Block block) {
        try {
            return this.callBlock(context, caller2, self, arg1, arg2, block);
        }
        catch (JumpException.BreakJump bj) {
            return SuperCallSite.handleBreakJump(context, bj);
        }
        catch (JumpException.RetryJump rj) {
            throw SuperCallSite.retryJumpError(context);
        }
    }

    public IRubyObject callIter(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg1, IRubyObject arg2, Block block) {
        try {
            IRubyObject iRubyObject = this.callBlock(context, caller2, self, arg1, arg2, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = SuperCallSite.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            throw SuperCallSite.retryJumpError(context);
        }
        finally {
            block.escape();
        }
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self, klazz, name2);
        CacheEntry myCache = this.cache;
        if (name2 == this.lastName && selfType != null && myCache.typeOk(selfType)) {
            return myCache.method.call(context, self, (RubyModule)selfType, name2, arg1, arg2, arg3);
        }
        return this.cacheAndCall(caller2, selfType, context, self, name2, arg1, arg2, arg3);
    }

    private IRubyObject callBlock(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self, klazz, name2);
        CacheEntry myCache = this.cache;
        if (name2 == this.lastName && selfType != null && myCache.typeOk(selfType)) {
            return myCache.method.call(context, self, (RubyModule)selfType, name2, arg1, arg2, arg3, block);
        }
        return this.cacheAndCall(caller2, selfType, block, context, self, name2, arg1, arg2, arg3);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        try {
            return this.callBlock(context, caller2, self, arg1, arg2, arg3, block);
        }
        catch (JumpException.BreakJump bj) {
            return SuperCallSite.handleBreakJump(context, bj);
        }
        catch (JumpException.RetryJump rj) {
            throw SuperCallSite.retryJumpError(context);
        }
    }

    public IRubyObject callIter(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        try {
            IRubyObject iRubyObject = this.callBlock(context, caller2, self, arg1, arg2, arg3, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = SuperCallSite.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            throw SuperCallSite.retryJumpError(context);
        }
        finally {
            block.escape();
        }
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, Block block, IRubyObject[] args2, ThreadContext context, IRubyObject self, String name2) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self, name2, method2, args2, block);
        }
        this.lastName = name2;
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, name2, args2, block);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, IRubyObject[] args2, ThreadContext context, IRubyObject self, String name2) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self, name2, method2, args2);
        }
        this.lastName = name2;
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, name2, args2);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, ThreadContext context, IRubyObject self, String name2) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self, name2, method2);
        }
        this.lastName = name2;
        this.cache = entry;
        return method2.call(context, self, selfType, name2);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, Block block, ThreadContext context, IRubyObject self, String name2) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self, name2, method2, block);
        }
        this.lastName = name2;
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, name2, block);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, ThreadContext context, IRubyObject self, String name2, IRubyObject arg2) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self, name2, method2, arg2);
        }
        this.lastName = name2;
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, name2, arg2);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, Block block, ThreadContext context, IRubyObject self, String name2, IRubyObject arg2) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self, name2, method2, arg2, block);
        }
        this.lastName = name2;
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, name2, arg2, block);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, ThreadContext context, IRubyObject self, String name2, IRubyObject arg1, IRubyObject arg2) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self, name2, method2, arg1, arg2);
        }
        this.lastName = name2;
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, name2, arg1, arg2);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, Block block, ThreadContext context, IRubyObject self, String name2, IRubyObject arg1, IRubyObject arg2) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self, name2, method2, arg1, arg2, block);
        }
        this.lastName = name2;
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, name2, arg1, arg2, block);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, ThreadContext context, IRubyObject self, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self, name2, method2, arg1, arg2, arg3);
        }
        this.lastName = name2;
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, name2, arg1, arg2, arg3);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, Block block, ThreadContext context, IRubyObject self, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self, name2, method2, arg1, arg2, arg3, block);
        }
        this.lastName = name2;
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, name2, arg1, arg2, arg3, block);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, String name2, DynamicMethod method2, IRubyObject[] args2) {
        return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, this.callType, args2, Block.NULL_BLOCK);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, String name2, DynamicMethod method2) {
        return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, this.callType, Block.NULL_BLOCK);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, String name2, DynamicMethod method2, Block block) {
        return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, this.callType, block);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, String name2, DynamicMethod method2, IRubyObject arg2) {
        return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, this.callType, arg2, Block.NULL_BLOCK);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, String name2, DynamicMethod method2, IRubyObject[] args2, Block block) {
        return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, this.callType, args2, block);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, String name2, DynamicMethod method2, IRubyObject arg0, Block block) {
        return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, this.callType, arg0, block);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, String name2, DynamicMethod method2, IRubyObject arg0, IRubyObject arg1) {
        return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, this.callType, arg0, arg1, Block.NULL_BLOCK);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, String name2, DynamicMethod method2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, this.callType, arg0, arg1, block);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, String name2, DynamicMethod method2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg3) {
        return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, this.callType, arg0, arg1, arg3, Block.NULL_BLOCK);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, String name2, DynamicMethod method2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, this.callType, arg0, arg1, arg2, block);
    }

    protected boolean methodMissing(DynamicMethod method2, IRubyObject caller2) {
        return method2.isUndefined();
    }

    protected static RubyClass pollAndGetClass(ThreadContext context, IRubyObject self, RubyModule frameClass, String frameName) {
        SuperCallSite.checkSuperDisabledOrOutOfMethod(context, frameClass, frameName);
        RubyClass superClass = RuntimeHelpers.findImplementerIfNecessary(self.getMetaClass(), frameClass).getSuperClass();
        return superClass;
    }

    protected static void checkSuperDisabledOrOutOfMethod(ThreadContext context, RubyModule frameClass, String frameName) {
        if (frameClass == null) {
            if (frameName != null) {
                throw context.getRuntime().newNameError("superclass method '" + frameName + "' disabled", frameName);
            }
            throw context.getRuntime().newNoMethodError("super called outside of method", null, context.getRuntime().getNil());
        }
    }

    protected static IRubyObject handleBreakJump(ThreadContext context, JumpException.BreakJump bj) throws JumpException.BreakJump {
        if (context.getFrameJumpTarget() == bj.getTarget()) {
            return (IRubyObject)bj.getValue();
        }
        throw bj;
    }

    protected static RaiseException retryJumpError(ThreadContext context) {
        return context.getRuntime().newLocalJumpError(RubyLocalJumpError.Reason.RETRY, context.getRuntime().getNil(), "retry outside of rescue not supported");
    }
}

