/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import java.io.Serializable;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.Node;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.DummyDynamicScope;

public abstract class StaticScope
implements Serializable {
    private static final long serialVersionUID = 4843861446986961013L;
    protected final StaticScope enclosingScope;
    private transient RubyModule cref = null;
    private StaticScope previousCRefScope = null;
    private String[] variableNames;
    private boolean[] variableCaptured;
    private int requiredArgs = 0;
    private int optionalArgs = 0;
    private int restArg = -1;
    private boolean isArgumentScope = false;
    private boolean isBackrefLastlineScope = false;
    private DynamicScope dummyScope;

    protected StaticScope(StaticScope enclosingScope, String[] names2) {
        assert (names2 != null) : "names is not null";
        assert (StaticScope.namesAreInterned(names2));
        this.enclosingScope = enclosingScope;
        this.variableNames = names2;
        this.variableCaptured = new boolean[this.variableNames.length];
    }

    private static boolean namesAreInterned(String[] names2) {
        for (String name2 : names2) {
            if (name2 == name2.intern()) continue;
            return false;
        }
        return true;
    }

    public int addVariable(String name2) {
        int slot = this.isDefined(name2);
        if (slot >= 0) {
            return slot;
        }
        this.growVariableNames(name2);
        return this.variableNames.length - 1;
    }

    public String[] getVariables() {
        return this.variableNames;
    }

    public int getNumberOfVariables() {
        return this.variableNames.length;
    }

    public void setVariables(String[] names2) {
        assert (names2 != null) : "names is not null";
        this.variableNames = new String[names2.length];
        System.arraycopy(names2, 0, this.variableNames, 0, names2.length);
        this.variableCaptured = new boolean[this.variableNames.length];
    }

    public IRubyObject getConstantWithConstMissing(Ruby runtime2, String internedName, RubyModule object) {
        IRubyObject result = this.getConstantInner(runtime2, internedName, object);
        return result == null ? this.cref.fastGetConstant(internedName) : result;
    }

    public IRubyObject getConstant(Ruby runtime2, String internedName, RubyModule object) {
        IRubyObject result = this.getConstantInner(runtime2, internedName, object);
        return result == null ? this.cref.getConstantNoConstMissing(internedName) : result;
    }

    private IRubyObject getConstantInner(Ruby runtime2, String internedName, RubyModule object) {
        IRubyObject result = this.cref.fastFetchConstant(internedName);
        if (result != null) {
            if (result == RubyObject.UNDEF) {
                return this.getUndefConstant(runtime2, internedName, object);
            }
            return result;
        }
        return this.previousCRefScope == null ? null : this.previousCRefScope.getConstantInnerNoObject(runtime2, internedName, object);
    }

    private IRubyObject getConstantInnerNoObject(Ruby runtime2, String internedName, RubyModule object) {
        if (this.previousCRefScope == null) {
            return null;
        }
        return this.getConstantInner(runtime2, internedName, object);
    }

    private IRubyObject getUndefConstant(Ruby runtime2, String internedName, RubyModule object) {
        if (this.cref.resolveUndefConstant(runtime2, internedName) == null) {
            return null;
        }
        return this.getConstantInner(runtime2, internedName, object);
    }

    public StaticScope getEnclosingScope() {
        return this.enclosingScope;
    }

    public int exists(String name2) {
        return this.findVariableName(name2);
    }

    private int findVariableName(String name2) {
        for (int i = 0; i < this.variableNames.length; ++i) {
            if (name2 != this.variableNames[i]) continue;
            return i;
        }
        return -1;
    }

    public int isDefined(String name2) {
        return this.isDefined(name2, 0);
    }

    public AssignableNode assign(ISourcePosition position, String name2, Node value2) {
        return this.assign(position, name2, value2, this, 0);
    }

    public abstract String[] getAllNamesInScope();

    protected abstract int isDefined(String var1, int var2);

    protected abstract AssignableNode assign(ISourcePosition var1, String var2, Node var3, StaticScope var4, int var5);

    protected abstract Node declare(ISourcePosition var1, String var2, int var3);

    public Node declare(ISourcePosition position, String name2) {
        return this.declare(position, name2, 0);
    }

    public void capture(int index2) {
        this.variableCaptured[index2] = true;
    }

    public boolean isCaptured(int index2) {
        return this.variableCaptured[index2];
    }

    public abstract StaticScope getLocalScope();

    public RubyModule getModule() {
        return this.cref;
    }

    public StaticScope getPreviousCRefScope() {
        return this.previousCRefScope;
    }

    public void setModule(RubyModule module) {
        this.cref = module;
        if (this.previousCRefScope == null) {
            for (StaticScope scope = this.getEnclosingScope(); scope != null; scope = scope.getEnclosingScope()) {
                if (scope.cref == null) continue;
                this.previousCRefScope = scope;
                return;
            }
        }
    }

    public RubyModule determineModule() {
        if (this.cref == null) {
            this.cref = this.getEnclosingScope().determineModule();
            assert (this.cref != null) : "CRef is always created before determine happens";
            this.previousCRefScope = this.getEnclosingScope().previousCRefScope;
        }
        return this.cref;
    }

    public int getOptionalArgs() {
        return this.optionalArgs;
    }

    public int getRequiredArgs() {
        return this.requiredArgs;
    }

    public void setRequiredArgs(int requiredArgs) {
        this.requiredArgs = requiredArgs;
    }

    public int getRestArg() {
        return this.restArg;
    }

    public void setRestArg(int restArg) {
        this.restArg = restArg;
    }

    public boolean isArgumentScope() {
        return this.isArgumentScope;
    }

    public void setArgumentScope(boolean isArgumentScope) {
        this.isArgumentScope = isArgumentScope;
    }

    public boolean isBackrefLastlineScope() {
        return this.isBackrefLastlineScope;
    }

    public void setBackrefLastlineScope(boolean isBackrefLastlineScope) {
        this.isBackrefLastlineScope = isBackrefLastlineScope;
    }

    public Arity getArity() {
        if (this.optionalArgs > 0) {
            if (this.restArg >= 0) {
                return Arity.optional();
            }
            return Arity.required(this.requiredArgs);
        }
        if (this.restArg >= 0) {
            return Arity.optional();
        }
        return Arity.fixed(this.requiredArgs);
    }

    public void setArities(int required, int optional, int rest2) {
        this.requiredArgs = required;
        this.optionalArgs = optional;
        this.restArg = rest2;
    }

    public DynamicScope getDummyScope() {
        return this.dummyScope == null ? (this.dummyScope = new DummyDynamicScope(this)) : this.dummyScope;
    }

    private void growVariableNames(String name2) {
        String[] newVariableNames = new String[this.variableNames.length + 1];
        System.arraycopy(this.variableNames, 0, newVariableNames, 0, this.variableNames.length);
        this.variableNames = newVariableNames;
        this.variableNames[this.variableNames.length - 1] = name2;
        boolean[] newVariableCaptured = new boolean[this.variableCaptured.length + 1];
        System.arraycopy(this.variableCaptured, 0, newVariableCaptured, 0, this.variableCaptured.length);
        this.variableCaptured = newVariableCaptured;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[");
        for (int i = 0; i < this.variableNames.length - 1; ++i) {
            buf.append(this.variableNames[i]).append(", ");
        }
        if (this.variableNames.length > 0) {
            buf.append(this.variableNames[this.variableNames.length - 1]);
        }
        buf.append("]");
        return buf.toString();
    }
}

