/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jna;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import org.jruby.Ruby;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.Util;
import org.jruby.ext.ffi.jna.NativeMemoryIO;

public class BoundedNativeMemoryIO
implements MemoryIO,
DirectMemoryIO {
    private static final int ADDRESS_SIZE = Platform.getPlatform().addressSize();
    private final Ruby runtime;
    protected final Pointer ptr;
    protected final long size;

    public BoundedNativeMemoryIO(Ruby runtime2, Pointer ptr, long size2) {
        this.runtime = runtime2;
        this.ptr = ptr;
        this.size = size2;
    }

    private final void checkBounds(long off, long len) {
        Util.checkBounds(this.runtime, this.size, off, len);
    }

    Pointer getPointer() {
        return this.ptr;
    }

    public final long getAddress() {
        PointerByReference ref = new PointerByReference(this.ptr);
        return ADDRESS_SIZE == 32 ? (long)ref.getPointer().getInt(0L) & 0xFFFFFFFFL : ref.getPointer().getLong(0L);
    }

    public final boolean isNull() {
        return this.ptr == null;
    }

    public final boolean isDirect() {
        return true;
    }

    public final byte getByte(long offset2) {
        this.checkBounds(offset2, 1L);
        return this.ptr.getByte(offset2);
    }

    public final short getShort(long offset2) {
        this.checkBounds(offset2, 2L);
        return this.ptr.getShort(offset2);
    }

    public final int getInt(long offset2) {
        this.checkBounds(offset2, 4L);
        return this.ptr.getInt(offset2);
    }

    public final long getLong(long offset2) {
        this.checkBounds(offset2, 8L);
        return this.ptr.getLong(offset2);
    }

    public final long getNativeLong(long offset2) {
        this.checkBounds(offset2, Platform.getPlatform().longSize() >> 3);
        return this.ptr.getNativeLong(offset2).longValue();
    }

    public long getAddress(long offset2) {
        this.checkBounds(offset2, ADDRESS_SIZE >> 3);
        return ADDRESS_SIZE == 32 ? (long)this.getInt(offset2) & 0xFFFFFFFFL : this.getLong(offset2);
    }

    public final DirectMemoryIO getMemoryIO(long offset2) {
        this.checkBounds(offset2, ADDRESS_SIZE >> 3);
        Pointer p2 = this.ptr.getPointer(offset2);
        return p2 != null ? new NativeMemoryIO(p2) : null;
    }

    public final float getFloat(long offset2) {
        this.checkBounds(offset2, 4L);
        return this.ptr.getFloat(offset2);
    }

    public final double getDouble(long offset2) {
        this.checkBounds(offset2, 8L);
        return this.ptr.getDouble(offset2);
    }

    public final Pointer getPointer(long offset2) {
        this.checkBounds(offset2, ADDRESS_SIZE >> 3);
        return this.ptr.getPointer(offset2);
    }

    public final void putByte(long offset2, byte value2) {
        this.checkBounds(offset2, 1L);
        this.ptr.setByte(offset2, value2);
    }

    public final void putShort(long offset2, short value2) {
        this.checkBounds(offset2, 2L);
        this.ptr.setShort(offset2, value2);
    }

    public final void putInt(long offset2, int value2) {
        this.checkBounds(offset2, 4L);
        this.ptr.setInt(offset2, value2);
    }

    public final void putLong(long offset2, long value2) {
        this.checkBounds(offset2, 8L);
        this.ptr.setLong(offset2, value2);
    }

    public final void putNativeLong(long offset2, long value2) {
        this.checkBounds(offset2, Platform.getPlatform().longSize() >> 3);
        this.ptr.setNativeLong(offset2, new NativeLong(value2));
    }

    public final void putAddress(long offset2, long value2) {
        this.checkBounds(offset2, ADDRESS_SIZE >> 3);
        if (ADDRESS_SIZE == 32) {
            this.ptr.setInt(offset2, (int)value2);
        } else {
            this.ptr.setLong(offset2, value2);
        }
    }

    public final void putMemoryIO(long offset2, MemoryIO value2) {
        this.checkBounds(offset2, ADDRESS_SIZE >> 3);
        if (value2 instanceof BoundedNativeMemoryIO) {
            this.ptr.setPointer(offset2, ((BoundedNativeMemoryIO)value2).ptr);
        } else {
            this.putAddress(offset2, ((DirectMemoryIO)value2).getAddress());
        }
    }

    public final void putFloat(long offset2, float value2) {
        this.checkBounds(offset2, 4L);
        this.ptr.setFloat(offset2, value2);
    }

    public final void putDouble(long offset2, double value2) {
        this.checkBounds(offset2, 8L);
        this.ptr.setDouble(offset2, value2);
    }

    public final void putPointer(long offset2, Pointer value2) {
        this.checkBounds(offset2, ADDRESS_SIZE >> 3);
        this.ptr.setPointer(offset2, value2);
    }

    public final void get(long offset2, byte[] dst, int off, int len) {
        this.checkBounds(offset2, len);
        this.ptr.read(offset2, dst, off, len);
    }

    public final void put(long offset2, byte[] dst, int off, int len) {
        this.checkBounds(offset2, len);
        this.ptr.write(offset2, dst, off, len);
    }

    public final void get(long offset2, short[] dst, int off, int len) {
        this.checkBounds(offset2, len << 1);
        this.ptr.read(offset2, dst, off, len);
    }

    public final void put(long offset2, short[] dst, int off, int len) {
        this.checkBounds(offset2, len << 1);
        this.ptr.write(offset2, dst, off, len);
    }

    public final void get(long offset2, int[] dst, int off, int len) {
        this.checkBounds(offset2, len << 2);
        this.ptr.read(offset2, dst, off, len);
    }

    public final void put(long offset2, int[] dst, int off, int len) {
        this.checkBounds(offset2, len << 2);
        this.ptr.write(offset2, dst, off, len);
    }

    public final void get(long offset2, long[] dst, int off, int len) {
        this.checkBounds(offset2, len << 8);
        this.ptr.read(offset2, dst, off, len);
    }

    public final void put(long offset2, long[] dst, int off, int len) {
        this.checkBounds(offset2, len << 8);
        this.ptr.write(offset2, dst, off, len);
    }

    public final void get(long offset2, float[] dst, int off, int len) {
        this.checkBounds(offset2, len << 4);
        this.ptr.read(offset2, dst, off, len);
    }

    public final void put(long offset2, float[] dst, int off, int len) {
        this.checkBounds(offset2, len << 4);
        this.ptr.write(offset2, dst, off, len);
    }

    public final void get(long offset2, double[] dst, int off, int len) {
        this.checkBounds(offset2, len << 8);
        this.ptr.read(offset2, dst, off, len);
    }

    public final void put(long offset2, double[] dst, int off, int len) {
        this.checkBounds(offset2, len << 8);
        this.ptr.write(offset2, dst, off, len);
    }

    public final int indexOf(long offset2, byte value2) {
        return (int)this.ptr.indexOf(offset2, value2);
    }

    public final int indexOf(long offset2, byte value2, int maxlen) {
        return (int)this.ptr.indexOf(offset2, value2);
    }

    public final void setMemory(long offset2, long size2, byte value2) {
        this.checkBounds(offset2, size2);
        this.ptr.setMemory(offset2, size2, value2);
    }

    public BoundedNativeMemoryIO slice(long offset2) {
        this.checkBounds(offset2, 1L);
        return offset2 == 0L ? this : new BoundedNativeMemoryIO(this.runtime, this.ptr.share(offset2), this.size - offset2);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof BoundedNativeMemoryIO) {
            BoundedNativeMemoryIO io2 = (BoundedNativeMemoryIO)obj;
            return io2.ptr == this.ptr || io2.ptr != null && io2.ptr.equals(this.ptr);
        }
        return obj instanceof DirectMemoryIO && ((DirectMemoryIO)obj).getAddress() == this.getAddress();
    }

    public int hashCode() {
        return this.ptr == null ? 0 : this.ptr.hashCode();
    }
}

