/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import jruby.objectweb.asm.Label;
import org.jruby.compiler.ArgumentsCallback;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.BaseBodyCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardInvocationCompiler;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;

public class InvokeDynamicInvocationCompiler
extends StandardInvocationCompiler {
    public InvokeDynamicInvocationCompiler(BaseBodyCompiler methodCompiler, SkinnyMethodAdapter method2) {
        super(methodCompiler, method2);
    }

    public SkinnyMethodAdapter getMethodAdapter() {
        return this.method;
    }

    public void setMethodAdapter(SkinnyMethodAdapter sma) {
        this.method = sma;
    }

    public void invokeAttrAssignMasgn(String name2, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        String signature;
        receiverCallback.call(this.methodCompiler);
        if (argsCallback == null) {
            signature = CodegenUtils.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class, ThreadContext.class, CallSite.class);
        } else {
            switch (argsCallback.getArity()) {
                case 0: {
                    signature = CodegenUtils.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class, ThreadContext.class, CallSite.class);
                    break;
                }
                case 1: {
                    argsCallback.call(this.methodCompiler);
                    signature = CodegenUtils.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, ThreadContext.class, CallSite.class);
                    break;
                }
                case 2: {
                    argsCallback.call(this.methodCompiler);
                    signature = CodegenUtils.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, ThreadContext.class, CallSite.class);
                    break;
                }
                case 3: {
                    argsCallback.call(this.methodCompiler);
                    signature = CodegenUtils.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, ThreadContext.class, CallSite.class);
                    break;
                }
                default: {
                    argsCallback.call(this.methodCompiler);
                    signature = CodegenUtils.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, ThreadContext.class, CallSite.class);
                }
            }
        }
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, name2, CallType.NORMAL);
        this.methodCompiler.invokeUtilityMethod("doAttrAsgn", signature);
    }

    public void invokeAttrAssign(String name2, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        Label variableCallType = new Label();
        Label readyForCall = new Label();
        receiverCallback.call(this.methodCompiler);
        this.method.dup();
        this.methodCompiler.loadSelf();
        this.method.if_acmpeq(variableCallType);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, name2, CallType.NORMAL);
        this.method.go_to(readyForCall);
        this.method.label(variableCallType);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, name2, CallType.VARIABLE);
        this.method.label(readyForCall);
        String signature = null;
        switch (argsCallback.getArity()) {
            case 1: {
                signature = CodegenUtils.sig(IRubyObject.class, IRubyObject.class, CallSite.class, IRubyObject.class, ThreadContext.class);
                break;
            }
            case 2: {
                signature = CodegenUtils.sig(IRubyObject.class, IRubyObject.class, CallSite.class, IRubyObject.class, IRubyObject.class, ThreadContext.class);
                break;
            }
            case 3: {
                signature = CodegenUtils.sig(IRubyObject.class, IRubyObject.class, CallSite.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, ThreadContext.class);
                break;
            }
            default: {
                signature = CodegenUtils.sig(IRubyObject.class, IRubyObject.class, CallSite.class, IRubyObject[].class, ThreadContext.class);
            }
        }
        argsCallback.call(this.methodCompiler);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeUtilityMethod("doAttrAsgn", signature);
    }

    public void opElementAsgnWithOr(CompilerCallback receiver2, ArgumentsCallback args2, CompilerCallback valueCallback) {
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]", CallType.FUNCTIONAL);
        this.methodCompiler.loadThreadContext();
        receiver2.call(this.methodCompiler);
        args2.call(this.methodCompiler);
        this.method.dup2();
        int argsLocal = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.methodCompiler.getVariableCompiler().setTempLocal(argsLocal);
        int receiverLocal = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.methodCompiler.getVariableCompiler().setTempLocal(receiverLocal);
        switch (args2.getArity()) {
            case 1: {
                this.method.invokevirtual(CodegenUtils.p(CallSite.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class));
                break;
            }
            default: {
                this.method.invokevirtual(CodegenUtils.p(CallSite.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class));
            }
        }
        this.method.dup();
        this.methodCompiler.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        Label done = new Label();
        this.method.ifne(done);
        this.method.pop();
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.getVariableCompiler().getTempLocal(receiverLocal);
        this.methodCompiler.getVariableCompiler().getTempLocal(argsLocal);
        valueCallback.call(this.methodCompiler);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]=", CallType.FUNCTIONAL);
        switch (args2.getArity()) {
            case 0: {
                throw new NotCompilableException("Op Element Asgn with zero-arity args");
            }
            case 1: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoOneArg", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class));
                break;
            }
            case 2: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoTwoArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
                break;
            }
            case 3: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoThreeArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
                break;
            }
            default: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoNArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
            }
        }
        this.method.label(done);
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
    }

    public void opElementAsgnWithAnd(CompilerCallback receiver2, ArgumentsCallback args2, CompilerCallback valueCallback) {
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]", CallType.FUNCTIONAL);
        this.methodCompiler.loadThreadContext();
        receiver2.call(this.methodCompiler);
        args2.call(this.methodCompiler);
        this.method.dup2();
        int argsLocal = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.methodCompiler.getVariableCompiler().setTempLocal(argsLocal);
        int receiverLocal = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.methodCompiler.getVariableCompiler().setTempLocal(receiverLocal);
        switch (args2.getArity()) {
            case 1: {
                this.method.invokevirtual(CodegenUtils.p(CallSite.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class));
                break;
            }
            default: {
                this.method.invokevirtual(CodegenUtils.p(CallSite.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class));
            }
        }
        this.method.dup();
        this.methodCompiler.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        Label done = new Label();
        this.method.ifeq(done);
        this.method.pop();
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.getVariableCompiler().getTempLocal(receiverLocal);
        this.methodCompiler.getVariableCompiler().getTempLocal(argsLocal);
        valueCallback.call(this.methodCompiler);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]=", CallType.FUNCTIONAL);
        switch (args2.getArity()) {
            case 0: {
                throw new NotCompilableException("Op Element Asgn with zero-arity args");
            }
            case 1: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoOneArg", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class));
                break;
            }
            case 2: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoTwoArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
                break;
            }
            case 3: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoThreeArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
                break;
            }
            default: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoNArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
            }
        }
        this.method.label(done);
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
    }

    public void opElementAsgnWithMethod(CompilerCallback receiver2, ArgumentsCallback args2, CompilerCallback valueCallback, String operator) {
        this.methodCompiler.loadThreadContext();
        receiver2.call(this.methodCompiler);
        args2.call(this.methodCompiler);
        valueCallback.call(this.methodCompiler);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]", CallType.FUNCTIONAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, operator, CallType.NORMAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]=", CallType.FUNCTIONAL);
        switch (args2.getArity()) {
            case 0: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
                break;
            }
            case 1: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
                break;
            }
            case 2: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
                break;
            }
            case 3: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
                break;
            }
            default: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
            }
        }
    }

    public void invokeSuper(CompilerCallback argsCallback, CompilerCallback closureArg) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeUtilityMethod("checkSuperDisabledOrOutOfMethod", CodegenUtils.sig(Void.TYPE, ThreadContext.class));
        this.methodCompiler.loadSelf();
        this.methodCompiler.loadThreadContext();
        if (argsCallback == null) {
            this.method.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
            if (closureArg == null) {
                this.methodCompiler.loadBlock();
            } else {
                closureArg.call(this.methodCompiler);
            }
        } else {
            argsCallback.call(this.methodCompiler);
            if (closureArg == null) {
                this.methodCompiler.loadBlock();
            } else {
                closureArg.call(this.methodCompiler);
            }
        }
        this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "callSuper", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject[].class, Block.class));
    }

    public void invokeDynamic(String name2, CompilerCallback receiverCallback, ArgumentsCallback argsCallback, CallType callType, CompilerCallback closureArg, boolean iterator) {
        String signature;
        if (receiverCallback != null) {
            receiverCallback.call(this.methodCompiler);
        } else {
            this.methodCompiler.loadSelf();
        }
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.method.ldc(name2);
        String callName = callType == CallType.NORMAL ? "c" : (callType == CallType.FUNCTIONAL ? "f" : "v");
        if (argsCallback == null) {
            if (closureArg == null) {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, String.class));
            } else {
                if (iterator) {
                    callName = callName + "b";
                }
                closureArg.call(this.methodCompiler);
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, String.class, Block.class));
            }
        } else {
            argsCallback.call(this.methodCompiler);
            if (closureArg == null) {
                switch (argsCallback.getArity()) {
                    case 1: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, String.class, IRubyObject.class));
                        break;
                    }
                    case 2: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, String.class, IRubyObject.class, IRubyObject.class));
                        break;
                    }
                    case 3: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                        break;
                    }
                    default: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, String.class, IRubyObject[].class));
                        break;
                    }
                }
            } else {
                if (iterator) {
                    callName = callName + "b";
                }
                closureArg.call(this.methodCompiler);
                switch (argsCallback.getArity()) {
                    case 1: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, String.class, IRubyObject.class, Block.class));
                        break;
                    }
                    case 2: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, String.class, IRubyObject.class, IRubyObject.class, Block.class));
                        break;
                    }
                    case 3: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
                        break;
                    }
                    default: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, String.class, IRubyObject[].class, Block.class));
                    }
                }
            }
        }
        this.method.invokedynamic(CodegenUtils.p(IRubyObject.class), callName, signature);
    }

    public void invokeOpAsgnWithOr(String attrName, String attrAsgnName, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        receiverCallback.call(this.methodCompiler);
        this.method.dup();
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, attrName, CallType.FUNCTIONAL);
        this.methodCompiler.invokeUtilityMethod("preOpAsgnWithOrAnd", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, ThreadContext.class, CallSite.class));
        Label done = new Label();
        Label isTrue = new Label();
        this.method.dup();
        this.methodCompiler.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        this.method.ifne(isTrue);
        this.method.pop();
        argsCallback.call(this.methodCompiler);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, attrAsgnName, CallType.NORMAL);
        this.methodCompiler.invokeUtilityMethod("postOpAsgnWithOrAnd", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class, ThreadContext.class, CallSite.class));
        this.method.go_to(done);
        this.method.label(isTrue);
        this.method.swap();
        this.method.pop();
        this.method.label(done);
    }

    public void invokeOpAsgnWithAnd(String attrName, String attrAsgnName, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        receiverCallback.call(this.methodCompiler);
        this.method.dup();
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, attrName, CallType.FUNCTIONAL);
        this.methodCompiler.invokeUtilityMethod("preOpAsgnWithOrAnd", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, ThreadContext.class, CallSite.class));
        Label done = new Label();
        Label isFalse = new Label();
        this.method.dup();
        this.methodCompiler.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        this.method.ifeq(isFalse);
        this.method.pop();
        argsCallback.call(this.methodCompiler);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, attrAsgnName, CallType.NORMAL);
        this.methodCompiler.invokeUtilityMethod("postOpAsgnWithOrAnd", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class, ThreadContext.class, CallSite.class));
        this.method.go_to(done);
        this.method.label(isFalse);
        this.method.swap();
        this.method.pop();
        this.method.label(done);
    }

    public void invokeOpAsgnWithMethod(String operatorName, String attrName, String attrAsgnName, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        this.methodCompiler.loadThreadContext();
        receiverCallback.call(this.methodCompiler);
        argsCallback.call(this.methodCompiler);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, attrName, CallType.FUNCTIONAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, operatorName, CallType.FUNCTIONAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, attrAsgnName, CallType.NORMAL);
        this.methodCompiler.invokeUtilityMethod("opAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
    }

    public void invokeOpElementAsgnWithMethod(String operatorName, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        this.methodCompiler.loadThreadContext();
        receiverCallback.call(this.methodCompiler);
        argsCallback.call(this.methodCompiler);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]", CallType.FUNCTIONAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, operatorName, CallType.FUNCTIONAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]=", CallType.NORMAL);
        this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
    }

    public void yield(CompilerCallback argsCallback, boolean unwrap) {
        String signature;
        this.methodCompiler.loadBlock();
        this.methodCompiler.loadThreadContext();
        if (argsCallback != null) {
            argsCallback.call(this.methodCompiler);
            signature = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, Boolean.TYPE);
        } else {
            signature = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, Boolean.TYPE);
        }
        this.method.ldc(unwrap);
        this.method.invokevirtual(CodegenUtils.p(Block.class), "yield", signature);
    }

    public void invokeEqq(ArgumentsCallback receivers, CompilerCallback argument) {
        if (argument == null) {
            receivers.call(this.methodCompiler);
            switch (receivers.getArity()) {
                case 1: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaselessWhen", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class));
                    break;
                }
                case 2: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaselessWhen", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class, IRubyObject.class));
                    break;
                }
                case 3: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaselessWhen", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                    break;
                }
                default: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaselessWhen", CodegenUtils.sig(Boolean.TYPE, IRubyObject[].class));
                    break;
                }
            }
        } else {
            this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "===", CallType.NORMAL);
            this.methodCompiler.loadThreadContext();
            this.methodCompiler.loadSelf();
            argument.call(this.methodCompiler);
            receivers.call(this.methodCompiler);
            switch (receivers.getArity()) {
                case 1: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaseWhen", CodegenUtils.sig(Boolean.TYPE, CallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                    break;
                }
                case 2: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaseWhen", CodegenUtils.sig(Boolean.TYPE, CallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                    break;
                }
                case 3: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaseWhen", CodegenUtils.sig(Boolean.TYPE, CallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                    break;
                }
                default: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaseWhen", CodegenUtils.sig(Boolean.TYPE, CallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class));
                }
            }
        }
    }
}

