/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Arrays;
import java.util.Iterator;
import org.jcodings.Encoding;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Region;
import org.joni.exception.JOniException;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;

@JRubyClass(name={"MatchData"})
public class RubyMatchData
extends RubyObject {
    Region regs;
    int begin;
    int end;
    RubyString str;
    Regex pattern;
    RubyRegexp regexp;
    boolean charOffsetUpdated;
    Region charOffsets;
    private static ObjectAllocator MATCH_DATA_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyMatchData(runtime2, klass);
        }
    };
    private static final int MATCH_BUSY = 128;

    public static RubyClass createMatchDataClass(Ruby runtime2) {
        RubyClass matchDataClass = runtime2.defineClass("MatchData", runtime2.getObject(), MATCH_DATA_ALLOCATOR);
        runtime2.setMatchData(matchDataClass);
        runtime2.defineGlobalConstant("MatchingData", matchDataClass);
        matchDataClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyMatchData;
            }
        };
        matchDataClass.getMetaClass().undefineMethod("new");
        matchDataClass.defineAnnotatedMethods(RubyMatchData.class);
        return matchDataClass;
    }

    public RubyMatchData(Ruby runtime2) {
        super(runtime2, runtime2.getMatchData());
    }

    public RubyMatchData(Ruby runtime2, RubyClass metaClass) {
        super(runtime2, metaClass);
    }

    private void updateCharOffset() {
        int p2;
        int numRegs;
        if (this.charOffsetUpdated) {
            return;
        }
        int n = numRegs = this.regs == null ? 1 : this.regs.numRegs;
        if (this.charOffsets == null || this.charOffsets.numRegs < numRegs) {
            this.charOffsets = new Region(numRegs);
        }
        Object[] pairs = new Pair[numRegs * 2];
        for (int i = 0; i < pairs.length; ++i) {
            pairs[i] = new Pair();
        }
        int numPos = 0;
        if (this.regs == null) {
            pairs[numPos++].bytePos = this.begin;
            ((Pair)pairs[numPos++]).bytePos = this.end;
        } else {
            for (int i = 0; i < numRegs; ++i) {
                if (this.regs.beg[i] < 0) continue;
                ((Pair)pairs[numPos++]).bytePos = this.regs.beg[i];
                ((Pair)pairs[numPos++]).bytePos = this.regs.end[i];
            }
        }
        Arrays.sort(pairs);
        ByteList value2 = this.str.getByteList();
        Encoding enc = value2.encoding;
        byte[] bytes2 = value2.bytes;
        int s = p2 = value2.begin;
        int c = 0;
        for (int i = 0; i < numPos; ++i) {
            int q = s + ((Pair)pairs[i]).bytePos;
            ((Pair)pairs[i]).charPos = c += StringSupport.strLength(enc, bytes2, p2, q);
            p2 = q;
        }
        Pair key2 = new Pair();
        if (this.regs == null) {
            key2.bytePos = this.begin;
            this.charOffsets.beg[0] = ((Pair)pairs[Arrays.binarySearch((Object[])pairs, (Object)key2)]).charPos;
            key2.bytePos = this.end;
            this.charOffsets.end[0] = ((Pair)pairs[Arrays.binarySearch((Object[])pairs, (Object)key2)]).charPos;
        } else {
            for (int i = 0; i < numRegs; ++i) {
                if (this.regs.beg[i] < 0) {
                    this.charOffsets.end[i] = -1;
                    this.charOffsets.beg[i] = -1;
                    continue;
                }
                key2.bytePos = this.regs.beg[i];
                this.charOffsets.beg[i] = ((Pair)pairs[Arrays.binarySearch((Object[])pairs, (Object)key2)]).charPos;
                key2.bytePos = this.regs.end[i];
                this.charOffsets.end[i] = ((Pair)pairs[Arrays.binarySearch((Object[])pairs, (Object)key2)]).charPos;
            }
        }
        this.charOffsetUpdated = true;
    }

    public final void use() {
        this.flags |= 0x80;
    }

    public final boolean used() {
        return (this.flags & 0x80) != 0;
    }

    private void check() {
        if (this.str == null) {
            throw this.getRuntime().newTypeError("uninitialized Match");
        }
    }

    private void checkLazyRegexp() {
        if (this.regexp == null) {
            this.regexp = RubyRegexp.newRegexp(this.getRuntime(), (ByteList)this.pattern.getUserObject(), this.pattern);
        }
    }

    private RubyArray match_array(Ruby runtime2, int start2) {
        this.check();
        if (this.regs == null) {
            if (start2 != 0) {
                return runtime2.newEmptyArray();
            }
            if (this.begin == -1) {
                return runtime2.newArray(runtime2.getNil());
            }
            RubyString ss = this.str.makeShared(runtime2, this.begin, this.end - this.begin);
            if (this.isTaint()) {
                ss.setTaint(true);
            }
            return runtime2.newArray((IRubyObject)ss);
        }
        RubyArray arr = runtime2.newArray(this.regs.numRegs - start2);
        for (int i = start2; i < this.regs.numRegs; ++i) {
            if (this.regs.beg[i] == -1) {
                arr.append(runtime2.getNil());
                continue;
            }
            RubyString ss = this.str.makeShared(runtime2, this.regs.beg[i], this.regs.end[i] - this.regs.beg[i]);
            if (this.isTaint()) {
                ss.setTaint(true);
            }
            arr.append(ss);
        }
        return arr;
    }

    public IRubyObject group(long n) {
        return RubyRegexp.nth_match((int)n, this);
    }

    public IRubyObject group(int n) {
        return RubyRegexp.nth_match(n, this);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        NameEntry e;
        if (this.str == null) {
            return this.anyToString();
        }
        Ruby runtime2 = this.getRuntime();
        RubyString result = runtime2.newString();
        result.cat((byte)35).cat((byte)60);
        result.append(this.getMetaClass().getRealClass().to_s());
        NameEntry[] names2 = new NameEntry[this.regs == null ? 1 : this.regs.numRegs];
        if (this.pattern.numberOfNames() > 0) {
            Iterator<NameEntry> i = this.pattern.namedBackrefIterator();
            while (i.hasNext()) {
                e = i.next();
                for (int num : e.getBackRefs()) {
                    names2[num] = e;
                }
            }
        }
        for (int i = 0; i < names2.length; ++i) {
            IRubyObject v;
            result.cat((byte)32);
            if (i > 0) {
                e = names2[i];
                if (e != null) {
                    result.cat(e.name, e.nameP, e.nameEnd - e.nameP);
                } else {
                    result.cat((byte)(48 + i));
                }
                result.cat((byte)58);
            }
            if ((v = RubyRegexp.nth_match(i, this)).isNil()) {
                result.cat("nil".getBytes());
                continue;
            }
            RubyString str = (RubyString)v;
            result.append(str.inspectCommon(runtime2.is1_9()));
        }
        return result.cat((byte)62);
    }

    @JRubyMethod(name={"regexp"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject regexp(ThreadContext context, Block block) {
        this.check();
        this.checkLazyRegexp();
        return this.regexp;
    }

    @JRubyMethod(name={"names"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject names(ThreadContext context, Block block) {
        this.check();
        this.checkLazyRegexp();
        return this.regexp.names(context);
    }

    @JRubyMethod(name={"to_a"})
    public RubyArray to_a() {
        return this.match_array(this.getRuntime(), 0);
    }

    @JRubyMethod(name={"values_at"}, required=1, rest=true)
    public IRubyObject values_at(IRubyObject[] args2) {
        return this.to_a().values_at(args2);
    }

    @JRubyMethod(name={"select"}, frame=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject select(ThreadContext context, Block block) {
        RubyArray result;
        Ruby runtime2 = context.getRuntime();
        if (this.regs == null) {
            if (this.begin < 0) {
                return runtime2.newEmptyArray();
            }
            IRubyObject s = this.str.substr(runtime2, this.begin, this.end - this.begin);
            s.setTaint(this.isTaint());
            result = block.yield(context, s).isTrue() ? runtime2.newArray(s) : runtime2.newEmptyArray();
        } else {
            result = runtime2.newArray();
            boolean taint2 = this.isTaint();
            for (int i = 0; i < this.regs.numRegs; ++i) {
                IRubyObject s = this.str.substr(runtime2, this.regs.beg[i], this.regs.end[i] - this.regs.beg[i]);
                if (taint2) {
                    s.setTaint(true);
                }
                if (!block.yield(context, s).isTrue()) continue;
                result.append(s);
            }
        }
        return result;
    }

    @JRubyMethod(name={"captures"})
    public IRubyObject captures(ThreadContext context) {
        return this.match_array(context.getRuntime(), 1);
    }

    private int nameToBackrefNumber(RubyString str) {
        ByteList value2 = str.getByteList();
        try {
            return this.pattern.nameToBackrefNumber(value2.bytes, value2.begin, value2.begin + value2.realSize, this.regs);
        }
        catch (JOniException je) {
            throw this.getRuntime().newIndexError(je.getMessage());
        }
    }

    final int backrefNumber(IRubyObject obj) {
        this.check();
        if (obj instanceof RubySymbol) {
            return this.nameToBackrefNumber((RubyString)((RubySymbol)obj).id2name());
        }
        if (obj instanceof RubyString) {
            return this.nameToBackrefNumber((RubyString)obj);
        }
        return RubyNumeric.num2int(obj);
    }

    public IRubyObject op_aref(IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.op_aref(args2[0]);
            }
            case 2: {
                return this.op_aref(args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(IRubyObject idx) {
        if (!(idx instanceof RubyFixnum) || ((RubyFixnum)idx).getLongValue() < 0L) {
            return this.to_a().aref(idx);
        }
        return RubyRegexp.nth_match(RubyNumeric.fix2int(idx), this);
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(IRubyObject idx, IRubyObject rest2) {
        if (!rest2.isNil() || !(idx instanceof RubyFixnum) || ((RubyFixnum)idx).getLongValue() < 0L) {
            return this.to_a().aref(idx, rest2);
        }
        return RubyRegexp.nth_match(RubyNumeric.fix2int(idx), this);
    }

    @JRubyMethod(name={"[]"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_aref19(IRubyObject idx) {
        IRubyObject result = this.op_arefCommon(idx);
        return result == null ? this.to_a().aref(idx) : result;
    }

    /*
     * WARNING - void declaration
     */
    @JRubyMethod(name={"[]"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_aref19(IRubyObject idx, IRubyObject rest2) {
        void var3_3;
        IRubyObject result;
        return !rest2.isNil() || (result = this.op_arefCommon(idx)) == null ? this.to_a().aref(idx, rest2) : var3_3;
    }

    private IRubyObject op_arefCommon(IRubyObject idx) {
        if (idx instanceof RubyFixnum) {
            int num = RubyNumeric.fix2int(idx);
            if (num >= 0) {
                return RubyRegexp.nth_match(num, this);
            }
        } else {
            if (idx instanceof RubySymbol) {
                return RubyRegexp.nth_match(this.nameToBackrefNumber((RubyString)((RubySymbol)idx).id2name()), this);
            }
            if (idx instanceof RubyString) {
                return RubyRegexp.nth_match(this.nameToBackrefNumber((RubyString)idx), this);
            }
        }
        return null;
    }

    @JRubyMethod(name={"size", "length"})
    public IRubyObject size(ThreadContext context) {
        this.check();
        Ruby runtime2 = context.getRuntime();
        return this.regs == null ? RubyFixnum.one(runtime2) : RubyFixnum.newFixnum(runtime2, this.regs.numRegs);
    }

    @JRubyMethod(name={"begin"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject begin(ThreadContext context, IRubyObject index2) {
        int i = RubyNumeric.num2int(index2);
        Ruby runtime2 = context.getRuntime();
        int b = this.beginCommon(runtime2, i);
        return b < 0 ? runtime2.getNil() : RubyFixnum.newFixnum(runtime2, b);
    }

    @JRubyMethod(name={"begin"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject begin19(ThreadContext context, IRubyObject index2) {
        int i = this.backrefNumber(index2);
        Ruby runtime2 = context.getRuntime();
        int b = this.beginCommon(runtime2, i);
        if (b < 0) {
            return runtime2.getNil();
        }
        if (!this.str.singleByteOptimizable()) {
            this.updateCharOffset();
            b = this.charOffsets.beg[i];
        }
        return RubyFixnum.newFixnum(runtime2, b);
    }

    private int beginCommon(Ruby runtime2, int i) {
        this.check();
        if (i < 0 || (this.regs == null ? 1 : this.regs.numRegs) <= i) {
            throw runtime2.newIndexError("index " + i + " out of matches");
        }
        return this.regs == null ? this.begin : this.regs.beg[i];
    }

    @JRubyMethod(name={"end"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject end(ThreadContext context, IRubyObject index2) {
        int i = RubyNumeric.num2int(index2);
        Ruby runtime2 = context.getRuntime();
        int e = this.endCommon(runtime2, i);
        return e < 0 ? runtime2.getNil() : RubyFixnum.newFixnum(runtime2, e);
    }

    @JRubyMethod(name={"end"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject end19(ThreadContext context, IRubyObject index2) {
        int i = this.backrefNumber(index2);
        Ruby runtime2 = context.getRuntime();
        int e = this.endCommon(runtime2, i);
        if (e < 0) {
            return runtime2.getNil();
        }
        if (!this.str.singleByteOptimizable()) {
            this.updateCharOffset();
            e = this.charOffsets.end[i];
        }
        return RubyFixnum.newFixnum(runtime2, e);
    }

    private int endCommon(Ruby runtime2, int i) {
        this.check();
        if (i < 0 || (this.regs == null ? 1 : this.regs.numRegs) <= i) {
            throw runtime2.newIndexError("index " + i + " out of matches");
        }
        return this.regs == null ? this.end : this.regs.end[i];
    }

    @JRubyMethod(name={"offset"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject offset(ThreadContext context, IRubyObject index2) {
        return this.offsetCommon(context, RubyNumeric.num2int(index2), false);
    }

    @JRubyMethod(name={"offset"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject offset19(ThreadContext context, IRubyObject index2) {
        return this.offsetCommon(context, this.backrefNumber(index2), true);
    }

    private IRubyObject offsetCommon(ThreadContext context, int i, boolean is_19) {
        int e;
        int b;
        this.check();
        Ruby runtime2 = context.getRuntime();
        if (i < 0 || (this.regs == null ? 1 : this.regs.numRegs) <= i) {
            throw runtime2.newIndexError("index " + i + " out of matches");
        }
        if (this.regs == null) {
            b = this.begin;
            e = this.end;
        } else {
            b = this.regs.beg[i];
            e = this.regs.end[i];
        }
        if (b < 0) {
            return runtime2.newArray(runtime2.getNil(), runtime2.getNil());
        }
        if (is_19 && !this.str.singleByteOptimizable()) {
            this.updateCharOffset();
            b = this.charOffsets.beg[i];
            e = this.charOffsets.end[i];
        }
        return runtime2.newArray((IRubyObject)RubyFixnum.newFixnum(runtime2, b), (IRubyObject)RubyFixnum.newFixnum(runtime2, e));
    }

    @JRubyMethod(name={"pre_match"})
    public IRubyObject pre_match(ThreadContext context) {
        this.check();
        if (this.begin == -1) {
            return context.getRuntime().getNil();
        }
        return this.str.makeShared(context.getRuntime(), 0, this.begin).infectBy(this);
    }

    @JRubyMethod(name={"post_match"})
    public IRubyObject post_match(ThreadContext context) {
        this.check();
        if (this.begin == -1) {
            return context.getRuntime().getNil();
        }
        return this.str.makeShared(context.getRuntime(), this.end, this.str.getByteList().length() - this.end).infectBy(this);
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        this.check();
        IRubyObject ss = RubyRegexp.last_match(this);
        if (ss.isNil()) {
            ss = RubyString.newEmptyString(this.getRuntime());
        }
        if (this.isTaint()) {
            ss.setTaint(true);
        }
        return ss;
    }

    @JRubyMethod(name={"string"})
    public IRubyObject string() {
        this.check();
        return this.str;
    }

    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (this == original) {
            return this;
        }
        if (this.getMetaClass() != original.getMetaClass()) {
            throw this.getRuntime().newTypeError("wrong argument class");
        }
        RubyMatchData origMatchData = (RubyMatchData)original;
        this.str = origMatchData.str;
        this.regs = origMatchData.regs;
        return this;
    }

    private static final class Pair
    implements Comparable {
        int bytePos;
        int charPos;

        private Pair() {
        }

        public int compareTo(Object o) {
            return this.bytePos - ((Pair)o).bytePos;
        }
    }
}

