/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyStruct;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.posix.Group;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.Passwd;
import org.jruby.ext.posix.util.Platform;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyModule(name={"Etc"})
public class RubyEtc {
    public static RubyModule createEtcModule(Ruby runtime2) {
        RubyModule etcModule = runtime2.defineModule("Etc");
        runtime2.setEtc(etcModule);
        etcModule.defineAnnotatedMethods(RubyEtc.class);
        RubyEtc.definePasswdStruct(runtime2);
        RubyEtc.defineGroupStruct(runtime2);
        return etcModule;
    }

    private static void definePasswdStruct(Ruby runtime2) {
        IRubyObject[] args2 = new IRubyObject[]{runtime2.newString("Passwd"), runtime2.newSymbol("name"), runtime2.newSymbol("passwd"), runtime2.newSymbol("uid"), runtime2.newSymbol("gid"), runtime2.newSymbol("gecos"), runtime2.newSymbol("dir"), runtime2.newSymbol("shell"), runtime2.newSymbol("change"), runtime2.newSymbol("uclass"), runtime2.newSymbol("expire")};
        runtime2.setPasswdStruct(RubyStruct.newInstance(runtime2.getStructClass(), args2, Block.NULL_BLOCK));
    }

    private static void defineGroupStruct(Ruby runtime2) {
        IRubyObject[] args2 = new IRubyObject[]{runtime2.newString("Group"), runtime2.newSymbol("name"), runtime2.newSymbol("passwd"), runtime2.newSymbol("gid"), runtime2.newSymbol("mem")};
        runtime2.setGroupStruct(RubyStruct.newInstance(runtime2.getStructClass(), args2, Block.NULL_BLOCK));
    }

    private static IRubyObject setupPasswd(Ruby runtime2, Passwd passwd2) {
        IRubyObject[] args2 = new IRubyObject[]{runtime2.newString(passwd2.getLoginName()), runtime2.newString(passwd2.getPassword()), runtime2.newFixnum(passwd2.getUID()), runtime2.newFixnum(passwd2.getGID()), runtime2.newString(passwd2.getGECOS()), runtime2.newString(passwd2.getHome()), runtime2.newString(passwd2.getShell()), runtime2.newFixnum(passwd2.getPasswdChangeTime()), runtime2.newString(passwd2.getAccessClass()), runtime2.newFixnum(passwd2.getExpire())};
        return RubyStruct.newStruct(runtime2.getPasswdStruct(), args2, Block.NULL_BLOCK);
    }

    private static IRubyObject setupGroup(Ruby runtime2, Group group2) {
        IRubyObject[] args2 = new IRubyObject[]{runtime2.newString(group2.getName()), runtime2.newString(group2.getPassword()), runtime2.newFixnum(group2.getGID()), RubyEtc.intoStringArray(runtime2, group2.getMembers())};
        return RubyStruct.newStruct(runtime2.getGroupStruct(), args2, Block.NULL_BLOCK);
    }

    private static IRubyObject intoStringArray(Ruby runtime2, String[] members2) {
        IRubyObject[] arr = new IRubyObject[members2.length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = runtime2.newString(members2[i]);
        }
        return runtime2.newArrayNoCopy(arr);
    }

    @JRubyMethod(name={"getpwuid"}, optional=1, module=true)
    public static IRubyObject getpwuid(IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = recv2.getRuntime();
        POSIX posix = runtime2.getPosix();
        try {
            int uid2 = args2.length == 0 ? posix.getuid() : RubyNumeric.fix2int(args2[0]);
            Passwd pwd = posix.getpwuid(uid2);
            if (pwd == null) {
                if (Platform.IS_WINDOWS) {
                    return recv2.getRuntime().getNil();
                }
                throw runtime2.newArgumentError("can't find user for " + uid2);
            }
            return RubyEtc.setupPasswd(runtime2, pwd);
        }
        catch (RaiseException re) {
            throw re;
        }
        catch (Exception e) {
            if (runtime2.getDebug().isTrue()) {
                runtime2.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.getpwuid is not supported by JRuby on this platform", e);
            }
            return runtime2.getNil();
        }
    }

    @JRubyMethod(name={"getpwnam"}, required=1, module=true)
    public static IRubyObject getpwnam(IRubyObject recv2, IRubyObject name2) {
        Ruby runtime2 = recv2.getRuntime();
        String nam = name2.convertToString().toString();
        try {
            Passwd pwd = runtime2.getPosix().getpwnam(nam);
            if (pwd == null) {
                if (Platform.IS_WINDOWS) {
                    return runtime2.getNil();
                }
                throw runtime2.newArgumentError("can't find user for " + nam);
            }
            return RubyEtc.setupPasswd(recv2.getRuntime(), pwd);
        }
        catch (Exception e) {
            if (runtime2.getDebug().isTrue()) {
                runtime2.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.getpwnam is not supported by JRuby on this platform", e);
            }
            return runtime2.getNil();
        }
    }

    @JRubyMethod(name={"passwd"}, module=true, frame=true)
    public static IRubyObject passwd(IRubyObject recv2, Block block) {
        Ruby runtime2 = recv2.getRuntime();
        POSIX posix = runtime2.getPosix();
        try {
            Passwd pw;
            posix.getpwent();
            if (block.isGiven()) {
                Passwd pw2;
                ThreadContext context = runtime2.getCurrentContext();
                posix.setpwent();
                while ((pw2 = posix.getpwent()) != null) {
                    block.yield(context, RubyEtc.setupPasswd(runtime2, pw2));
                }
                posix.endpwent();
            }
            if ((pw = posix.getpwent()) != null) {
                return RubyEtc.setupPasswd(runtime2, pw);
            }
            return runtime2.getNil();
        }
        catch (Exception e) {
            if (runtime2.getDebug().isTrue()) {
                runtime2.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.passwd is not supported by JRuby on this platform", e);
            }
            return runtime2.getNil();
        }
    }

    @JRubyMethod(name={"getlogin"}, module=true)
    public static IRubyObject getlogin(IRubyObject recv2) {
        Ruby runtime2 = recv2.getRuntime();
        try {
            String login = runtime2.getPosix().getlogin();
            if (login != null) {
                return runtime2.newString(login);
            }
            login = System.getenv("USER");
            if (login != null) {
                return runtime2.newString(login);
            }
            return runtime2.getNil();
        }
        catch (Exception e) {
            return runtime2.newString(System.getProperty("user.name"));
        }
    }

    @JRubyMethod(name={"endpwent"}, module=true)
    public static IRubyObject endpwent(IRubyObject recv2) {
        Ruby runtime2;
        block2: {
            runtime2 = recv2.getRuntime();
            try {
                runtime2.getPosix().endpwent();
            }
            catch (Exception e) {
                if (!runtime2.getDebug().isTrue()) break block2;
                runtime2.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.endpwent is not supported by JRuby on this platform", e);
            }
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"setpwent"}, module=true)
    public static IRubyObject setpwent(IRubyObject recv2) {
        Ruby runtime2;
        block2: {
            runtime2 = recv2.getRuntime();
            try {
                runtime2.getPosix().setpwent();
            }
            catch (Exception e) {
                if (!runtime2.getDebug().isTrue()) break block2;
                runtime2.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.setpwent is not supported by JRuby on this platform", e);
            }
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"getpwent"}, module=true)
    public static IRubyObject getpwent(IRubyObject recv2) {
        Ruby runtime2 = recv2.getRuntime();
        try {
            Passwd passwd2 = runtime2.getPosix().getpwent();
            if (passwd2 != null) {
                return RubyEtc.setupPasswd(runtime2, passwd2);
            }
            return runtime2.getNil();
        }
        catch (Exception e) {
            if (runtime2.getDebug().isTrue()) {
                runtime2.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.getpwent is not supported by JRuby on this platform", e);
            }
            return runtime2.getNil();
        }
    }

    @JRubyMethod(name={"getgrnam"}, required=1, module=true)
    public static IRubyObject getgrnam(IRubyObject recv2, IRubyObject name2) {
        Ruby runtime2 = recv2.getRuntime();
        String nam = name2.convertToString().toString();
        try {
            Group grp = runtime2.getPosix().getgrnam(nam);
            if (grp == null) {
                if (Platform.IS_WINDOWS) {
                    return runtime2.getNil();
                }
                throw runtime2.newArgumentError("can't find group for " + nam);
            }
            return RubyEtc.setupGroup(runtime2, grp);
        }
        catch (Exception e) {
            if (runtime2.getDebug().isTrue()) {
                runtime2.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.getgrnam is not supported by JRuby on this platform", e);
            }
            return runtime2.getNil();
        }
    }

    @JRubyMethod(name={"getgrgid"}, optional=1, module=true)
    public static IRubyObject getgrgid(IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = recv2.getRuntime();
        POSIX posix = runtime2.getPosix();
        try {
            int gid2 = args2.length == 0 ? posix.getgid() : RubyNumeric.fix2int(args2[0]);
            Group gr = posix.getgrgid(gid2);
            if (gr == null) {
                if (Platform.IS_WINDOWS) {
                    return runtime2.getNil();
                }
                throw runtime2.newArgumentError("can't find group for " + gid2);
            }
            return RubyEtc.setupGroup(runtime2, gr);
        }
        catch (RaiseException re) {
            throw re;
        }
        catch (Exception e) {
            if (runtime2.getDebug().isTrue()) {
                runtime2.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.getgrgid is not supported by JRuby on this platform", e);
            }
            return runtime2.getNil();
        }
    }

    @JRubyMethod(name={"endgrent"}, module=true)
    public static IRubyObject endgrent(IRubyObject recv2) {
        Ruby runtime2;
        block2: {
            runtime2 = recv2.getRuntime();
            try {
                runtime2.getPosix().endgrent();
            }
            catch (Exception e) {
                if (!runtime2.getDebug().isTrue()) break block2;
                runtime2.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.engrent is not supported by JRuby on this platform", e);
            }
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"setgrent"}, module=true)
    public static IRubyObject setgrent(IRubyObject recv2) {
        Ruby runtime2;
        block2: {
            runtime2 = recv2.getRuntime();
            try {
                runtime2.getPosix().setgrent();
            }
            catch (Exception e) {
                if (!runtime2.getDebug().isTrue()) break block2;
                runtime2.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.setgrent is not supported by JRuby on this platform", e);
            }
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"group"}, module=true, frame=true)
    public static IRubyObject group(IRubyObject recv2, Block block) {
        Ruby runtime2 = recv2.getRuntime();
        POSIX posix = runtime2.getPosix();
        try {
            Group gr;
            posix.getgrent();
            if (block.isGiven()) {
                Group gr2;
                ThreadContext context = runtime2.getCurrentContext();
                posix.setgrent();
                while ((gr2 = posix.getgrent()) != null) {
                    block.yield(context, RubyEtc.setupGroup(runtime2, gr2));
                }
                posix.endgrent();
            }
            if ((gr = posix.getgrent()) != null) {
                return RubyEtc.setupGroup(runtime2, gr);
            }
            return runtime2.getNil();
        }
        catch (Exception e) {
            if (runtime2.getDebug().isTrue()) {
                runtime2.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.group is not supported by JRuby on this platform", e);
            }
            return runtime2.getNil();
        }
    }

    @JRubyMethod(name={"getgrent"}, module=true)
    public static IRubyObject getgrent(IRubyObject recv2) {
        Ruby runtime2 = recv2.getRuntime();
        try {
            Group gr = runtime2.getPosix().getgrent();
            if (gr != null) {
                return RubyEtc.setupGroup(recv2.getRuntime(), gr);
            }
            return runtime2.getNil();
        }
        catch (Exception e) {
            if (runtime2.getDebug().isTrue()) {
                runtime2.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.getgrent is not supported by JRuby on this platform", e);
            }
            return runtime2.getNil();
        }
    }
}

