/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.SharedScopeBlock;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CompiledSharedScopeBlock
extends SharedScopeBlock {
    private CompiledBlockCallback callback;
    private boolean hasMultipleArgsHead;
    private int argumentType;

    public CompiledSharedScopeBlock(ThreadContext context, IRubyObject self, Arity arity, DynamicScope dynamicScope, CompiledBlockCallback callback, boolean hasMultipleArgsHead, int argumentType) {
        this(self, context.getCurrentFrame().duplicate(), Visibility.PUBLIC, context.getRubyClass(), dynamicScope, arity, callback, hasMultipleArgsHead, argumentType);
    }

    private CompiledSharedScopeBlock(IRubyObject self, Frame frame, Visibility visibility, RubyModule klass, DynamicScope dynamicScope, Arity arity, CompiledBlockCallback callback, boolean hasMultipleArgsHead, int argumentType) {
        super(null, self, frame, visibility, klass, dynamicScope);
        this.arity = arity;
        this.callback = callback;
        this.hasMultipleArgsHead = hasMultipleArgsHead;
        this.argumentType = argumentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject args, IRubyObject self, RubyModule klass, boolean aValue) {
        if (klass == null) {
            self = this.self;
            this.frame.setSelf(self);
        }
        Visibility oldVis = this.frame.getVisibility();
        try {
            IRubyObject[] realArgs = aValue ? this.setupBlockArgs(context, args, self) : this.setupBlockArg(context, args, self);
            this.pre(context, klass);
            try {
                IRubyObject iRubyObject = this.callback.call(context, self, realArgs);
                return iRubyObject;
            }
            catch (JumpException.BreakJump bj) {
                try {
                    if (bj.getTarget() == null) {
                        bj.setTarget(this);
                    }
                    throw bj;
                }
                catch (JumpException.NextJump nj) {
                    IRubyObject iRubyObject = this.type == Block.Type.LAMBDA ? context.getRuntime().getNil() : (IRubyObject)nj.getValue();
                    return iRubyObject;
                }
            }
        }
        finally {
            this.frame.setVisibility(oldVis);
            this.post(context);
        }
    }

    private IRubyObject[] setupBlockArgs(ThreadContext context, IRubyObject value, IRubyObject self) {
        switch (this.argumentType) {
            case 0: {
                return IRubyObject.NULL_ARRAY;
            }
            case 1: {
                return new IRubyObject[]{value};
            }
        }
        int length = this.arrayLength(value);
        switch (length) {
            case 0: {
                value = context.getRuntime().getNil();
                break;
            }
            case 1: {
                value = ((RubyArray)value).eltInternal(0);
                break;
            }
            default: {
                context.getRuntime().getWarnings().warn("multiple values for a block parameter (" + length + " for 1)");
            }
        }
        return new IRubyObject[]{value};
    }

    private IRubyObject[] setupBlockArg(ThreadContext context, IRubyObject value, IRubyObject self) {
        switch (this.argumentType) {
            case 0: {
                return IRubyObject.NULL_ARRAY;
            }
            case 1: {
                return new IRubyObject[]{ArgsUtil.convertToRubyArray(context.getRuntime(), value, this.hasMultipleArgsHead)};
            }
        }
        if (value == null) {
            context.getRuntime().getWarnings().warn("multiple values for a block parameter (0 for 1)");
            return new IRubyObject[]{context.getRuntime().getNil()};
        }
        return new IRubyObject[]{value};
    }

    @Override
    public Block cloneBlock() {
        CompiledSharedScopeBlock newBlock = new CompiledSharedScopeBlock(this.self, this.frame.duplicate(), this.visibility, this.klass, this.dynamicScope, this.arity, this.callback, this.hasMultipleArgsHead, this.argumentType);
        newBlock.type = this.type;
        return newBlock;
    }
}

