/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.CallAdapter;
import org.jruby.util.collections.WeakHashSet;

public class CacheMap {
    private final Map<DynamicMethod, Set<CallAdapter>> mappings = new WeakHashMap<DynamicMethod, Set<CallAdapter>>();

    public synchronized void add(DynamicMethod method, CallAdapter site) {
        Set<CallAdapter> siteList = this.mappings.get(method);
        if (siteList == null) {
            siteList = new WeakHashSet<CallAdapter>();
            this.mappings.put(method, siteList);
        }
        siteList.add(site);
    }

    public synchronized void remove(String name, DynamicMethod method) {
        Set<CallAdapter> siteList = this.mappings.remove(method);
        if (siteList == null) {
            return;
        }
        for (CallAdapter site : siteList) {
            if (site == null) continue;
            site.removeCachedMethod();
        }
    }

    public synchronized void moduleIncluded(RubyModule targetModule, RubyModule includedModule) {
        for (String methodName : includedModule.getMethods().keySet()) {
            for (RubyModule current = targetModule; current != null; current = current.getSuperClass()) {
                Set<CallAdapter> adapters;
                DynamicMethod method;
                if (current == includedModule || (method = (DynamicMethod)current.getMethods().get(methodName)) == null || (adapters = this.mappings.remove(method)) == null) continue;
                for (CallAdapter adapter : adapters) {
                    adapter.removeCachedMethod();
                }
            }
        }
    }
}

