/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import org.jruby.Ruby;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.builtin.IRubyObject;

public class UndefinedAccessor
implements IAccessor {
    private final Ruby runtime;
    private final GlobalVariable globalVariable;
    private final String notInitializedWarning;

    public UndefinedAccessor(Ruby runtime, GlobalVariable globalVariable, String name) {
        assert (runtime != null);
        assert (globalVariable != null);
        assert (name != null);
        this.runtime = runtime;
        this.globalVariable = globalVariable;
        this.notInitializedWarning = "global variable `" + name + "' not initialized";
    }

    @Override
    public IRubyObject getValue() {
        this.runtime.getWarnings().warning(this.notInitializedWarning);
        return this.runtime.getNil();
    }

    @Override
    public IRubyObject setValue(IRubyObject newValue) {
        assert (newValue != null);
        this.globalVariable.setAccessor(new ValueAccessor(newValue));
        return newValue;
    }
}

