/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jruby.Finalizable;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBinding;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.Node;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.callback.Callback;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.util.IdUtil;

public class RubyObject
implements Cloneable,
IRubyObject {
    public static final IRubyObject NEVER = new RubyObject();
    protected RubyClass metaClass;
    protected volatile transient VariableTableEntry[] variableTable;
    protected transient int variableTableSize;
    protected transient int variableTableThreshold;
    private transient Object dataStruct;
    protected int flags;
    public static final int ALL_F = -1;
    public static final int FALSE_F = 1;
    public static final int NIL_F = 2;
    public static final int FROZEN_F = 4;
    public static final int TAINTED_F = 8;
    public static final int FL_USHIFT = 4;
    public static final int USER0_F = 16;
    public static final int USER1_F = 32;
    public static final int USER2_F = 64;
    public static final int USER3_F = 128;
    public static final int USER4_F = 256;
    public static final int USER5_F = 512;
    public static final int USER6_F = 1024;
    public static final int USER7_F = 2048;
    private Finalizer finalizer;
    public static final ObjectAllocator OBJECT_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyObject(runtime, klass);
        }
    };
    protected static final String ERR_INSECURE_SET_INST_VAR = "Insecure: can't modify instance variable";
    protected static final int VARIABLE_TABLE_DEFAULT_CAPACITY = 8;
    protected static final int VARIABLE_TABLE_MAXIMUM_CAPACITY = 0x40000000;
    protected static final float VARIABLE_TABLE_LOAD_FACTOR = 0.75f;
    protected static final VariableTableEntry[] VARIABLE_TABLE_EMPTY_TABLE = new VariableTableEntry[0];

    private RubyObject() {
    }

    public final void setFlag(int flag, boolean set) {
        this.flags = set ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    public final boolean getFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    public RubyObject(Ruby runtime, RubyClass metaClass) {
        this(runtime, metaClass, runtime.isObjectSpaceEnabled());
    }

    protected RubyObject(Ruby runtime, RubyClass metaClass, boolean useObjectSpace) {
        this.metaClass = metaClass;
        if (useObjectSpace) {
            assert (runtime.isObjectSpaceEnabled());
            runtime.getObjectSpace().add(this);
        }
        if (runtime.getSafeLevel() >= 3) {
            this.flags |= 8;
        }
    }

    public static RubyClass createObjectClass(Ruby runtime, RubyClass objectClass) {
        objectClass.index = 14;
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyObject.class);
        objectClass.defineFastPrivateMethod("initialize", callbackFactory.getFastMethod("initialize"));
        return objectClass;
    }

    public void attachToObjectSpace() {
        this.getRuntime().getObjectSpace().add(this);
    }

    @Override
    public int getNativeTypeIndex() {
        return 14;
    }

    @Override
    public boolean isModule() {
        return false;
    }

    @Override
    public boolean isClass() {
        return false;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    public RubyClass makeMetaClass(RubyClass superClass) {
        MetaClass klass = new MetaClass(this.getRuntime(), superClass);
        this.setMetaClass(klass);
        klass.setAttached(this);
        if (this.isSingleton()) {
            klass.setMetaClass(klass);
            klass.setSuperClass(((RubyClass)this).getSuperClass().getRealClass().getMetaClass());
        } else {
            klass.setMetaClass(superClass.getRealClass().getMetaClass());
        }
        return klass;
    }

    @Override
    public Class getJavaClass() {
        return IRubyObject.class;
    }

    public static void puts(Object obj) {
        System.out.println(obj.toString());
    }

    public boolean equals(Object other) {
        return other == this || other instanceof IRubyObject && this.callMethod(this.getRuntime().getCurrentContext(), MethodIndex.EQUALEQUAL, "==", (IRubyObject)other).isTrue();
    }

    public String toString() {
        return this.callMethod(this.getRuntime().getCurrentContext(), MethodIndex.TO_S, "to_s", IRubyObject.NULL_ARRAY).toString();
    }

    @Override
    public Ruby getRuntime() {
        return this.metaClass.getRuntime();
    }

    @Override
    public final RubyClass getMetaClass() {
        return this.metaClass;
    }

    @Override
    public void setMetaClass(RubyClass metaClass) {
        this.metaClass = metaClass;
    }

    @Override
    public boolean isFrozen() {
        return (this.flags & 4) != 0;
    }

    @Override
    public void setFrozen(boolean frozen) {
        this.flags = frozen ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    protected void testFrozen(String message) {
        if (this.isFrozen()) {
            throw this.getRuntime().newFrozenError(message + this.getMetaClass().getName());
        }
    }

    protected void checkFrozen() {
        this.testFrozen("can't modify frozen ");
    }

    @Override
    public boolean isTaint() {
        return (this.flags & 8) != 0;
    }

    @Override
    public void setTaint(boolean taint) {
        this.flags = taint ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    @Override
    public final boolean isNil() {
        return (this.flags & 2) != 0;
    }

    @Override
    public final boolean isTrue() {
        return (this.flags & 1) == 0;
    }

    public final boolean isFalse() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean respondsTo(String name) {
        if (this.getMetaClass().searchMethod("respond_to?") == this.getRuntime().getRespondToMethod()) {
            return this.getMetaClass().isMethodBound(name, false);
        }
        return this.callMethod(this.getRuntime().getCurrentContext(), "respond_to?", this.getRuntime().newSymbol(name)).isTrue();
    }

    @Override
    public boolean isKindOf(RubyModule type) {
        return type.kindOf.isKindOf(this, type);
    }

    @Override
    public RubyClass getSingletonClass() {
        RubyClass klass = this.getMetaClass().isSingleton() && ((MetaClass)this.getMetaClass()).getAttached() == this ? this.getMetaClass() : this.makeMetaClass(this.getMetaClass());
        klass.setTaint(this.isTaint());
        if (this.isFrozen()) {
            klass.setFrozen(true);
        }
        return klass;
    }

    protected RubyClass getSingletonClassClone() {
        RubyClass klass = this.getMetaClass();
        if (!klass.isSingleton()) {
            return klass;
        }
        MetaClass clone = new MetaClass(this.getRuntime());
        clone.flags = this.flags;
        if (this instanceof RubyClass) {
            clone.setMetaClass(clone);
        } else {
            clone.setMetaClass(klass.getSingletonClassClone());
        }
        clone.setSuperClass(klass.getSuperClass());
        if (klass.hasVariables()) {
            clone.syncVariables(klass.getVariableList());
        }
        klass.cloneMethods(clone);
        ((MetaClass)clone.getMetaClass()).setAttached(clone);
        return clone;
    }

    private static void initCopy(IRubyObject clone, RubyObject original) {
        assert (!clone.isFrozen()) : "frozen object (" + clone.getMetaClass().getName() + ") allocated";
        original.copySpecialInstanceVariables(clone);
        if (original.hasVariables()) {
            clone.syncVariables(original.getVariableList());
        }
        clone.callMethod(clone.getRuntime().getCurrentContext(), "initialize_copy", original);
    }

    @Override
    public IRubyObject infectBy(IRubyObject obj) {
        if (obj.isTaint()) {
            this.setTaint(true);
        }
        return this;
    }

    @Override
    public IRubyObject callSuper(ThreadContext context, IRubyObject[] args, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        RubyClass superClass = RuntimeHelpers.findImplementerIfNecessary(this.getMetaClass(), klazz).getSuperClass();
        assert (superClass != null) : "Superclass should always be something for " + klazz.getBaseName();
        return this.callMethod(context, (RubyModule)superClass, context.getFrameName(), args, CallType.SUPER, block);
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, String name) {
        return this.callMethod(context, (RubyModule)this.getMetaClass(), name, IRubyObject.NULL_ARRAY, null, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, String name, IRubyObject arg) {
        return this.callMethod(context, (RubyModule)this.getMetaClass(), name, new IRubyObject[]{arg}, CallType.FUNCTIONAL, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, String name, Block block) {
        return this.callMethod(context, (RubyModule)this.getMetaClass(), name, IRubyObject.NULL_ARRAY, null, block);
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, String name, IRubyObject[] args) {
        return this.callMethod(context, (RubyModule)this.getMetaClass(), name, args, CallType.FUNCTIONAL, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, String name, IRubyObject[] args, Block block) {
        return this.callMethod(context, (RubyModule)this.getMetaClass(), name, args, CallType.FUNCTIONAL, block);
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, String name, IRubyObject[] args, CallType callType) {
        return this.callMethod(context, (RubyModule)this.getMetaClass(), name, args, callType, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, String name, IRubyObject[] args, CallType callType, Block block) {
        return this.callMethod(context, (RubyModule)this.getMetaClass(), name, args, callType, block);
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, int methodIndex, String name) {
        return this.callMethod(context, this.getMetaClass(), methodIndex, name, IRubyObject.NULL_ARRAY, null, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, int methodIndex, String name, IRubyObject arg) {
        return this.callMethod(context, this.getMetaClass(), methodIndex, name, new IRubyObject[]{arg}, CallType.FUNCTIONAL, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, int methodIndex, String name, IRubyObject[] args) {
        return this.callMethod(context, this.getMetaClass(), methodIndex, name, args, CallType.FUNCTIONAL, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, int methodIndex, String name, IRubyObject[] args, CallType callType) {
        return this.callMethod(context, this.getMetaClass(), methodIndex, name, args, callType, Block.NULL_BLOCK);
    }

    public IRubyObject callMethod(ThreadContext context, RubyModule rubyclass, int methodIndex, String name, IRubyObject[] args, CallType callType) {
        return this.callMethod(context, rubyclass, methodIndex, name, args, callType, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, RubyModule rubyclass, int methodIndex, String name, IRubyObject[] args, CallType callType, Block block) {
        if (context.getRuntime().hasEventHooks()) {
            return this.callMethod(context, rubyclass, name, args, callType, block);
        }
        return rubyclass.dispatcher.callMethod(context, this, rubyclass, methodIndex, name, args, callType, block);
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, RubyModule rubyclass, String name, IRubyObject[] args, CallType callType, Block block) {
        assert (args != null);
        DynamicMethod method = null;
        method = rubyclass.searchMethod(name);
        if (method.isUndefined() || !name.equals("method_missing") && !method.isCallableFrom(context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, this, method, name, args, context.getFrameSelf(), callType, block);
        }
        return method.call(context, this, rubyclass, name, args, block);
    }

    public void callInit(IRubyObject[] args, Block block) {
        this.callMethod(this.getRuntime().getCurrentContext(), "initialize", args, block);
    }

    @Override
    public String asSymbol() {
        throw this.getRuntime().newTypeError(this.inspect().toString() + " is not a symbol");
    }

    @Override
    public RubyArray convertToArray() {
        return (RubyArray)this.convertToType(this.getRuntime().getArray(), MethodIndex.TO_ARY, "to_ary");
    }

    @Override
    public RubyHash convertToHash() {
        return (RubyHash)this.convertToType(this.getRuntime().getHash(), MethodIndex.TO_HASH, "to_hash");
    }

    @Override
    public RubyFloat convertToFloat() {
        return (RubyFloat)this.convertToType(this.getRuntime().getFloat(), MethodIndex.TO_F, "to_f");
    }

    @Override
    public RubyInteger convertToInteger() {
        return this.convertToInteger(MethodIndex.TO_INT, "to_int");
    }

    @Override
    public RubyInteger convertToInteger(int convertMethodIndex, String convertMethod) {
        IRubyObject val = this.convertToType(this.getRuntime().getInteger(), convertMethodIndex, convertMethod, true);
        if (!(val instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(this.getMetaClass().getName() + "#" + convertMethod + " should return Integer");
        }
        return (RubyInteger)val;
    }

    @Override
    public RubyString convertToString() {
        return (RubyString)this.convertToType(this.getRuntime().getString(), MethodIndex.TO_STR, "to_str");
    }

    @Override
    public final IRubyObject convertToType(RubyClass target, int convertMethodIndex, String convertMethod, boolean raise) {
        if (!this.respondsTo(convertMethod)) {
            if (raise) {
                String type = this.isNil() ? "nil" : (this instanceof RubyBoolean ? (this.isTrue() ? "true" : "false") : target.getName());
                throw this.getRuntime().newTypeError("can't convert " + this.getMetaClass().getName() + " into " + type);
            }
            return this.getRuntime().getNil();
        }
        return this.callMethod(this.getRuntime().getCurrentContext(), convertMethodIndex, convertMethod);
    }

    public final IRubyObject convertToType(RubyClass target, int convertMethodIndex) {
        return this.convertToType(target, convertMethodIndex, MethodIndex.NAMES.get(convertMethodIndex));
    }

    @Override
    public final IRubyObject convertToType(RubyClass target, int convertMethodIndex, String convertMethod) {
        if (this.isKindOf(target)) {
            return this;
        }
        IRubyObject val = this.convertToType(target, convertMethodIndex, convertMethod, true);
        if (!val.isKindOf(target)) {
            throw this.getRuntime().newTypeError(this.getMetaClass() + "#" + convertMethod + " should return " + target.getName());
        }
        return val;
    }

    @Override
    public final IRubyObject convertToTypeWithCheck(RubyClass target, int convertMethodIndex, String convertMethod) {
        if (this.isKindOf(target)) {
            return this;
        }
        IRubyObject val = this.convertToType(target, convertMethodIndex, convertMethod, false);
        if (val.isNil()) {
            return val;
        }
        if (!val.isKindOf(target)) {
            throw this.getRuntime().newTypeError(this.getMetaClass() + "#" + convertMethod + " should return " + target.getName());
        }
        return val;
    }

    @Override
    public RubyString asString() {
        IRubyObject str = this.callMethod(this.getRuntime().getCurrentContext(), MethodIndex.TO_S, "to_s", IRubyObject.NULL_ARRAY);
        if (!(str instanceof RubyString)) {
            return (RubyString)this.anyToString();
        }
        if (this.isTaint()) {
            str.setTaint(true);
        }
        return (RubyString)str;
    }

    @Override
    public IRubyObject checkStringType() {
        IRubyObject str = this.convertToTypeWithCheck(this.getRuntime().getString(), MethodIndex.TO_STR, "to_str");
        if (!str.isNil() && !(str instanceof RubyString)) {
            str = this.getRuntime().newString("");
        }
        return str;
    }

    @Override
    public IRubyObject checkArrayType() {
        return this.convertToTypeWithCheck(this.getRuntime().getArray(), MethodIndex.TO_ARY, "to_ary");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject specificEval(RubyModule mod, IRubyObject[] args, Block block) {
        if (block.isGiven()) {
            if (args.length > 0) {
                throw this.getRuntime().newArgumentError(args.length, 0);
            }
            return this.yieldUnder(mod, new IRubyObject[]{this}, block);
        }
        ThreadContext tc = this.getRuntime().getCurrentContext();
        if (args.length == 0) {
            throw this.getRuntime().newArgumentError("block not supplied");
        }
        if (args.length > 3) {
            String lastFuncName = tc.getFrameName();
            throw this.getRuntime().newArgumentError("wrong # of arguments: " + lastFuncName + "(src) or " + lastFuncName + "{..}");
        }
        args[0].convertToString();
        IRubyObject file = args.length > 1 ? args[1] : this.getRuntime().newString("(eval)");
        IRubyObject line = args.length > 2 ? args[2] : RubyFixnum.one(this.getRuntime());
        Visibility savedVisibility = tc.getCurrentVisibility();
        tc.setCurrentVisibility(Visibility.PUBLIC);
        try {
            IRubyObject iRubyObject = this.evalUnder(mod, args[0], file, line);
            return iRubyObject;
        }
        finally {
            tc.setCurrentVisibility(savedVisibility);
        }
    }

    public IRubyObject evalUnder(RubyModule under, IRubyObject src, IRubyObject file, IRubyObject line) {
        return under.executeUnder(new Callback(){

            @Override
            public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
                IRubyObject source = args[1];
                IRubyObject filename = args[2];
                return args[0].evalSimple(source.getRuntime().getCurrentContext(), source, filename.convertToString().toString());
            }

            @Override
            public Arity getArity() {
                return Arity.optional();
            }
        }, new IRubyObject[]{this, src, file, line}, Block.NULL_BLOCK);
    }

    private IRubyObject yieldUnder(RubyModule under, IRubyObject[] args, Block block) {
        return under.executeUnder(new Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
                ThreadContext context = RubyObject.this.getRuntime().getCurrentContext();
                Visibility savedVisibility = block.getVisibility();
                block.setVisibility(Visibility.PUBLIC);
                try {
                    boolean aValue;
                    IRubyObject valueInYield;
                    if (args.length == 1) {
                        valueInYield = args[0];
                        aValue = false;
                    } else {
                        valueInYield = RubyArray.newArray(RubyObject.this.getRuntime(), args);
                        aValue = true;
                    }
                    block = block.cloneBlock();
                    block.setSelf(RubyObject.this);
                    block.getFrame().setSelf(RubyObject.this);
                    IRubyObject iRubyObject = block.yield(context, valueInYield, RubyObject.this, context.getRubyClass(), aValue);
                    return iRubyObject;
                }
                catch (JumpException.BreakJump bj) {
                    IRubyObject iRubyObject = (IRubyObject)bj.getValue();
                    return iRubyObject;
                }
                finally {
                    block.setVisibility(savedVisibility);
                }
            }

            @Override
            public Arity getArity() {
                return Arity.optional();
            }
        }, args, block);
    }

    @Override
    public IRubyObject evalWithBinding(ThreadContext context, IRubyObject src, IRubyObject scope, String file, int lineNumber) {
        assert (!scope.isNil());
        assert (file != null);
        ISourcePosition savedPosition = context.getPosition();
        if (!(scope instanceof RubyBinding)) {
            if (scope instanceof RubyProc) {
                scope = ((RubyProc)scope).binding();
            } else {
                throw this.getRuntime().newTypeError("wrong argument type " + scope.getMetaClass() + " (expected Proc/Binding)");
            }
        }
        Block blockOfBinding = ((RubyBinding)scope).getBlock();
        blockOfBinding.getDynamicScope().getStaticScope().determineModule();
        try {
            context.preEvalWithBinding(blockOfBinding);
            IRubyObject newSelf = context.getFrameSelf();
            RubyString source = src.convertToString();
            Node node = this.getRuntime().parseEval(source.getByteList(), file, blockOfBinding.getDynamicScope(), lineNumber);
            IRubyObject iRubyObject = ASTInterpreter.eval(this.getRuntime(), context, node, newSelf, blockOfBinding);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            throw this.getRuntime().newLocalJumpError("break", (IRubyObject)bj.getValue(), "unexpected break");
        }
        catch (JumpException.RedoJump rj) {
            throw this.getRuntime().newLocalJumpError("redo", (IRubyObject)rj.getValue(), "unexpected redo");
        }
        finally {
            context.postEvalWithBinding(blockOfBinding);
            context.setPosition(savedPosition);
        }
    }

    @Override
    public IRubyObject evalSimple(ThreadContext context, IRubyObject src, String file) {
        assert (file != null);
        ISourcePosition savedPosition = context.getPosition();
        RubyString source = src.convertToString();
        try {
            Node node = this.getRuntime().parseEval(source.getByteList(), file, context.getCurrentScope(), 0);
            IRubyObject iRubyObject = ASTInterpreter.eval(this.getRuntime(), context, node, this, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            throw this.getRuntime().newLocalJumpError("break", (IRubyObject)bj.getValue(), "unexpected break");
        }
        finally {
            context.setPosition(savedPosition);
        }
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(IRubyObject obj) {
        return this == obj ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"equal?"}, required=1)
    public IRubyObject equal_p(IRubyObject obj) {
        return this == obj ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(IRubyObject obj) {
        return this == obj ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"==="}, required=1)
    public IRubyObject op_eqq(IRubyObject other) {
        if (this == other || this.callMethod(this.getRuntime().getCurrentContext(), MethodIndex.EQUALEQUAL, "==", other).isTrue()) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    protected static IRubyObject equalInternal(ThreadContext context, IRubyObject that, IRubyObject other) {
        if (that == other) {
            return that.getRuntime().getTrue();
        }
        return that.callMethod(context, MethodIndex.EQUALEQUAL, "==", other);
    }

    @Override
    public boolean eql(IRubyObject other) {
        return this.callMethod(this.getRuntime().getCurrentContext(), MethodIndex.EQL_P, "eql?", other).isTrue();
    }

    protected static boolean eqlInternal(ThreadContext context, IRubyObject that, IRubyObject other) {
        if (that == other) {
            return true;
        }
        return that.callMethod(context, MethodIndex.EQL_P, "eql?", other).isTrue();
    }

    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (this == original) {
            return this;
        }
        this.checkFrozen();
        if (this.getMetaClass().getRealClass() != original.getMetaClass().getRealClass()) {
            throw this.getRuntime().newTypeError("initialize_copy should take same class object");
        }
        return this;
    }

    @JRubyMethod(name={"respond_to?"}, rest=true)
    public RubyBoolean respond_to_p(IRubyObject[] args) {
        Arity.checkArgumentCount(this.getRuntime(), args, 1, 2);
        String name = args[0].asSymbol();
        boolean includePrivate = args.length > 1 ? args[1].isTrue() : false;
        return this.getRuntime().newBoolean(this.getMetaClass().isMethodBound(name, !includePrivate));
    }

    @Override
    @JRubyMethod(name={"object_id", "__id__"})
    public synchronized IRubyObject id() {
        return this.getRuntime().newFixnum(this.getRuntime().getObjectSpace().idOf(this));
    }

    @JRubyMethod(name={"id"})
    public synchronized IRubyObject id_deprecated() {
        this.getRuntime().getWarnings().warn("Object#id will be deprecated; use Object#object_id");
        return this.id();
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(super.hashCode());
    }

    public int hashCode() {
        IRubyObject hashValue = this.callMethod(this.getRuntime().getCurrentContext(), MethodIndex.HASH, "hash");
        if (hashValue instanceof RubyFixnum) {
            return (int)RubyNumeric.fix2long(hashValue);
        }
        return super.hashCode();
    }

    @JRubyMethod(name={"class"})
    public RubyClass type() {
        return this.getMetaClass().getRealClass();
    }

    @JRubyMethod(name={"type"})
    public RubyClass type_deprecated() {
        this.getRuntime().getWarnings().warn("Object#type is deprecated; use Object#class");
        return this.type();
    }

    @Override
    @JRubyMethod(name={"clone"}, frame=true)
    public IRubyObject rbClone() {
        if (this.isImmediate()) {
            throw this.getRuntime().newTypeError("can't clone " + this.getMetaClass().getName());
        }
        IRubyObject clone = this.getMetaClass().getRealClass().allocate();
        clone.setMetaClass(this.getSingletonClassClone());
        if (this.isTaint()) {
            clone.setTaint(true);
        }
        RubyObject.initCopy(clone, this);
        if (this.isFrozen()) {
            clone.setFrozen(true);
        }
        return clone;
    }

    @Override
    @JRubyMethod(name={"dup"})
    public IRubyObject dup() {
        if (this.isImmediate()) {
            throw this.getRuntime().newTypeError("can't dup " + this.getMetaClass().getName());
        }
        IRubyObject dup = this.getMetaClass().getRealClass().allocate();
        if (this.isTaint()) {
            dup.setTaint(true);
        }
        RubyObject.initCopy(dup, this);
        return dup;
    }

    protected void copySpecialInstanceVariables(IRubyObject clone) {
    }

    @JRubyMethod(name={"display"}, optional=1)
    public IRubyObject display(IRubyObject[] args) {
        IRubyObject port = args.length == 0 ? this.getRuntime().getGlobalVariables().get("$>") : args[0];
        port.callMethod(this.getRuntime().getCurrentContext(), "write", this);
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"tainted?"})
    public RubyBoolean tainted_p() {
        return this.getRuntime().newBoolean(this.isTaint());
    }

    @JRubyMethod(name={"taint"})
    public IRubyObject taint() {
        this.getRuntime().secure(4);
        if (!this.isTaint()) {
            this.testFrozen("object");
            this.setTaint(true);
        }
        return this;
    }

    @JRubyMethod(name={"untaint"})
    public IRubyObject untaint() {
        this.getRuntime().secure(3);
        if (this.isTaint()) {
            this.testFrozen("object");
            this.setTaint(false);
        }
        return this;
    }

    @JRubyMethod(name={"freeze"})
    public IRubyObject freeze() {
        if (this.getRuntime().getSafeLevel() >= 4 && this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't freeze object");
        }
        this.setFrozen(true);
        return this;
    }

    @JRubyMethod(name={"frozen?"})
    public RubyBoolean frozen_p() {
        return this.getRuntime().newBoolean(this.isFrozen());
    }

    private StringBuffer inspectObj(StringBuffer part) {
        String sep = "";
        for (Variable<IRubyObject> ivar : this.getInstanceVariableList()) {
            part.append(sep);
            part.append(" ");
            part.append(ivar.getName());
            part.append("=");
            part.append(ivar.getValue().callMethod(this.getRuntime().getCurrentContext(), "inspect"));
            sep = ",";
        }
        part.append(">");
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        Ruby runtime = this.getRuntime();
        if (!this.isImmediate() && !(this instanceof RubyClass) && this != runtime.getObject() && this != runtime.getModule() && !(this instanceof RubyModule) && this.hasVariables()) {
            StringBuffer part = new StringBuffer();
            String cname = this.getMetaClass().getRealClass().getName();
            part.append("#<").append(cname).append(":0x");
            part.append(Integer.toHexString(System.identityHashCode(this)));
            if (runtime.isInspecting(this)) {
                part.append(" ...>");
                return runtime.newString(part.toString());
            }
            try {
                runtime.registerInspecting(this);
                RubyString rubyString = runtime.newString(this.inspectObj(part).toString());
                return rubyString;
            }
            finally {
                runtime.unregisterInspecting(this);
            }
        }
        if (this.isNil()) {
            return RubyNil.inspect(this);
        }
        return this.callMethod(runtime.getCurrentContext(), MethodIndex.TO_S, "to_s", IRubyObject.NULL_ARRAY);
    }

    @JRubyMethod(name={"instance_of?"}, required=1)
    public RubyBoolean instance_of_p(IRubyObject type) {
        return this.getRuntime().newBoolean(this.type() == type);
    }

    @JRubyMethod(name={"kind_of?", "is_a?"}, required=1)
    public RubyBoolean kind_of_p(IRubyObject type) {
        if (!(type instanceof RubyModule)) {
            throw this.getRuntime().newTypeError(type, this.getRuntime().getModule());
        }
        return this.getRuntime().newBoolean(this.isKindOf((RubyModule)type));
    }

    @JRubyMethod(name={"methods"}, optional=1)
    public IRubyObject methods(IRubyObject[] args) {
        Arity.checkArgumentCount(this.getRuntime(), args, 0, 1);
        if (args.length == 0) {
            args = new IRubyObject[]{this.getRuntime().getTrue()};
        }
        return this.getMetaClass().instance_methods(args);
    }

    @JRubyMethod(name={"public_methods"}, optional=1)
    public IRubyObject public_methods(IRubyObject[] args) {
        Arity.checkArgumentCount(this.getRuntime(), args, 0, 1);
        if (args.length == 0) {
            args = new IRubyObject[]{this.getRuntime().getTrue()};
        }
        return this.getMetaClass().public_instance_methods(args);
    }

    @JRubyMethod(name={"protected_methods"}, optional=1)
    public IRubyObject protected_methods(IRubyObject[] args) {
        Arity.checkArgumentCount(this.getRuntime(), args, 0, 1);
        if (args.length == 0) {
            args = new IRubyObject[]{this.getRuntime().getTrue()};
        }
        return this.getMetaClass().protected_instance_methods(args);
    }

    @JRubyMethod(name={"private_methods"}, optional=1)
    public IRubyObject private_methods(IRubyObject[] args) {
        Arity.checkArgumentCount(this.getRuntime(), args, 0, 1);
        if (args.length == 0) {
            args = new IRubyObject[]{this.getRuntime().getTrue()};
        }
        return this.getMetaClass().private_instance_methods(args);
    }

    @JRubyMethod(name={"singleton_methods"}, optional=1)
    public RubyArray singleton_methods(IRubyObject[] args) {
        boolean all = true;
        if (Arity.checkArgumentCount(this.getRuntime(), args, 0, 1) == 1) {
            all = args[0].isTrue();
        }
        RubyArray result = this.getRuntime().newArray();
        for (RubyClass type = this.getMetaClass(); type != null && (type instanceof MetaClass || all && type.isIncluded()); type = type.getSuperClass()) {
            for (Map.Entry entry : type.getMethods().entrySet()) {
                DynamicMethod method = (DynamicMethod)entry.getValue();
                if (method.getImplementationClass() != type && (!all || !type.isIncluded())) continue;
                RubyString methodName = this.getRuntime().newString((String)entry.getKey());
                if (method.getVisibility() != Visibility.PUBLIC || result.includes(methodName)) continue;
                result.append(methodName);
            }
        }
        return result;
    }

    @JRubyMethod(name={"method"}, required=1)
    public IRubyObject method(IRubyObject symbol) {
        return this.getMetaClass().newMethod(this, symbol.asSymbol(), true);
    }

    @Override
    public IRubyObject anyToString() {
        String cname = this.getMetaClass().getRealClass().getName();
        RubyString str = this.getRuntime().newString("#<" + cname + ":0x" + Integer.toHexString(System.identityHashCode(this)) + ">");
        str.setTaint(this.isTaint());
        return str;
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        return this.anyToString();
    }

    @JRubyMethod(name={"to_a"}, visibility=Visibility.PUBLIC)
    public RubyArray to_a() {
        this.getRuntime().getWarnings().warn("default 'to_a' will be obsolete");
        return this.getRuntime().newArray(this);
    }

    @JRubyMethod(name={"instance_eval"}, optional=3, frame=true)
    public IRubyObject instance_eval(IRubyObject[] args, Block block) {
        RubyModule klazz;
        if (this.isImmediate()) {
            klazz = this.getRuntime().getCurrentContext().getPreviousFrame().getKlazz();
            if (klazz == null) {
                klazz = this.getRuntime().getObject();
            }
        } else {
            klazz = this.getSingletonClass();
        }
        return this.specificEval(klazz, args, block);
    }

    @JRubyMethod(name={"instance_exec"}, optional=3, frame=true)
    public IRubyObject instance_exec(IRubyObject[] args, Block block) {
        RubyModule klazz;
        if (!block.isGiven()) {
            throw this.getRuntime().newArgumentError("block not supplied");
        }
        if (this.isImmediate()) {
            klazz = this.getRuntime().getCurrentContext().getPreviousFrame().getKlazz();
            if (klazz == null) {
                klazz = this.getRuntime().getObject();
            }
        } else {
            klazz = this.getSingletonClass();
        }
        return this.yieldUnder(klazz, args, block);
    }

    @JRubyMethod(name={"extend"}, required=1, rest=true)
    public IRubyObject extend(IRubyObject[] args) {
        int i;
        Arity.checkArgumentCount(this.getRuntime(), args, 1, -1);
        for (i = 0; i < args.length; ++i) {
            if (args[i].isModule()) continue;
            throw this.getRuntime().newTypeError(args[i], this.getRuntime().getModule());
        }
        for (i = 0; i < args.length; ++i) {
            args[i].callMethod(this.getRuntime().getCurrentContext(), "extend_object", this);
            args[i].callMethod(this.getRuntime().getCurrentContext(), "extended", this);
        }
        return this;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"send", "__send__"}, required=1, rest=true)
    public IRubyObject send(IRubyObject[] args, Block block) {
        if (args.length < 1) {
            throw this.getRuntime().newArgumentError("no method name given");
        }
        String name = args[0].asSymbol();
        IRubyObject[] newArgs = new IRubyObject[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
        ThreadContext context = this.getRuntime().getCurrentContext();
        assert (args != null);
        DynamicMethod method = null;
        RubyClass rubyClass = this.getMetaClass();
        method = rubyClass.searchMethod(name);
        if (method.isUndefined()) {
            return RuntimeHelpers.callMethodMissing(context, this, method, name, newArgs, context.getFrameSelf(), CallType.FUNCTIONAL, block);
        }
        return method.call(context, this, rubyClass, name, newArgs, block);
    }

    @JRubyMethod(name={"nil?"})
    public IRubyObject nil_p() {
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"=~"}, required=1)
    public IRubyObject op_match(IRubyObject arg) {
        return this.getRuntime().getFalse();
    }

    @Override
    public RubyClass getType() {
        return this.type();
    }

    @Override
    public synchronized void dataWrapStruct(Object obj) {
        this.dataStruct = obj;
    }

    @Override
    public synchronized Object dataGetStruct() {
        return this.dataStruct;
    }

    @Override
    public void addFinalizer(RubyProc finalizer) {
        if (this.finalizer == null) {
            this.finalizer = new Finalizer(this.getRuntime().getObjectSpace().idOf(this));
            this.getRuntime().addFinalizer(this.finalizer);
        }
        this.finalizer.addFinalizer(finalizer);
    }

    @Override
    public void removeFinalizers() {
        if (this.finalizer != null) {
            this.finalizer.removeFinalizers();
            this.finalizer = null;
            this.getRuntime().removeFinalizer(this.finalizer);
        }
    }

    @JRubyMethod(name={"instance_variable_defined?"}, required=1)
    public IRubyObject instance_variable_defined_p(IRubyObject name) {
        if (this.variableTableFastContains(this.validateInstanceVariable(name.asSymbol()))) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"instance_variable_get"}, required=1)
    public IRubyObject instance_variable_get(IRubyObject name) {
        IRubyObject value = this.variableTableFastFetch(this.validateInstanceVariable(name.asSymbol()));
        if (value != null) {
            return value;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"instance_variable_set"}, required=2)
    public IRubyObject instance_variable_set(IRubyObject name, IRubyObject value) {
        this.ensureInstanceVariablesSettable();
        return this.variableTableFastStore(this.validateInstanceVariable(name.asSymbol()), value);
    }

    @JRubyMethod(name={"remove_instance_variable"}, required=1, frame=true)
    public IRubyObject remove_instance_variable(IRubyObject name, Block block) {
        this.ensureInstanceVariablesSettable();
        IRubyObject value = this.variableTableRemove(this.validateInstanceVariable(name.asSymbol()));
        if (value != null) {
            return value;
        }
        throw this.getRuntime().newNameError("instance variable " + name.asSymbol() + " not defined", name.asSymbol());
    }

    @JRubyMethod(name={"instance_variables"})
    public RubyArray instance_variables() {
        Ruby runtime = this.getRuntime();
        List<String> nameList = this.getInstanceVariableNameList();
        RubyArray array = runtime.newArray(nameList.size());
        for (String name : nameList) {
            array.append(runtime.newString(name));
        }
        return array;
    }

    @Override
    public boolean hasInstanceVariable(String name) {
        assert (IdUtil.isInstanceVariable(name));
        return this.variableTableContains(name);
    }

    @Override
    public boolean fastHasInstanceVariable(String internedName) {
        assert (IdUtil.isInstanceVariable(internedName));
        return this.variableTableFastContains(internedName);
    }

    @Override
    public IRubyObject getInstanceVariable(String name) {
        assert (IdUtil.isInstanceVariable(name));
        return this.variableTableFetch(name);
    }

    @Override
    public IRubyObject fastGetInstanceVariable(String internedName) {
        assert (IdUtil.isInstanceVariable(internedName));
        return this.variableTableFastFetch(internedName);
    }

    @Override
    public IRubyObject setInstanceVariable(String name, IRubyObject value) {
        assert (IdUtil.isInstanceVariable(name) && value != null);
        this.ensureInstanceVariablesSettable();
        return this.variableTableStore(name, value);
    }

    @Override
    public IRubyObject fastSetInstanceVariable(String internedName, IRubyObject value) {
        assert (IdUtil.isInstanceVariable(internedName) && value != null);
        this.ensureInstanceVariablesSettable();
        return this.variableTableFastStore(internedName, value);
    }

    @Override
    public IRubyObject removeInstanceVariable(String name) {
        assert (IdUtil.isInstanceVariable(name));
        this.ensureInstanceVariablesSettable();
        return this.variableTableRemove(name);
    }

    @Override
    public List<Variable<IRubyObject>> getInstanceVariableList() {
        VariableTableEntry[] table = this.variableTableGetTable();
        ArrayList<Variable<IRubyObject>> list = new ArrayList<Variable<IRubyObject>>();
        int n = table.length;
        while (--n >= 0) {
            VariableTableEntry i = table[n];
            while (i != null) {
                if (IdUtil.isInstanceVariable(i.name)) {
                    IRubyObject e = i.value;
                    if (e == null) {
                        e = this.variableTableReadLocked(i);
                    }
                    list.add(new VariableEntry<IRubyObject>(i.name, e));
                }
                i = i.next;
            }
        }
        return list;
    }

    @Override
    public List<String> getInstanceVariableNameList() {
        VariableTableEntry[] table = this.variableTableGetTable();
        ArrayList<String> list = new ArrayList<String>();
        int i = table.length;
        while (--i >= 0) {
            VariableTableEntry e = table[i];
            while (e != null) {
                if (IdUtil.isInstanceVariable(e.name)) {
                    list.add(e.name);
                }
                e = e.next;
            }
        }
        return list;
    }

    protected String validateInstanceVariable(String name) {
        if (IdUtil.isValidInstanceVariableName(name)) {
            return name;
        }
        throw this.getRuntime().newNameError("`" + name + "' is not allowable as an instance variable name", name);
    }

    protected void ensureInstanceVariablesSettable() {
        if (!this.isFrozen() && (this.getRuntime().getSafeLevel() < 4 || this.isTaint())) {
            return;
        }
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError(ERR_INSECURE_SET_INST_VAR);
        }
        if (this.isFrozen()) {
            if (this instanceof RubyModule) {
                throw this.getRuntime().newFrozenError("class/module ");
            }
            throw this.getRuntime().newFrozenError("");
        }
    }

    @Override
    public boolean hasInternalVariable(String name) {
        assert (!RubyObject.isRubyVariable(name));
        return this.variableTableContains(name);
    }

    @Override
    public boolean fastHasInternalVariable(String internedName) {
        assert (!RubyObject.isRubyVariable(internedName));
        return this.variableTableFastContains(internedName);
    }

    @Override
    public IRubyObject getInternalVariable(String name) {
        assert (!RubyObject.isRubyVariable(name));
        return this.variableTableFetch(name);
    }

    @Override
    public IRubyObject fastGetInternalVariable(String internedName) {
        assert (!RubyObject.isRubyVariable(internedName));
        return this.variableTableFastFetch(internedName);
    }

    @Override
    public void setInternalVariable(String name, IRubyObject value) {
        assert (!RubyObject.isRubyVariable(name));
        this.variableTableStore(name, value);
    }

    @Override
    public void fastSetInternalVariable(String internedName, IRubyObject value) {
        assert (!RubyObject.isRubyVariable(internedName));
        this.variableTableFastStore(internedName, value);
    }

    @Override
    public IRubyObject removeInternalVariable(String name) {
        assert (!RubyObject.isRubyVariable(name));
        return this.variableTableRemove(name);
    }

    @Override
    public void syncVariables(List<Variable<IRubyObject>> variables) {
        this.variableTableSync(variables);
    }

    @Override
    public List<Variable<IRubyObject>> getInternalVariableList() {
        VariableTableEntry[] table = this.variableTableGetTable();
        ArrayList<Variable<IRubyObject>> list = new ArrayList<Variable<IRubyObject>>();
        int n = table.length;
        while (--n >= 0) {
            VariableTableEntry i = table[n];
            while (i != null) {
                if (!RubyObject.isRubyVariable(i.name)) {
                    IRubyObject e = i.value;
                    if (e == null) {
                        e = this.variableTableReadLocked(i);
                    }
                    list.add(new VariableEntry<IRubyObject>(i.name, e));
                }
                i = i.next;
            }
        }
        return list;
    }

    @Override
    public boolean hasVariables() {
        return this.variableTableGetSize() > 0;
    }

    @Override
    public int getVariableCount() {
        return this.variableTableGetSize();
    }

    @Override
    public List<Variable<IRubyObject>> getVariableList() {
        VariableTableEntry[] table = this.variableTableGetTable();
        ArrayList<Variable<IRubyObject>> list = new ArrayList<Variable<IRubyObject>>();
        int n = table.length;
        while (--n >= 0) {
            VariableTableEntry i = table[n];
            while (i != null) {
                IRubyObject e = i.value;
                if (e == null) {
                    e = this.variableTableReadLocked(i);
                }
                list.add(new VariableEntry<IRubyObject>(i.name, e));
                i = i.next;
            }
        }
        return list;
    }

    @Override
    public List<String> getVariableNameList() {
        VariableTableEntry[] table = this.variableTableGetTable();
        ArrayList<String> list = new ArrayList<String>();
        int i = table.length;
        while (--i >= 0) {
            VariableTableEntry e = table[i];
            while (e != null) {
                list.add(e.name);
                e = e.next;
            }
        }
        return list;
    }

    @Override
    @Deprecated
    public Map getVariableMap() {
        return this.variableTableGetMap();
    }

    protected static final boolean isRubyVariable(String name) {
        char c;
        return name.length() > 0 && ((c = name.charAt(0)) == '@' || c <= 'Z' && c >= 'A');
    }

    protected synchronized IRubyObject variableTableReadLocked(VariableTableEntry entry) {
        return entry.value;
    }

    protected boolean variableTableContains(String name) {
        VariableTableEntry[] table = this.variableTable;
        if (this.variableTable != null) {
            int hash = name.hashCode();
            VariableTableEntry e = table[hash & table.length - 1];
            while (e != null) {
                if (hash == e.hash && name.equals(e.name)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    protected boolean variableTableFastContains(String internedName) {
        VariableTableEntry[] table = this.variableTable;
        if (this.variableTable != null) {
            VariableTableEntry e = table[internedName.hashCode() & table.length - 1];
            while (e != null) {
                if (internedName == e.name) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    protected IRubyObject variableTableFetch(String name) {
        VariableTableEntry[] table = this.variableTable;
        if (this.variableTable != null) {
            int n = name.hashCode();
            VariableTableEntry hash = table[n & table.length - 1];
            while (hash != null) {
                if (n == hash.hash && name.equals(hash.name)) {
                    IRubyObject e = hash.value;
                    if (e != null) {
                        return e;
                    }
                    return this.variableTableReadLocked(hash);
                }
                hash = hash.next;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected IRubyObject variableTableFastFetch(String internedName) {
        VariableTableEntry[] table = this.variableTable;
        if (this.variableTable != null) {
            VariableTableEntry variableTableEntry = table[internedName.hashCode() & table.length - 1];
            while (variableTableEntry != null) {
                if (internedName == variableTableEntry.name) {
                    void readValue;
                    IRubyObject e = variableTableEntry.value;
                    if (e != null) {
                        return e;
                    }
                    return this.variableTableReadLocked((VariableTableEntry)readValue);
                }
                variableTableEntry = variableTableEntry.next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject variableTableStore(String name, IRubyObject value) {
        int hash = name.hashCode();
        RubyObject rubyObject = this;
        synchronized (rubyObject) {
            VariableTableEntry[] table = this.variableTable;
            if (this.variableTable == null) {
                VariableTableEntry e;
                table = new VariableTableEntry[8];
                table[hash & 7] = e = new VariableTableEntry(hash, name.intern(), value, null);
                this.variableTableThreshold = 6;
                this.variableTableSize = 1;
                this.variableTable = table;
                return value;
            }
            int potentialNewSize = this.variableTableSize + 1;
            if (potentialNewSize > this.variableTableThreshold) {
                table = this.variableTableRehash();
            }
            int index = hash & table.length - 1;
            VariableTableEntry e = table[index];
            while (e != null) {
                if (hash == e.hash && name.equals(e.name)) {
                    e.value = value;
                    return value;
                }
                e = e.next;
            }
            table[index] = e = new VariableTableEntry(hash, name.intern(), value, table[index]);
            this.variableTableSize = potentialNewSize;
            this.variableTable = table;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject variableTableFastStore(String internedName, IRubyObject value) {
        assert (internedName == internedName.intern()) : internedName + " not interned";
        int hash = internedName.hashCode();
        RubyObject rubyObject = this;
        synchronized (rubyObject) {
            VariableTableEntry[] table = this.variableTable;
            if (this.variableTable == null) {
                VariableTableEntry e;
                table = new VariableTableEntry[8];
                table[hash & 7] = e = new VariableTableEntry(hash, internedName, value, null);
                this.variableTableThreshold = 6;
                this.variableTableSize = 1;
                this.variableTable = table;
                return value;
            }
            int potentialNewSize = this.variableTableSize + 1;
            if (potentialNewSize > this.variableTableThreshold) {
                table = this.variableTableRehash();
            }
            int index = hash & table.length - 1;
            VariableTableEntry e = table[index];
            while (e != null) {
                if (internedName == e.name) {
                    e.value = value;
                    return value;
                }
                e = e.next;
            }
            table[index] = e = new VariableTableEntry(hash, internedName, value, table[index]);
            this.variableTableSize = potentialNewSize;
            this.variableTable = table;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject variableTableRemove(String name) {
        RubyObject rubyObject = this;
        synchronized (rubyObject) {
            VariableTableEntry[] table = this.variableTable;
            if (this.variableTable != null) {
                VariableTableEntry first;
                int hash = name.hashCode();
                int index = hash & table.length - 1;
                VariableTableEntry e = first = table[index];
                while (e != null) {
                    if (hash == e.hash && name.equals(e.name)) {
                        IRubyObject oldValue = e.value;
                        VariableTableEntry newFirst = e.next;
                        VariableTableEntry p = first;
                        while (p != e) {
                            newFirst = new VariableTableEntry(p.hash, p.name, p.value, newFirst);
                            p = p.next;
                        }
                        table[index] = newFirst;
                        --this.variableTableSize;
                        this.variableTable = table;
                        return oldValue;
                    }
                    e = e.next;
                }
            }
        }
        return null;
    }

    protected VariableTableEntry[] variableTableGetTable() {
        VariableTableEntry[] table = this.variableTable;
        if (this.variableTable != null) {
            return table;
        }
        return VARIABLE_TABLE_EMPTY_TABLE;
    }

    protected int variableTableGetSize() {
        if (this.variableTable != null) {
            return this.variableTableSize;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void variableTableSync(List<Variable<IRubyObject>> vars) {
        RubyObject rubyObject = this;
        synchronized (rubyObject) {
            this.variableTableSize = 0;
            this.variableTableThreshold = 6;
            this.variableTable = new VariableTableEntry[8];
            for (Variable<IRubyObject> var : vars) {
                this.variableTableStore(var.getName(), var.getValue());
            }
        }
    }

    protected final VariableTableEntry[] variableTableRehash() {
        VariableTableEntry[] oldTable = this.variableTable;
        int oldCapacity = oldTable.length;
        if (oldCapacity >= 0x40000000) {
            return oldTable;
        }
        int newCapacity = oldCapacity << 1;
        VariableTableEntry[] newTable = new VariableTableEntry[newCapacity];
        this.variableTableThreshold = (int)((float)newCapacity * 0.75f);
        int sizeMask = newCapacity - 1;
        int n = oldCapacity;
        while (--n >= 0) {
            int k;
            VariableTableEntry i = oldTable[n];
            if (i == null) continue;
            VariableTableEntry next = i.next;
            int idx = i.hash & sizeMask;
            if (next == null) {
                newTable[idx] = i;
                continue;
            }
            VariableTableEntry lastRun = i;
            int lastIdx = idx;
            VariableTableEntry last = next;
            while (last != null) {
                k = last.hash & sizeMask;
                if (k != lastIdx) {
                    lastIdx = k;
                    lastRun = last;
                }
                last = last.next;
            }
            newTable[lastIdx] = lastRun;
            VariableTableEntry p = i;
            while (p != lastRun) {
                VariableTableEntry m;
                k = p.hash & sizeMask;
                newTable[k] = m = new VariableTableEntry(p.hash, p.name, p.value, newTable[k]);
                p = p.next;
            }
        }
        this.variableTable = newTable;
        return newTable;
    }

    protected Map variableTableGetMap() {
        HashMap<String, IRubyObject> map = new HashMap<String, IRubyObject>();
        VariableTableEntry[] table = this.variableTable;
        if (this.variableTable != null) {
            int n = table.length;
            while (--n >= 0) {
                VariableTableEntry i = table[n];
                while (i != null) {
                    IRubyObject e = i.value;
                    if (e == null) {
                        e = this.variableTableReadLocked(i);
                    }
                    map.put(i.name, e);
                    i = i.next;
                }
            }
        }
        return map;
    }

    protected Map variableTableGetMap(Map map) {
        VariableTableEntry[] table = this.variableTable;
        if (this.variableTable != null) {
            int n = table.length;
            while (--n >= 0) {
                VariableTableEntry i = table[n];
                while (i != null) {
                    IRubyObject e = i.value;
                    if (e == null) {
                        e = this.variableTableReadLocked(i);
                    }
                    map.put(i.name, e);
                    i = i.next;
                }
            }
        }
        return map;
    }

    @Override
    @Deprecated
    public Map getInstanceVariables() {
        this.getRuntime().getWarnings().warn("internal: deprecated getInstanceVariables() called");
        return this.variableTableGetMap();
    }

    @Override
    @Deprecated
    public Map getInstanceVariablesSnapshot() {
        this.getRuntime().getWarnings().warn("internal: deprecated getInstanceVariablesSnapshot() called");
        return this.variableTableGetMap();
    }

    @Override
    @Deprecated
    public Iterator instanceVariableNames() {
        this.getRuntime().getWarnings().warn("internal: deprecated instanceVariableNames() called");
        return this.variableTableGetMap().keySet().iterator();
    }

    @Override
    @Deprecated
    public Map safeGetInstanceVariables() {
        this.getRuntime().getWarnings().warn("internal: deprecated safeGetInstanceVariables() called");
        return this.variableTableGetMap();
    }

    @Override
    @Deprecated
    public boolean safeHasInstanceVariables() {
        this.getRuntime().getWarnings().warn("internal: deprecated safeHasInstanceVariables() called");
        return this.variableTable != null && this.variableTableSize > 0;
    }

    @Deprecated
    public IRubyObject setInstanceVariable(String name, IRubyObject value, String taintError, String freezeError) {
        throw new UnsupportedOperationException("deprecated");
    }

    @Override
    @Deprecated
    public void setInstanceVariables(Map instanceVariables) {
        throw new UnsupportedOperationException("deprecated - use syncVariables()");
    }

    protected static final class VariableTableEntry {
        final int hash;
        final String name;
        volatile IRubyObject value;
        final VariableTableEntry next;

        VariableTableEntry(int hash, String name, IRubyObject value, VariableTableEntry next) {
            this.hash = hash;
            this.name = name;
            this.value = value;
            this.next = next;
        }
    }

    public class Finalizer
    implements Finalizable {
        private long id;
        private List finalizers;
        private AtomicBoolean finalized;

        public Finalizer(long id) {
            this.id = id;
            this.finalized = new AtomicBoolean(false);
        }

        public void addFinalizer(RubyProc finalizer) {
            if (this.finalizers == null) {
                this.finalizers = new ArrayList();
            }
            this.finalizers.add(finalizer);
        }

        public void removeFinalizers() {
            this.finalizers = null;
        }

        @Override
        public void finalize() {
            if (this.finalized.compareAndSet(false, true) && this.finalizers != null) {
                for (int i = 0; i < this.finalizers.size(); ++i) {
                    ((RubyProc)this.finalizers.get(i)).call(new IRubyObject[]{RubyObject.this});
                }
            }
        }
    }
}

