/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.JRubyFile;

public class RubyFileTest {
    public static RubyModule createFileTestModule(Ruby runtime) {
        RubyModule fileTestModule = runtime.defineModule("FileTest");
        runtime.setFileTest(fileTestModule);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyFileTest.class);
        fileTestModule.defineAnnotatedMethods(RubyFileTest.class);
        return fileTestModule;
    }

    @JRubyMethod(name={"setgid?"}, required=1, module=true)
    public static RubyBoolean setgid_p(IRubyObject recv, IRubyObject filename) {
        throw recv.getRuntime().newNotImplementedError("FileTest#setgid? not yet implemented");
    }

    @JRubyMethod(name={"grpowned?"}, required=1, module=true)
    public static RubyBoolean grpowned_p(IRubyObject recv, IRubyObject filename) {
        throw recv.getRuntime().newNotImplementedError("FileTest#grpowned? not yet implemented");
    }

    @JRubyMethod(name={"sticky?"}, required=1, module=true)
    public static RubyBoolean sticky_p(IRubyObject recv, IRubyObject filename) {
        throw recv.getRuntime().newNotImplementedError("FileTest#sticky? not yet implemented");
    }

    @JRubyMethod(name={"chardev?"}, required=1, module=true)
    public static RubyBoolean chardev_p(IRubyObject recv, IRubyObject filename) {
        throw recv.getRuntime().newNotImplementedError("FileTest#chardev? not yet implemented");
    }

    @JRubyMethod(name={"identical?"}, required=2, module=true)
    public static RubyBoolean identical_p(IRubyObject recv, IRubyObject filename1, IRubyObject filename2) {
        throw recv.getRuntime().newNotImplementedError("FileTest#identical? not yet implemented");
    }

    @JRubyMethod(name={"socket?"}, required=1, module=true)
    public static RubyBoolean socket_p(IRubyObject recv, IRubyObject filename) {
        throw recv.getRuntime().newNotImplementedError("FileTest#socket? not yet implemented");
    }

    @JRubyMethod(name={"executable_real?"}, required=1, module=true)
    public static RubyBoolean executable_real_p(IRubyObject recv, IRubyObject filename) {
        throw recv.getRuntime().newNotImplementedError("FileTest#executable_real? not yet implemented");
    }

    @JRubyMethod(name={"blockdev?"}, required=1, module=true)
    public static RubyBoolean blockdev_p(IRubyObject recv, IRubyObject filename) {
        throw recv.getRuntime().newNotImplementedError("FileTest#blockdev? not yet implemented");
    }

    @JRubyMethod(name={"owned?"}, required=1, module=true)
    public static RubyBoolean owned_p(IRubyObject recv, IRubyObject filename) {
        throw recv.getRuntime().newNotImplementedError("FileTest#owned? not yet implemented");
    }

    @JRubyMethod(name={"setuid?"}, required=1, module=true)
    public static RubyBoolean setuid_p(IRubyObject recv, IRubyObject filename) {
        throw recv.getRuntime().newNotImplementedError("FileTest#setuid? not yet implemented");
    }

    @JRubyMethod(name={"pipe?"}, required=1, module=true)
    public static RubyBoolean pipe_p(IRubyObject recv, IRubyObject filename) {
        throw recv.getRuntime().newNotImplementedError("FileTest#pipe? not yet implemented");
    }

    @JRubyMethod(name={"size?"}, required=1, module=true)
    public static RubyBoolean size_p(IRubyObject recv, IRubyObject filename) {
        throw recv.getRuntime().newNotImplementedError("FileTest#size? not yet implemented");
    }

    @JRubyMethod(name={"directory?"}, required=1, module=true)
    public static RubyBoolean directory_p(IRubyObject recv, IRubyObject filename) {
        return recv.getRuntime().newBoolean(RubyFileTest.newFile(filename).isDirectory());
    }

    @JRubyMethod(name={"exist?", "exists?"}, required=1, module=true)
    public static IRubyObject exist_p(IRubyObject recv, IRubyObject filename) {
        return recv.getRuntime().newBoolean(RubyFileTest.newFile(filename).exists());
    }

    @JRubyMethod(name={"readable?", "readable_real?"}, required=1, module=true)
    public static RubyBoolean readable_p(IRubyObject recv, IRubyObject filename) {
        return filename.getRuntime().newBoolean(RubyFileTest.newFile(filename).canRead());
    }

    @JRubyMethod(name={"executable?"}, required=1, module=true)
    public static IRubyObject executable_p(IRubyObject recv, IRubyObject filename) {
        recv.getRuntime().getWarnings().warn("executable? does not work on JRuby and will return a dummy value");
        return RubyFileTest.exist_p(recv, filename);
    }

    @JRubyMethod(name={"size"}, required=1, module=true)
    public static IRubyObject size(IRubyObject recv, IRubyObject filename) {
        JRubyFile file = RubyFileTest.newFile(filename);
        if (!file.exists()) {
            throw recv.getRuntime().newErrnoENOENTError("No such file: " + filename);
        }
        return filename.getRuntime().newFixnum(file.length());
    }

    @JRubyMethod(name={"symlink?"}, required=1, module=true)
    public static RubyBoolean symlink_p(IRubyObject recv, IRubyObject _filename) {
        Ruby runtime = recv.getRuntime();
        RubyString filename = RubyString.stringValue(_filename);
        JRubyFile file = JRubyFile.create(runtime.getCurrentDirectory(), filename.toString());
        try {
            File absoluteParent = file.getAbsoluteFile().getParentFile();
            File canonicalParent = file.getAbsoluteFile().getParentFile().getCanonicalFile();
            if (canonicalParent.getAbsolutePath().equals(absoluteParent.getAbsolutePath())) {
                return file.getAbsolutePath().equals(file.getCanonicalPath()) ? runtime.getFalse() : runtime.getTrue();
            }
            file = JRubyFile.create(runtime.getCurrentDirectory(), canonicalParent.getAbsolutePath() + "/" + file.getName());
            return file.getAbsolutePath().equals(file.getCanonicalPath()) ? runtime.getFalse() : runtime.getTrue();
        }
        catch (IOException ioe) {
            return runtime.getFalse();
        }
    }

    @JRubyMethod(name={"writable?", "writable_real?"}, required=1, module=true)
    public static RubyBoolean writable_p(IRubyObject recv, IRubyObject filename) {
        return filename.getRuntime().newBoolean(RubyFileTest.newFile(filename).canWrite());
    }

    @JRubyMethod(name={"zero?"}, required=1, module=true)
    public static RubyBoolean zero_p(IRubyObject recv, IRubyObject filename) {
        JRubyFile file = RubyFileTest.newFile(filename);
        return filename.getRuntime().newBoolean(file.exists() && file.length() == 0L);
    }

    @JRubyMethod(name={"file?"}, required=1, module=true)
    public static RubyBoolean file_p(IRubyObject recv, IRubyObject filename) {
        JRubyFile file = RubyFileTest.newFile(filename);
        return filename.getRuntime().newBoolean(file.isFile());
    }

    private static JRubyFile newFile(IRubyObject path) {
        return JRubyFile.create(path.getRuntime().getCurrentDirectory(), path.convertToString().toString());
    }
}

