/*
 * Decompiled with CFR 0.152.
 */
package jregex;

import jregex.Bitset;
import jregex.UnicodeConstants;

class Block
implements UnicodeConstants {
    private boolean isFull;
    boolean[] bits;
    private boolean shared = false;
    private static final boolean[] EMPTY_BITS = new boolean[256];
    private static final boolean[] FULL_BITS = new boolean[256];

    Block() {
    }

    Block(boolean[] bits) {
        this.bits = bits;
        this.shared = true;
    }

    final boolean set(int c) {
        if (this.isFull) {
            return false;
        }
        boolean[] bits = this.bits;
        if (bits == null) {
            this.bits = bits = new boolean[256];
            this.shared = false;
            bits[c] = true;
            return true;
        }
        if (bits[c]) {
            return false;
        }
        if (this.shared) {
            bits = Block.copyBits(this);
        }
        bits[c] = true;
        return true;
    }

    final boolean get(int c) {
        if (this.isFull) {
            return true;
        }
        boolean[] bits = this.bits;
        if (bits == null) {
            return false;
        }
        return bits[c];
    }

    static final int add(Block[] targets, Block[] addends, int from, int to, boolean inv) {
        int s = 0;
        for (int i = from; i <= to; ++i) {
            Block addend = addends[i];
            if (addend != null ? addend.isFull && inv : !inv) continue;
            Block target = targets[i];
            if (target == null) {
                targets[i] = target = new Block();
            } else if (target.isFull) continue;
            s += Block.add(target, addend, inv);
        }
        return s;
    }

    /*
     * WARNING - void declaration
     */
    private static final int add(Block target, Block addend, boolean inv) {
        void var5_10;
        if (addend == null) {
            void targetbits;
            if (!inv) {
                return 0;
            }
            int n = 256;
            boolean[] blArray = target.bits;
            if (target.bits != null) {
                targetbits -= Block.count(blArray, 0, 255);
            }
            target.isFull = true;
            target.bits = null;
            target.shared = false;
            return (int)targetbits;
        }
        if (addend.isFull) {
            if (inv) {
                return 0;
            }
            int targetbits = 256;
            boolean[] blArray = target.bits;
            if (target.bits != null) {
                targetbits -= Block.count(blArray, 0, 255);
            }
            target.isFull = true;
            target.bits = null;
            target.shared = false;
            return targetbits;
        }
        boolean[] s = addend.bits;
        if (addend.bits == null) {
            if (!inv) {
                return 0;
            }
            int targetbits = 256;
            boolean[] addbits = target.bits;
            if (target.bits != null) {
                targetbits -= Block.count(addbits, 0, 255);
            }
            target.isFull = true;
            target.bits = null;
            target.shared = false;
            return targetbits;
        }
        boolean[] addbits = target.bits;
        if (target.bits == null) {
            if (!inv) {
                target.bits = var5_10;
                target.shared = true;
                return Block.count((boolean[])var5_10, 0, 255);
            }
            target.bits = addbits = Block.emptyBits(null);
            target.shared = false;
            return Bitset.add(addbits, (boolean[])var5_10, 0, 255, inv);
        }
        if (target.shared) {
            addbits = Block.copyBits(target);
        }
        return Bitset.add(addbits, (boolean[])var5_10, 0, 255, inv);
    }

    static final int subtract(Block[] targets, Block[] subtrahends, int from, int to, boolean inv) {
        int s = 0;
        for (int i = from; i <= to; ++i) {
            Block target = targets[i];
            if (target == null || !target.isFull && target.bits == null) continue;
            Block subtrahend = subtrahends[i];
            if (subtrahend == null) {
                if (!inv) continue;
                s = target.isFull ? (s -= 256) : (s -= Block.count(target.bits, 0, 255));
                target.isFull = false;
                target.bits = null;
                target.shared = false;
                continue;
            }
            s += Block.subtract(target, subtrahend, inv);
        }
        return s;
    }

    private static final int subtract(Block target, Block subtrahend, boolean inv) {
        if (subtrahend.isFull) {
            if (inv) {
                return 0;
            }
            int n = 0;
            n = target.isFull ? 256 : Block.count(target.bits, 0, 255);
            target.isFull = false;
            target.bits = null;
            target.shared = false;
            return n;
        }
        boolean[] subbits = subtrahend.bits;
        if (subtrahend.bits == null) {
            if (!inv) {
                return 0;
            }
            int n = 0;
            n = target.isFull ? 256 : Block.count(target.bits, 0, 255);
            target.isFull = false;
            target.bits = null;
            target.shared = false;
            return n;
        }
        if (target.isFull) {
            boolean[] blArray = Block.fullBits(target.bits);
            int bits = Bitset.subtract(blArray, subbits, 0, 255, inv);
            target.isFull = false;
            target.shared = false;
            target.bits = blArray;
            return bits;
        }
        boolean[] blArray = target.shared ? Block.copyBits(target) : target.bits;
        return Bitset.subtract(blArray, subbits, 0, 255, inv);
    }

    private static boolean[] copyBits(Block block) {
        boolean[] bits = new boolean[256];
        System.arraycopy(block.bits, 0, bits, 0, 256);
        block.bits = bits;
        block.shared = false;
        return bits;
    }

    private static boolean[] fullBits(boolean[] bits) {
        if (bits == null) {
            bits = new boolean[256];
        }
        System.arraycopy(FULL_BITS, 0, bits, 0, 256);
        return bits;
    }

    private static boolean[] emptyBits(boolean[] bits) {
        if (bits == null) {
            bits = new boolean[256];
        } else {
            System.arraycopy(EMPTY_BITS, 0, bits, 0, 256);
        }
        return bits;
    }

    static final int count(boolean[] arr, int from, int to) {
        int s = 0;
        for (int i = from; i <= to; ++i) {
            if (!arr[i]) continue;
            ++s;
        }
        return s;
    }

    static final boolean[][] toBitset2(Block[] blocks) {
        int len = blocks.length;
        boolean[][] result = new boolean[len][];
        for (int i = 0; i < len; ++i) {
            Block block = blocks[i];
            if (block == null) continue;
            result[i] = block.isFull ? FULL_BITS : block.bits;
        }
        return result;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            Block.FULL_BITS[i] = true;
        }
    }
}

