/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.common.IRubyWarnings;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;

public class JRubyPOSIXHandler
implements POSIXHandler {
    Ruby runtime;

    public JRubyPOSIXHandler(Ruby runtime) {
        this.runtime = runtime;
    }

    public void error(POSIX.ERRORS error, String extraData) {
        switch (error) {
            case ENOENT: {
                throw this.runtime.newErrnoENOENTError("No such file or directory - " + extraData);
            }
        }
    }

    public void unimplementedError(String method) {
        throw this.runtime.newNotImplementedError(method + " unsupported on this platform");
    }

    public void warn(POSIXHandler.WARNING_ID id, String message, Object ... data) {
        IRubyWarnings.ID ourID = id == POSIXHandler.WARNING_ID.DUMMY_VALUE_USED ? IRubyWarnings.ID.DUMMY_VALUE_USED : IRubyWarnings.ID.MISCELLANEOUS;
        this.runtime.getWarnings().warn(ourID, message, data);
    }

    public File getCurrentWorkingDirectory() {
        return new File(this.runtime.getCurrentDirectory());
    }

    public String[] getEnv() {
        RubyHash hash = (RubyHash)this.runtime.getObject().fastGetConstant("ENV");
        int i = 0;
        String[] env = new String[hash.size()];
        for (Map.Entry entry : hash.directEntrySet()) {
            env[i] = entry.getKey().toString() + "=" + entry.getValue().toString();
            ++i;
        }
        return env;
    }

    public PrintStream getErrorStream() {
        return this.runtime.getErrorStream();
    }

    public InputStream getInputStream() {
        return this.runtime.getInputStream();
    }

    public int getPID() {
        return this.runtime.hashCode();
    }

    public PrintStream getOutputStream() {
        return this.runtime.getOutputStream();
    }
}

