/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.Library;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.TypeMapper;
import com.sun.jna.WString;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public final class Native {
    private static Map typeMappers = new WeakHashMap();
    private static Map alignments = new WeakHashMap();
    private static Map options = new WeakHashMap();
    private static Map libraries = new WeakHashMap();
    public static final int POINTER_SIZE;
    public static final int LONG_SIZE;
    public static final int WCHAR_SIZE;
    private static final ThreadLocal lastError;

    private Native() {
    }

    private static native void initIDs();

    public static synchronized native void setProtected(boolean var0);

    public static synchronized native boolean isProtected();

    public static synchronized native void setPreserveLastError(boolean var0);

    public static synchronized native boolean getPreserveLastError();

    public static long getWindowID(Window w) throws HeadlessException {
        return Native.getComponentID(w);
    }

    public static long getComponentID(Component c) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException("No native windows when headless");
        }
        if (c.isLightweight()) {
            throw new IllegalArgumentException("Component must be heavyweight");
        }
        if (!c.isDisplayable()) {
            throw new IllegalStateException("Component must be displayable");
        }
        if (Platform.isX11() && System.getProperty("java.version").matches("^1\\.4\\..*") && !c.isVisible()) {
            throw new IllegalStateException("Component must be visible");
        }
        return Native.getWindowHandle0(c);
    }

    public static Pointer getWindowPointer(Window w) throws HeadlessException {
        return Native.getComponentPointer(w);
    }

    public static Pointer getComponentPointer(Component c) throws HeadlessException {
        return new Pointer(Native.getComponentID(c));
    }

    private static native long getWindowHandle0(Component var0);

    public static Pointer getByteBufferPointer(ByteBuffer b) {
        return Native.getDirectBufferPointer(b);
    }

    public static native Pointer getDirectBufferPointer(Buffer var0);

    public static String toString(byte[] buf) {
        int term;
        String encoding = System.getProperty("jna.encoding");
        String s = null;
        if (encoding != null) {
            try {
                s = new String(buf, encoding);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if (s == null) {
            s = new String(buf);
        }
        if ((term = s.indexOf(0)) != -1) {
            s = s.substring(0, term);
        }
        return s;
    }

    public static String toString(char[] buf) {
        String s = new String(buf);
        int term = s.indexOf(0);
        if (term != -1) {
            s = s.substring(0, term);
        }
        return s;
    }

    public static Object loadLibrary(String name, Class interfaceClass) {
        return Native.loadLibrary(name, interfaceClass, Collections.EMPTY_MAP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object loadLibrary(String name, Class interfaceClass, Map libOptions) {
        Library.Handler handler = new Library.Handler(name, interfaceClass, libOptions);
        ClassLoader loader = interfaceClass.getClassLoader();
        Library proxy = (Library)Proxy.newProxyInstance(loader, new Class[]{interfaceClass}, (InvocationHandler)handler);
        Map map = libraries;
        synchronized (map) {
            if (!libOptions.isEmpty()) {
                options.put(interfaceClass, libOptions);
            }
            if (libOptions.containsKey("type-mapper")) {
                typeMappers.put(interfaceClass, libOptions.get("type-mapper"));
            }
            if (libOptions.containsKey("structure-alignment")) {
                alignments.put(interfaceClass, libOptions.get("structure-alignment"));
            }
            libraries.put(interfaceClass, new WeakReference<Library>(proxy));
        }
        return proxy;
    }

    private static boolean loadInstance(Class cls) {
        if (libraries.containsKey(cls)) {
            return true;
        }
        if (cls != null) {
            try {
                Field[] fields = cls.getFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    if (field.getType() != cls || !Modifier.isStatic(field.getModifiers())) continue;
                    libraries.put(cls, new WeakReference<Object>(field.get(null)));
                    return true;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not access instance of " + cls + " (" + e + ")");
            }
        }
        return false;
    }

    static Class findLibraryClass(Class cls) {
        if (cls == null) {
            return null;
        }
        if (Library.class.isAssignableFrom(cls)) {
            return cls;
        }
        Class fromDeclaring = Native.findLibraryClass(cls.getDeclaringClass());
        if (fromDeclaring != null) {
            return fromDeclaring;
        }
        return Native.findLibraryClass(cls.getSuperclass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getLibraryOptions(Class type) {
        Map map = libraries;
        synchronized (map) {
            Class interfaceClass = Native.findLibraryClass(type);
            if (interfaceClass == null) {
                return null;
            }
            if (!Native.loadInstance(interfaceClass) || !options.containsKey(interfaceClass)) {
                try {
                    Field field = interfaceClass.getField("OPTIONS");
                    options.put(interfaceClass, field.get(null));
                }
                catch (NoSuchFieldException e) {
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("OPTIONS must be a public field of type java.util.Map (" + e + "): " + interfaceClass);
                }
            }
            return (Map)options.get(interfaceClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeMapper getTypeMapper(Class cls) {
        Map map = libraries;
        synchronized (map) {
            Class interfaceClass = Native.findLibraryClass(cls);
            if (interfaceClass == null) {
                return null;
            }
            if (!Native.loadInstance(interfaceClass) || !typeMappers.containsKey(interfaceClass)) {
                try {
                    Field field = interfaceClass.getField("TYPE_MAPPER");
                    typeMappers.put(interfaceClass, field.get(null));
                }
                catch (NoSuchFieldException e) {
                    Map options = Native.getLibraryOptions(cls);
                    if (options != null && options.containsKey("type-mapper")) {
                        typeMappers.put(interfaceClass, options.get("type-mapper"));
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("TYPE_MAPPER must be a public field of type " + TypeMapper.class.getName() + " (" + e + "): " + interfaceClass);
                }
            }
            return (TypeMapper)typeMappers.get(interfaceClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getStructureAlignment(Class cls) {
        Map map = libraries;
        synchronized (map) {
            Integer value;
            Class interfaceClass = Native.findLibraryClass(cls);
            if (interfaceClass == null) {
                return 0;
            }
            if (!Native.loadInstance(interfaceClass) || !alignments.containsKey(interfaceClass)) {
                try {
                    Field field = interfaceClass.getField("STRUCTURE_ALIGNMENT");
                    alignments.put(interfaceClass, field.get(null));
                }
                catch (NoSuchFieldException e) {
                    Map options = Native.getLibraryOptions(cls);
                    if (options != null && options.containsKey("structure-alignment")) {
                        alignments.put(interfaceClass, options.get("structure-alignment"));
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("STRUCTURE_ALIGNMENT must be a public field of type int (" + e + "): " + interfaceClass);
                }
            }
            int n = (value = (Integer)alignments.get(interfaceClass)) != null ? value : 0;
            return n;
        }
    }

    static byte[] getBytes(String s) {
        String encoding = System.getProperty("jna.encoding");
        if (encoding != null) {
            try {
                return s.getBytes(encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return s.getBytes();
    }

    private static String getNativeLibraryResourcePath() {
        String osPrefix;
        String arch = System.getProperty("os.arch");
        if (Platform.isWindows()) {
            osPrefix = "win32-" + arch;
        } else if (Platform.isMac()) {
            osPrefix = "darwin";
        } else if (Platform.isLinux()) {
            osPrefix = "linux-" + arch;
        } else if (Platform.isSolaris()) {
            osPrefix = "sunos-" + arch;
        } else {
            osPrefix = System.getProperty("os.name").toLowerCase();
            int space = osPrefix.indexOf(" ");
            if (space != -1) {
                osPrefix = osPrefix.substring(0, space);
            }
            osPrefix = osPrefix + "-" + arch;
        }
        return "/com/sun/jna/" + osPrefix;
    }

    /*
     * WARNING - void declaration
     */
    private static void loadNativeLibrary() {
        String resourceName;
        String libname = System.mapLibraryName("jnidispatch");
        URL url = Native.class.getResource(resourceName = Native.getNativeLibraryResourcePath() + "/" + libname);
        if (url == null && Platform.isMac() && resourceName.endsWith(".dylib")) {
            resourceName = resourceName.substring(0, resourceName.lastIndexOf(".dylib")) + ".jnilib";
            url = Native.class.getResource(resourceName);
        }
        if (url == null) {
            throw new UnsatisfiedLinkError("jnidispatch (" + resourceName + ") not found in resource path");
        }
        File lib = null;
        if (url.getProtocol().toLowerCase().equals("file")) {
            try {
                lib = new File(URLDecoder.decode(url.getPath(), "UTF8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new Error("JRE is unexpectedly missing UTF8 encoding");
            }
        }
        InputStream is = Native.class.getResourceAsStream(resourceName);
        if (is == null) {
            throw new Error("Can't obtain jnidispatch InputStream");
        }
        FileOutputStream fos = null;
        try {
            int buf;
            lib = File.createTempFile("jna", null);
            lib.deleteOnExit();
            if (Platform.isWindows()) {
                Runtime.getRuntime().addShutdownHook(new W32Cleanup(lib));
            }
            fos = new FileOutputStream(lib);
            byte[] byArray = new byte[1024];
            while ((buf = is.read(byArray, 0, byArray.length)) > 0) {
                void count;
                fos.write((byte[])count, 0, buf);
            }
        }
        catch (IOException iOException) {
            throw new Error("Failed to create temporary file for jnidispatch library", iOException);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
        System.load(lib.getAbsolutePath());
    }

    private static native int pointerSize();

    private static native int longSize();

    private static native int wideCharSize();

    private static native String getNativeVersion();

    private static native String getAPIChecksum();

    public static int getLastError() {
        return (Integer)lastError.get();
    }

    public static native void setLastError(int var0);

    static void updateLastError(int e) {
        lastError.set(new Integer(e));
    }

    public static Library synchronizedLibrary(final Library library) {
        Class<?> cls = library.getClass();
        if (!Proxy.isProxyClass(cls)) {
            throw new IllegalArgumentException("Library must be a proxy class");
        }
        InvocationHandler ih = Proxy.getInvocationHandler(library);
        if (!(ih instanceof Library.Handler)) {
            throw new IllegalArgumentException("Unrecognized proxy handler: " + ih);
        }
        final Library.Handler handler = (Library.Handler)ih;
        InvocationHandler newHandler = new InvocationHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                NativeLibrary nativeLibrary = handler.getNativeLibrary();
                synchronized (nativeLibrary) {
                    return handler.invoke(library, method, args);
                }
            }
        };
        return (Library)Proxy.newProxyInstance(cls.getClassLoader(), cls.getInterfaces(), newHandler);
    }

    public static String getWebStartLibraryPath(String libName) {
        if (System.getProperty("javawebstart.version") == null) {
            return null;
        }
        try {
            ClassLoader cl = Native.class.getClassLoader();
            Method m = ClassLoader.class.getDeclaredMethod("findLibrary", String.class);
            m.setAccessible(true);
            String libpath = (String)m.invoke((Object)cl, libName);
            if (libpath != null) {
                return new File(libpath).getParent();
            }
            String msg = "Library '" + libName + "' was not found by class loader " + cl;
            throw new IllegalArgumentException(msg);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getNativeSize(Class cls) {
        if (NativeMapped.class.isAssignableFrom(cls)) {
            cls = new NativeMappedConverter(cls).nativeType();
        }
        if (cls == Boolean.TYPE || cls == Boolean.class) {
            return 4;
        }
        if (cls == Byte.TYPE || cls == Byte.class) {
            return 1;
        }
        if (cls == Short.TYPE || cls == Short.class) {
            return 2;
        }
        if (cls == Character.TYPE || cls == Character.class) {
            return WCHAR_SIZE;
        }
        if (cls == Integer.TYPE || cls == Integer.class) {
            return 4;
        }
        if (cls == Long.TYPE || cls == Long.class) {
            return 8;
        }
        if (cls == Float.TYPE || cls == Float.class) {
            return 4;
        }
        if (cls == Double.TYPE || cls == Double.class) {
            return 8;
        }
        if (Structure.class.isAssignableFrom(cls)) {
            if (Structure.ByValue.class.isAssignableFrom(cls)) {
                return Structure.newInstance(cls).size();
            }
            return POINTER_SIZE;
        }
        if (Pointer.class.isAssignableFrom(cls) || Buffer.class.isAssignableFrom(cls) || Callback.class.isAssignableFrom(cls) || String.class == cls || WString.class == cls) {
            return POINTER_SIZE;
        }
        throw new IllegalArgumentException("Native size for type \"" + cls.getName() + "\" is unknown");
    }

    public static boolean isSupportedNativeType(Class cls) {
        if (Structure.class.isAssignableFrom(cls)) {
            return true;
        }
        try {
            return Native.getNativeSize(cls) != 0;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static void main(String[] args) {
        Package pkg = Native.class.getPackage();
        System.out.println(pkg.getSpecificationTitle());
        System.out.println("Version: " + Native.class.getPackage().getImplementationVersion());
        System.out.println(" Native: " + Native.getNativeVersion() + " (" + Native.getAPIChecksum() + ")");
        System.exit(0);
    }

    static {
        try {
            System.loadLibrary("jnidispatch");
        }
        catch (UnsatisfiedLinkError e) {
            Native.loadNativeLibrary();
        }
        POINTER_SIZE = Native.pointerSize();
        LONG_SIZE = Native.longSize();
        WCHAR_SIZE = Native.wideCharSize();
        Native.initIDs();
        if (Boolean.getBoolean("jna.protected")) {
            Native.setProtected(true);
        }
        lastError = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new Integer(0);
            }
        };
    }

    public static class W32Cleanup
    extends Thread {
        private File file;

        public W32Cleanup(File file) {
            this.file = file;
        }

        public void run() {
            try {
                Runtime.getRuntime().exec(new String[]{System.getProperty("java.home") + "/bin/java", "-cp", System.getProperty("java.class.path"), this.getClass().getName(), this.file.getAbsolutePath()});
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public static void main(String[] args) {
            File file;
            if (args.length == 1 && (file = new File(args[0])).exists()) {
                long start = System.currentTimeMillis();
                while (!file.delete() && file.exists()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() - start <= 1000L) continue;
                }
            }
            System.exit(0);
        }
    }
}

