/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.IterNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NodeType;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class BlockBody
implements JumpTarget {
    public static final int ZERO_ARGS = 0;
    public static final int MULTIPLE_ASSIGNMENT = 1;
    public static final int ARRAY = 2;
    public static final int SINGLE_RESTARG = 3;
    protected final int argumentType;
    public static final BlockBody NULL_BODY = new BlockBody(0){

        public IRubyObject call(ThreadContext context, IRubyObject[] args, Binding binding, Block.Type type) {
            return null;
        }

        public IRubyObject yield(ThreadContext context, IRubyObject value, Binding binding, Block.Type type) {
            return null;
        }

        public IRubyObject yield(ThreadContext context, IRubyObject value, IRubyObject self, RubyModule klass, boolean aValue, Binding binding, Block.Type type) {
            return null;
        }

        public StaticScope getStaticScope() {
            return null;
        }

        public Block cloneBlock(Binding binding) {
            return null;
        }

        public Arity arity() {
            return null;
        }
    };

    public BlockBody(int argumentType) {
        this.argumentType = argumentType;
    }

    public abstract IRubyObject call(ThreadContext var1, IRubyObject[] var2, Binding var3, Block.Type var4);

    public abstract IRubyObject yield(ThreadContext var1, IRubyObject var2, Binding var3, Block.Type var4);

    public abstract IRubyObject yield(ThreadContext var1, IRubyObject var2, IRubyObject var3, RubyModule var4, boolean var5, Binding var6, Block.Type var7);

    protected int arrayLength(IRubyObject node) {
        return node instanceof RubyArray ? ((RubyArray)node).getLength() : 0;
    }

    public abstract StaticScope getStaticScope();

    public abstract Block cloneBlock(Binding var1);

    public abstract Arity arity();

    public boolean isGiven() {
        return true;
    }

    public static int asArgumentType(NodeType nodeId) {
        if (nodeId == null) {
            return 0;
        }
        switch (nodeId) {
            case ZEROARGNODE: {
                return 0;
            }
            case MULTIPLEASGNNODE: {
                return 1;
            }
            case SVALUENODE: {
                return 3;
            }
        }
        return 2;
    }

    public IRubyObject[] prepareArgumentsForCall(ThreadContext context, IRubyObject[] args, Block.Type type) {
        switch (type) {
            case NORMAL: {
                assert (false) : "can this happen?";
                if (args.length == 1 && args[0] instanceof RubyArray) {
                    if (this.argumentType != 1 && this.argumentType != 3) break;
                    args = ((RubyArray)args[0]).toJavaArray();
                    break;
                }
            }
            case PROC: {
                if (args.length != 1 || !(args[0] instanceof RubyArray) || this.argumentType != 1 || this.argumentType == 3) break;
                args = ((RubyArray)args[0]).toJavaArray();
                break;
            }
            case LAMBDA: {
                if (this.argumentType == 2 && args.length != 1) {
                    context.getRuntime().getWarnings().warn("multiple values for a block parameter (" + args.length + " for " + this.arity().getValue() + ")");
                    if (args.length == 0) {
                        args = new IRubyObject[]{context.getRuntime().getNil()};
                        break;
                    }
                    args = new IRubyObject[]{context.getRuntime().newArrayNoCopy(args)};
                    break;
                }
                this.arity().checkArity(context.getRuntime(), args);
            }
        }
        return args;
    }

    public static NodeType getArgumentTypeWackyHack(IterNode iterNode) {
        MultipleAsgnNode multipleAsgnNode;
        NodeType argsNodeId = null;
        if (iterNode.getVarNode() != null && iterNode.getVarNode().nodeId != NodeType.ZEROARGNODE && (argsNodeId = iterNode.getVarNode().nodeId) == NodeType.MULTIPLEASGNNODE && (multipleAsgnNode = (MultipleAsgnNode)iterNode.getVarNode()).getHeadNode() == null && multipleAsgnNode.getArgsNode() != null) {
            argsNodeId = NodeType.SVALUENODE;
        }
        return argsNodeId;
    }
}

