/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Block {
    public static final int ZERO_ARGS = 0;
    public static final int MULTIPLE_ASSIGNMENT = 1;
    public static final int ARRAY = 2;
    public static final int SINGLE_RESTARG = 3;
    private RubyProc proc = null;
    public Type type = Type.NORMAL;
    private final Binding binding;
    private final BlockBody body;
    public static final Block NULL_BLOCK = new Block(){

        public boolean isGiven() {
            return false;
        }

        public IRubyObject yield(ThreadContext context, IRubyObject value, IRubyObject self, RubyModule klass, boolean aValue) {
            throw context.getRuntime().newLocalJumpError("noreason", value, "yield called out of block");
        }

        public IRubyObject call(ThreadContext context, IRubyObject[] args) {
            throw context.getRuntime().newLocalJumpError("noreason", context.getRuntime().newArrayNoCopy(args), "yield called out of block");
        }

        public IRubyObject yield(ThreadContext context, IRubyObject value) {
            throw context.getRuntime().newLocalJumpError("noreason", value, "yield called out of block");
        }

        public Block cloneBlock() {
            return this;
        }

        public BlockBody getBody() {
            return BlockBody.NULL_BODY;
        }
    };

    protected Block() {
        this(null, null);
    }

    public Block(BlockBody body, Binding binding) {
        this.body = body;
        this.binding = binding;
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args) {
        return this.body.call(context, args, this.binding, this.type);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value) {
        return this.body.yield(context, value, this.binding, this.type);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value, IRubyObject self, RubyModule klass, boolean aValue) {
        return this.body.yield(context, value, self, klass, aValue, this.binding, this.type);
    }

    protected int arrayLength(IRubyObject node) {
        return node instanceof RubyArray ? ((RubyArray)node).getLength() : 0;
    }

    public Block cloneBlock() {
        Block newBlock = this.body.cloneBlock(this.binding);
        newBlock.type = this.type;
        return newBlock;
    }

    public Arity arity() {
        return this.body.arity();
    }

    public RubyProc getProcObject() {
        return this.proc;
    }

    public void setProcObject(RubyProc procObject) {
        this.proc = procObject;
    }

    public boolean isGiven() {
        return true;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public BlockBody getBody() {
        return this.body;
    }

    public Frame getFrame() {
        return this.binding.getFrame();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NORMAL,
        PROC,
        LAMBDA,
        THREAD;

    }
}

