/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.AbstractVariableCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;

public class StackBasedVariableCompiler
extends AbstractVariableCompiler {
    private int scopeIndex;

    public StackBasedVariableCompiler(StandardASMCompiler.AbstractMethodCompiler methodCompiler, SkinnyMethodAdapter method, int scopeIndex, int argsIndex, int closureIndex) {
        super(methodCompiler, method, argsIndex, closureIndex);
        this.scopeIndex = scopeIndex;
    }

    public void beginMethod(CompilerCallback argsCallback, StaticScope scope) {
        this.methodCompiler.loadNil();
        for (int i = 0; i < scope.getNumberOfVariables(); ++i) {
            this.assignLocalVariable(i);
        }
        this.method.pop();
        if (argsCallback != null) {
            argsCallback.call(this.methodCompiler);
        }
    }

    public void beginClass(CompilerCallback bodyPrep, StaticScope scope) {
        throw new NotCompilableException("ERROR: stack-based variables should not be compiling class bodies");
    }

    public void beginClosure(CompilerCallback argsCallback, StaticScope scope) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentScope", cg.sig(DynamicScope.class));
        this.method.astore(this.scopeIndex);
        if (scope != null) {
            this.methodCompiler.loadNil();
            for (int i = 0; i < scope.getNumberOfVariables(); ++i) {
                this.assignLocalVariable(i);
            }
            this.method.pop();
        }
        if (argsCallback != null) {
            this.method.aload(this.argsIndex);
            this.method.ldc(new Integer(0));
            this.method.arrayload();
            argsCallback.call(this.methodCompiler);
            this.method.pop();
        }
    }

    public void assignLocalVariable(int index) {
        this.method.dup();
        this.method.astore(10 + index);
    }

    public void assignLocalVariable(int index, int depth) {
        if (depth == 0) {
            this.assignLocalVariable(index);
        } else {
            this.method.dup();
            this.method.aload(this.scopeIndex);
            this.method.swap();
            this.method.ldc(new Integer(index));
            this.method.swap();
            this.method.ldc(new Integer(depth));
            this.method.invokevirtual(cg.p(DynamicScope.class), "setValue", cg.sig(Void.TYPE, cg.params(Integer.TYPE, IRubyObject.class, Integer.TYPE)));
        }
    }

    public void retrieveLocalVariable(int index) {
        this.method.aload(10 + index);
    }

    public void retrieveLocalVariable(int index, int depth) {
        if (depth == 0) {
            this.retrieveLocalVariable(index);
        } else {
            this.method.aload(this.scopeIndex);
            this.method.ldc(new Integer(index));
            this.method.ldc(new Integer(depth));
            this.methodCompiler.loadNil();
            this.method.invokevirtual(cg.p(DynamicScope.class), "getValueOrNil", cg.sig(IRubyObject.class, cg.params(Integer.TYPE, Integer.TYPE, IRubyObject.class)));
        }
    }
}

