/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import org.jruby.Ruby;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.compiler.ASTCompiler;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.MethodCompiler;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DefaultMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.JavaNameMangler;

public class JITCompiler {
    public static void runJIT(DefaultMethod method, Ruby runtime, ThreadContext context, String name) {
        if (method.getCallCount() >= 0) {
            try {
                method.setCallCount(method.getCallCount() + 1);
                if (method.getCallCount() >= runtime.getInstanceConfig().getJitThreshold()) {
                    CallConfiguration methodCompiler;
                    MethodCompiler jitCallConfig;
                    String cleanName = JavaNameMangler.mangleStringForCleanJavaIdentifier(name);
                    String filename = "__eval__";
                    Node bodyNode = method.getBodyNode();
                    final ArgsNode argsNode = method.getArgsNode();
                    StaticScope staticScope = method.getStaticScope();
                    if (bodyNode != null) {
                        filename = bodyNode.getPosition().getFile();
                    } else if (argsNode != null) {
                        filename = argsNode.getPosition().getFile();
                    }
                    StandardASMCompiler asmCompiler = new StandardASMCompiler(cleanName + method.hashCode() + "_" + context.hashCode(), filename);
                    asmCompiler.startScript(staticScope);
                    final ASTCompiler compiler = new ASTCompiler();
                    CompilerCallback args = new CompilerCallback(){

                        public void call(MethodCompiler context) {
                            compiler.compileArgs(argsNode, context);
                        }
                    };
                    ASTInspector inspector = new ASTInspector();
                    inspector.inspect(bodyNode);
                    inspector.inspect(argsNode);
                    Object var13_15 = null;
                    if (bodyNode != null) {
                        jitCallConfig = asmCompiler.startMethod("__file__", args, staticScope, inspector);
                        compiler.compile(bodyNode, jitCallConfig);
                    } else if (argsNode != null && (argsNode.getRequiredArgsCount() > 0 || argsNode.getOptionalArgsCount() > 0)) {
                        jitCallConfig = asmCompiler.startMethod("__file__", args, staticScope, inspector);
                        jitCallConfig.loadNil();
                    } else {
                        jitCallConfig = asmCompiler.startMethod("__file__", null, staticScope, inspector);
                        jitCallConfig.loadNil();
                        methodCompiler = CallConfiguration.NO_FRAME_NO_SCOPE;
                    }
                    jitCallConfig.endMethod();
                    asmCompiler.endScript();
                    Class<?> sourceClass = asmCompiler.loadClass(new JRubyClassLoader(runtime.getJRubyClassLoader()));
                    if (methodCompiler == null) {
                        methodCompiler = !inspector.hasClosure() && !inspector.hasScopeAwareMethods() ? CallConfiguration.FRAME_ONLY : CallConfiguration.FRAME_AND_SCOPE;
                    }
                    Script jitCompiledScript = (Script)sourceClass.newInstance();
                    if (runtime.getInstanceConfig().isJitLogging()) {
                        String className = method.getImplementationClass().getBaseName();
                        if (className == null) {
                            className = "<anon class>";
                        }
                        System.err.println("compiled: " + className + "." + name);
                    }
                    method.setJITCallConfig(methodCompiler);
                    method.setJITCompiledScript(jitCompiledScript);
                    method.setCallCount(-1);
                }
            }
            catch (Exception e) {
                if (runtime.getInstanceConfig().isJitLoggingVerbose()) {
                    String className = method.getImplementationClass().getBaseName();
                    if (className == null) {
                        className = "<anon class>";
                    }
                    System.err.println("could not compile: " + className + "." + name + " because of: \"" + e.getMessage() + '\"');
                }
                method.setCallCount(-1);
            }
        }
    }
}

