/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.Comparator;
import java.util.Stack;

public class Qsort {
    private static int SIZE_THRESHOLD = 16;
    private static int[] INCREMENT = new int[]{1, 4, 10, 23, 57, 132, 301, 701, 1750, 4023, 9258, 21293, 48974, 112640};

    public static void sort(Comparable[] a) {
        if (a.length < SIZE_THRESHOLD) {
            Qsort.insertionsort(a, 0, a.length);
            return;
        }
        if (!Qsort.quicksort_loop(a, 0, a.length, 2 * Qsort.floorLog2(a.length))) {
            Qsort.insertionsort(a, 0, a.length);
        }
    }

    public static void sort(Object[] a, Comparator c) {
        if (a.length < SIZE_THRESHOLD) {
            Qsort.insertionsort(a, 0, a.length, c);
            return;
        }
        if (!Qsort.quicksort_loop(a, 0, a.length, 2 * Qsort.floorLog2(a.length), c)) {
            Qsort.insertionsort(a, 0, a.length, c);
        }
    }

    public static void sort(Comparable[] a, int begin2, int end2) {
        if (begin2 < end2) {
            if (end2 - begin2 < SIZE_THRESHOLD) {
                Qsort.insertionsort(a, begin2, end2);
                return;
            }
            if (!Qsort.quicksort_loop(a, begin2, end2, 2 * Qsort.floorLog2(end2 - begin2))) {
                Qsort.insertionsort(a, begin2, end2);
            }
        }
    }

    public static void sort(Object[] a, int begin2, int end2, Comparator c) {
        if (begin2 < end2) {
            if (end2 - begin2 < SIZE_THRESHOLD) {
                Qsort.insertionsort(a, begin2, end2, c);
                return;
            }
            if (!Qsort.quicksort_loop(a, begin2, end2, 2 * Qsort.floorLog2(end2 - begin2), c)) {
                Qsort.insertionsort(a, begin2, end2, c);
            }
        }
    }

    private static void endTest(Comparable[] a, int lo, int hi) {
        int comp1 = a[lo].compareTo(a[lo + 1]);
        int comp2 = a[hi - 2].compareTo(a[hi - 1]);
        if (comp1 <= 0) {
            if (comp2 > 0) {
                Qsort.bubbleUp(a, lo, hi);
            }
        } else if (comp2 <= 0) {
            Qsort.bubbleDown(a, lo, hi);
        } else {
            Qsort.bubbleBoth(a, lo, hi);
        }
    }

    private static void endTest(Object[] a, int lo, int hi, Comparator c) {
        int comp1 = c.compare(a[lo], a[lo + 1]);
        int comp2 = c.compare(a[hi - 2], a[hi - 1]);
        if (comp1 <= 0) {
            if (comp2 > 0) {
                Qsort.bubbleUp(a, lo, hi, c);
            }
        } else if (comp2 <= 0) {
            Qsort.bubbleDown(a, lo, hi, c);
        } else {
            Qsort.bubbleBoth(a, lo, hi, c);
        }
    }

    private static boolean seqtest(Comparable[] a, int lo, int hi) {
        for (int i = lo + 1; i < hi - 2; ++i) {
            if (a[i].compareTo(a[i + 1]) <= 0) continue;
            return false;
        }
        Qsort.endTest(a, lo, hi);
        return true;
    }

    private static boolean seqtest(Object[] a, int lo, int hi, Comparator c) {
        for (int i = lo + 1; i < hi - 2; ++i) {
            if (c.compare(a[i], a[i + 1]) <= 0) continue;
            return false;
        }
        Qsort.endTest(a, lo, hi, c);
        return true;
    }

    private static boolean revtest(Comparable[] a, int lo, int hi) {
        int i;
        for (i = lo + 1; i < hi - 2; ++i) {
            if (a[i].compareTo(a[i + 1]) >= 0) continue;
            return false;
        }
        i = lo;
        for (int j = hi - 1; i < j; ++i, --j) {
            Qsort.swap(a, i, j);
        }
        Qsort.endTest(a, lo, hi);
        return true;
    }

    private static boolean revtest(Object[] a, int lo, int hi, Comparator c) {
        int i;
        for (i = lo + 1; i < hi - 2; ++i) {
            if (c.compare(a[i], a[i + 1]) >= 0) continue;
            return false;
        }
        i = lo;
        for (int j = hi - 1; i < j; ++i, --j) {
            Qsort.swap(a, i, j);
        }
        Qsort.endTest(a, lo, hi, c);
        return true;
    }

    private static boolean quicksort_loop(Comparable[] a, int lo1, int hi1, int depth_limit1) {
        boolean done = false;
        Stack<int[]> stack = new Stack<int[]>();
        int[] entry = new int[]{lo1, hi1, depth_limit1};
        stack.push(entry);
        boolean checklim = true;
        while (stack.size() > 0) {
            Comparable m3;
            Comparable m1;
            int t;
            entry = (int[])stack.pop();
            int lo = entry[0];
            int hi = entry[1];
            int depth_limit = entry[2];
            if (depth_limit == 0) {
                Qsort.shellsort(a, lo, hi);
                continue;
            }
            --depth_limit;
            int midi = lo + (hi - lo) / 2;
            Comparable mid = a[midi];
            if (hi - lo >= 200) {
                t = (hi - lo) / 8;
                m1 = Qsort.med3(a[lo + t], a[lo + t * 2], a[lo + t * 3]);
                m3 = Qsort.med3(a[midi + t], a[midi + t * 2], a[midi + t * 3]);
            } else {
                t = (hi - lo) / 4;
                m1 = a[lo + t];
                m3 = a[midi + t];
            }
            mid = Qsort.med3(m1, mid, m3);
            if (checklim && hi - lo >= 63) {
                checklim = false;
                int comp1 = m1.compareTo(mid);
                int comp2 = mid.compareTo(m3);
                if (comp1 <= 0 && comp2 <= 0 && Qsort.seqtest(a, lo, hi)) {
                    if (lo != lo1 || hi != hi1) continue;
                    done = true;
                    continue;
                }
                if (comp1 >= 0 && comp2 >= 0 && Qsort.revtest(a, lo, hi)) {
                    if (lo != lo1 || hi != hi1) continue;
                    done = true;
                    continue;
                }
            }
            int p2 = Qsort.partition(a, lo, hi, mid);
            boolean entryUsed = false;
            if (hi - p2 > SIZE_THRESHOLD) {
                entryUsed = true;
                entry[0] = p2;
                entry[1] = hi;
                entry[2] = depth_limit;
                stack.push(entry);
            }
            if (p2 - lo <= SIZE_THRESHOLD) continue;
            if (entryUsed) {
                entry = new int[]{lo, p2, depth_limit};
            }
            stack.push(entry);
        }
        return done;
    }

    private static boolean quicksort_loop(Object[] a, int lo1, int hi1, int depth_limit1, Comparator c) {
        boolean done = false;
        Stack<int[]> stack = new Stack<int[]>();
        int[] entry = new int[]{lo1, hi1, depth_limit1};
        stack.push(entry);
        boolean checklim = true;
        while (stack.size() > 0) {
            Object m3;
            Object m1;
            int t;
            entry = (int[])stack.pop();
            int lo = entry[0];
            int hi = entry[1];
            int depth_limit = entry[2];
            if (depth_limit == 0) {
                Qsort.shellsort(a, lo, hi, c);
                continue;
            }
            --depth_limit;
            int midi = lo + (hi - lo) / 2;
            Object mid = a[midi];
            if (hi - lo >= 200) {
                t = (hi - lo) / 8;
                m1 = Qsort.med3(a[lo + t], a[lo + t * 2], a[lo + t * 3], c);
                m3 = Qsort.med3(a[midi + t], a[midi + t * 2], a[midi + t * 3], c);
            } else {
                t = (hi - lo) / 4;
                m1 = a[lo + t];
                m3 = a[midi + t];
            }
            mid = Qsort.med3(m1, mid, m3, c);
            if (checklim && hi - lo >= 63) {
                checklim = false;
                int comp1 = c.compare(m1, mid);
                int comp2 = c.compare(mid, m3);
                if (comp1 <= 0 && comp2 <= 0 && Qsort.seqtest(a, lo, hi, c)) {
                    if (lo != lo1 || hi != hi1) continue;
                    done = true;
                    continue;
                }
                if (comp1 >= 0 && comp2 >= 0 && Qsort.revtest(a, lo, hi, c)) {
                    if (lo != lo1 || hi != hi1) continue;
                    done = true;
                    continue;
                }
            }
            int p2 = Qsort.partition(a, lo, hi, mid, c);
            boolean entryUsed = false;
            if (hi - p2 > SIZE_THRESHOLD) {
                entryUsed = true;
                entry[0] = p2;
                entry[1] = hi;
                entry[2] = depth_limit;
                stack.push(entry);
            }
            if (p2 - lo <= SIZE_THRESHOLD) continue;
            if (entryUsed) {
                entry = new int[]{lo, p2, depth_limit};
            }
            stack.push(entry);
        }
        return done;
    }

    private static int partition(Comparable[] a, int lo, int hi, Comparable x) {
        int i = lo;
        int j = hi;
        while (true) {
            if (i < hi && a[i].compareTo(x) < 0) {
                ++i;
                continue;
            }
            --j;
            while (j >= lo && x.compareTo(a[j]) < 0) {
                --j;
            }
            if (i >= j) {
                return i;
            }
            Qsort.swap(a, i, j);
            ++i;
        }
    }

    private static int partition(Object[] a, int lo, int hi, Object x, Comparator c) {
        int i = lo;
        int j = hi;
        while (true) {
            if (i < hi && c.compare(a[i], x) < 0) {
                ++i;
                continue;
            }
            --j;
            while (j >= lo && c.compare(x, a[j]) < 0) {
                --j;
            }
            if (i >= j) {
                return i;
            }
            Qsort.swap(a, i, j);
            ++i;
        }
    }

    private static Comparable med3(Comparable lo, Comparable mid, Comparable hi) {
        if (mid.compareTo(lo) < 0) {
            if (hi.compareTo(mid) < 0) {
                return mid;
            }
            if (hi.compareTo(lo) < 0) {
                return hi;
            }
            return lo;
        }
        if (hi.compareTo(mid) < 0) {
            if (hi.compareTo(lo) < 0) {
                return lo;
            }
            return hi;
        }
        return mid;
    }

    private static Object med3(Object lo, Object mid, Object hi, Comparator c) {
        if (c.compare(mid, lo) < 0) {
            if (c.compare(hi, mid) < 0) {
                return mid;
            }
            if (c.compare(hi, lo) < 0) {
                return hi;
            }
            return lo;
        }
        if (c.compare(hi, mid) < 0) {
            if (c.compare(hi, lo) < 0) {
                return lo;
            }
            return hi;
        }
        return mid;
    }

    private static void shellsort(Comparable[] a, int lo, int hi) {
        int size2 = hi - lo + 1;
        int increm = -1;
        for (int i = INCREMENT.length - 1; i > -1; --i) {
            if (INCREMENT[i] >= size2) continue;
            increm = i;
            break;
        }
        while (increm > -1) {
            int loInc;
            int increment = INCREMENT[increm];
            for (int i = loInc = lo + increment; i < hi; ++i) {
                Comparable tmp = a[i];
                for (int j = i; j >= loInc && tmp.compareTo(a[j - increment]) < 0; j -= increment) {
                    a[j] = a[j - increment];
                }
                a[j] = tmp;
            }
            --increm;
        }
    }

    private static void shellsort(Object[] a, int lo, int hi, Comparator c) {
        int size2 = hi - lo + 1;
        int increm = -1;
        for (int i = INCREMENT.length - 1; i > -1; --i) {
            if (INCREMENT[i] >= size2) continue;
            increm = i;
            break;
        }
        while (increm > -1) {
            int loInc;
            int increment = INCREMENT[increm];
            for (int i = loInc = lo + increment; i < hi; ++i) {
                Object tmp = a[i];
                for (int j = i; j >= loInc && c.compare(tmp, a[j - increment]) < 0; j -= increment) {
                    a[j] = a[j - increment];
                }
                a[j] = tmp;
            }
            --increm;
        }
    }

    private static void insertionsort(Comparable[] a, int lo, int hi) {
        for (int i = lo; i < hi; ++i) {
            Comparable t = a[i];
            for (int j = i; j != lo && t.compareTo(a[j - 1]) < 0; --j) {
                a[j] = a[j - 1];
            }
            a[j] = t;
        }
    }

    private static void insertionsort(Object[] a, int lo, int hi, Comparator c) {
        for (int i = lo; i < hi; ++i) {
            Object t = a[i];
            for (int j = i; j != lo && c.compare(t, a[j - 1]) < 0; --j) {
                a[j] = a[j - 1];
            }
            a[j] = t;
        }
    }

    private static void bubbleBoth(Comparable[] a, int lo, int hi) {
        Qsort.bubbleDown(a, lo, hi);
        Qsort.bubbleUp(a, lo, hi);
    }

    private static void bubbleBoth(Object[] a, int lo, int hi, Comparator c) {
        Qsort.bubbleDown(a, lo, hi, c);
        Qsort.bubbleUp(a, lo, hi, c);
    }

    private static void bubbleDown(Comparable[] a, int lo, int hi) {
        int i = lo;
        int end2 = hi - 2;
        while (i < end2 && a[i].compareTo(a[i + 1]) > 0) {
            Qsort.swap(a, i++, i);
        }
    }

    private static void bubbleDown(Object[] a, int lo, int hi, Comparator c) {
        int i = lo;
        int end2 = hi - 2;
        while (i < end2 && c.compare(a[i], a[i + 1]) > 0) {
            Qsort.swap(a, i++, i);
        }
    }

    private static void bubbleUp(Comparable[] a, int lo, int hi) {
        int i = hi - 1;
        int start2 = lo;
        while (i > start2 && a[i].compareTo(a[i - 1]) < 0) {
            Qsort.swap(a, i--, i);
        }
    }

    private static void bubbleUp(Object[] a, int lo, int hi, Comparator c) {
        int i = hi - 1;
        int start2 = lo;
        while (i > start2 && c.compare(a[i], a[i - 1]) < 0) {
            Qsort.swap(a, i--, i);
        }
    }

    private static void swap(Object[] a, int i, int j) {
        Object t = a[i];
        a[i] = a[j];
        a[j] = t;
    }

    private static int floorLog2(int a) {
        return (int)Math.floor(Math.log(a) / Math.log(2.0));
    }
}

