/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpElementAsgnNode
extends Node {
    private final Node receiverNode;
    private final Node argsNode;
    private final Node valueNode;
    public final CallSite callAdapter;
    public final CallSite elementAdapter;
    public final CallSite elementAsgnAdapter;

    public OpElementAsgnNode(ISourcePosition position, Node receiverNode, String operatorName, Node argsNode, Node valueNode) {
        super(position, NodeType.OPELEMENTASGNNODE);
        assert (receiverNode != null) : "receiverNode is not null";
        assert (valueNode != null) : "valueNode is not null";
        this.receiverNode = receiverNode;
        this.argsNode = argsNode;
        if (argsNode instanceof ArrayNode) {
            ((ArrayNode)argsNode).setLightweight(true);
        }
        this.valueNode = valueNode;
        this.callAdapter = MethodIndex.getCallSite(operatorName);
        this.elementAdapter = MethodIndex.getFunctionalCallSite("[]");
        this.elementAsgnAdapter = MethodIndex.getFunctionalCallSite("[]=");
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitOpElementAsgnNode(this);
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    public String getOperatorName() {
        return this.callAdapter.methodName;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    public Node getValueNode() {
        return this.valueNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.argsNode, this.valueNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject receiver2 = this.receiverNode.interpret(runtime2, context, self, aBlock);
        IRubyObject[] args2 = ASTInterpreter.setupArgs(runtime2, context, this.argsNode, self, aBlock);
        IRubyObject value2 = this.elementAdapter.call(context, self, receiver2, args2);
        if (this.getOperatorName() == "||") {
            if (value2.isTrue()) {
                return value2;
            }
            value2 = this.valueNode.interpret(runtime2, context, self, aBlock);
        } else if (this.getOperatorName() == "&&") {
            if (!value2.isTrue()) {
                return value2;
            }
            value2 = this.valueNode.interpret(runtime2, context, self, aBlock);
        } else {
            value2 = this.callAdapter.call(context, self, value2, this.valueNode.interpret(runtime2, context, self, aBlock));
        }
        IRubyObject[] expandedArgs = new IRubyObject[args2.length + 1];
        System.arraycopy(args2, 0, expandedArgs, 0, args2.length);
        expandedArgs[expandedArgs.length - 1] = value2;
        this.elementAsgnAdapter.call(context, self, receiver2, expandedArgs);
        return value2;
    }
}

