/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.util;

import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyKernel;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.WrapperMethod;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaUtil;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.LocalStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.CompiledBlock;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.CompiledBlockLight;
import org.jruby.runtime.CompiledSharedScopeBlock;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;

public class RuntimeHelpers {
    public static final int MAX_SPECIFIC_ARITY_OBJECT_ARRAY = 5;
    public static final int MAX_SPECIFIC_ARITY_HASH = 3;

    public static IRubyObject doAttrAsgn(IRubyObject value2, IRubyObject receiver2, ThreadContext context, IRubyObject caller2, CallSite callSite) {
        callSite.call(context, caller2, receiver2, value2);
        return value2;
    }

    public static IRubyObject doAttrAsgn(IRubyObject value2, IRubyObject receiver2, IRubyObject arg0, ThreadContext context, IRubyObject caller2, CallSite callSite) {
        callSite.call(context, caller2, receiver2, arg0, value2);
        return value2;
    }

    public static IRubyObject doAttrAsgn(IRubyObject value2, IRubyObject receiver2, IRubyObject arg0, IRubyObject arg1, ThreadContext context, IRubyObject caller2, CallSite callSite) {
        callSite.call(context, caller2, receiver2, arg0, arg1, value2);
        return value2;
    }

    public static IRubyObject doAttrAsgn(IRubyObject value2, IRubyObject receiver2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, ThreadContext context, IRubyObject caller2, CallSite callSite) {
        callSite.call(context, caller2, receiver2, arg0, arg1, arg2, value2);
        return value2;
    }

    public static IRubyObject doAttrAsgn(IRubyObject value2, IRubyObject receiver2, IRubyObject[] args2, ThreadContext context, IRubyObject caller2, CallSite callSite) {
        callSite.call(context, caller2, receiver2, RuntimeHelpers.appendToObjectArray(args2, value2));
        return value2;
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver2, CallSite callSite, IRubyObject value2, ThreadContext context, IRubyObject caller2) {
        callSite.call(context, caller2, receiver2, value2);
        return value2;
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver2, CallSite callSite, IRubyObject arg0, IRubyObject value2, ThreadContext context, IRubyObject caller2) {
        callSite.call(context, caller2, receiver2, arg0, value2);
        return value2;
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver2, CallSite callSite, IRubyObject arg0, IRubyObject arg1, IRubyObject value2, ThreadContext context, IRubyObject caller2) {
        callSite.call(context, caller2, receiver2, arg0, arg1, value2);
        return value2;
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver2, CallSite callSite, IRubyObject[] args2, ThreadContext context, IRubyObject caller2) {
        callSite.call(context, caller2, receiver2, args2);
        return args2[args2.length - 1];
    }

    public static IRubyObject invokeEqqForCaseWhen(IRubyObject receiver2, IRubyObject arg2, CallSite callSite, ThreadContext context, IRubyObject caller2) {
        return callSite.call(context, caller2, receiver2, arg2);
    }

    public static CompiledBlockCallback createBlockCallback(Ruby runtime2, Object scriptObject, String closureMethod) {
        Class<?> scriptClass = scriptObject.getClass();
        ClassLoader scriptClassLoader = scriptClass.getClassLoader();
        CallbackFactory factory = CallbackFactory.createFactory(runtime2, scriptClass, scriptClassLoader);
        return factory.getBlockCallback(closureMethod, scriptObject);
    }

    public static BlockBody createCompiledBlockBody(ThreadContext context, Object scriptObject, String closureMethod, int arity2, String[] staticScopeNames, boolean hasMultipleArgsHead, int argsNodeType, boolean light) {
        BlockStaticScope staticScope = new BlockStaticScope(context.getCurrentScope().getStaticScope(), staticScopeNames);
        staticScope.determineModule();
        if (light) {
            return CompiledBlockLight.newCompiledBlockLight(Arity.createArity(arity2), staticScope, RuntimeHelpers.createBlockCallback(context.getRuntime(), scriptObject, closureMethod), hasMultipleArgsHead, argsNodeType);
        }
        return CompiledBlock.newCompiledBlock(Arity.createArity(arity2), staticScope, RuntimeHelpers.createBlockCallback(context.getRuntime(), scriptObject, closureMethod), hasMultipleArgsHead, argsNodeType);
    }

    public static Block createBlock(ThreadContext context, IRubyObject self, BlockBody body) {
        return CompiledBlock.newCompiledClosure(context, self, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject runBeginBlock(ThreadContext context, IRubyObject self, String[] staticScopeNames, CompiledBlockCallback callback) {
        BlockStaticScope staticScope = new BlockStaticScope(context.getCurrentScope().getStaticScope(), staticScopeNames);
        staticScope.determineModule();
        context.preScopedBody(DynamicScope.newDynamicScope(staticScope, context.getCurrentScope()));
        Block block = CompiledBlock.newCompiledClosure(context, self, Arity.createArity(0), staticScope, callback, false, 0);
        try {
            block.yield(context, null);
            Object var7_6 = null;
            context.postScopedBody();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            context.postScopedBody();
            throw throwable;
        }
        return context.getRuntime().getNil();
    }

    public static Block createSharedScopeBlock(ThreadContext context, IRubyObject self, int arity2, CompiledBlockCallback callback, boolean hasMultipleArgsHead, int argsNodeType) {
        return CompiledSharedScopeBlock.newCompiledSharedScopeClosure(context, self, Arity.createArity(arity2), context.getCurrentScope(), callback, hasMultipleArgsHead, argsNodeType);
    }

    public static IRubyObject def(ThreadContext context, IRubyObject self, Object scriptObject, String name2, String javaName, String[] scopeNames, int arity2, int required, int optional, int rest2, CallConfiguration callConfig) {
        Class<?> compiledClass = scriptObject.getClass();
        Ruby runtime2 = context.getRuntime();
        RubyModule containingClass = context.getRubyClass();
        Visibility visibility = context.getCurrentVisibility();
        RuntimeHelpers.performNormalMethodChecks(containingClass, runtime2, name2);
        StaticScope scope = RuntimeHelpers.creatScopeForClass(context, scopeNames, required, optional, rest2);
        MethodFactory factory = MethodFactory.createFactory(compiledClass.getClassLoader());
        DynamicMethod method2 = RuntimeHelpers.constructNormalMethod(name2, visibility, factory, containingClass, javaName, arity2, scope, scriptObject, callConfig);
        RuntimeHelpers.addInstanceMethod(containingClass, name2, method2, visibility, context, runtime2);
        return runtime2.getNil();
    }

    public static IRubyObject defs(ThreadContext context, IRubyObject self, IRubyObject receiver2, Object scriptObject, String name2, String javaName, String[] scopeNames, int arity2, int required, int optional, int rest2, CallConfiguration callConfig) {
        Class<?> compiledClass = scriptObject.getClass();
        Ruby runtime2 = context.getRuntime();
        RubyClass rubyClass = RuntimeHelpers.performSingletonMethodChecks(runtime2, receiver2, name2);
        StaticScope scope = RuntimeHelpers.creatScopeForClass(context, scopeNames, required, optional, rest2);
        MethodFactory factory = MethodFactory.createFactory(compiledClass.getClassLoader());
        DynamicMethod method2 = RuntimeHelpers.constructSingletonMethod(factory, rubyClass, javaName, arity2, scope, scriptObject, callConfig);
        rubyClass.addMethod(name2, method2);
        RuntimeHelpers.callSingletonMethodHook(receiver2, context, runtime2.fastNewSymbol(name2));
        return runtime2.getNil();
    }

    public static RubyClass getSingletonClass(Ruby runtime2, IRubyObject receiver2) {
        if (receiver2 instanceof RubyFixnum || receiver2 instanceof RubySymbol) {
            throw runtime2.newTypeError("no virtual class for " + receiver2.getMetaClass().getBaseName());
        }
        if (runtime2.getSafeLevel() >= 4 && !receiver2.isTaint()) {
            throw runtime2.newSecurityError("Insecure: can't extend object.");
        }
        return receiver2.getSingletonClass();
    }

    public static IRubyObject invokeMethodMissing(IRubyObject receiver2, String name2, IRubyObject[] args2) {
        ThreadContext context = receiver2.getRuntime().getCurrentContext();
        context.setLastCallStatusAndVisibility(CallType.FUNCTIONAL, Visibility.PUBLIC);
        if (name2 == "method_missing") {
            return RubyKernel.method_missing(context, receiver2, args2, Block.NULL_BLOCK);
        }
        IRubyObject[] newArgs = RuntimeHelpers.prepareMethodMissingArgs(args2, context, name2);
        return RuntimeHelpers.invoke(context, receiver2, "method_missing", newArgs, Block.NULL_BLOCK);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver2, DynamicMethod method2, String name2, IRubyObject[] args2, CallType callType, Block block) {
        context.setLastCallStatusAndVisibility(callType, method2.getVisibility());
        return RuntimeHelpers.callMethodMissingInternal(context, receiver2, name2, args2, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver2, DynamicMethod method2, String name2, IRubyObject arg2, CallType callType, Block block) {
        context.setLastCallStatusAndVisibility(callType, method2.getVisibility());
        return RuntimeHelpers.callMethodMissingInternal(context, receiver2, name2, arg2, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver2, DynamicMethod method2, String name2, IRubyObject arg0, IRubyObject arg1, CallType callType, Block block) {
        context.setLastCallStatusAndVisibility(callType, method2.getVisibility());
        return RuntimeHelpers.callMethodMissingInternal(context, receiver2, name2, arg0, arg1, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver2, DynamicMethod method2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, CallType callType, Block block) {
        context.setLastCallStatusAndVisibility(callType, method2.getVisibility());
        return RuntimeHelpers.callMethodMissingInternal(context, receiver2, name2, arg0, arg1, arg2, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver2, DynamicMethod method2, String name2, CallType callType, Block block) {
        context.setLastCallStatusAndVisibility(callType, method2.getVisibility());
        return RuntimeHelpers.callMethodMissingInternal(context, receiver2, name2, block);
    }

    private static IRubyObject callMethodMissingInternal(ThreadContext context, IRubyObject receiver2, String name2, IRubyObject[] args2, Block block) {
        if (name2.equals("method_missing")) {
            return RubyKernel.method_missing(context, receiver2, args2, block);
        }
        IRubyObject[] newArgs = RuntimeHelpers.prepareMethodMissingArgs(args2, context, name2);
        return RuntimeHelpers.invoke(context, receiver2, "method_missing", newArgs, block);
    }

    private static IRubyObject callMethodMissingInternal(ThreadContext context, IRubyObject receiver2, String name2, Block block) {
        if (name2.equals("method_missing")) {
            return RubyKernel.method_missing(context, receiver2, IRubyObject.NULL_ARRAY, block);
        }
        return RuntimeHelpers.invoke(context, receiver2, "method_missing", (IRubyObject)context.getRuntime().newSymbol(name2), block);
    }

    private static IRubyObject callMethodMissingInternal(ThreadContext context, IRubyObject receiver2, String name2, IRubyObject arg0, Block block) {
        if (name2.equals("method_missing")) {
            return RubyKernel.method_missing(context, receiver2, RuntimeHelpers.constructObjectArray(arg0), block);
        }
        return RuntimeHelpers.invoke(context, receiver2, "method_missing", (IRubyObject)context.getRuntime().newSymbol(name2), arg0, block);
    }

    private static IRubyObject callMethodMissingInternal(ThreadContext context, IRubyObject receiver2, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        if (name2.equals("method_missing")) {
            return RubyKernel.method_missing(context, receiver2, RuntimeHelpers.constructObjectArray(arg0, arg1), block);
        }
        return RuntimeHelpers.invoke(context, receiver2, "method_missing", context.getRuntime().newSymbol(name2), arg0, arg1, block);
    }

    private static IRubyObject callMethodMissingInternal(ThreadContext context, IRubyObject receiver2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        if (name2.equals("method_missing")) {
            return RubyKernel.method_missing(context, receiver2, RuntimeHelpers.constructObjectArray(arg0, arg1, arg2), block);
        }
        return RuntimeHelpers.invoke(context, receiver2, "method_missing", RuntimeHelpers.constructObjectArray(context.getRuntime().newSymbol(name2), arg0, arg1, arg2), block);
    }

    private static IRubyObject[] prepareMethodMissingArgs(IRubyObject[] args2, ThreadContext context, String name2) {
        IRubyObject[] newArgs = new IRubyObject[args2.length + 1];
        System.arraycopy(args2, 0, newArgs, 1, args2.length);
        newArgs[0] = context.getRuntime().newSymbol(name2);
        return newArgs;
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, Block block) {
        return self.getMetaClass().finvoke(context, self, name2, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, Block block) {
        return self.getMetaClass().finvoke(context, self, name2, arg0, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return self.getMetaClass().finvoke(context, self, name2, arg0, arg1, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return self.getMetaClass().finvoke(context, self, name2, arg0, arg1, arg2, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject[] args2, Block block) {
        return self.getMetaClass().finvoke(context, self, name2, args2, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name2) {
        return self.getMetaClass().finvoke(context, self, name2);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0) {
        return self.getMetaClass().finvoke(context, self, name2, arg0);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1) {
        return self.getMetaClass().finvoke(context, self, name2, arg0, arg1);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return self.getMetaClass().finvoke(context, self, name2, arg0, arg1, arg2);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject[] args2) {
        return self.getMetaClass().finvoke(context, self, name2, args2);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, CallType callType) {
        return RuntimeHelpers.invoke(context, self, name2, IRubyObject.NULL_ARRAY, callType, Block.NULL_BLOCK);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject[] args2, CallType callType, Block block) {
        return self.getMetaClass().invoke(context, self, name2, args2, callType, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg2, CallType callType, Block block) {
        return self.getMetaClass().invoke(context, self, name2, arg2, callType, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self, String name2, IRubyObject[] args2, Block block) {
        return asClass.finvoke(context, self, name2, args2, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self, String name2, Block block) {
        return asClass.finvoke(context, self, name2, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self, String name2, IRubyObject arg0, Block block) {
        return asClass.finvoke(context, self, name2, arg0, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return asClass.finvoke(context, self, name2, arg0, arg1, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return asClass.finvoke(context, self, name2, arg0, arg1, arg2, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        RubyClass superClass = RuntimeHelpers.findImplementerIfNecessary(self.getMetaClass(), klazz).getSuperClass();
        if (superClass == null) {
            String name2 = context.getFrameName();
            return RuntimeHelpers.callMethodMissing(context, self, klazz.searchMethod(name2), name2, args2, CallType.SUPER, block);
        }
        return RuntimeHelpers.invokeAs(context, superClass, self, context.getFrameName(), args2, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        RubyClass superClass = RuntimeHelpers.findImplementerIfNecessary(self.getMetaClass(), klazz).getSuperClass();
        if (superClass == null) {
            String name2 = context.getFrameName();
            return RuntimeHelpers.callMethodMissing(context, self, klazz.searchMethod(name2), name2, CallType.SUPER, block);
        }
        return RuntimeHelpers.invokeAs(context, superClass, self, context.getFrameName(), block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self, IRubyObject arg0, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        RubyClass superClass = RuntimeHelpers.findImplementerIfNecessary(self.getMetaClass(), klazz).getSuperClass();
        if (superClass == null) {
            String name2 = context.getFrameName();
            return RuntimeHelpers.callMethodMissing(context, self, klazz.searchMethod(name2), name2, arg0, CallType.SUPER, block);
        }
        return RuntimeHelpers.invokeAs(context, superClass, self, context.getFrameName(), arg0, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        RubyClass superClass = RuntimeHelpers.findImplementerIfNecessary(self.getMetaClass(), klazz).getSuperClass();
        if (superClass == null) {
            String name2 = context.getFrameName();
            return RuntimeHelpers.callMethodMissing(context, self, klazz.searchMethod(name2), name2, arg0, arg1, CallType.SUPER, block);
        }
        return RuntimeHelpers.invokeAs(context, superClass, self, context.getFrameName(), arg0, arg1, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        RubyClass superClass = RuntimeHelpers.findImplementerIfNecessary(self.getMetaClass(), klazz).getSuperClass();
        if (superClass == null) {
            String name2 = context.getFrameName();
            return RuntimeHelpers.callMethodMissing(context, self, klazz.searchMethod(name2), name2, arg0, arg1, arg2, CallType.SUPER, block);
        }
        return RuntimeHelpers.invokeAs(context, superClass, self, context.getFrameName(), arg0, arg1, arg2, block);
    }

    public static RubyArray ensureRubyArray(IRubyObject value2) {
        return RuntimeHelpers.ensureRubyArray(value2.getRuntime(), value2);
    }

    public static RubyArray ensureRubyArray(Ruby runtime2, IRubyObject value2) {
        return value2 instanceof RubyArray ? (RubyArray)value2 : RubyArray.newArray(runtime2, value2);
    }

    public static RubyArray ensureMultipleAssignableRubyArray(IRubyObject value2, Ruby runtime2, boolean masgnHasHead) {
        if (!(value2 instanceof RubyArray)) {
            value2 = ArgsUtil.convertToRubyArray(runtime2, value2, masgnHasHead);
        }
        return (RubyArray)value2;
    }

    public static IRubyObject fetchClassVariable(ThreadContext context, Ruby runtime2, IRubyObject self, String name2) {
        RubyModule rubyClass = ASTInterpreter.getClassVariableBase(context, runtime2);
        if (rubyClass == null) {
            rubyClass = self.getMetaClass();
        }
        return rubyClass.getClassVar(name2);
    }

    public static IRubyObject fastFetchClassVariable(ThreadContext context, Ruby runtime2, IRubyObject self, String internedName) {
        RubyModule rubyClass = ASTInterpreter.getClassVariableBase(context, runtime2);
        if (rubyClass == null) {
            rubyClass = self.getMetaClass();
        }
        return rubyClass.fastGetClassVar(internedName);
    }

    public static IRubyObject getConstant(ThreadContext context, String internedName) {
        Ruby runtime2 = context.getRuntime();
        return context.getCurrentScope().getStaticScope().getConstantWithConstMissing(runtime2, internedName, runtime2.getObject());
    }

    public static IRubyObject nullToNil(IRubyObject value2, Ruby runtime2) {
        return value2 != null ? value2 : runtime2.getNil();
    }

    public static RubyClass prepareSuperClass(Ruby runtime2, IRubyObject rubyClass) {
        RubyClass.checkInheritable(rubyClass);
        return (RubyClass)rubyClass;
    }

    public static RubyModule prepareClassNamespace(ThreadContext context, IRubyObject rubyModule) {
        if ((rubyModule == null || rubyModule.isNil()) && (rubyModule = context.getCurrentScope().getStaticScope().getModule()) == null) {
            throw context.getRuntime().newTypeError("no outer class/module");
        }
        if (rubyModule instanceof RubyModule) {
            return (RubyModule)rubyModule;
        }
        throw context.getRuntime().newTypeError(rubyModule + " is not a class/module");
    }

    public static IRubyObject setClassVariable(ThreadContext context, Ruby runtime2, IRubyObject self, String name2, IRubyObject value2) {
        RubyModule rubyClass = ASTInterpreter.getClassVariableBase(context, runtime2);
        if (rubyClass == null) {
            rubyClass = self.getMetaClass();
        }
        rubyClass.setClassVar(name2, value2);
        return value2;
    }

    public static IRubyObject fastSetClassVariable(ThreadContext context, Ruby runtime2, IRubyObject self, String internedName, IRubyObject value2) {
        RubyModule rubyClass = ASTInterpreter.getClassVariableBase(context, runtime2);
        if (rubyClass == null) {
            rubyClass = self.getMetaClass();
        }
        rubyClass.fastSetClassVar(internedName, value2);
        return value2;
    }

    public static IRubyObject declareClassVariable(ThreadContext context, Ruby runtime2, IRubyObject self, String name2, IRubyObject value2) {
        RubyModule rubyClass = ASTInterpreter.getClassVariableBase(context, runtime2);
        if (rubyClass == null) {
            throw runtime2.newTypeError("no class/module to define class variable");
        }
        rubyClass.setClassVar(name2, value2);
        return value2;
    }

    public static IRubyObject fastDeclareClassVariable(ThreadContext context, Ruby runtime2, IRubyObject self, String internedName, IRubyObject value2) {
        RubyModule rubyClass = ASTInterpreter.getClassVariableBase(context, runtime2);
        if (rubyClass == null) {
            throw runtime2.newTypeError("no class/module to define class variable");
        }
        rubyClass.fastSetClassVar(internedName, value2);
        return value2;
    }

    public static void handleArgumentSizes(ThreadContext context, Ruby runtime2, int given, int required, int opt, int rest2) {
        if (opt == 0) {
            if (rest2 < 0 ? given != required : given < required) {
                throw runtime2.newArgumentError("wrong # of arguments(" + given + " for " + required + ")");
            }
        } else if (rest2 < 0) {
            if (given < required) {
                throw runtime2.newArgumentError("wrong # of arguments(" + given + " for " + required + ")");
            }
            if (given > required + opt) {
                throw runtime2.newArgumentError("wrong # of arguments(" + given + " for " + (required + opt) + ")");
            }
        } else if (given < required) {
            throw runtime2.newArgumentError("wrong # of arguments(" + given + " for " + required + ")");
        }
    }

    public static Throwable unwrapRedoNextBreakOrJustLocalJump(RaiseException re, ThreadContext context) {
        RubyException exception2 = re.getException();
        if (context.getRuntime().getLocalJumpError().isInstance(exception2)) {
            RubyLocalJumpError jumpError = (RubyLocalJumpError)re.getException();
            switch (jumpError.getReason()) {
                case REDO: {
                    return JumpException.REDO_JUMP;
                }
                case NEXT: {
                    return new JumpException.NextJump(jumpError.exit_value());
                }
                case BREAK: {
                    return new JumpException.BreakJump(context.getFrameJumpTarget(), jumpError.exit_value());
                }
            }
        }
        return re;
    }

    public static String getLocalJumpTypeOrRethrow(RaiseException re) {
        RubyException exception2 = re.getException();
        Ruby runtime2 = exception2.getRuntime();
        if (runtime2.getLocalJumpError().isInstance(exception2)) {
            RubyLocalJumpError jumpError = (RubyLocalJumpError)re.getException();
            IRubyObject reason2 = jumpError.reason();
            return reason2.asJavaString();
        }
        throw re;
    }

    public static IRubyObject unwrapLocalJumpErrorValue(RaiseException re) {
        return ((RubyLocalJumpError)re.getException()).exit_value();
    }

    public static IRubyObject processBlockArgument(Ruby runtime2, Block block) {
        if (!block.isGiven()) {
            return runtime2.getNil();
        }
        return RuntimeHelpers.processGivenBlock(block, runtime2);
    }

    private static IRubyObject processGivenBlock(Block block, Ruby runtime2) {
        RubyProc blockArg = block.getProcObject();
        if (blockArg == null) {
            blockArg = runtime2.newBlockPassProc(Block.Type.PROC, block);
            blockArg.getBlock().type = Block.Type.PROC;
        }
        return blockArg;
    }

    public static Block getBlockFromBlockPassBody(Ruby runtime2, IRubyObject proc2, Block currentBlock) {
        if (proc2.isNil()) {
            return Block.NULL_BLOCK;
        }
        if (!(proc2 instanceof RubyProc)) {
            proc2 = RuntimeHelpers.coerceProc(proc2, runtime2);
        }
        return RuntimeHelpers.getBlockFromProc(currentBlock, proc2);
    }

    private static IRubyObject coerceProc(IRubyObject proc2, Ruby runtime2) throws RaiseException {
        if (!((proc2 = TypeConverter.convertToType(proc2, runtime2.getProc(), "to_proc", false)) instanceof RubyProc)) {
            throw runtime2.newTypeError("wrong argument type " + proc2.getMetaClass().getName() + " (expected Proc)");
        }
        return proc2;
    }

    private static Block getBlockFromProc(Block currentBlock, IRubyObject proc2) {
        RubyProc procObject;
        if (currentBlock != null && currentBlock.isGiven() && (procObject = currentBlock.getProcObject()) != null && procObject == proc2) {
            return currentBlock;
        }
        return ((RubyProc)proc2).getBlock();
    }

    public static Block getBlockFromBlockPassBody(IRubyObject proc2, Block currentBlock) {
        return RuntimeHelpers.getBlockFromBlockPassBody(proc2.getRuntime(), proc2, currentBlock);
    }

    public static IRubyObject backref(ThreadContext context) {
        IRubyObject backref = context.getCurrentFrame().getBackRef();
        if (backref instanceof RubyMatchData) {
            ((RubyMatchData)backref).use();
        }
        return backref;
    }

    public static IRubyObject backrefLastMatch(ThreadContext context) {
        IRubyObject backref = context.getCurrentFrame().getBackRef();
        return RubyRegexp.last_match(backref);
    }

    public static IRubyObject backrefMatchPre(ThreadContext context) {
        IRubyObject backref = context.getCurrentFrame().getBackRef();
        return RubyRegexp.match_pre(backref);
    }

    public static IRubyObject backrefMatchPost(ThreadContext context) {
        IRubyObject backref = context.getCurrentFrame().getBackRef();
        return RubyRegexp.match_post(backref);
    }

    public static IRubyObject backrefMatchLast(ThreadContext context) {
        IRubyObject backref = context.getCurrentFrame().getBackRef();
        return RubyRegexp.match_last(backref);
    }

    public static IRubyObject callZSuper(Ruby runtime2, ThreadContext context, Block block, IRubyObject self) {
        RuntimeHelpers.checkSuperDisabledOrOutOfMethod(context);
        if (!block.isGiven()) {
            block = context.getCurrentFrame().getBlock();
        }
        return RuntimeHelpers.invokeSuper(context, self, context.getCurrentScope().getArgValues(), block);
    }

    public static IRubyObject[] appendToObjectArray(IRubyObject[] array, IRubyObject add3) {
        IRubyObject[] newArray = new IRubyObject[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = add3;
        return newArray;
    }

    public static JumpException.ReturnJump returnJump(IRubyObject result, ThreadContext context) {
        return context.returnJump(result);
    }

    public static IRubyObject breakJumpInWhile(JumpException.BreakJump bj, ThreadContext context) {
        if (bj.getTarget() == context.getFrameJumpTarget()) {
            return (IRubyObject)bj.getValue();
        }
        throw bj;
    }

    public static IRubyObject breakJump(ThreadContext context, IRubyObject value2) {
        throw new JumpException.BreakJump(context.getFrameJumpTarget(), value2);
    }

    public static IRubyObject breakLocalJumpError(Ruby runtime2, IRubyObject value2) {
        throw runtime2.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, value2, "unexpected break");
    }

    public static IRubyObject[] concatObjectArrays(IRubyObject[] array, IRubyObject[] add3) {
        IRubyObject[] newArray = new IRubyObject[array.length + add3.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        System.arraycopy(add3, 0, newArray, array.length, add3.length);
        return newArray;
    }

    public static IRubyObject isExceptionHandled(RubyException currentException, IRubyObject[] exceptions, Ruby runtime2, ThreadContext context, IRubyObject self) {
        for (int i = 0; i < exceptions.length; ++i) {
            if (!runtime2.getModule().isInstance(exceptions[i])) {
                throw runtime2.newTypeError("class or module required for rescue clause");
            }
            IRubyObject result = exceptions[i].callMethod(context, "===", currentException);
            if (!result.isTrue()) continue;
            return result;
        }
        return runtime2.getFalse();
    }

    public static IRubyObject isJavaExceptionHandled(Exception currentException, IRubyObject[] exceptions, Ruby runtime2, ThreadContext context, IRubyObject self) {
        if (currentException instanceof RaiseException) {
            return RuntimeHelpers.isExceptionHandled(((RaiseException)currentException).getException(), exceptions, runtime2, context, self);
        }
        for (int i = 0; i < exceptions.length; ++i) {
            Class cls;
            RubyClass rubyClass;
            JavaClass javaClass;
            if (!(exceptions[i] instanceof RubyClass) || (javaClass = (JavaClass)(rubyClass = (RubyClass)exceptions[i]).fastGetInstanceVariable("@java_class")) == null || !(cls = javaClass.javaClass()).isInstance(currentException)) continue;
            return runtime2.getTrue();
        }
        return runtime2.getFalse();
    }

    public static void storeExceptionInErrorInfo(Exception currentException, ThreadContext context) {
        IRubyObject exception2 = null;
        exception2 = currentException instanceof RaiseException ? ((RaiseException)currentException).getException() : JavaUtil.convertJavaToUsableRubyObject(context.getRuntime(), currentException);
        context.setErrorInfo(exception2);
    }

    public static void clearErrorInfo(ThreadContext context) {
        context.setErrorInfo(context.getRuntime().getNil());
    }

    public static void checkSuperDisabledOrOutOfMethod(ThreadContext context) {
        if (context.getFrameKlazz() == null) {
            String name2 = context.getFrameName();
            if (name2 != null) {
                throw context.getRuntime().newNameError("superclass method '" + name2 + "' disabled", name2);
            }
            throw context.getRuntime().newNoMethodError("super called outside of method", null, context.getRuntime().getNil());
        }
    }

    public static Block ensureSuperBlock(Block given, Block parent) {
        if (!given.isGiven()) {
            return parent;
        }
        return given;
    }

    public static RubyModule findImplementerIfNecessary(RubyModule clazz, RubyModule implementationClass) {
        if (implementationClass != null && implementationClass.needsImplementer()) {
            return clazz.findImplementer(implementationClass);
        }
        return implementationClass;
    }

    public static RubyArray createSubarray(RubyArray input, int start2) {
        return (RubyArray)input.subseqLight(start2, input.size() - start2);
    }

    public static RubyArray createSubarray(IRubyObject[] input, Ruby runtime2, int start2) {
        return RubyArray.newArrayNoCopy(runtime2, input, start2);
    }

    public static RubyBoolean isWhenTriggered(IRubyObject expression, IRubyObject expressionsObject, ThreadContext context) {
        RubyArray expressions = RuntimeHelpers.splatValue(expressionsObject);
        int k = expressions.getLength();
        for (int j = 0; j < k; ++j) {
            IRubyObject condition = expressions.eltInternal(j);
            if ((expression == null || !condition.callMethod(context, "===", expression).isTrue()) && (expression != null || !condition.isTrue())) continue;
            return context.getRuntime().getTrue();
        }
        return context.getRuntime().getFalse();
    }

    public static IRubyObject setConstantInModule(IRubyObject module, IRubyObject value2, String name2, ThreadContext context) {
        return context.setConstantInModule(name2, module, value2);
    }

    public static IRubyObject retryJump() {
        throw JumpException.RETRY_JUMP;
    }

    public static IRubyObject redoJump() {
        throw JumpException.REDO_JUMP;
    }

    public static IRubyObject redoLocalJumpError(Ruby runtime2) {
        throw runtime2.newLocalJumpError(RubyLocalJumpError.Reason.REDO, runtime2.getNil(), "unexpected redo");
    }

    public static IRubyObject nextJump(IRubyObject value2) {
        throw new JumpException.NextJump(value2);
    }

    public static IRubyObject nextLocalJumpError(Ruby runtime2, IRubyObject value2) {
        throw runtime2.newLocalJumpError(RubyLocalJumpError.Reason.NEXT, value2, "unexpected next");
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one) {
        return new IRubyObject[]{one};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two) {
        return new IRubyObject[]{one, two};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three) {
        return new IRubyObject[]{one, two, three};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four) {
        return new IRubyObject[]{one, two, three, four};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five) {
        return new IRubyObject[]{one, two, three, four, five};
    }

    public static String[] constructStringArray(String one) {
        return new String[]{one};
    }

    public static String[] constructStringArray(String one, String two) {
        return new String[]{one, two};
    }

    public static String[] constructStringArray(String one, String two, String three) {
        return new String[]{one, two, three};
    }

    public static String[] constructStringArray(String one, String two, String three, String four) {
        return new String[]{one, two, three, four};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five) {
        return new String[]{one, two, three, four, five};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six) {
        return new String[]{one, two, three, four, five, six};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six, String seven) {
        return new String[]{one, two, three, four, five, six, seven};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six, String seven, String eight) {
        return new String[]{one, two, three, four, five, six, seven, eight};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six, String seven, String eight, String nine) {
        return new String[]{one, two, three, four, five, six, seven, eight, nine};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six, String seven, String eight, String nine, String ten) {
        return new String[]{one, two, three, four, five, six, seven, eight, nine, ten};
    }

    public static RubyHash constructHash(Ruby runtime2, IRubyObject key1, IRubyObject value1) {
        RubyHash hash2 = RubyHash.newHash(runtime2);
        hash2.fastASet(key1, value1);
        return hash2;
    }

    public static RubyHash constructHash(Ruby runtime2, IRubyObject key1, IRubyObject value1, IRubyObject key2, IRubyObject value2) {
        RubyHash hash2 = RubyHash.newHash(runtime2);
        hash2.fastASet(key1, value1);
        hash2.fastASet(key2, value2);
        return hash2;
    }

    public static RubyHash constructHash(Ruby runtime2, IRubyObject key1, IRubyObject value1, IRubyObject key2, IRubyObject value2, IRubyObject key3, IRubyObject value3) {
        RubyHash hash2 = RubyHash.newHash(runtime2);
        hash2.fastASet(key1, value1);
        hash2.fastASet(key2, value2);
        hash2.fastASet(key3, value3);
        return hash2;
    }

    public static IRubyObject defineAlias(ThreadContext context, String newName, String oldName) {
        Ruby runtime2 = context.getRuntime();
        RubyModule module = context.getRubyClass();
        if (module == null) {
            throw runtime2.newTypeError("no class to make alias");
        }
        module.defineAlias(newName, oldName);
        module.callMethod(context, "method_added", runtime2.newSymbol(newName));
        return runtime2.getNil();
    }

    public static IRubyObject negate(IRubyObject value2, Ruby runtime2) {
        if (value2.isTrue()) {
            return runtime2.getFalse();
        }
        return runtime2.getTrue();
    }

    public static IRubyObject stringOrNil(String value2, Ruby runtime2, IRubyObject nil) {
        if (value2 == null) {
            return nil;
        }
        return RubyString.newString(runtime2, value2);
    }

    public static void preLoad(ThreadContext context, String[] varNames) {
        LocalStaticScope staticScope = new LocalStaticScope(null, varNames);
        staticScope.setModule(context.getRuntime().getObject());
        DynamicScope scope = DynamicScope.newDynamicScope(staticScope);
        context.preScopedBody(scope);
    }

    public static void postLoad(ThreadContext context) {
        context.postScopedBody();
    }

    public static void registerEndBlock(Block block, Ruby runtime2) {
        runtime2.pushExitBlock(runtime2.newProc(Block.Type.LAMBDA, block));
    }

    public static IRubyObject match3(RubyRegexp regexp2, IRubyObject value2, ThreadContext context) {
        if (value2 instanceof RubyString) {
            return regexp2.op_match(context, value2);
        }
        return value2.callMethod(context, "=~", regexp2);
    }

    public static IRubyObject getErrorInfo(Ruby runtime2) {
        return runtime2.getGlobalVariables().get("$!");
    }

    public static void setErrorInfo(Ruby runtime2, IRubyObject error) {
        runtime2.getGlobalVariables().set("$!", error);
    }

    public static IRubyObject setLastLine(Ruby runtime2, ThreadContext context, IRubyObject value2) {
        return context.getCurrentFrame().setLastLine(value2);
    }

    public static IRubyObject getLastLine(Ruby runtime2, ThreadContext context) {
        return context.getCurrentFrame().getLastLine();
    }

    public static IRubyObject setBackref(Ruby runtime2, ThreadContext context, IRubyObject value2) {
        if (!value2.isNil() && !(value2 instanceof RubyMatchData)) {
            throw runtime2.newTypeError(value2, runtime2.getMatchData());
        }
        return context.getCurrentFrame().setBackRef(value2);
    }

    public static IRubyObject getBackref(Ruby runtime2, ThreadContext context) {
        IRubyObject backref = context.getCurrentFrame().getBackRef();
        if (backref instanceof RubyMatchData) {
            ((RubyMatchData)backref).use();
        }
        return backref;
    }

    public static IRubyObject preOpAsgnWithOrAnd(IRubyObject receiver2, ThreadContext context, IRubyObject self, CallSite varSite) {
        return varSite.call(context, self, receiver2);
    }

    public static IRubyObject postOpAsgnWithOrAnd(IRubyObject receiver2, IRubyObject value2, ThreadContext context, IRubyObject self, CallSite varAsgnSite) {
        varAsgnSite.call(context, self, receiver2, value2);
        return value2;
    }

    public static IRubyObject opAsgnWithMethod(ThreadContext context, IRubyObject self, IRubyObject receiver2, IRubyObject arg2, CallSite varSite, CallSite opSite, CallSite opAsgnSite) {
        IRubyObject var = varSite.call(context, self, receiver2);
        IRubyObject result = opSite.call(context, self, var, arg2);
        opAsgnSite.call(context, self, receiver2, result);
        return result;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext context, IRubyObject self, IRubyObject receiver2, IRubyObject value2, CallSite elementSite, CallSite opSite, CallSite elementAsgnSite) {
        IRubyObject var = elementSite.call(context, self, receiver2);
        IRubyObject result = opSite.call(context, self, var, value2);
        elementAsgnSite.call(context, self, receiver2, result);
        return result;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext context, IRubyObject self, IRubyObject receiver2, IRubyObject arg2, IRubyObject value2, CallSite elementSite, CallSite opSite, CallSite elementAsgnSite) {
        IRubyObject var = elementSite.call(context, self, receiver2, arg2);
        IRubyObject result = opSite.call(context, self, var, value2);
        elementAsgnSite.call(context, self, receiver2, arg2, result);
        return result;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext context, IRubyObject self, IRubyObject receiver2, IRubyObject arg1, IRubyObject arg2, IRubyObject value2, CallSite elementSite, CallSite opSite, CallSite elementAsgnSite) {
        IRubyObject var = elementSite.call(context, self, receiver2, arg1, arg2);
        IRubyObject result = opSite.call(context, self, var, value2);
        elementAsgnSite.call(context, self, receiver2, arg1, arg2, result);
        return result;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext context, IRubyObject self, IRubyObject receiver2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject value2, CallSite elementSite, CallSite opSite, CallSite elementAsgnSite) {
        IRubyObject var = elementSite.call(context, self, receiver2, arg1, arg2, arg3);
        IRubyObject result = opSite.call(context, self, var, value2);
        elementAsgnSite.call(context, self, receiver2, arg1, arg2, arg3, result);
        return result;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext context, IRubyObject self, IRubyObject receiver2, IRubyObject[] args2, IRubyObject value2, CallSite elementSite, CallSite opSite, CallSite elementAsgnSite) {
        IRubyObject var = elementSite.call(context, self, receiver2);
        IRubyObject result = opSite.call(context, self, var, value2);
        elementAsgnSite.call(context, self, receiver2, RuntimeHelpers.appendToObjectArray(args2, result));
        return result;
    }

    public static IRubyObject opElementAsgnWithOrPartTwoOneArg(ThreadContext context, IRubyObject self, IRubyObject receiver2, IRubyObject arg2, IRubyObject value2, CallSite asetSite) {
        asetSite.call(context, self, receiver2, arg2, value2);
        return value2;
    }

    public static IRubyObject opElementAsgnWithOrPartTwoTwoArgs(ThreadContext context, IRubyObject self, IRubyObject receiver2, IRubyObject[] args2, IRubyObject value2, CallSite asetSite) {
        asetSite.call(context, self, receiver2, args2[0], args2[1], value2);
        return value2;
    }

    public static IRubyObject opElementAsgnWithOrPartTwoThreeArgs(ThreadContext context, IRubyObject self, IRubyObject receiver2, IRubyObject[] args2, IRubyObject value2, CallSite asetSite) {
        asetSite.call(context, self, receiver2, args2[0], args2[1], args2[2], value2);
        return value2;
    }

    public static IRubyObject opElementAsgnWithOrPartTwoNArgs(ThreadContext context, IRubyObject self, IRubyObject receiver2, IRubyObject[] args2, IRubyObject value2, CallSite asetSite) {
        IRubyObject[] newArgs = new IRubyObject[args2.length + 1];
        System.arraycopy(args2, 0, newArgs, 0, args2.length);
        newArgs[args2.length] = value2;
        asetSite.call(context, self, receiver2, newArgs);
        return value2;
    }

    public static RubyArray arrayValue(IRubyObject value2) {
        IRubyObject tmp = value2.checkArrayType();
        if (tmp.isNil()) {
            Ruby runtime2 = value2.getRuntime();
            if (value2.getMetaClass().searchMethod("to_a").getImplementationClass() != runtime2.getKernel()) {
                if (!((value2 = value2.callMethod(runtime2.getCurrentContext(), "to_a")) instanceof RubyArray)) {
                    throw runtime2.newTypeError("`to_a' did not return Array");
                }
                return (RubyArray)value2;
            }
            return runtime2.newArray(value2);
        }
        return (RubyArray)tmp;
    }

    public static IRubyObject aryToAry(IRubyObject value2) {
        if (value2 instanceof RubyArray) {
            return value2;
        }
        if (value2.respondsTo("to_ary")) {
            return TypeConverter.convertToType(value2, value2.getRuntime().getArray(), "to_ary", false);
        }
        return value2.getRuntime().newArray(value2);
    }

    public static IRubyObject aValueSplat(IRubyObject value2) {
        if (!(value2 instanceof RubyArray) || ((RubyArray)value2).length().getLongValue() == 0L) {
            return value2.getRuntime().getNil();
        }
        RubyArray array = (RubyArray)value2;
        return array.getLength() == 1 ? array.first() : array;
    }

    public static RubyArray splatValue(IRubyObject value2) {
        if (value2.isNil()) {
            return value2.getRuntime().newArray(value2);
        }
        return RuntimeHelpers.arrayValue(value2);
    }

    public static void addInstanceMethod(RubyModule containingClass, String name2, DynamicMethod method2, Visibility visibility, ThreadContext context, Ruby runtime2) {
        containingClass.addMethod(name2, method2);
        RubySymbol sym = runtime2.fastNewSymbol(name2);
        if (visibility == Visibility.MODULE_FUNCTION) {
            RuntimeHelpers.addModuleMethod(containingClass, name2, method2, context, sym);
        }
        RuntimeHelpers.callNormalMethodHook(containingClass, context, sym);
    }

    private static void addModuleMethod(RubyModule containingClass, String name2, DynamicMethod method2, ThreadContext context, RubySymbol sym) {
        containingClass.getSingletonClass().addMethod(name2, new WrapperMethod((RubyModule)containingClass.getSingletonClass(), method2, Visibility.PUBLIC));
        containingClass.callMethod(context, "singleton_method_added", sym);
    }

    private static void callNormalMethodHook(RubyModule containingClass, ThreadContext context, RubySymbol name2) {
        if (containingClass.isSingleton()) {
            RuntimeHelpers.callSingletonMethodHook(((MetaClass)containingClass).getAttached(), context, name2);
        } else {
            containingClass.callMethod(context, "method_added", name2);
        }
    }

    private static void callSingletonMethodHook(IRubyObject receiver2, ThreadContext context, RubySymbol name2) {
        receiver2.callMethod(context, "singleton_method_added", name2);
    }

    private static DynamicMethod constructNormalMethod(String name2, Visibility visibility, MethodFactory factory, RubyModule containingClass, String javaName, int arity2, StaticScope scope, Object scriptObject, CallConfiguration callConfig) {
        if (name2.equals("initialize") || name2.equals("initialize_copy") || visibility == Visibility.MODULE_FUNCTION) {
            visibility = Visibility.PRIVATE;
        }
        DynamicMethod method2 = RubyInstanceConfig.LAZYHANDLES_COMPILE ? factory.getCompiledMethodLazily(containingClass, javaName, Arity.createArity(arity2), visibility, scope, scriptObject, callConfig) : factory.getCompiledMethod(containingClass, javaName, Arity.createArity(arity2), visibility, scope, scriptObject, callConfig);
        return method2;
    }

    private static DynamicMethod constructSingletonMethod(MethodFactory factory, RubyClass rubyClass, String javaName, int arity2, StaticScope scope, Object scriptObject, CallConfiguration callConfig) {
        return factory.getCompiledMethodLazily(rubyClass, javaName, Arity.createArity(arity2), Visibility.PUBLIC, scope, scriptObject, callConfig);
    }

    private static StaticScope creatScopeForClass(ThreadContext context, String[] scopeNames, int required, int optional, int rest2) {
        LocalStaticScope scope = new LocalStaticScope(context.getCurrentScope().getStaticScope(), scopeNames);
        scope.determineModule();
        scope.setArities(required, optional, rest2);
        return scope;
    }

    private static void performNormalMethodChecks(RubyModule containingClass, Ruby runtime2, String name2) throws RaiseException {
        if (containingClass == runtime2.getDummy()) {
            throw runtime2.newTypeError("no class/module to add method");
        }
        if (containingClass == runtime2.getObject() && name2.equals("initialize")) {
            runtime2.getWarnings().warn(IRubyWarnings.ID.REDEFINING_DANGEROUS, "redefining Object#initialize may cause infinite loop", "Object#initialize");
        }
        if (name2.equals("__id__") || name2.equals("__send__")) {
            runtime2.getWarnings().warn(IRubyWarnings.ID.REDEFINING_DANGEROUS, "redefining `" + name2 + "' may cause serious problem", name2);
        }
    }

    private static RubyClass performSingletonMethodChecks(Ruby runtime2, IRubyObject receiver2, String name2) throws RaiseException {
        if (runtime2.getSafeLevel() >= 4 && !receiver2.isTaint()) {
            throw runtime2.newSecurityError("Insecure; can't define singleton method.");
        }
        if (receiver2 instanceof RubyFixnum || receiver2 instanceof RubySymbol) {
            throw runtime2.newTypeError("can't define singleton method \"" + name2 + "\" for " + receiver2.getMetaClass().getBaseName());
        }
        if (receiver2.isFrozen()) {
            throw runtime2.newFrozenError("object");
        }
        RubyClass rubyClass = receiver2.getSingletonClass();
        if (runtime2.getSafeLevel() >= 4 && rubyClass.getMethods().get(name2) != null) {
            throw runtime2.newSecurityError("redefining method prohibited.");
        }
        return rubyClass;
    }

    public static IRubyObject arrayEntryOrNil(RubyArray array, IRubyObject nil, int index2) {
        if (index2 < array.getLength()) {
            return array.entry(index2);
        }
        return nil;
    }

    public static RubyArray subarrayOrEmpty(RubyArray array, Ruby runtime2, int index2) {
        if (index2 < array.getLength()) {
            return RuntimeHelpers.createSubarray(array, index2);
        }
        return RubyArray.newEmptyArray(runtime2);
    }

    public static RubyModule checkIsModule(IRubyObject maybeModule) {
        if (maybeModule instanceof RubyModule) {
            return (RubyModule)maybeModule;
        }
        throw maybeModule.getRuntime().newTypeError(maybeModule + " is not a class/module");
    }

    public static IRubyObject getGlobalVariable(Ruby runtime2, String name2) {
        return runtime2.getGlobalVariables().get(name2);
    }

    public static IRubyObject setGlobalVariable(IRubyObject value2, Ruby runtime2, String name2) {
        return runtime2.getGlobalVariables().set(name2, value2);
    }

    public static IRubyObject getInstanceVariable(IRubyObject self, Ruby runtime2, String internedName) {
        IRubyObject result = self.getInstanceVariables().fastGetInstanceVariable(internedName);
        if (result == null) {
            runtime2.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, "instance variable " + internedName + " not initialized", new Object[0]);
            return runtime2.getNil();
        }
        return result;
    }

    public static IRubyObject setInstanceVariable(IRubyObject value2, IRubyObject self, String name2) {
        return self.getInstanceVariables().fastSetInstanceVariable(name2, value2);
    }
}

