/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.addons;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyIO;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.PipeException;

public class IOJavaAddons {
    @JRubyMethod
    public static IRubyObject to_inputstream(ThreadContext context, IRubyObject self) {
        RubyIO io2 = (RubyIO)self;
        Ruby runtime2 = context.getRuntime();
        try {
            io2.getOpenFile().checkReadable(context.getRuntime());
        }
        catch (PipeException pe) {
            throw runtime2.newErrnoEPIPEError();
        }
        catch (IOException ex) {
            throw runtime2.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime2.newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw runtime2.newErrnoEINVALError();
        }
        return JavaUtil.convertJavaToUsableRubyObject(context.getRuntime(), io2.getInStream());
    }

    @JRubyMethod
    public static IRubyObject to_outputstream(ThreadContext context, IRubyObject self) {
        RubyIO io2 = (RubyIO)self;
        Ruby runtime2 = context.getRuntime();
        try {
            io2.getOpenFile().checkWritable(context.getRuntime());
        }
        catch (PipeException pe) {
            throw runtime2.newErrnoEPIPEError();
        }
        catch (IOException ex) {
            throw runtime2.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime2.newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw runtime2.newErrnoEINVALError();
        }
        return JavaUtil.convertJavaToUsableRubyObject(context.getRuntime(), io2.getOutStream());
    }

    @JRubyMethod
    public static IRubyObject to_channel(ThreadContext context, IRubyObject self) {
        RubyIO io2 = (RubyIO)self;
        return JavaUtil.convertJavaToUsableRubyObject(context.getRuntime(), io2.getChannel());
    }
}

