/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaClass;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Java::JavaObject"})
public class JavaObject
extends RubyObject {
    private static Object NULL_LOCK = new Object();

    protected JavaObject(Ruby runtime2, RubyClass rubyClass, Object value2) {
        super(runtime2, rubyClass);
        this.dataStruct = value2;
    }

    protected JavaObject(Ruby runtime2, Object value2) {
        this(runtime2, runtime2.getJavaSupport().getJavaObjectClass(), value2);
    }

    public static JavaObject wrap(Ruby runtime2, Object value2) {
        if (value2 != null) {
            if (value2 instanceof Class) {
                return JavaClass.get(runtime2, (Class)value2);
            }
            if (value2.getClass().isArray()) {
                return new JavaArray(runtime2, value2);
            }
        }
        return new JavaObject(runtime2, value2);
    }

    @Override
    public Class<?> getJavaClass() {
        return this.dataStruct != null ? this.dataStruct.getClass() : Void.TYPE;
    }

    public Object getValue() {
        return this.dataStruct;
    }

    public static RubyClass createJavaObjectClass(Ruby runtime2, RubyModule javaModule) {
        RubyClass result = javaModule.defineClassUnder("JavaObject", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        JavaObject.registerRubyMethods(runtime2, result);
        result.getMetaClass().undefineMethod("new");
        result.getMetaClass().undefineMethod("allocate");
        result.setMarshal(ObjectMarshal.NOT_MARSHALABLE_MARSHAL);
        return result;
    }

    protected static void registerRubyMethods(Ruby runtime2, RubyClass result) {
        result.defineAnnotatedMethods(JavaObject.class);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof JavaObject && this.dataStruct == ((JavaObject)other).dataStruct;
    }

    @Override
    public int hashCode() {
        if (this.dataStruct != null) {
            return this.dataStruct.hashCode();
        }
        return 0;
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    @Override
    @JRubyMethod
    public IRubyObject to_s() {
        if (this.dataStruct != null) {
            String stringValue = this.dataStruct.toString();
            if (stringValue != null) {
                return RubyString.newUnicodeString(this.getRuntime(), this.dataStruct.toString());
            }
            return this.getRuntime().getNil();
        }
        return RubyString.newEmptyString(this.getRuntime());
    }

    @JRubyMethod(name={"==", "eql?"}, required=1)
    public IRubyObject op_equal(IRubyObject other) {
        if (!(other instanceof JavaObject) && !((other = (JavaObject)other.dataGetStruct()) instanceof JavaObject)) {
            return this.getRuntime().getFalse();
        }
        if (this.getValue() == null && ((JavaObject)other).getValue() == null) {
            return this.getRuntime().getTrue();
        }
        boolean isEqual = this.getValue().equals(((JavaObject)other).getValue());
        return isEqual ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"equal?"}, required=1)
    public IRubyObject same(IRubyObject other) {
        if (!(other instanceof JavaObject) && !((other = (JavaObject)other.dataGetStruct()) instanceof JavaObject)) {
            return this.getRuntime().getFalse();
        }
        if (this.getValue() == null && ((JavaObject)other).getValue() == null) {
            return this.getRuntime().getTrue();
        }
        boolean isSame = this.getValue() == ((JavaObject)other).getValue();
        return isSame ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod
    public RubyString java_type() {
        return this.getRuntime().newString(this.getJavaClass().getName());
    }

    @JRubyMethod
    public IRubyObject java_class() {
        return JavaClass.get(this.getRuntime(), this.getJavaClass());
    }

    @JRubyMethod
    public RubyFixnum length() {
        throw this.getRuntime().newTypeError("not a java array");
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject aref(IRubyObject index2) {
        throw this.getRuntime().newTypeError("not a java array");
    }

    @JRubyMethod(name={"[]="}, required=2)
    public IRubyObject aset(IRubyObject index2, IRubyObject someValue) {
        throw this.getRuntime().newTypeError("not a java array");
    }

    @JRubyMethod(name={"fill"}, required=3)
    public IRubyObject afill(IRubyObject beginIndex, IRubyObject endIndex, IRubyObject someValue) {
        throw this.getRuntime().newTypeError("not a java array");
    }

    @JRubyMethod(name={"java_proxy?"})
    public IRubyObject is_java_proxy() {
        return this.getRuntime().getTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"synchronized"})
    public IRubyObject ruby_synchronized(ThreadContext context, Block block) {
        Object lock2 = this.getValue();
        Object object = lock2 != null ? lock2 : NULL_LOCK;
        synchronized (object) {
            return block.yield(context, null);
        }
    }
}

