/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.TypeConverter;

@JRubyClass(name={"Hash"}, include={"Enumerable"})
public class RubyHash
extends RubyObject
implements Map {
    private static final ObjectAllocator HASH_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyHash(runtime2, klass);
        }
    };
    private RubyHashEntry[] table;
    private int size = 0;
    private int threshold;
    private static final int PROCDEFAULT_HASH_F = 1024;
    private IRubyObject ifNone;
    private static final int[] MRI_PRIMES = new int[]{11, 19, 37, 67, 131, 283, 521, 1033, 2053, 4099, 8219, 16427, 32771, 65581, 131101, 262147, 524309, 0x100007, 0x200011, 0x40000F, 0x800009, 16777259, 0x2000023, 0x400000F, 134217757, 0x10000003, 0x2000000B, 0x40000055, 0};
    private static final int JAVASOFT_INITIAL_CAPACITY = 8;
    private static final int MRI_INITIAL_CAPACITY = MRI_PRIMES[0];
    private static final int INITIAL_THRESHOLD = 6;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final RubyHashEntry NO_ENTRY = new RubyHashEntry();
    private int generation = 0;
    private final RubyHashEntry head = new RubyHashEntry();
    private static final int HASH_SIGN_BIT_MASK = Integer.MAX_VALUE;
    private static final int MIN_CAPA = 8;
    private static final int ST_DEFAULT_MAX_DENSITY = 5;
    private static final boolean MRI_HASH = true;
    private static final boolean MRI_HASH_RESIZE = true;
    public static long collisions = 0L;
    private static final EntryMatchType MATCH_KEY = new EntryMatchType(){

        public boolean matches(RubyHashEntry entry, Object obj) {
            IRubyObject key = entry.key;
            return obj == key || ((IRubyObject)obj).eql(key);
        }
    };
    private static final EntryMatchType MATCH_ENTRY = new EntryMatchType(){

        public boolean matches(RubyHashEntry entry, Object obj) {
            return entry.equals(obj);
        }
    };
    private static final boolean EQUAL_CHECK_DEFAULT_VALUE = false;
    private static final EntryView DIRECT_KEY_VIEW = new EntryView(){

        public Object convertEntry(Ruby runtime2, RubyHashEntry entry) {
            return entry.key;
        }

        public boolean contains(RubyHash hash2, Object o) {
            if (!(o instanceof IRubyObject)) {
                return false;
            }
            return hash2.internalGet((IRubyObject)o) != null;
        }

        public boolean remove(RubyHash hash2, Object o) {
            if (!(o instanceof IRubyObject)) {
                return false;
            }
            return hash2.internalDelete((IRubyObject)o) != NO_ENTRY;
        }
    };
    private static final EntryView KEY_VIEW = new EntryView(){

        public Object convertEntry(Ruby runtime2, RubyHashEntry entry) {
            return JavaUtil.convertRubyToJava(entry.key, Object.class);
        }

        public boolean contains(RubyHash hash2, Object o) {
            return hash2.containsKey(o);
        }

        public boolean remove(RubyHash hash2, Object o) {
            return hash2.remove(o) != null;
        }
    };
    private static final EntryView DIRECT_VALUE_VIEW = new EntryView(){

        public Object convertEntry(Ruby runtime2, RubyHashEntry entry) {
            return entry.value;
        }

        public boolean contains(RubyHash hash2, Object o) {
            if (!(o instanceof IRubyObject)) {
                return false;
            }
            IRubyObject obj = (IRubyObject)o;
            return hash2.hasValue(obj.getRuntime().getCurrentContext(), obj);
        }

        public boolean remove(RubyHash hash2, Object o) {
            if (!(o instanceof IRubyObject)) {
                return false;
            }
            IRubyObject obj = (IRubyObject)o;
            IRubyObject key = hash2.internalIndex(obj.getRuntime().getCurrentContext(), obj);
            if (key == null) {
                return false;
            }
            return hash2.internalDelete(key) != NO_ENTRY;
        }
    };
    private final EntryView VALUE_VIEW;
    private final EntryView DIRECT_ENTRY_VIEW;
    private final EntryView ENTRY_VIEW;

    public static RubyClass createHashClass(Ruby runtime2) {
        RubyClass hashc = runtime2.defineClass("Hash", runtime2.getObject(), HASH_ALLOCATOR);
        runtime2.setHash(hashc);
        hashc.index = 10;
        hashc.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyHash;
            }
        };
        hashc.includeModule(runtime2.getEnumerable());
        hashc.defineAnnotatedMethods(RubyHash.class);
        return hashc;
    }

    public int getNativeTypeIndex() {
        return 10;
    }

    @JRubyMethod(name={"[]"}, rest=true, frame=true, meta=true)
    public static IRubyObject create(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject tmp;
        RubyClass klass = (RubyClass)recv2;
        Ruby runtime2 = context.getRuntime();
        if (args2.length == 1 && !(tmp = TypeConverter.convertToTypeWithCheck(args2[0], runtime2.getHash(), MethodIndex.TO_HASH, "to_hash")).isNil()) {
            RubyHash otherHash = (RubyHash)tmp;
            return new RubyHash(runtime2, klass, otherHash);
        }
        if ((args2.length & 1) != 0) {
            throw runtime2.newArgumentError("odd number of args for Hash");
        }
        RubyHash hash2 = (RubyHash)klass.allocate();
        for (int i = 0; i < args2.length; i += 2) {
            hash2.op_aset(context, args2[i], args2[i + 1]);
        }
        return hash2;
    }

    public static final RubyHash newHash(Ruby runtime2) {
        return new RubyHash(runtime2);
    }

    public static final RubyHash newHash(Ruby runtime2, Map valueMap, IRubyObject defaultValue) {
        assert (defaultValue != null);
        return new RubyHash(runtime2, valueMap, defaultValue);
    }

    private RubyHash(Ruby runtime2, RubyClass klass, RubyHash other) {
        super(runtime2, klass);
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.VALUE_VIEW = new EntryView(){

            public Object convertEntry(Ruby runtime2, RubyHashEntry entry) {
                return JavaUtil.convertRubyToJava(entry.value, Object.class);
            }

            public boolean contains(RubyHash hash2, Object o) {
                return hash2.containsValue(o);
            }

            public boolean remove(RubyHash hash2, Object o) {
                IRubyObject value2 = JavaUtil.convertJavaToRuby(hash2.getRuntime(), o);
                IRubyObject key = hash2.internalIndex(hash2.getRuntime().getCurrentContext(), value2);
                if (key == null) {
                    return false;
                }
                return hash2.internalDelete(key) != NO_ENTRY;
            }
        };
        this.DIRECT_ENTRY_VIEW = new EntryView(){

            public Object convertEntry(Ruby runtime2, RubyHashEntry entry) {
                return entry;
            }

            public boolean contains(RubyHash hash2, Object o) {
                if (!(o instanceof RubyHashEntry)) {
                    return false;
                }
                RubyHashEntry entry = (RubyHashEntry)o;
                RubyHashEntry candidate = RubyHash.this.internalGetEntry(entry.key);
                return candidate != NO_ENTRY && entry.equals(candidate);
            }

            public boolean remove(RubyHash hash2, Object o) {
                if (!(o instanceof RubyHashEntry)) {
                    return false;
                }
                return hash2.internalDeleteEntry((RubyHashEntry)o) != NO_ENTRY;
            }
        };
        this.ENTRY_VIEW = new EntryView(){

            public Object convertEntry(Ruby runtime2, RubyHashEntry entry) {
                return new ConvertingEntry(runtime2, entry);
            }

            public boolean contains(RubyHash hash2, Object o) {
                if (!(o instanceof ConvertingEntry)) {
                    return false;
                }
                ConvertingEntry entry = (ConvertingEntry)o;
                RubyHashEntry candidate = hash2.internalGetEntry(entry.entry.key);
                return candidate != NO_ENTRY && entry.entry.equals(candidate);
            }

            public boolean remove(RubyHash hash2, Object o) {
                if (!(o instanceof ConvertingEntry)) {
                    return false;
                }
                ConvertingEntry entry = (ConvertingEntry)o;
                return hash2.internalDeleteEntry(entry.entry) != NO_ENTRY;
            }
        };
        this.ifNone = runtime2.getNil();
        this.threshold = 6;
        this.table = other.internalCopyTable(this.head);
        this.size = other.size;
    }

    public RubyHash(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.VALUE_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.DIRECT_ENTRY_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.ENTRY_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.ifNone = runtime2.getNil();
        this.alloc();
    }

    public RubyHash(Ruby runtime2) {
        this(runtime2, runtime2.getNil());
    }

    public RubyHash(Ruby runtime2, IRubyObject defaultValue) {
        super(runtime2, runtime2.getHash());
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.VALUE_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.DIRECT_ENTRY_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.ENTRY_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.ifNone = defaultValue;
        this.alloc();
    }

    RubyHash(Ruby runtime2, boolean objectSpace) {
        super(runtime2, runtime2.getHash(), objectSpace);
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.VALUE_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.DIRECT_ENTRY_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.ENTRY_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.alloc();
    }

    public RubyHash(Ruby runtime2, Map valueMap, IRubyObject defaultValue) {
        super(runtime2, runtime2.getHash());
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.VALUE_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.DIRECT_ENTRY_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.ENTRY_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.ifNone = defaultValue;
        this.alloc();
        for (Map.Entry e : valueMap.entrySet()) {
            this.internalPut((IRubyObject)e.getKey(), (IRubyObject)e.getValue());
        }
    }

    private final void alloc() {
        this.threshold = 6;
        ++this.generation;
        this.head.nextAdded = (this.head.prevAdded = this.head);
        this.table = new RubyHashEntry[MRI_INITIAL_CAPACITY];
    }

    private static int JavaSoftHashValue(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private static int JavaSoftBucketIndex(int h, int length2) {
        return h & length2 - 1;
    }

    private static int MRIHashValue(int h) {
        return h & Integer.MAX_VALUE;
    }

    private static int MRIBucketIndex(int h, int length2) {
        return h % length2;
    }

    private final void resize(int newCapacity) {
        RubyHashEntry[] oldTable = this.table;
        RubyHashEntry[] newTable = new RubyHashEntry[newCapacity];
        for (int j = 0; j < oldTable.length; ++j) {
            RubyHashEntry entry = oldTable[j];
            oldTable[j] = null;
            while (entry != null) {
                RubyHashEntry next2 = entry.next;
                int i = RubyHash.bucketIndex(entry.hash, newCapacity);
                entry.next = newTable[i];
                newTable[i] = entry;
                entry = next2;
            }
        }
        this.table = newTable;
    }

    private final void JavaSoftCheckResize() {
        if (this.overThreshold()) {
            RubyHashEntry[] tbl = this.table;
            if (tbl.length == 0x40000000) {
                this.threshold = Integer.MAX_VALUE;
                return;
            }
            this.resizeAndAdjustThreshold(this.table);
        }
    }

    private boolean overThreshold() {
        return this.size > this.threshold;
    }

    private void resizeAndAdjustThreshold(RubyHashEntry[] oldTable) {
        int newCapacity = oldTable.length << 1;
        this.resize(newCapacity);
        this.threshold = newCapacity - (newCapacity >> 2);
    }

    private final void MRICheckResize() {
        if (this.size / this.table.length > 5) {
            int forSize = this.table.length + 1;
            int i = 0;
            int newCapacity = 8;
            while (i < MRI_PRIMES.length) {
                if (newCapacity > forSize) {
                    this.resize(MRI_PRIMES[i]);
                    return;
                }
                ++i;
                newCapacity <<= 1;
            }
            return;
        }
    }

    private static int hashValue(int h) {
        return RubyHash.MRIHashValue(h);
    }

    private static int bucketIndex(int h, int length2) {
        return RubyHash.MRIBucketIndex(h, length2);
    }

    private void checkResize() {
        this.MRICheckResize();
    }

    private final void internalPut(IRubyObject key, IRubyObject value2) {
        this.internalPut(key, value2, true);
    }

    private final void internalPut(IRubyObject key, IRubyObject value2, boolean checkForExisting) {
        this.checkResize();
        int hash2 = RubyHash.hashValue(key.hashCode());
        int i = RubyHash.bucketIndex(hash2, this.table.length);
        if (checkForExisting) {
            RubyHashEntry entry = this.table[i];
            while (entry != null) {
                IRubyObject k;
                if (entry.hash == hash2 && ((k = entry.key) == key || key.eql(k))) {
                    entry.value = value2;
                    return;
                }
                entry = entry.next;
            }
        }
        this.table[i] = new RubyHashEntry(hash2, key, value2, this.table[i], this.head);
        ++this.size;
    }

    private final IRubyObject internalGet(IRubyObject key) {
        return this.internalGetEntry(key).value;
    }

    private final RubyHashEntry internalGetEntry(IRubyObject key) {
        int hash2 = RubyHash.hashValue(key.hashCode());
        RubyHashEntry entry = this.table[RubyHash.bucketIndex(hash2, this.table.length)];
        while (entry != null) {
            IRubyObject k;
            if (entry.hash == hash2 && ((k = entry.key) == key || key.eql(k))) {
                return entry;
            }
            entry = entry.next;
        }
        return NO_ENTRY;
    }

    private final RubyHashEntry internalDelete(IRubyObject key) {
        return this.internalDelete(RubyHash.hashValue(key.hashCode()), MATCH_KEY, key);
    }

    private final RubyHashEntry internalDeleteEntry(RubyHashEntry entry) {
        return this.internalDelete(RubyHash.hashValue(entry.key.hashCode()), MATCH_ENTRY, entry);
    }

    private final RubyHashEntry internalDelete(int hash2, EntryMatchType matchType, Object obj) {
        int i = RubyHash.bucketIndex(hash2, this.table.length);
        RubyHashEntry entry = this.table[i];
        if (entry != null) {
            RubyHashEntry prior = null;
            while (entry != null) {
                if (entry.hash == hash2 && matchType.matches(entry, obj)) {
                    if (prior != null) {
                        prior.next = entry.next;
                    } else {
                        this.table[i] = entry.next;
                    }
                    entry.detach();
                    --this.size;
                    return entry;
                }
                prior = entry;
                entry = entry.next;
            }
        }
        return NO_ENTRY;
    }

    private final RubyHashEntry[] internalCopyTable(RubyHashEntry destHead) {
        RubyHashEntry[] newTable = new RubyHashEntry[this.table.length];
        RubyHashEntry entry = this.head.nextAdded;
        while (entry != this.head) {
            int i = RubyHash.bucketIndex(entry.hash, this.table.length);
            newTable[i] = new RubyHashEntry(entry.hash, entry.key, entry.value, newTable[i], destHead);
            entry = entry.nextAdded;
        }
        return newTable;
    }

    public void visitAll(Visitor visitor) {
        int startGeneration = this.generation;
        RubyHashEntry entry = this.head.nextAdded;
        while (entry != this.head) {
            if (startGeneration != this.generation) {
                startGeneration = this.generation;
                entry = this.head.nextAdded;
                if (entry == this.head) break;
            }
            if (entry.isLive()) {
                visitor.visit(entry.key, entry.value);
            }
            entry = entry.nextAdded;
        }
    }

    @JRubyMethod(name={"initialize"}, optional=1, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        this.modify();
        if (block.isGiven()) {
            if (args2.length > 0) {
                throw this.getRuntime().newArgumentError("wrong number of arguments");
            }
            this.ifNone = this.getRuntime().newProc(Block.Type.PROC, block);
            this.flags |= 0x400;
        } else {
            Arity.checkArgumentCount(this.getRuntime(), args2, 0, 1);
            if (args2.length == 1) {
                this.ifNone = args2[0];
            }
        }
        return this;
    }

    @Deprecated
    public IRubyObject default_value_get(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.default_value_get(context);
            }
            case 1: {
                return this.default_value_get(context, args2[0]);
            }
        }
        throw context.getRuntime().newArgumentError(args2.length, 1);
    }

    @JRubyMethod(name={"default"}, frame=true)
    public IRubyObject default_value_get(ThreadContext context) {
        if ((this.flags & 0x400) != 0) {
            return this.getRuntime().getNil();
        }
        return this.ifNone;
    }

    @JRubyMethod(name={"default"}, frame=true)
    public IRubyObject default_value_get(ThreadContext context, IRubyObject arg2) {
        if ((this.flags & 0x400) != 0) {
            return RuntimeHelpers.invoke(context, this.ifNone, "call", (IRubyObject)this, arg2);
        }
        return this.ifNone;
    }

    @JRubyMethod(name={"default="}, required=1)
    public IRubyObject default_value_set(IRubyObject defaultValue) {
        this.modify();
        this.ifNone = defaultValue;
        this.flags &= 0xFFFFFBFF;
        return this.ifNone;
    }

    @JRubyMethod(name={"default_proc"}, frame=true)
    public IRubyObject default_proc() {
        return (this.flags & 0x400) != 0 ? this.ifNone : this.getRuntime().getNil();
    }

    public void modify() {
        this.testFrozen("hash");
        if (this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't modify hash");
        }
    }

    private IRubyObject inspectHash(final ThreadContext context) {
        final ByteList buffer = new ByteList();
        buffer.append(123);
        final boolean[] firstEntry = new boolean[]{true};
        this.visitAll(new Visitor(){

            public void visit(IRubyObject key, IRubyObject value2) {
                if (!firstEntry[0]) {
                    buffer.append(44).append(32);
                }
                buffer.append(RubyObject.inspect(context, key).getByteList());
                buffer.append(61).append(62);
                buffer.append(RubyObject.inspect(context, value2).getByteList());
                firstEntry[0] = false;
            }
        });
        buffer.append(125);
        return this.getRuntime().newString(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        if (this.size == 0) {
            return this.getRuntime().newString("{}");
        }
        if (this.getRuntime().isInspecting(this)) {
            return this.getRuntime().newString("{...}");
        }
        try {
            this.getRuntime().registerInspecting(this);
            IRubyObject iRubyObject = this.inspectHash(context);
            return iRubyObject;
        }
        finally {
            this.getRuntime().unregisterInspecting(this);
        }
    }

    @JRubyMethod(name={"size", "length"})
    public RubyFixnum rb_size() {
        return this.getRuntime().newFixnum(this.size);
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p() {
        return this.size == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"to_a"})
    public RubyArray to_a() {
        final Ruby runtime2 = this.getRuntime();
        final RubyArray result = RubyArray.newArray(runtime2, this.size);
        this.visitAll(new Visitor(){

            public void visit(IRubyObject key, IRubyObject value2) {
                result.append(RubyArray.newArray(runtime2, key, value2));
            }
        });
        result.setTaint(this.isTaint());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (runtime2.isInspecting(this)) {
            return runtime2.newString("{...}");
        }
        try {
            runtime2.registerInspecting(this);
            IRubyObject iRubyObject = this.to_a().to_s();
            return iRubyObject;
        }
        finally {
            runtime2.unregisterInspecting(this);
        }
    }

    @JRubyMethod(name={"to_s"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_s19(ThreadContext context) {
        return this.inspect(context);
    }

    @JRubyMethod(name={"rehash"})
    public RubyHash rehash() {
        this.modify();
        RubyHashEntry[] oldTable = this.table;
        RubyHashEntry[] newTable = new RubyHashEntry[oldTable.length];
        for (int j = 0; j < oldTable.length; ++j) {
            RubyHashEntry entry = oldTable[j];
            oldTable[j] = null;
            while (entry != null) {
                RubyHashEntry next2 = entry.next;
                entry.hash = entry.key.hashCode();
                int i = RubyHash.bucketIndex(entry.hash, newTable.length);
                entry.next = newTable[i];
                newTable[i] = entry;
                entry = next2;
            }
        }
        this.table = newTable;
        return this;
    }

    @JRubyMethod(name={"to_hash"})
    public RubyHash to_hash() {
        return this;
    }

    public RubyHash convertToHash() {
        return this;
    }

    public final void fastASet(IRubyObject key, IRubyObject value2) {
        this.internalPut(key, value2);
    }

    @Deprecated
    public IRubyObject op_aset(IRubyObject key, IRubyObject value2) {
        return this.op_aset(this.getRuntime().getCurrentContext(), key, value2);
    }

    @JRubyMethod(name={"[]=", "store"}, required=2)
    public IRubyObject op_aset(ThreadContext context, IRubyObject key, IRubyObject value2) {
        this.modify();
        if (!(key instanceof RubyString)) {
            this.internalPut(key, value2);
        } else {
            RubyHashEntry entry = this.internalGetEntry(key);
            if (entry != NO_ENTRY) {
                entry.value = value2;
            } else {
                RubyString realKey = (RubyString)key;
                if (!realKey.isFrozen()) {
                    realKey = realKey.strDup(context.getRuntime(), realKey.getMetaClass().getRealClass());
                    realKey.setFrozen(true);
                }
                this.internalPut(realKey, value2, false);
            }
        }
        return value2;
    }

    public IRubyObject aset(IRubyObject key, IRubyObject value2) {
        return this.op_aset(this.getRuntime().getCurrentContext(), key, value2);
    }

    public IRubyObject aref(IRubyObject key) {
        return this.op_aref(this.getRuntime().getCurrentContext(), key);
    }

    public final IRubyObject fastARef(IRubyObject key) {
        return this.internalGet(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject equal(final ThreadContext context, IRubyObject other, final boolean eql) {
        Ruby runtime2 = context.getRuntime();
        if (this == other) {
            return runtime2.getTrue();
        }
        if (!(other instanceof RubyHash)) {
            if (!other.respondsTo("to_hash")) {
                return runtime2.getFalse();
            }
            return (eql ? RubyHash.eqlInternal(context, other, this) : RubyHash.equalInternal(context, other, this)) ? runtime2.getTrue() : runtime2.getFalse();
        }
        final RubyHash otherHash = (RubyHash)other;
        if (this.size != otherHash.size || runtime2.isInspecting(this)) {
            return runtime2.getFalse();
        }
        if ((this.size | otherHash.size) == 0) {
            runtime2.getTrue();
        }
        try {
            runtime2.registerInspecting(this);
            this.visitAll(new Visitor(){

                public void visit(IRubyObject key, IRubyObject value2) {
                    IRubyObject value22 = otherHash.fastARef(key);
                    if (value22 == null || !(!eql ? RubyObject.equalInternal(context, value2, value22) : RubyObject.eqlInternal(context, value2, value22))) {
                        throw new Mismatch();
                    }
                }
            });
        }
        catch (Mismatch e) {
            RubyBoolean rubyBoolean = runtime2.getFalse();
            return rubyBoolean;
        }
        finally {
            runtime2.unregisterInspecting(this);
        }
        return runtime2.getTrue();
    }

    @JRubyMethod(name={"=="}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_equal19(ThreadContext context, IRubyObject other) {
        return this.equal(context, other, false);
    }

    @JRubyMethod(name={"eql?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_eql19(ThreadContext context, IRubyObject other) {
        return this.equal(context, other, true);
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject op_aref(ThreadContext context, IRubyObject key) {
        IRubyObject value2 = this.internalGet(key);
        return value2 == null ? this.callMethod(context, MethodIndex.DEFAULT, "default", key) : value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"hash"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject hash19(final ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (this.size == 0 || runtime2.isInspecting(this)) {
            return RubyFixnum.zero(runtime2);
        }
        final long[] hash2 = new long[]{this.size};
        try {
            runtime2.registerInspecting(this);
            this.visitAll(new Visitor(){

                public void visit(IRubyObject key, IRubyObject value2) {
                    hash2[0] = hash2[0] ^ key.callMethod(context, "hash").convertToInteger().getLongValue();
                    hash2[0] = hash2[0] ^ value2.callMethod(context, "hash").convertToInteger().getLongValue();
                }
            });
        }
        finally {
            runtime2.unregisterInspecting(this);
        }
        return RubyFixnum.newFixnum(runtime2, hash2[0]);
    }

    @JRubyMethod(name={"fetch"}, required=1, optional=1, frame=true)
    public IRubyObject fetch(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject value2;
        if (args2.length == 2 && block.isGiven()) {
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.BLOCK_BEATS_DEFAULT_VALUE, "block supersedes default value argument", new Object[0]);
        }
        if ((value2 = this.internalGet(args2[0])) == null) {
            if (block.isGiven()) {
                return block.yield(context, args2[0]);
            }
            if (args2.length == 1) {
                throw this.getRuntime().newIndexError("key not found");
            }
            return args2[1];
        }
        return value2;
    }

    @JRubyMethod(name={"has_key?", "key?", "include?", "member?"}, required=1)
    public RubyBoolean has_key_p(IRubyObject key) {
        return this.internalGetEntry(key) == NO_ENTRY ? this.getRuntime().getFalse() : this.getRuntime().getTrue();
    }

    private boolean hasValue(final ThreadContext context, final IRubyObject expected) {
        try {
            this.visitAll(new Visitor(){

                public void visit(IRubyObject key, IRubyObject value2) {
                    if (RubyObject.equalInternal(context, value2, expected)) {
                        throw new Found();
                    }
                }
            });
            return false;
        }
        catch (Found found) {
            return true;
        }
    }

    @JRubyMethod(name={"has_value?", "value?"}, required=1)
    public RubyBoolean has_value_p(ThreadContext context, IRubyObject expected) {
        return this.getRuntime().newBoolean(this.hasValue(context, expected));
    }

    @JRubyMethod(name={"each"}, frame=true)
    public RubyHash each(final ThreadContext context, final Block block) {
        final Ruby runtime2 = this.getRuntime();
        this.visitAll(new Visitor(){

            public void visit(IRubyObject key, IRubyObject value2) {
                block.yield(context, RubyArray.newArray(runtime2, key, value2), null, null, false);
            }
        });
        return this;
    }

    @JRubyMethod(name={"each"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject each19(ThreadContext context, Block block) {
        return block.isGiven() ? this.each(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "each");
    }

    @JRubyMethod(name={"each_pair"}, frame=true)
    public RubyHash each_pair(final ThreadContext context, final Block block) {
        final Ruby runtime2 = this.getRuntime();
        this.visitAll(new Visitor(){

            public void visit(IRubyObject key, IRubyObject value2) {
                block.yield(context, RubyArray.newArray(runtime2, key, value2), null, null, true);
            }
        });
        return this;
    }

    @JRubyMethod(name={"each_pair"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject each_pair19(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_pair(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_pair");
    }

    @JRubyMethod(name={"each_value"}, frame=true)
    public RubyHash each_value(final ThreadContext context, final Block block) {
        this.visitAll(new Visitor(){

            public void visit(IRubyObject key, IRubyObject value2) {
                block.yield(context, value2);
            }
        });
        return this;
    }

    @JRubyMethod(name={"each_value"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject each_value19(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_value(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_value");
    }

    @JRubyMethod(name={"each_key"}, frame=true)
    public RubyHash each_key(final ThreadContext context, final Block block) {
        this.visitAll(new Visitor(){

            public void visit(IRubyObject key, IRubyObject value2) {
                block.yield(context, key);
            }
        });
        return this;
    }

    @JRubyMethod(name={"each_key"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject each_key19(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_key(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_key");
    }

    @JRubyMethod(name={"sort"}, frame=true)
    public RubyArray sort(Block block) {
        return this.to_a().sort_bang(block);
    }

    @JRubyMethod(name={"index"}, required=1)
    public IRubyObject index(ThreadContext context, IRubyObject expected) {
        IRubyObject key = this.internalIndex(context, expected);
        if (key != null) {
            return key;
        }
        return this.getRuntime().getNil();
    }

    private IRubyObject internalIndex(final ThreadContext context, final IRubyObject expected) {
        try {
            this.visitAll(new Visitor(){

                public void visit(IRubyObject key, IRubyObject value2) {
                    if (RubyObject.equalInternal(context, value2, expected)) {
                        throw new FoundKey(key);
                    }
                }
            });
            return null;
        }
        catch (FoundKey found) {
            return found.key;
        }
    }

    @JRubyMethod(name={"indexes", "indices"}, rest=true)
    public RubyArray indices(ThreadContext context, IRubyObject[] indices2) {
        return this.values_at(context, indices2);
    }

    @JRubyMethod(name={"keys"})
    public RubyArray keys() {
        Ruby runtime2 = this.getRuntime();
        final RubyArray keys2 = RubyArray.newArray(runtime2, this.size);
        this.visitAll(new Visitor(){

            public void visit(IRubyObject key, IRubyObject value2) {
                keys2.append(key);
            }
        });
        return keys2;
    }

    @JRubyMethod(name={"values"})
    public RubyArray rb_values() {
        final RubyArray values = RubyArray.newArray(this.getRuntime(), this.size);
        this.visitAll(new Visitor(){

            public void visit(IRubyObject key, IRubyObject value2) {
                values.append(value2);
            }
        });
        return values;
    }

    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(final ThreadContext context, IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyHash)) {
            if (other.respondsTo("to_hash") && RubyHash.equalInternal(context, other, this)) {
                return this.getRuntime().getTrue();
            }
            return this.getRuntime().getFalse();
        }
        final RubyHash otherHash = (RubyHash)other;
        if (this.size != otherHash.size) {
            return this.getRuntime().getFalse();
        }
        Ruby runtime2 = this.getRuntime();
        try {
            this.visitAll(new Visitor(){

                public void visit(IRubyObject key, IRubyObject value2) {
                    IRubyObject otherValue = otherHash.internalGet(key);
                    if (otherValue == null || !RubyObject.equalInternal(context, value2, otherValue)) {
                        throw new Mismatch();
                    }
                }
            });
            return runtime2.getTrue();
        }
        catch (Mismatch e) {
            return runtime2.getFalse();
        }
    }

    @JRubyMethod(name={"shift"})
    public IRubyObject shift(ThreadContext context) {
        this.modify();
        RubyHashEntry entry = this.head.nextAdded;
        if (entry != this.head) {
            RubyArray result = RubyArray.newArray(this.getRuntime(), entry.key, entry.value);
            this.internalDeleteEntry(entry);
            return result;
        }
        if ((this.flags & 0x400) != 0) {
            return RuntimeHelpers.invoke(context, this.ifNone, "call", (IRubyObject)this, this.getRuntime().getNil());
        }
        return this.ifNone;
    }

    public final boolean fastDelete(IRubyObject key) {
        return this.internalDelete(key) != NO_ENTRY;
    }

    @JRubyMethod(name={"delete"}, required=1, frame=true)
    public IRubyObject delete(ThreadContext context, IRubyObject key, Block block) {
        this.modify();
        RubyHashEntry entry = this.internalDelete(key);
        if (entry != NO_ENTRY) {
            return entry.value;
        }
        if (block.isGiven()) {
            return block.yield(context, key);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"select"}, frame=true)
    public IRubyObject select(final ThreadContext context, final Block block) {
        final Ruby runtime2 = this.getRuntime();
        final RubyArray result = runtime2.newArray();
        this.visitAll(new Visitor(){

            public void visit(IRubyObject key, IRubyObject value2) {
                if (block.yield(context, runtime2.newArray(key, value2), null, null, true).isTrue()) {
                    result.append(runtime2.newArray(key, value2));
                }
            }
        });
        return result;
    }

    @JRubyMethod(name={"select"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject select19(final ThreadContext context, final Block block) {
        final Ruby runtime2 = context.getRuntime();
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime2, this, "select");
        }
        final RubyHash result = RubyHash.newHash(runtime2);
        this.visitAll(new Visitor(){

            public void visit(IRubyObject key, IRubyObject value2) {
                if (block.yield(context, runtime2.newArray(key, value2), null, null, true).isTrue()) {
                    result.fastASet(key, value2);
                }
            }
        });
        return result;
    }

    @JRubyMethod(name={"delete_if"}, frame=true)
    public RubyHash delete_if(final ThreadContext context, final Block block) {
        this.modify();
        final Ruby runtime2 = this.getRuntime();
        final RubyHash self = this;
        this.visitAll(new Visitor(){

            public void visit(IRubyObject key, IRubyObject value2) {
                if (block.yield(context, RubyArray.newArray(runtime2, key, value2), null, null, true).isTrue()) {
                    self.delete(context, key, block);
                }
            }
        });
        return this;
    }

    @JRubyMethod(name={"delete_if"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject delete_if19(ThreadContext context, Block block) {
        return block.isGiven() ? this.delete_if(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "delete_if");
    }

    @JRubyMethod(name={"reject"}, frame=true)
    public RubyHash reject(ThreadContext context, Block block) {
        return ((RubyHash)this.dup()).delete_if(context, block);
    }

    @JRubyMethod(name={"reject"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject reject19(ThreadContext context, Block block) {
        return block.isGiven() ? this.reject(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "reject");
    }

    @JRubyMethod(name={"reject!"}, frame=true)
    public IRubyObject reject_bang(ThreadContext context, Block block) {
        int n = this.size;
        this.delete_if(context, block);
        if (n == this.size) {
            return this.getRuntime().getNil();
        }
        return this;
    }

    @JRubyMethod(name={"clear"})
    public RubyHash rb_clear() {
        this.modify();
        if (this.size > 0) {
            this.alloc();
            this.size = 0;
        }
        return this;
    }

    @JRubyMethod(name={"invert"})
    public RubyHash invert(final ThreadContext context) {
        final RubyHash result = RubyHash.newHash(this.getRuntime());
        this.visitAll(new Visitor(){

            public void visit(IRubyObject key, IRubyObject value2) {
                result.op_aset(context, value2, key);
            }
        });
        return result;
    }

    @JRubyMethod(name={"merge!", "update"}, required=1, frame=true)
    public RubyHash merge_bang(final ThreadContext context, IRubyObject other, final Block block) {
        this.modify();
        final Ruby runtime2 = this.getRuntime();
        RubyHash otherHash = other.convertToHash();
        final RubyHash self = this;
        otherHash.visitAll(new Visitor(){

            public void visit(IRubyObject key, IRubyObject value2) {
                IRubyObject existing;
                if (block.isGiven() && (existing = self.internalGet(key)) != null) {
                    value2 = block.yield(context, RubyArray.newArrayNoCopy(runtime2, new IRubyObject[]{key, existing, value2}));
                }
                self.op_aset(context, key, value2);
            }
        });
        return this;
    }

    @JRubyMethod(name={"merge"}, required=1, frame=true)
    public RubyHash merge(ThreadContext context, IRubyObject other, Block block) {
        return ((RubyHash)this.dup()).merge_bang(context, other, block);
    }

    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public RubyHash initialize_copy(ThreadContext context, IRubyObject other) {
        return this.replace(context, other);
    }

    @JRubyMethod(name={"replace"}, required=1)
    public RubyHash replace(final ThreadContext context, IRubyObject other) {
        RubyHash otherHash = other.convertToHash();
        if (this == otherHash) {
            return this;
        }
        this.rb_clear();
        final RubyHash self = this;
        otherHash.visitAll(new Visitor(){

            public void visit(IRubyObject key, IRubyObject value2) {
                self.op_aset(context, key, value2);
            }
        });
        this.ifNone = otherHash.ifNone;
        this.flags = (otherHash.flags & 0x400) != 0 ? (this.flags |= 0x400) : (this.flags &= 0xFFFFFBFF);
        return this;
    }

    @JRubyMethod(name={"values_at"}, rest=true)
    public RubyArray values_at(ThreadContext context, IRubyObject[] args2) {
        RubyArray result = RubyArray.newArray(this.getRuntime(), args2.length);
        for (int i = 0; i < args2.length; ++i) {
            result.append(this.op_aref(context, args2[i]));
        }
        return result;
    }

    public boolean hasDefaultProc() {
        return (this.flags & 0x400) != 0;
    }

    public IRubyObject getIfNone() {
        return this.ifNone;
    }

    public static void marshalTo(RubyHash hash2, final MarshalStream output) throws IOException {
        output.registerLinkTarget(hash2);
        output.writeInt(hash2.size);
        try {
            hash2.visitAll(new Visitor(){

                public void visit(IRubyObject key, IRubyObject value2) {
                    try {
                        output.dumpObject(key);
                        output.dumpObject(value2);
                    }
                    catch (IOException e) {
                        throw new VisitorIOException(e);
                    }
                }
            });
        }
        catch (VisitorIOException e) {
            throw (IOException)e.getCause();
        }
        if (!hash2.ifNone.isNil()) {
            output.dumpObject(hash2.ifNone);
        }
    }

    public static RubyHash unmarshalFrom(UnmarshalStream input, boolean defaultValue) throws IOException {
        RubyHash result = RubyHash.newHash(input.getRuntime());
        input.registerLinkTarget(result);
        int size2 = input.unmarshalInt();
        ThreadContext context = input.getRuntime().getCurrentContext();
        for (int i = 0; i < size2; ++i) {
            result.op_aset(context, input.unmarshalObject(), input.unmarshalObject());
        }
        if (defaultValue) {
            result.default_value_set(input.unmarshalObject());
        }
        return result;
    }

    public Class getJavaClass() {
        return Map.class;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean containsKey(Object key) {
        return this.internalGet(JavaUtil.convertJavaToRuby(this.getRuntime(), key)) != null;
    }

    public boolean containsValue(Object value2) {
        return this.hasValue(this.getRuntime().getCurrentContext(), JavaUtil.convertJavaToRuby(this.getRuntime(), value2));
    }

    public Object get(Object key) {
        return JavaUtil.convertRubyToJava(this.internalGet(JavaUtil.convertJavaToRuby(this.getRuntime(), key)));
    }

    public Object put(Object key, Object value2) {
        this.internalPut(JavaUtil.convertJavaToRuby(this.getRuntime(), key), JavaUtil.convertJavaToRuby(this.getRuntime(), value2));
        return value2;
    }

    public Object remove(Object key) {
        IRubyObject rubyKey = JavaUtil.convertJavaToRuby(this.getRuntime(), key);
        return this.internalDelete(rubyKey).value;
    }

    public void putAll(Map map) {
        Ruby runtime2 = this.getRuntime();
        for (Object key : map.keySet()) {
            this.internalPut(JavaUtil.convertJavaToRuby(runtime2, key), JavaUtil.convertJavaToRuby(runtime2, map.get(key)));
        }
    }

    public void clear() {
        this.rb_clear();
    }

    public boolean equals(Object other) {
        if (!(other instanceof RubyHash)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.op_equal(this.getRuntime().getCurrentContext(), (RubyHash)other).isTrue();
    }

    public Set keySet() {
        return new BaseSet(KEY_VIEW);
    }

    public Set directKeySet() {
        return new BaseSet(DIRECT_KEY_VIEW);
    }

    public Collection values() {
        return new BaseCollection(this.VALUE_VIEW);
    }

    public Collection directValues() {
        return new BaseCollection(DIRECT_VALUE_VIEW);
    }

    public Set entrySet() {
        return new BaseSet(this.ENTRY_VIEW);
    }

    public Set directEntrySet() {
        return new BaseSet(this.DIRECT_ENTRY_VIEW);
    }

    private static class ConvertingEntry
    implements Map.Entry {
        private final RubyHashEntry entry;
        private final Ruby runtime;

        public ConvertingEntry(Ruby runtime2, RubyHashEntry entry) {
            this.entry = entry;
            this.runtime = runtime2;
        }

        public Object getKey() {
            return JavaUtil.convertRubyToJava(this.entry.key, Object.class);
        }

        public Object getValue() {
            return JavaUtil.convertRubyToJava(this.entry.value, Object.class);
        }

        public Object setValue(Object o) {
            return this.entry.setValue(JavaUtil.convertJavaToRuby(this.runtime, o));
        }

        public boolean equals(Object o) {
            if (!(o instanceof ConvertingEntry)) {
                return false;
            }
            ConvertingEntry other = (ConvertingEntry)o;
            return this.entry.equals(other.entry);
        }

        public int hashCode() {
            return this.entry.hashCode();
        }
    }

    private static abstract class EntryView {
        private EntryView() {
        }

        public abstract Object convertEntry(Ruby var1, RubyHashEntry var2);

        public abstract boolean contains(RubyHash var1, Object var2);

        public abstract boolean remove(RubyHash var1, Object var2);
    }

    private class BaseIterator
    implements Iterator {
        private final EntryView view;
        private RubyHashEntry entry;
        private boolean peeking;
        private int startGeneration;

        public BaseIterator(EntryView view) {
            this.view = view;
            this.entry = RubyHash.this.head;
            this.startGeneration = RubyHash.this.generation;
        }

        private void advance(boolean consume) {
            if (!this.peeking) {
                do {
                    if (this.startGeneration != RubyHash.this.generation) {
                        this.startGeneration = RubyHash.this.generation;
                        this.entry = RubyHash.this.head;
                    }
                    this.entry = this.entry.nextAdded;
                } while (this.entry != RubyHash.this.head && !this.entry.isLive());
            }
            this.peeking = !consume;
        }

        public Object next() {
            this.advance(true);
            if (this.entry == RubyHash.this.head) {
                this.peeking = true;
                throw new NoSuchElementException();
            }
            return this.view.convertEntry(RubyHash.this.getRuntime(), this.entry);
        }

        public boolean hasNext() {
            this.advance(false);
            return this.entry != RubyHash.this.head;
        }

        public void remove() {
            if (this.entry == RubyHash.this.head) {
                throw new IllegalStateException("Iterator out of range");
            }
            RubyHash.this.internalDeleteEntry(this.entry);
        }
    }

    private class BaseCollection
    extends AbstractCollection {
        final EntryView view;

        public BaseCollection(EntryView view) {
            this.view = view;
        }

        public Iterator iterator() {
            return new BaseIterator(this.view);
        }

        public boolean contains(Object o) {
            return this.view.contains(RubyHash.this, o);
        }

        public void clear() {
            RubyHash.this.clear();
        }

        public int size() {
            return RubyHash.this.size;
        }

        public boolean remove(Object o) {
            return this.view.remove(RubyHash.this, o);
        }
    }

    private class BaseSet
    extends AbstractSet {
        final EntryView view;

        public BaseSet(EntryView view) {
            this.view = view;
        }

        public Iterator iterator() {
            return new BaseIterator(this.view);
        }

        public boolean contains(Object o) {
            return this.view.contains(RubyHash.this, o);
        }

        public void clear() {
            RubyHash.this.clear();
        }

        public int size() {
            return RubyHash.this.size;
        }

        public boolean remove(Object o) {
            return this.view.remove(RubyHash.this, o);
        }
    }

    private static class VisitorIOException
    extends RuntimeException {
        VisitorIOException(Throwable cause2) {
            super(cause2);
        }
    }

    private static class Mismatch
    extends RuntimeException {
        private Mismatch() {
        }
    }

    private static class FoundKey
    extends RuntimeException {
        public IRubyObject key;

        FoundKey(IRubyObject key) {
            this.key = key;
        }
    }

    private class Found
    extends RuntimeException {
        private Found() {
        }
    }

    public static abstract class Visitor {
        public abstract void visit(IRubyObject var1, IRubyObject var2);
    }

    private static abstract class EntryMatchType {
        private EntryMatchType() {
        }

        public abstract boolean matches(RubyHashEntry var1, Object var2);
    }

    static final class RubyHashEntry
    implements Map.Entry {
        private IRubyObject key;
        private IRubyObject value;
        private RubyHashEntry next;
        private RubyHashEntry prevAdded;
        private RubyHashEntry nextAdded;
        private int hash;

        RubyHashEntry() {
            this.key = RubyObject.NEVER;
        }

        RubyHashEntry(int h, IRubyObject k, IRubyObject v, RubyHashEntry e, RubyHashEntry head) {
            this.key = k;
            this.value = v;
            this.next = e;
            this.hash = h;
            this.prevAdded = head.prevAdded;
            this.nextAdded = head;
            this.nextAdded.prevAdded = this;
            this.prevAdded.nextAdded = this;
        }

        public void detach() {
            if (this.prevAdded != null) {
                this.prevAdded.nextAdded = this.nextAdded;
                this.nextAdded.prevAdded = this.prevAdded;
                this.prevAdded = null;
            }
        }

        public boolean isLive() {
            return this.prevAdded != null;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getJavaifiedKey() {
            return JavaUtil.convertRubyToJava(this.key);
        }

        public Object getValue() {
            return this.value;
        }

        public Object getJavaifiedValue() {
            return JavaUtil.convertRubyToJava(this.value);
        }

        public Object setValue(Object value2) {
            IRubyObject oldValue = this.value;
            if (!(value2 instanceof IRubyObject)) {
                throw new UnsupportedOperationException("directEntrySet() doesn't support setValue for non IRubyObject instance entries, convert them manually or use entrySet() instead");
            }
            this.value = (IRubyObject)value2;
            return oldValue;
        }

        public boolean equals(Object other) {
            if (!(other instanceof RubyHashEntry)) {
                return false;
            }
            RubyHashEntry otherEntry = (RubyHashEntry)other;
            return !(this.key != otherEntry.key && !this.key.eql(otherEntry.key) || this.value != otherEntry.value && !this.value.equals(otherEntry.value));
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }
    }
}

