/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaProxy
extends RubyObject {
    public JavaProxy(Ruby runtime2, RubyClass klazz) {
        super(runtime2, klazz);
    }

    public static RubyClass createJavaProxy(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        RubyClass javaProxy = runtime2.defineClass("JavaProxy", runtime2.getObject(), new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
                return new JavaProxy(runtime2, klazz);
            }
        });
        RubyClass singleton = javaProxy.getSingletonClass();
        singleton.addReadWriteAttribute(context, "java_class");
        javaProxy.defineAnnotatedMethods(JavaProxy.class);
        javaProxy.includeModule(runtime2.fastGetModule("JavaProxyMethods"));
        return javaProxy;
    }

    @JRubyMethod(frame=true, meta=true)
    public static IRubyObject inherited(ThreadContext context, IRubyObject recv2, IRubyObject subclass) {
        IRubyObject subJavaClass = RuntimeHelpers.invoke(context, subclass, "java_class");
        if (subJavaClass.isNil()) {
            subJavaClass = RuntimeHelpers.invoke(context, recv2, "java_class");
            RuntimeHelpers.invoke(context, subclass, "java_class=", subJavaClass);
        }
        return recv2.callSuper(context, new IRubyObject[]{subclass}, Block.NULL_BLOCK);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject singleton_class(IRubyObject recv2) {
        return ((RubyClass)recv2).getSingletonClass();
    }

    @JRubyMethod(name={"[]"}, meta=true, rest=true)
    public static IRubyObject op_aref(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject javaClass = RuntimeHelpers.invoke(context, recv2, "java_class");
        if (args2.length > 0) {
            IRubyObject[] newArgs = new IRubyObject[args2.length + 1];
            newArgs[0] = javaClass;
            System.arraycopy(args2, 0, newArgs, 1, args2.length);
            return context.getRuntime().fastGetClass("ArrayJavaProxyCreator").newInstance(context, newArgs, Block.NULL_BLOCK);
        }
        return Java.get_proxy_class(javaClass, RuntimeHelpers.invoke(context, javaClass, "array_class"));
    }

    @JRubyMethod(meta=true)
    public static IRubyObject new_instance_for(IRubyObject recv2, IRubyObject arg0) {
        return Java.new_instance_for(recv2, arg0);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject to_java_object(IRubyObject recv2) {
        return Java.to_java_object(recv2);
    }

    public Object unwrap() {
        return ((JavaObject)this.dataGetStruct()).getValue();
    }
}

