/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.executable.RubiniusCMethod;
import org.jruby.ast.executable.RubiniusMachine;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class RubiniusMethod
extends DynamicMethod
implements JumpTarget {
    private RubiniusCMethod cmethod;
    private StaticScope staticScope;
    private Arity arity;

    public RubiniusMethod(RubyModule implementationClass, RubiniusCMethod cmethod, StaticScope staticScope, Visibility visibility) {
        super(implementationClass, visibility, CallConfiguration.FRAME_AND_SCOPE);
        this.staticScope = staticScope;
        this.cmethod = cmethod;
        this.arity = Arity.optional();
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject[] args2, Block block) {
        assert (args2 != null);
        Ruby runtime2 = context.getRuntime();
        this.callConfig.pre(context, self, klazz, name2, block, this.staticScope, this);
        try {
            if (runtime2.hasEventHooks()) {
                this.traceCall(context, runtime2, name2);
            }
            IRubyObject iRubyObject = RubiniusMachine.INSTANCE.exec(context, self, this.cmethod.code, this.cmethod.literals, args2);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            if (rj.getTarget() == this) {
                IRubyObject iRubyObject = (IRubyObject)rj.getValue();
                return iRubyObject;
            }
            throw rj;
        }
        finally {
            if (runtime2.hasEventHooks()) {
                this.traceReturn(context, runtime2, name2);
            }
            this.callConfig.post(context);
        }
    }

    private void traceReturn(ThreadContext context, Ruby runtime2, String name2) {
        if (!runtime2.hasEventHooks()) {
            return;
        }
        Frame frame = context.getPreviousFrame();
        runtime2.callEventHooks(context, RubyEvent.RETURN, frame.getFile(), frame.getLine(), name2, this.getImplementationClass());
    }

    private void traceCall(ThreadContext context, Ruby runtime2, String name2) {
        if (!runtime2.hasEventHooks()) {
            return;
        }
        runtime2.callEventHooks(context, RubyEvent.CALL, context.getFile(), context.getLine(), name2, this.getImplementationClass());
    }

    public Arity getArity() {
        return this.arity;
    }

    public DynamicMethod dup() {
        return new RubiniusMethod(this.getImplementationClass(), this.cmethod, this.staticScope, this.getVisibility());
    }
}

