/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.Invoker;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Util;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"JRuby::FFI::Provider"}, parent="Object")
public abstract class FFIProvider
extends RubyObject {
    public static final String MODULE_NAME = "JRuby::FFI";
    public static final String CLASS_NAME = "Provider";

    public static RubyClass createProviderClass(Ruby runtime2) {
        RubyModule module = FFIProvider.getModule(runtime2);
        RubyClass result = module.defineClassUnder(CLASS_NAME, runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(FFIProvider.class);
        result.defineAnnotatedConstants(FFIProvider.class);
        return result;
    }

    protected FFIProvider(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    protected FFIProvider(Ruby runtime2) {
        super(runtime2, FFIProvider.getModule(runtime2).fastGetClass(CLASS_NAME));
    }

    public static RubyModule getModule(Ruby runtime2) {
        return (RubyModule)runtime2.fastGetModule("JRuby").fastGetConstantAt("FFI");
    }

    @JRubyMethod(name={"create_invoker", "createInvoker"}, required=5)
    public IRubyObject createInvoker(ThreadContext context, IRubyObject[] args2) {
        RubyArray paramTypes = (RubyArray)args2[3];
        NativeType[] nativeParamTypes = new NativeType[paramTypes.size()];
        for (int i = 0; i < paramTypes.size(); ++i) {
            nativeParamTypes[i] = NativeType.valueOf(Util.int32Value(paramTypes.entry(i)));
        }
        try {
            return this.createInvoker(context.getRuntime(), args2[0].toString(), args2[1].toString(), NativeType.valueOf(Util.int32Value(args2[2])), nativeParamTypes, args2[4].toString());
        }
        catch (UnsatisfiedLinkError ex) {
            return context.getRuntime().getNil();
        }
    }

    @JRubyMethod(name={"error", "last_error"})
    public IRubyObject getLastError(ThreadContext context) {
        return context.getRuntime().newFixnum(this.getLastError());
    }

    @JRubyMethod(name={"error=", "last_error="})
    public IRubyObject getLastError(ThreadContext context, IRubyObject error) {
        this.setLastError(Util.int32Value(error));
        return context.getRuntime().getNil();
    }

    public abstract Invoker createInvoker(Ruby var1, String var2, String var3, NativeType var4, NativeType[] var5, String var6);

    public abstract int getLastError();

    public abstract void setLastError(int var1);
}

