/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComplex;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyObject;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"NilClass"})
public class RubyNil
extends RubyObject {
    public static final ObjectAllocator NIL_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return runtime2.getNil();
        }
    };

    public RubyNil(Ruby runtime2) {
        super(runtime2, runtime2.getNilClass(), false);
        this.flags |= 3;
    }

    public static RubyClass createNilClass(Ruby runtime2) {
        RubyClass nilClass = runtime2.defineClass("NilClass", runtime2.getObject(), NIL_ALLOCATOR);
        runtime2.setNilClass(nilClass);
        nilClass.index = 5;
        nilClass.defineAnnotatedMethods(RubyNil.class);
        nilClass.getMetaClass().undefineMethod("new");
        return nilClass;
    }

    @Override
    public int getNativeTypeIndex() {
        return 5;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public RubyClass getSingletonClass() {
        return this.metaClass;
    }

    @Override
    public Class<?> getJavaClass() {
        return Void.TYPE;
    }

    @JRubyMethod(name={"to_i"})
    public static RubyFixnum to_i(IRubyObject recv2) {
        return RubyFixnum.zero(recv2.getRuntime());
    }

    @JRubyMethod(name={"to_f"})
    public static RubyFloat to_f(IRubyObject recv2) {
        return RubyFloat.newFloat(recv2.getRuntime(), 0.0);
    }

    @JRubyMethod(name={"to_s"})
    public static RubyString to_s(IRubyObject recv2) {
        return RubyString.newEmptyString(recv2.getRuntime());
    }

    @JRubyMethod(name={"to_a"})
    public static RubyArray to_a(IRubyObject recv2) {
        return recv2.getRuntime().newEmptyArray();
    }

    @JRubyMethod(name={"inspect"})
    public static RubyString inspect(IRubyObject recv2) {
        return recv2.getRuntime().newString("nil");
    }

    @JRubyMethod(name={"type"})
    public static RubyClass type(IRubyObject recv2) {
        return recv2.getRuntime().getNilClass();
    }

    @JRubyMethod(name={"&"}, required=1)
    public static RubyBoolean op_and(IRubyObject recv2, IRubyObject obj) {
        return recv2.getRuntime().getFalse();
    }

    @JRubyMethod(name={"|"}, required=1)
    public static RubyBoolean op_or(IRubyObject recv2, IRubyObject obj) {
        return recv2.getRuntime().newBoolean(obj.isTrue());
    }

    @JRubyMethod(name={"^"}, required=1)
    public static RubyBoolean op_xor(IRubyObject recv2, IRubyObject obj) {
        return recv2.getRuntime().newBoolean(obj.isTrue());
    }

    @JRubyMethod(name={"nil?"})
    public IRubyObject nil_p() {
        return this.getRuntime().getTrue();
    }

    @Override
    public RubyFixnum id() {
        return this.getRuntime().newFixnum(4);
    }

    @Override
    public IRubyObject taint(ThreadContext context) {
        return this;
    }

    @Override
    public IRubyObject freeze(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"to_c"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject to_c(ThreadContext context, IRubyObject recv2) {
        return RubyComplex.newComplexCanonicalize(context, RubyFixnum.zero(context.getRuntime()));
    }

    @JRubyMethod(name={"to_r"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject to_r(ThreadContext context, IRubyObject recv2) {
        return RubyRational.newRationalCanonicalize(context, RubyFixnum.zero(context.getRuntime()));
    }
}

